/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.mek9200;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.DataChangedListenerInput;
import jalis.laboratorio.interfaceamento.comunicacao.DataChangedListenerOutput;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServerTriplex;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListenerInput;
import jalis.laboratorio.interfaceamento.comunicacao.SoftHandShakeListenerOutput;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.mek9200.model.DadosRequisicao;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrmO01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQbp011;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQryQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceHl7Listener
implements DataChangedListenerInput,
DataChangedListenerOutput,
SoftHandShakeListenerInput,
SoftHandShakeListenerOutput {
    private HashMap<String, String> mapaParametros = new HashMap();

    public InterfaceListener() {
        super("Mek-9200");
        this.carregarParametros();
    }

    @Override
    public synchronized void dataChanged() {
        String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
        if (!Funcoes.textoVazio(message) && this.messageParser.checkMessage(message)) {
            this.parse(message);
            if (this.getPortaCOM().getInputString().length() > 0) {
                this.dataChanged();
            }
        }
    }

    @Override
    public String parse(String text) {
        try {
            Message message = this.messageParser.textToMessage(text);
            if (message != null) {
                this.mensagemRecebida(message);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    protected void mensagemRecebida(Message message) {
        switch (message.getType()) {
            case ORU_R01: {
                this.messageOruR01Recebida((MessageOruR01)message);
                break;
            }
            case QRY_Q02: {
                this.messageQryQ02Recebida((MessageQryQ02)message);
                break;
            }
            case ACK_Q03: {
                this.messageAckQ03Recebida((MessageAckQ03)message);
                break;
            }
            case ORM_O01: {
                this.messageOrmO01Recebida((MessageOrmO01)message);
                break;
            }
            case QBP_011: {
                this.messageQBPRecebida((MessageQbp011)message);
                break;
            }
            default: {
                this.fireExcecaoEncontrada("Mensagem de tipo desconhecido recebida");
            }
        }
    }

    private void messageQBPRecebida(MessageQbp011 message) {
        String messageId = message.getMsh().getMessageControlId();
        this.confirmaRecebimentoMensagem(message);
        try {
            String tuboId = message.getQpd().getEntityIdentifier();
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            if (tuboId != null && !tuboId.trim().isEmpty() && tuboId != "null" && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                DadosRequisicao dados = this.extrairTuboId(tuboId);
                Object[] req = this.getRequisicaoAba(dados.getFilCodigo(), dados.getReqCodigo(), dados.getRecCodigo(), 0);
                PanelAbaAbstrata aba = this.equipamento.getTab(0);
                String exames = this.extrairExames(dados, req, aba);
                if (req == null) {
                    this.fireExcecaoEncontrada("Nenhuma requisi\u00e7\u00e3o encontrada.");
                    return;
                }
                dados.setMcoCodigo((String)req[aba.getColIndice("C\u00f3d. Mat.")]);
                dados.setIntCodigo((String)req[aba.getColIndice("Interface")]);
                dados.setPacNome((String)req[aba.getColIndice("Paciente")]);
                dados.setPacIdade((String)req[aba.getColIndice("Ide")]);
                dados.setPacSexo((String)req[aba.getColIndice("S")]);
                dados.setRecTuboPai((String)req[aba.getColIndice("Tubo")]);
                dados.setData(TempoUtil.getCurrentDateBr());
                dados.setHora(TempoUtil.getCurrentTime());
                StringBuilder examesFilho = new StringBuilder();
                Set<String> tests = this.examesParaEnviar(exames, dados, examesFilho);
                if (this.possuiExames(tests)) {
                    String nome;
                    InfoExameRequisicao exame = new InfoExameRequisicao(dados.getFilCodigo(), dados.getReqCodigo(), dados.getMcoCodigo(), dados.getRecCodigo(), dados.getPacNome(), dados.getPacIdade(), dados.getPacSexo(), dados.getData(), dados.getHora(), exames);
                    exame.setInterface(dados.getIntCodigo());
                    if (!Funcoes.preencheZero(dados.getRecTuboPai(), ParametrosGerais.getDigitosTuboTubo()).equals(dados.getRecCodigo()) && !Funcoes.textoVazio(examesFilho.toString().trim())) {
                        exame.setTuboPai(dados.getRecTuboPai());
                        exame.setExamesFilho(examesFilho.toString().trim());
                        exame.setCurva(true);
                    }
                    this.examesEnviadosPorSid.put(tuboId, exame);
                    this.examesEnviadosPorMid.put(messageId, exame);
                    String pacNasc = this.getPacienteDataNascimento(dados.getFilCodigo(), dados.getReqCodigo());
                    String sobrenome = nome = StringUtil.removerAcentos(dados.getPacNome());
                    if (nome.indexOf(" ") > 0) {
                        String[] names = nome.split(" ");
                        sobrenome = names.length <= 2 ? names[1] : names[names.length - 1];
                        if (sobrenome.length() > 20) {
                            sobrenome = sobrenome.substring(0, 20);
                        }
                        if (names.length > 2) {
                            nome = names[0] + " " + sobrenome + " " + names[1];
                        }
                    } else if (sobrenome.length() > 36) {
                        nome = sobrenome.substring(0, 36);
                        sobrenome = " ";
                    }
                    dados.setPacNome(nome);
                    if (!Funcoes.textoVazio(dados.getPacNome()) && dados.getPacNome().length() > 30) {
                        dados.setPacNome(dados.getPacNome().substring(0, 30));
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append(this.montaMSH(dados));
                    buf.append(this.montaPID(dados, pacNasc));
                    buf.append(this.montaSPM());
                    buf.append(this.montaSac(tuboId));
                    Integer contador = 0;
                    if (tests.contains("CBC+DIFF")) {
                        tests = new HashSet<String>();
                        tests.add("CBC^^99UNK");
                        tests.add("DIFF^^99UNK");
                    }
                    for (String test : tests) {
                        String tmp = "";
                        tmp = tmp + test;
                        Integer n = contador;
                        Integer n2 = contador = Integer.valueOf(contador + 1);
                        buf.append(this.montaORC());
                        buf.append(this.montaOBR(test, contador.toString()));
                    }
                    buf.append('\u001c').append('\r');
                    ((PortaSocketServerTriplex)this.getPortaCOM()).writeOut(buf.toString());
                    this.enviarRequisicao(dados.getPacNome(), dados.getPacSexo(), dados.getPacIdade(), dados.getData(), dados.getHora(), null, null, dados.getFilCodigo(), dados.getIntCodigo(), dados.getReqCodigo(), dados.getMcoCodigo(), dados.getRecCodigo(), exames, "A");
                }
            } else {
                this.fireExcecaoEncontrada("Nenhum c\u00f3digo de requisi\u00e7\u00e3o encontrado;");
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    @Override
    protected String getPacienteDataNascimento(String filial, String requisicao) {
        Date dateNascPac = BDUtil.getDataNacimentoPaciente(filial, requisicao);
        String dtNascPac = "";
        if (dateNascPac != null) {
            dtNascPac = Funcoes.formataData("yyyyMMdd", dateNascPac);
        }
        return dtNascPac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        if (acao.equals("A") || acao.equals("N")) {
            Statement st = Conexao.getStatement();
            try {
                String[] stringArray = exames.split(" ");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String exame;
                    int situacao = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame = stringArray[i], mcoCodigo, recCodigo);
                    this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    private Object montaORC() {
        StringBuilder buf = new StringBuilder();
        buf.append("ORC|NW").append('\r');
        return buf.toString();
    }

    private String montaOBR(String tmp, String contador) {
        StringBuilder buf = new StringBuilder();
        buf.append("OBR||").append("OID0001").append("||").append(tmp);
        buf.append('\r');
        return buf.toString();
    }

    private String montaSac(String tuboId) {
        StringBuilder buf = new StringBuilder();
        buf.append("SAC|||");
        buf.append(tuboId);
        buf.append('\r');
        return buf.toString();
    }

    private String montaSPM() {
        StringBuilder buf = new StringBuilder();
        buf.append("SPM|||||||||||P^^HL70369");
        buf.append('\r');
        return buf.toString();
    }

    private String montaPID(DadosRequisicao dados, String pacNasc) {
        StringBuilder buf = new StringBuilder();
        buf.append("PID|||").append(dados.getReqCodigo());
        buf.append("||");
        buf.append(dados.getPacNome().replaceAll(" ", "^")).append("^^^^L||").append(pacNasc).append("|").append(dados.getPacSexo());
        buf.append('\r');
        return buf.toString();
    }

    private String montaMSH(DadosRequisicao dados) {
        StringBuilder buf = new StringBuilder();
        buf.append('\u000b');
        String hora = dados.getHora();
        String dataHora = Funcoes.formataData("yyyyMMddHHmmss", Funcoes.getHoraServidor());
        buf.append("MSH|^~\\&|Jalis|Lis|MEK-9100|Laboratory|").append("||OML^O33^OML_O33|ID").append("|P|2.5|||NE|AL||~ISO IR87|||LAB-28^IHE").append('\r');
        return buf.toString();
    }

    private String extrairExames(DadosRequisicao dados, Object[] req, PanelAbaAbstrata aba) {
        String exames = "";
        if (req != null) {
            exames = (String)req[aba.getColIndice("Exame")];
        }
        if (req == null) {
            req = this.getRequisicaoAba(dados.getFilCodigo(), dados.getReqCodigo(), dados.getRecCodigo(), 1);
            aba = this.equipamento.getTab(1);
            exames = this.getExames(dados.getFilCodigo(), dados.getReqCodigo(), dados.getRecCodigo(), req, aba, exames, 1);
            if (Funcoes.textoVazio(exames) && req != null) {
                if (!Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(dados.getRecCodigo())) {
                    exames = this.getExames(dados.getFilCodigo(), dados.getReqCodigo(), (String)req[aba.getColIndice("Tubo")], req, aba, exames, 1);
                }
            }
        }
        if (req == null) {
            req = this.getRequisicaoAba(dados.getFilCodigo(), dados.getReqCodigo(), dados.getRecCodigo(), 2);
            aba = this.equipamento.getTab(2);
            exames = this.getExames(dados.getFilCodigo(), dados.getReqCodigo(), dados.getRecCodigo(), req, aba, exames, 2);
            if (Funcoes.textoVazio(exames) && req != null) {
                if (!Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(dados.getRecCodigo())) {
                    exames = this.getExames(dados.getFilCodigo(), dados.getReqCodigo(), (String)req[aba.getColIndice("Tubo")], req, aba, exames, 2);
                }
            }
        }
        return exames;
    }

    private DadosRequisicao extrairTuboId(String tuboId) {
        DadosRequisicao dados = new DadosRequisicao();
        dados.setFilCodigo(tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial()));
        dados.setReqCodigo(tuboId.substring(ParametrosGerais.getDigitosTuboFilial()));
        dados.setRecCodigo(dados.getReqCodigo().substring(ParametrosGerais.getDigitosTuboRequisicao()));
        dados.setReqCodigo(dados.getReqCodigo().substring(0, ParametrosGerais.getDigitosTuboRequisicao()));
        DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
        if (etiqueta != null) {
            dados.setFilCodigo(Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial()));
            dados.setReqCodigo(Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()));
            dados.setRecCodigo(Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo()));
        }
        return dados;
    }

    private Set<String> examesParaEnviar(String exames, DadosRequisicao dados, StringBuilder examesFilho) throws SQLException {
        ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
        for (String string : exames.trim().split(" ", 0)) {
            examesDaRequisicao.add(new ExameMaterial(string, new Integer(dados.getMcoCodigo())));
        }
        Date dataColeta = null;
        ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
        for (ExameMaterial exameMaterial : examesDaRequisicao) {
            if (dataColeta == null) {
                dataColeta = BDUtil.getExmColeta(dados.getFilCodigo(), dados.getReqCodigo(), exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
            }
            int n = this.getExameSituacao(Conexao.getStatement(), dados.getFilCodigo(), dados.getIntCodigo(), dados.getReqCodigo(), exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), dados.getRecCodigo());
            boolean curva = BDUtil.isExameCurva(dados.getFilCodigo(), dados.getIntCodigo(), exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
            if (BDUtil.isExameDesmembrado(dados.getFilCodigo(), dados.getIntCodigo(), exameMaterial.getString(), dados.getMcoCodigo())) {
                int sitFilho;
                List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(dados.getFilCodigo(), dados.getIntCodigo(), exameMaterial.getString(), dados.getMcoCodigo()));
                if (!(n != 0 && n != 1 || curva)) {
                    examesParaEnviar.addAll(examesFilhos);
                    continue;
                }
                if (curva) {
                    for (ExameMaterial exameFilho : examesFilhos) {
                        sitFilho = BDUtil.getDesmSituacao(dados.getFilCodigo(), dados.getIntCodigo(), dados.getReqCodigo(), exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), dados.getRecTuboPai(), exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                        String tuboFilho = BDUtil.getExameDesmembradoTubo(dados.getFilCodigo(), dados.getReqCodigo(), dados.getRecTuboPai(), dados.getIntCodigo(), exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                        if (sitFilho != 0 && sitFilho != 1 && sitFilho != 3 || !Funcoes.preencheZero(tuboFilho, ParametrosGerais.getDigitosTuboTubo()).equals(dados.getRecCodigo())) continue;
                        examesFilho.append(exameFilho.getNomeExame()).append(" ");
                        examesParaEnviar.add(exameFilho);
                    }
                    continue;
                }
                for (ExameMaterial exameFilho : examesFilhos) {
                    sitFilho = BDUtil.getDesmSituacao(dados.getFilCodigo(), dados.getIntCodigo(), dados.getReqCodigo(), exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), dados.getRecCodigo(), exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                    if (sitFilho != 3) continue;
                    examesParaEnviar.add(exameFilho);
                }
                continue;
            }
            if (n != 0 && n != 1 && n != 3) continue;
            examesParaEnviar.add(exameMaterial);
        }
        HashSet<String> tests = new HashSet<String>();
        for (ExameMaterial exameMaterial : examesParaEnviar) {
            String test = BDUtil.getExmCodigoAlternativo(dados.getFilCodigo(), exameMaterial.getNomeExame(), dados.getMcoCodigo(), dados.getIntCodigo());
            if (test == null || test.trim().isEmpty()) continue;
            tests.add(test);
        }
        return tests;
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        this.confirmaRecebimentoResultado(oruR01);
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = oruR01.getObr().getPlacerOrderNumber();
            if (Funcoes.textoVazio(tuboId) || tuboId.length() != digitosCodigoTubo) {
                tuboId = oruR01.getSac().getId().trim();
            }
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                String emiAlternativo;
                String intCodigo;
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                if (etiqueta != null) {
                    filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                    reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                    recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                }
                if ((Funcoes.textoVazio(intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo = String.valueOf(oruR01.getObr().getUniversalServiceId()).trim())) || intCodigo == null) && (Funcoes.textoVazio(intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, "CBC+DIFF")) || intCodigo == null)) {
                    this.fireExcecaoEncontrada("Alternativo n\u00e3o encontrado " + emiAlternativo);
                    return;
                }
                ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                if (exame == null && (emiAlternativo.trim().equals("DIFF^^99UNK") || emiAlternativo.trim().equals("CBC^^99UNK"))) {
                    emiAlternativo = "CBC+DIFF";
                    exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                }
                if (exame == null) {
                    this.fireExcecaoEncontrada("Nenhum exame encontrado com o alternativo " + emiAlternativo);
                    return;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                ArrayList<String> flags = new ArrayList<String>();
                for (MessageSegmentObx obx : oruR01.getObxList()) {
                    if (exame == null) continue;
                    if (obx.getAbnormalFlag() != null) {
                        flags.add(obx.getAbnormalFlag().toString());
                    }
                    int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                    String campo = obx.getObservationId().substring(0, obx.getObservationId().indexOf("^"));
                    String resultado = "";
                    if (obx.getValueType() != null) {
                        switch (obx.getValueType()) {
                            case NUMERIC: {
                                resultado = obx.getObservationValue();
                                resultado = this.arrendondaValor(resultado, filCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, reqCodigo);
                                resultado = resultado.replace('.', ',');
                                break;
                            }
                            case STRING: {
                                resultado = obx.getObservationValue();
                            }
                        }
                    }
                    String campoJalis = this.mapaParametros.get(campo);
                    dados.put(campoJalis, resultado);
                }
                int situacao = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                if (BDUtil.existeDesmembramento(filCodigo, intCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial())) {
                    ExameMaterial[] exaPai = BDUtil.getDesmExamesPai(filCodigo, intCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial());
                    if (situacao == 0 || situacao == 1 || situacao == 3) {
                        for (ExameMaterial exameFilho : exaPai) {
                            int sitFilho = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial(), recCodigo);
                            if (sitFilho != 0 && sitFilho != 1 && sitFilho != 3) continue;
                            this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial(), intCodigo, dados, flags);
                        }
                    }
                } else if (exame != null) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados, flags);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    private void confirmaRecebimentoResultado(MessageOruR01 oruR01) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append('\u000b');
            buf.append("MSH|^~\\&|LIS|Laboratory|MEK-9100|Laboratory|");
            buf.append(Funcoes.formataData("yyyyMMddHHmmss", Funcoes.getDataHoraServidor()));
            buf.append("||ACK^R22^ACK_R22|ID");
            buf.append(Funcoes.formataData("yyyyMMddHHmmss", Funcoes.getDataHoraServidor())).append("0004");
            buf.append("|P|2.5||||||~ISO IR87|||LAB-29^IHE");
            buf.append('\r');
            buf.append("MSA|AA|").append(oruR01.getMsh().getMessageControlId()).append('\r');
            buf.append('\u001c').append('\r');
            ((PortaSocketServerTriplex)this.getPortaCOM()).writeInTriplex(buf.toString());
        }
        catch (IOException e) {
            this.fireExcecaoEncontrada("Falha ao enviar a confirma\u00e7\u00e3o de recebimento do resultado.");
        }
    }

    @Override
    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setReceivingApplication(this.receivingApplication);
            mensagem.getMsh().setReceivingFacility(this.modelo);
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.3.1");
            mensagem.getMsh().setCharacterSet("ASCII");
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            ((PortaSocketServerTriplex)this.getPortaCOM()).writeOut(this.messageParser.messageToText(mensagem, this.fieldSeparator));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    private boolean possuiExames(Set<String> tests) {
        return !tests.isEmpty();
    }

    private void confirmaRecebimentoMensagem(MessageQbp011 message) {
        try {
            StringBuilder buft = new StringBuilder();
            buft.append('\u000b');
            buft.append("MSH|^~\\&|Jalis|Jalis|MEK-9100|Laboratory|");
            buft.append(Funcoes.formataData("yyyyMMddHHmmss", Funcoes.getDataHoraServidor()));
            buft.append("||RSP^K11^RSP_K11|ID");
            buft.append(Funcoes.formataData("yyyyMMddHHmmss", Funcoes.getDataHoraServidor())).append("0003");
            buft.append("|P|2.5|||NE|AL||~ISO IR87|||LAB-27^IHE").append('\r');
            buft.append("MSA|AA|").append(message.getMsh().getMessageControlId()).append('\r');
            buft.append("QAK|").append(message.getQpd().getNameCodingSystem()).append("|OK|WOS^Work Order Step^IHELAW").append('\r');
            buft.append("QPD|WOS^Work Order Step^IHELAW|").append(message.getMsh().getMessageControlId()).append("|").append(message.getQpd().getQueryTag()).append('\r');
            buft.append('\u001c').append('\r');
            ((PortaSocketServerTriplex)this.getPortaCOM()).writeIn(buft.toString());
        }
        catch (IOException e) {
            this.fireExcecaoEncontrada("Falha ao enviar a confirma\u00e7\u00e3o para interface;");
        }
    }

    private void carregarParametros() {
        this.mapaParametros.put("WBC", "leucocitos");
        this.mapaParametros.put("RBC", "hemacias");
        this.mapaParametros.put("HGB", "hgb");
        this.mapaParametros.put("HCT", "hct");
        this.mapaParametros.put("MCV", "vcm");
        this.mapaParametros.put("MCH", "chcm");
        this.mapaParametros.put("MCHC", "mchc");
        this.mapaParametros.put("PLT", "plaquetas");
        this.mapaParametros.put("RDW-CV", "rdw_cv");
        this.mapaParametros.put("RDW-SD", "rdw_sd");
        this.mapaParametros.put("PCT", "pct");
        this.mapaParametros.put("MPV", "vpm");
        this.mapaParametros.put("PDW", "pdw");
        this.mapaParametros.put("P-LCR", "plaquetas_lcr");
        this.mapaParametros.put("NE", "neutrofilo_contagem");
        this.mapaParametros.put("NE%", "neutrofilo_percentual");
        this.mapaParametros.put("LY", "linfocitos_tipicos_contagem");
        this.mapaParametros.put("LY%", "linfocitos_tipicos_percentual");
        this.mapaParametros.put("MO", "monocitos_contagem");
        this.mapaParametros.put("MO%", "monocitos_percentual");
        this.mapaParametros.put("EO", "eosinofilos_contagem");
        this.mapaParametros.put("EO%", "eosinofilos_percentual");
        this.mapaParametros.put("BA", "basofilos_contagem");
        this.mapaParametros.put("BA%", "basofilos_percentual");
        this.mapaParametros.put("HIST_WBC", "bc_histograma_wbc");
        this.mapaParametros.put("HIST_PLT", "bc_histograma_plt");
        this.mapaParametros.put("HIST_RBC", "bc_histograma_rbc");
    }

    @Override
    public void dataChangedOutput() {
        String message = ((PortaSocketServerTriplex)this.getPortaCOM()).removeOutputString(this.getMsgEnd());
        if (!Funcoes.textoVazio(message) && this.messageParser.checkMessage(message)) {
            this.parse(message);
            if (((PortaSocketServerTriplex)this.getPortaCOM()).getOutputString().length() > 0) {
                this.dataChangedOutput();
            }
        }
    }

    @Override
    public void dataChangedInput() {
        String message = ((PortaSocketServerTriplex)this.getPortaCOM()).removeInputString(this.getMsgEnd());
        if (!Funcoes.textoVazio(message) && this.messageParser.checkMessage(message)) {
            this.parse(message);
            if (((PortaSocketServerTriplex)this.getPortaCOM()).getInputString().length() > 0) {
                this.dataChangedInput();
            }
        }
    }

    @Override
    public void dataChangedInputTriplex() {
        String message = ((PortaSocketServerTriplex)this.getPortaCOM()).removeInputStringTriplex(this.getMsgEnd());
        if (!Funcoes.textoVazio(message) && this.messageParser.checkMessage(message)) {
            this.parse(message);
            if (((PortaSocketServerTriplex)this.getPortaCOM()).getInputTriplexString().length() > 0) {
                this.dataChangedInputTriplex();
            }
        }
    }

    @Override
    public void handShakeCharReceivedOutput(char c) {
    }

    @Override
    public void handShakeCharReceivedInput(char c) {
    }

    @Override
    public void teste() {
        StringBuilder tmp = new StringBuilder();
        String idAmostra = JOptionPane.showInputDialog("Informe o Id da amostra:");
        if (Funcoes.textoVazio(idAmostra)) {
            return;
        }
        tmp.append("[SB]MSH|^~\\&|MEK-9100|Laboratory|Jalis|Lis|20220217155704||OUL^R22^OUL_R22|ID202202171557041197|P|2.5|||NE|AL||~ISO[SP]IR87|||LAB-29^IHE[CR]\r\nPID|||" + idAmostra + "||JALIS^5^^^^L||19780112|F[CR]\r\nSPM|1||||||||||P^^HL70369[CR]\r\nSAC|||" + idAmostra + "[CR]\r\nOBR|1|OID0001||CBC^^99UNK[CR]\r\nORC|SC||||CM[CR]\r\nOBX|1|NM|NE%^Neutrophil[SP]Percent^99UNK||38.72|%^percent^UCUM|28.00[SP]-[SP]78.00|*^Possibility[SP]of[SP]abnormal[SP]cells^99FNK|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|2|NM|LY%^Lymphocyte[SP]Percent^99UNK||49.67|%^percent^UCUM|17.00[SP]-[SP]57.00|*^Possibility[SP]of[SP]abnormal[SP]cells^99FNK|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|3|NM|MO%^Monocyte[SP]Percent^99UNK||6.39|%^percent^UCUM|0.00[SP]-[SP]10.00|*^Possibility[SP]of[SP]abnormal[SP]cells^99FNK|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|4|NM|EO%^Eosinophil[SP]Percent^99UNK||1.68|%^percent^UCUM|0.00[SP]-[SP]10.00|*^Possibility[SP]of[SP]abnormal[SP]cells^99FNK|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|5|NM|BA%^Basophil[SP]Percent^99UNK||3.54|%^percent^UCUM|0.00[SP]-[SP]2.00|*^Possibility[SP]of[SP]abnormal[SP]cells^99FNK|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|6|NM|NE^Neutrophil[SP]Count^99UNK||2.39|10*3/uL^thousand[SP]per[SP]microliter^UCUM|1.10[SP]-[SP]7.00|*^Possibility[SP]of[SP]abnormal[SP]cells^99FNK|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|7|NM|LY^Lymphocyte[SP]Count^99UNK||3.07|10*3/uL^thousand[SP]per[SP]microliter^UCUM|0.70[SP]-[SP]5.10|*^Possibility[SP]of[SP]abnormal[SP]cells^99FNK|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|8|NM|MO^Monocyte[SP]Count^99UNK||0.39|10*3/uL^thousand[SP]per[SP]microliter^UCUM|0.00[SP]-[SP]0.90|*^Possibility[SP]of[SP]abnormal[SP]cells^99FNK|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|9|NM|EO^Eosinophil[SP]Count^99UNK||0.10|10*3/uL^thousand[SP]per[SP]microliter^UCUM|0.00[SP]-[SP]0.90|*^Possibility[SP]of[SP]abnormal[SP]cells^99FNK|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|10|NM|BA^Basophil[SP]Count^99UNK||0.22|10*3/uL^thousand[SP]per[SP]microliter^UCUM|0.00[SP]-[SP]0.20|*^Possibility[SP]of[SP]abnormal[SP]cells^99FNK|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBR|2|OID0001||DIFF^^99UNK[CR]\r\nORC|SC||||CM[CR]\r\nOBX|1|NM|WBC^White[SP]Blood[SP]Cell[SP]Count^99UNK||6.17|10*3/uL^thousand[SP]per[SP]microliter^UCUM|4.00[SP]-[SP]9.00|C^Possibility[SP]of[SP]PLT[SP]clumps^99FNK|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|2|NM|RBC^Red[SP]Blood[SP]Cell[SP]Count^99UNK||5.21|10*6/uL^million[SP]per[SP]microliter^UCUM|3.76[SP]-[SP]5.70|\"\"|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|3|NM|HGB^Hemoglobin^99UNK||13.76|g/dL^gram[SP]per[SP]deciliter^UCUM|12.00[SP]-[SP]18.00|\"\"|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|4|NM|HCT^Hematocrit^99UNK||47.5|%^percent^UCUM|33.5[SP]-[SP]52.0|\"\"|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|5|NM|MCV^Mean[SP]Corpuscular[SP]Volume^99UNK||91.2|fL^femtoliter^UCUM|80.0[SP]-[SP]100.0|\"\"|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|6|NM|MCH^Mean[SP]Corpuscular[SP]Hemoglobin^99UNK||26.4|pg^picogram^UCUM|28.0[SP]-[SP]32.0|L^Low^HL70078|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|7|NM|MCHC^Mean[SP]Corpuscular[SP]Hemoglobin[SP]Concentration^99UNK||29.0|g/dL^gram[SP]per[SP]deciliter^UCUM|31.0[SP]-[SP]35.0|L^Low^HL70078|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|8|NM|RDW-CV^Red[SP]Blood[SP]Cell[SP]Distribution[SP]Width[SP]in[SP]CV^99UNK||16.7|%^percent^UCUM|11.6[SP]-[SP]14.0|H^High^HL70078|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|9|NM|RDW-SD^Red[SP]Blood[SP]Cell[SP]Distribution[SP]Width[SP]in[SP]SD^99UNK||60.9|fL^femtoliter^UCUM|42.8[SP]-[SP]51.0|H^High^HL70078|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|10|NM|PLT^Platelet[SP]Count^99UNK||264.8|10*3/uL^thousand[SP]per[SP]microliter^UCUM|150.0[SP]-[SP]350.0|C^Possibility[SP]of[SP]PLT[SP]clumps^99FNK|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|11|NM|PCT^Plateletcrit^99UNK||0.26|%^percent^UCUM|0.16[SP]-[SP]0.33|\"\"|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|12|NM|MPV^Mean[SP]Platelet[SP]Volume^99UNK||9.8|fL^femtoliter^UCUM|7.0[SP]-[SP]11.0|\"\"|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|13|NM|PDW^Platelet[SP]Distribution[SP]Width^99UNK||18.4|%^percent^UCUM|15.5[SP]-[SP]18.9|\"\"|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|14|NM|P-LCR^Platelet[SP]Large[SP]Cell[SP]Ratio^99UNK||57.2|%^percent^UCUM|20.0[SP]-[SP]58.0|\"\"|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|15|EI|MORPHOLOGICAL_FLAG^Morphological[SP]flag^99UNK||Blasts^Blasto^99ANK|||\"\"|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|16|EI|MORPHOLOGICAL_FLAG^Morphological[SP]flag^99UNK||Atypical[SP]Ly^LY[SP]at\u001b$(D+?\u001b(Bpico^99ANK|||\"\"|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|17|EI|MORPHOLOGICAL_FLAG^Morphological[SP]flag^99UNK||Ly-Mo[SP]Interference^Interfer\u001b$(D+4\u001b(Bncia[SP]LY-MO^99ANK|||\"\"|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|18|EI|MORPHOLOGICAL_FLAG^Morphological[SP]flag^99UNK||Small[SP]Nucleated[SP]Cell^C\u001b$(D+1\u001b(Blula[SP]nucleada[SP]pequena^99ANK|||\"\"|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\nOBX|19|EI|NUMERIC_FLAG_PLT^Numeric[SP]flag[SP]PLT^99UNK||PLT[SP]Clumps^PLT[SP]agregadas^99ANK|||\"\"|||F|||||ANTONIO||MEK-9100~01196|20220217155537||||||||||RSLT[CR]\r\n[EB][CR]");
        this.parse(TestesInterface.arruma(tmp.toString()));
    }
}

