/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.mek7300k;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final int REQUISICAO = 22;
    private Map<String, String> flag = new HashMap<String, String>();
    public static final String FLAG_TYPE_HIGH = "H";
    public static final String FLAG_TYPE_LOW = "L";
    public static final String FLAG_TYPE_VALOR_FORA_DO_PADRAO = "*";
    public static final String FLAG_TYPE_PLT_PODEM_ESTAR_COAGULADAS = "C";
    protected int TIME_RX = 15000;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento(this, 5000);
    private Map<Integer, String> flags = new HashMap<Integer, String>();

    public InterfaceListener() {
        this.flag.put(FLAG_TYPE_HIGH, "High");
        this.flag.put(FLAG_TYPE_VALOR_FORA_DO_PADRAO, "O resutlado est\u00e1 fora do valor normal");
        this.flag.put(FLAG_TYPE_PLT_PODEM_ESTAR_COAGULADAS, "PLT podem estar coaguladas");
        this.flag.put(FLAG_TYPE_LOW, "Low");
        this.flags.put(46, "Leucocitose");
        this.flags.put(47, "Leucopenia");
        this.flags.put(48, "Neutrofilia");
        this.flags.put(49, "Neutropenia");
        this.flags.put(50, "Linfocitose");
        this.flags.put(51, "Linfopenia");
        this.flags.put(52, "Monocitose");
        this.flags.put(53, "Eosinofilia");
        this.flags.put(54, "Basofilia");
        this.flags.put(55, "Blastos");
        this.flags.put(56, "Granul\u00f3citos Imaturos");
        this.flags.put(57, "Desvio \u00e0 Esquerda");
        this.flags.put(58, "Linf\u00f3citos at\u00edpicos");
        this.flags.put(59, "Hem\u00f3lise ruim");
        this.flags.put(60, "Pequena c\u00e9lula nucleada");
        this.flags.put(61, "Interfer\u00eancia Ly-Mo");
        this.flags.put(62, "Interfer\u00eancia Ne-No");
        this.flags.put(63, "Dados de reserva 2");
        this.flags.put(64, "Eritrocitose");
        this.flags.put(65, "Anemia");
        this.flags.put(66, "Anisocitose");
        this.flags.put(67, "Microcitose");
        this.flags.put(68, "Macrocitose");
        this.flags.put(69, "Hipocromia");
        this.flags.put(70, "MCHC anormal");
        this.flags.put(71, "Dados de reserva 10");
        this.flags.put(72, "Trombocitose");
        this.flags.put(73, "Trombocitopenia");
        this.flags.put(74, "Grumos PLT");
        this.flags.put(75, "Interfer\u00eancia PLT-RBC");
    }

    protected void parseRecord(String codRequisicao, String[] lines) throws Exception {
        try {
            if (codRequisicao != null) {
                int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                String req_codigo = null;
                String dadoCabecalho = lines[0].trim();
                String email_alternativo = lines[4].trim();
                req_codigo = this.getCodigoApoiado(codRequisicao);
                if (Funcoes.textoVazio(email_alternativo) && !Funcoes.textoVazio(dadoCabecalho) && dadoCabecalho.equalsIgnoreCase("EXP")) {
                    return;
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                if (!(Funcoes.isNumeric(fil_codigo) && Funcoes.isNumeric(req_codigo) && Funcoes.isNumeric(rec_codigo))) {
                    this.fireExcecaoEncontrada(String.format("C\u00f3digo da amostra fora do padr\u00e3o %s %s %s ", fil_codigo, req_codigo, rec_codigo));
                    return;
                }
                String int_codigo = "";
                Map<String, Object> dados = null;
                dados = this.trataPadrao(lines, dados);
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, email_alternativo);
                List<String> listaFlags = this.trataFlags(lines);
                List<String> flags = this.getFlags(dados);
                if (!flags.isEmpty()) {
                    StringBuilder strFlags = new StringBuilder();
                    for (String str : flags) {
                        strFlags.append(str).append(" ");
                    }
                    dados.put("flag", strFlags.toString());
                }
                if (!listaFlags.isEmpty()) {
                    flags.addAll(listaFlags);
                }
                if (dados == null) {
                    this.fireExcecaoEncontrada("Tipo do resultado recebido n\u00e3o existe ou n\u00e3o interfaceado");
                    return;
                }
                if (Funcoes.textoVazio(int_codigo)) {
                    this.fireExcecaoEncontrada(fil_codigo + " " + req_codigo + " " + rec_codigo + " - " + "Requisi\u00e7\u00e3o n\u00e3o encontrada ou n\u00e3o interfaceada!");
                    return;
                }
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, email_alternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada(fil_codigo + " " + req_codigo + " " + rec_codigo + " - " + ("Exame n\u00e3o existe ou n\u00e3o esta interfaceado (int: " + (int_codigo == null ? "-1" : int_codigo) + ", type: " + lines[4] + ")"));
                    return;
                }
                Statement st = Conexao.getStatement();
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
                for (BDExame e : exames) {
                    this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, e.getExame(), e.getMaterial(), int_codigo, dados, flags);
                }
                this.fireAtualizarTabela();
                Conexao.arquivaSQL();
            }
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada(String.format("N\u00e3o foi poss\u00edvel identificar a requisi\u00e7\u00e3o %s ", codRequisicao));
        }
    }

    private List<String> trataFlags(String[] lines) {
        ArrayList<String> listaFlags = new ArrayList<String>();
        for (Integer pos : this.flags.keySet()) {
            if (lines.length < pos || !lines[pos].trim().equals("+")) continue;
            listaFlags.add(this.flags.get(pos));
        }
        return listaFlags;
    }

    private String getCodigoApoiado(String codRequisicao) {
        return codRequisicao;
    }

    protected List<String> getFlags(Map<String, Object> dados) {
        ArrayList<String> flags = new ArrayList<String>();
        for (String key : dados.keySet()) {
            String valor = (String)dados.get(key);
            String nome = key;
            if (key.contains("_")) {
                nome = key.substring(0, key.indexOf("_"));
            }
            if (valor.contains(FLAG_TYPE_HIGH)) {
                dados.put(key, valor.substring(0, valor.indexOf(FLAG_TYPE_HIGH)));
                flags.add(nome + " = " + this.flag.get(FLAG_TYPE_HIGH));
            }
            if (valor.contains(FLAG_TYPE_VALOR_FORA_DO_PADRAO)) {
                dados.put(key, valor.substring(0, valor.indexOf(FLAG_TYPE_VALOR_FORA_DO_PADRAO)));
                flags.add(nome + " = " + this.flag.get(FLAG_TYPE_VALOR_FORA_DO_PADRAO));
            }
            if (valor.contains(FLAG_TYPE_LOW)) {
                dados.put(key, valor.substring(0, valor.indexOf(FLAG_TYPE_LOW)));
                flags.add(nome + " = " + this.flag.get(FLAG_TYPE_LOW));
            }
            if (!valor.contains(FLAG_TYPE_PLT_PODEM_ESTAR_COAGULADAS)) continue;
            dados.put(key, valor.substring(0, valor.indexOf(FLAG_TYPE_PLT_PODEM_ESTAR_COAGULADAS)));
            flags.add(nome + " = " + this.flag.get(FLAG_TYPE_PLT_PODEM_ESTAR_COAGULADAS));
        }
        return flags;
    }

    public Map<String, Object> trataPadrao(String[] lines, Map<String, Object> dados) throws Exception {
        dados = new HashMap<String, Object>();
        dados.put("leucocitos", lines[23].replaceAll("\\.", ",").trim());
        dados.put("neutrofilo_percentual", lines[24].replaceAll("\\.", ",").trim());
        dados.put("linfocitos_tipicos_percentual", lines[25].replaceAll("\\.", ",").trim());
        dados.put("monocitos_percentual", lines[26].replaceAll("\\.", ",").trim());
        dados.put("eosinofilos_percentual", lines[27].replaceAll("\\.", ",").trim());
        dados.put("basofilos_percentual", lines[28].replaceAll("\\.", ",").trim());
        dados.put("granulocitos_percentual", lines[29].replaceAll("\\.", ",").trim());
        dados.put("linfocitos_tipicos_contagem", lines[30].replaceAll("\\.", ",").trim());
        dados.put("monocitos_contagem", lines[31].replaceAll("\\.", ",").trim());
        dados.put("eosinofilos_contagem", lines[32].replaceAll("\\.", ",").trim());
        dados.put("basofilos_contagem", lines[33].replaceAll("\\.", ",").trim());
        dados.put("hemacias", lines[34].replaceAll("\\.", ",").trim());
        dados.put("hgb", lines[35].replaceAll("\\.", ",").trim());
        dados.put("hct", lines[36].replaceAll("\\.", ",").trim());
        dados.put("vcm", lines[37].replaceAll("\\.", ",").trim());
        dados.put("hcm", lines[38].replaceAll("\\.", ",").trim());
        dados.put("chcm", lines[39].replaceAll("\\.", ",").trim());
        dados.put("rdw_cv", lines[40].replaceAll("\\.", ",").trim());
        dados.put("plaquetas", lines[41].replaceAll("\\.", ",").trim());
        dados.put("pct", lines[42].replaceAll("\\.", ",").trim());
        dados.put("vpm", lines[43].replaceAll("\\.", ",").trim());
        dados.put("pdw", lines[44].replaceAll("\\.", ",").trim());
        return dados;
    }

    @Override
    public String parse(String message) {
        try {
            Object checksum = null;
            int pos = message.length() - 1;
            if (pos == 0) {
                this.fireExcecaoEncontrada(String.format("Erro ao receber bloco de dados: Tamanho do bloco incorreto (%s)!", message));
                return "Erro ao receber bloco de dados: Tamanho do bloco incorreto!";
            }
            message = message.substring(1, pos);
            String[] msg = message.split(String.valueOf('\r'));
            boolean i = false;
            int indexCr = message.indexOf(String.valueOf('\r'));
            if (indexCr == -1 || msg.length < 0) {
                this.fireExcecaoEncontrada(String.format("Erro ao receber bloco de dados: Tamanho do bloco incorreto (%s)!", message));
                return "Erro ao receber bloco de dados: Tamanho do bloco incorreto!";
            }
            String codRequisicao = msg[22].trim();
            if (!Funcoes.isNumeric(codRequisicao) && Funcoes.textoVazio(codRequisicao)) {
                this.fireExcecaoEncontrada(String.format("Erro ao receber bloco de dados: Tamanho do bloco incorreto (%s)!", message));
                return "Erro ao receber bloco de dados: Tamanho do bloco incorreto!";
            }
            this.parseRecord(codRequisicao, msg);
            return "";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), String.format("AbstractABXInterfaceamento: parse messsage=\"%s\"", message));
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractABXInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public void teste() {
        String log = TestesInterface.arruma("[STX]24/02/01[CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("[SP]010002532801[CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("[SP]4.4[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("32.1[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("[SP]7.2[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("55.7[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("[SP]4.3[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("[SP]0.7[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("[SP]1.4[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("[SP]0.3[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("[SP]2.5[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("[SP]0.2[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("[SP]0.0[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("5.47[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("15.2[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("47.2[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("86.3[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("27.8L[SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("32.2[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("11.7[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("[SP]184[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("0.12L[SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("[SP]6.3L[SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("16.8[SP][SP][CR]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
        log = TestesInterface.arruma("[ETX]");
        ((PortaCOM)this.getPortaCOM()).read(log, log.length());
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        this.setIdle();
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (!message.equals("") && message.startsWith(this.getMsgStart())) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
            } else {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractABXInterfaceamento: evento de dados recebidos");
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
                }
            };
            SwingUtilities.invokeLater(run);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    protected void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    protected void aguardarProximoFrame() throws Exception {
        this.setRX(this.TIME_RX);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return null;
    }
}

