/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.mek6500jexa;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.mek6500jexa.TiposResultados;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private HashMap<TiposResultados, String> resultados = new HashMap();
    private HashMap<String, Object> dados = new HashMap();

    public InterfaceListener() {
        this.resultados.put(TiposResultados.ID, "");
        this.resultados.put(TiposResultados.WBC, "");
        this.resultados.put(TiposResultados.LYP, "");
        this.resultados.put(TiposResultados.MOP, "");
        this.resultados.put(TiposResultados.EOP, "");
        this.resultados.put(TiposResultados.GRP, "");
        this.resultados.put(TiposResultados.LY, "");
        this.resultados.put(TiposResultados.MO, "");
        this.resultados.put(TiposResultados.EO, "");
        this.resultados.put(TiposResultados.GR, "");
        this.resultados.put(TiposResultados.RBC, "");
        this.resultados.put(TiposResultados.HGB, "");
        this.resultados.put(TiposResultados.HCT, "");
        this.resultados.put(TiposResultados.MCV, "");
        this.resultados.put(TiposResultados.MCH, "");
        this.resultados.put(TiposResultados.MCHC, "");
        this.resultados.put(TiposResultados.PLT, "");
        this.resultados.put(TiposResultados.PCT, "");
        this.resultados.put(TiposResultados.MPV, "");
        this.resultados.put(TiposResultados.PDW, "");
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        this.setIdle();
    }

    @Override
    public void dataChanged() {
        try {
            String[] sep;
            String message = this.getPortaCOM().getInputString();
            StringBuilder builder = new StringBuilder();
            message = message.replaceAll(" ", "");
            for (String linha : sep = message.split("0D0A")) {
                String[] quebra = linha.split("0D");
                for (int o = 0; o < quebra.length; ++o) {
                    String resultado = quebra[o];
                    builder.delete(0, builder.length());
                    for (int i = 0; i < resultado.trim().length(); i += 2) {
                        if (resultado.trim().length() < i + 2) continue;
                        String s = resultado.trim().substring(i, i + 2);
                        int n = Integer.valueOf(s.trim(), 16);
                        builder.append((char)n);
                    }
                    String valor = builder.toString().trim();
                    if (valor.contains(".") && (valor = valor.replace(".", ",")).substring(0).equals(".")) {
                        valor = "0" + valor;
                    }
                    this.resultados.put(TiposResultados.getTipo(o), valor);
                }
            }
            this.parseRecord(this.resultados);
        }
        catch (Exception ex) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractABXInterfaceamento: evento de dados recebidos");
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
                }
            };
            SwingUtilities.invokeLater(run);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        return "";
    }

    protected void parseRecord(HashMap<TiposResultados, String> resultados) throws Exception {
        String codRequisicao = resultados.get((Object)TiposResultados.ID);
        if (codRequisicao != null) {
            int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String req_codigo = codRequisicao;
            String dadoCabecalho = "";
            String alternativo = "CBC+DIFF";
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            if (!(Funcoes.isNumeric(fil_codigo) && Funcoes.isNumeric(req_codigo) && Funcoes.isNumeric(rec_codigo))) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da amostra fora do padr\u00e3o %s %s %s ", fil_codigo, req_codigo, rec_codigo));
                return;
            }
            String int_codigo = "";
            Map<String, Object> dados = this.getDados(resultados);
            int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, alternativo);
            if (dados == null) {
                this.fireExcecaoEncontrada("Tipo do resultado recebido n\u00e3o existe ou n\u00e3o interfaceado");
                return;
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, alternativo);
            if (exame == null) {
                this.fireExcecaoEncontrada(fil_codigo + " " + req_codigo + " " + rec_codigo + " - " + ("Exame n\u00e3o existe ou n\u00e3o esta interfaceado (int: " + (int_codigo == null ? "-1" : int_codigo) + ", type: )"));
                return;
            }
            Statement st = Conexao.getStatement();
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
            for (BDExame e : exames) {
                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, e.getExame(), e.getMaterial(), int_codigo, dados, null);
            }
            this.fireAtualizarTabela();
            Conexao.arquivaSQL();
        }
    }

    private Map<String, Object> getDados(HashMap<TiposResultados, String> res) {
        this.dados = new HashMap();
        this.dados.put("leucocitos", res.get((Object)TiposResultados.WBC));
        this.dados.put("neutrofilo_percentual", "");
        this.dados.put("linfocitos_tipicos_percentual", res.get((Object)TiposResultados.LYP));
        this.dados.put("monocitos_percentual", res.get((Object)TiposResultados.MOP));
        this.dados.put("eosinofilos_percentual", res.get((Object)TiposResultados.EOP));
        this.dados.put("basofilos_percentual", "");
        this.dados.put("granulocitos_percentual", res.get((Object)TiposResultados.GRP));
        this.dados.put("linfocitos_tipicos_contagem", res.get((Object)TiposResultados.LY));
        this.dados.put("monocitos_contagem", res.get((Object)TiposResultados.MO));
        this.dados.put("eosinofilos_contagem", res.get((Object)TiposResultados.EO));
        this.dados.put("basofilos_contagem", "");
        this.dados.put("hemacias", res.get((Object)TiposResultados.RBC));
        this.dados.put("hgb", res.get((Object)TiposResultados.HGB));
        this.dados.put("hct", res.get((Object)TiposResultados.HCT));
        this.dados.put("vcm", res.get((Object)TiposResultados.MCV));
        this.dados.put("hcm", res.get((Object)TiposResultados.MCH));
        this.dados.put("chcm", res.get((Object)TiposResultados.MCHC));
        this.dados.put("rdw_cv", "");
        this.dados.put("plaquetas", res.get((Object)TiposResultados.PLT));
        this.dados.put("pct", res.get((Object)TiposResultados.PCT));
        this.dados.put("vpm", res.get((Object)TiposResultados.MPV));
        this.dados.put("pdw", res.get((Object)TiposResultados.PDW));
        return this.dados;
    }

    @Override
    public void teste() {
        String codigoRequisicao = JOptionPane.showInputDialog("Informe a requisi\u00e7\u00e3o: ");
        StringBuilder buf = new StringBuilder();
        char[] hexa = codigoRequisicao.toCharArray();
        StringBuilder builder = new StringBuilder();
        for (char c : hexa) {
            String hexCode = String.format("%H", Character.valueOf(c));
            builder.append(hexCode);
        }
        buf.append("2");
        buf.append("30 36 2F 20 31 2F 33 31 0D 0A");
        buf.append(builder.toString()).append("0D");
        buf.append("20 37 2E 35 20 20 0D");
        buf.append("33 30 2E 35 20 20 0D");
        buf.append("20 35 2E 30 20 20 0D");
        buf.append("20 37 2E 33 20 20 0D");
        buf.append("36 34 2E 35 20 20 0D");
        buf.append("20 32 2E 33 20 20 0D");
        buf.append("20 20 2E 34 20 20 0D");
        buf.append("20 20 30 39 20 20 0D");
        buf.append("20 20 36 31 20 20 0D");
        buf.append("20 34 2E 34 35 20 0D");
        buf.append("31 33 2E 36 20 20 0D");
        buf.append("34 30 2E 32 20 20 0D");
        buf.append("39 30 2E 31 20 20 0D");
        buf.append("33 30 2E 36 20 20 0D");
        buf.append("33 33 2E 38 20 20 0D");
        buf.append("32 37 2E 33 20 20 0D");
        buf.append("20 20 2E 32 31 20 0D");
        buf.append("20 37 2E 36 20 20 0D");
        buf.append("31 37 2E 39 20 20 0D");
        buf.append("3");
        this.getPortaCOM().read(buf.toString(), buf.toString().length());
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return null;
    }
}

