/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.mek6500j;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final int REQUISICAO = 17;
    public static final String FLAG_TYPE_HIGH = "H";
    public static final String FLAG_TYPE_LOW = "L";
    public static final String FLAG_TYPE_VALOR_FORA_DO_PADRAO = "*";
    public static final String FLAG_TYPE_PLT_PODEM_ESTAR_COAGULADAS = "C";
    public static final String FLAG_TYPE_HEMOLISACAO_FRACA = "!";
    public static final String FLAG_TYPE_MUITOS_FANTASMAS_RBC = "F1";
    public static final String FLAG_TYPE_LINFOCITO_NAO_PODE_SER_ANALISADO = "F2";
    public static final String FLAG_TYPE_GRANULOCITO_NAO_PODE_SER_ANALISADO = "F3";
    public static final String FLAG_TYPE_WBC_NAO_PODE_SER_DIFERENCIADO = "F4";
    public static final String FLAG_TYPE_LEVEL_1 = "LEVEL1";
    public static final String FLAG_TYPE_LEVEL_2 = "LEVEL2";
    public static final String FLAG_TYPE_LEVEL_3 = "LEVEL3";
    public static final String FLAG_TYPE_BBL_1 = "BBL1";
    public static final String FLAG_TYPE_BBL_2 = "BBL2";
    public static final String FLAG_TYPE_BBL_3 = "BBL3";
    public static final String FLAG_TYPE_BBL_4 = "BBL4";
    public static final String FLAG_TYPE_CLOG = "CLOG";
    public static final String FLAG_TYPE_NOISE_1 = "NOISE1";
    public static final String FLAG_TYPE_NOISE_2 = "NOISE2";
    private Map<String, String> flag = new HashMap<String, String>();
    private Map<String, String> mapFlags = new HashMap<String, String>();
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento(this, 5000);
    protected int TIME_RX = 15000;

    public InterfaceListener() {
        this.flag.put(FLAG_TYPE_HIGH, "High");
        this.flag.put(FLAG_TYPE_VALOR_FORA_DO_PADRAO, "O resutlado est\u00e1 fora do valor normal");
        this.flag.put(FLAG_TYPE_PLT_PODEM_ESTAR_COAGULADAS, "PLT podem estar coaguladas");
        this.flag.put(FLAG_TYPE_LOW, "Low");
        this.flag.put(FLAG_TYPE_HEMOLISACAO_FRACA, "Hemolisa\u00e7\u00e3o Fraca");
        this.flag.put(FLAG_TYPE_MUITOS_FANTASMAS_RBC, "Muitos fantasmas RBC");
        this.flag.put(FLAG_TYPE_LINFOCITO_NAO_PODE_SER_ANALISADO, "Discrimina\u00e7\u00e3o fraca de Linf\u00f3cito ou Mon\u00f3cito");
        this.flag.put(FLAG_TYPE_GRANULOCITO_NAO_PODE_SER_ANALISADO, "Discrimina\u00e7\u00e3o fraca do Granul\u00f3cito");
        this.flag.put(FLAG_TYPE_WBC_NAO_PODE_SER_DIFERENCIADO, "Discrimina\u00e7\u00e3o fraca de Linf\u00f3cito, Mon\u00f3cito ou Granul\u00f3cito");
        this.flag.put(FLAG_TYPE_LEVEL_1, "Nivel 1 de flu\u00eddo do WBC ou RBC");
        this.flag.put(FLAG_TYPE_LEVEL_2, "Nivel 2 de flu\u00eddo do WBC ou RBC");
        this.flag.put(FLAG_TYPE_LEVEL_3, "Nivel 3 de flu\u00eddo do WBC ou RBC");
        this.flag.put(FLAG_TYPE_BBL_1, "Bolha 1 do WBC ou RBC");
        this.flag.put(FLAG_TYPE_BBL_2, "Bolha 2 do WBC ou RBC");
        this.flag.put(FLAG_TYPE_BBL_3, "Bolha 3 do WBC ou RBC");
        this.flag.put(FLAG_TYPE_BBL_4, "Bolha 4 do WBC ou RBC");
        this.flag.put(FLAG_TYPE_CLOG, "Entupido do WBC ou RBC");
        this.flag.put(FLAG_TYPE_NOISE_1, "Ru\u00eddo de software do WBC ou RBC");
        this.flag.put(FLAG_TYPE_NOISE_2, "Ru\u00eddo de hardware do WBC ou RBC");
        this.mapFlags.put("leucocitos", "Leucocitose");
        this.mapFlags.put("hemacias", "Hem\u00e1cias (Eritr\u00f3citos)");
        this.mapFlags.put("hgb", "Hemoglobina");
        this.mapFlags.put("hct", "Hemat\u00f3crito");
        this.mapFlags.put("vcm", "V.C.M.");
        this.mapFlags.put("hcm", "H.C.M.");
        this.mapFlags.put("mchc", "M.C.H.C.");
        this.mapFlags.put("rdw_cv", "R.D.W. CV");
        this.mapFlags.put("plaquetas", "Plaquetas");
        this.mapFlags.put("pct", "P.C.T.");
        this.mapFlags.put("vpm", "V.P.M.");
        this.mapFlags.put("pdw", "P.D.W.");
        this.mapFlags.put("linfocitos_tipicos_percentual", "% Linf. T\u00edpicos");
        this.mapFlags.put("monocitos_percentual", "% Mon\u00f3citos");
        this.mapFlags.put("granulocitos_percentual", "% Granul\u00f3citos");
        this.mapFlags.put("linfocitos_tipicos_contagem", "Linf. T\u00edpicos");
        this.mapFlags.put("monocitos_contagem", "Mon\u00f3citos");
        this.mapFlags.put("granulocitos_contagem", "Granul\u00f3citos");
    }

    protected void parseRecord(String codRequisicao, String[] lines) throws Exception {
        if (!Funcoes.objectIsNull(codRequisicao)) {
            int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String req_codigo = null;
            String dadoCabecalho = lines[0].trim();
            String email_alternativo = lines[4].trim();
            req_codigo = this.getCodigoApoiado(codRequisicao);
            if (Funcoes.textoVazio(email_alternativo) && !Funcoes.textoVazio(dadoCabecalho) && dadoCabecalho.equalsIgnoreCase("EXP")) {
                return;
            }
            int quantidadeDigitosEtiqueta = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            if (Funcoes.textoVazio(req_codigo) || !Funcoes.textoVazio(req_codigo) && req_codigo.length() < quantidadeDigitosEtiqueta || !Funcoes.isNumeric(req_codigo)) {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da amostra fora do padr\u00e3o %s.", req_codigo));
                return;
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String int_codigo = "";
            Map<String, Object> dados = null;
            dados = this.trataPadrao(lines, dados);
            int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, email_alternativo);
            List<String> flags = this.getFlags(dados);
            if (!flags.isEmpty()) {
                StringBuilder strFlags = new StringBuilder();
                for (String str : flags) {
                    strFlags.append(str).append(" ");
                }
                dados.put("flag", strFlags.toString());
            }
            if (Funcoes.objectIsNull(dados)) {
                this.fireExcecaoEncontrada("Tipo do resultado recebido n\u00e3o existe ou n\u00e3o interfaceado");
                return;
            }
            if (Funcoes.textoVazio(int_codigo)) {
                this.fireExcecaoEncontrada(fil_codigo + " " + req_codigo + " " + rec_codigo + " - " + "Requisi\u00e7\u00e3o n\u00e3o encontrada ou n\u00e3o interfaceada!");
                return;
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, email_alternativo);
            if (Funcoes.objectIsNull(exame)) {
                this.fireExcecaoEncontrada(fil_codigo + " " + req_codigo + " " + rec_codigo + " - " + ("Exame n\u00e3o existe ou n\u00e3o esta interfaceado (int: " + (int_codigo == null ? "-1" : int_codigo) + ", type: " + lines[4] + ")"));
                return;
            }
            Statement st = Conexao.getStatement();
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
            for (BDExame e : exames) {
                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, e.getExame(), e.getMaterial(), int_codigo, dados, flags);
            }
            this.fireAtualizarTabela();
            Conexao.arquivaSQL();
        }
    }

    private String getCodigoApoiado(String codRequisicao) {
        return codRequisicao;
    }

    protected List<String> getFlags(Map<String, Object> dados) {
        ArrayList<String> flags = new ArrayList<String>();
        for (String key : dados.keySet()) {
            String valor = (String)dados.get(key);
            String nome = this.mapFlags.get(key);
            for (String keyFlag : this.flag.keySet()) {
                if (!valor.contains(keyFlag)) continue;
                dados.put(key, valor.substring(0, valor.indexOf(keyFlag)));
                flags.add(nome + " = " + this.flag.get(keyFlag));
            }
        }
        return flags;
    }

    public Map<String, Object> trataPadrao(String[] lines, Map<String, Object> dados) throws Exception {
        dados = new HashMap<String, Object>();
        dados.put("leucocitos", this.getValor(lines[18]));
        dados.put("hemacias", this.getValor(lines[29]));
        dados.put("hgb", this.getValor(lines[30]));
        dados.put("hct", this.getValor(lines[31]));
        dados.put("vcm", this.getValor(lines[32]));
        dados.put("hcm", this.getValor(lines[33]));
        dados.put("mchc", this.getValor(lines[34]));
        dados.put("rdw_cv", this.getValor(lines[35]));
        dados.put("plaquetas", this.getValor(lines[36]));
        dados.put("pct", this.getValor(lines[37]));
        dados.put("vpm", this.getValor(lines[38]));
        dados.put("pdw", this.getValor(lines[39]));
        dados.put("linfocitos_tipicos_percentual", this.getValor(lines[40]));
        dados.put("monocitos_percentual", this.getValor(lines[41]));
        dados.put("granulocitos_percentual", this.getValor(lines[42]));
        dados.put("linfocitos_tipicos_contagem", this.getValor(lines[43]));
        dados.put("monocitos_contagem", this.getValor(lines[44]));
        dados.put("granulocitos_contagem", this.getValor(lines[45]));
        return dados;
    }

    private String getValor(String valor) {
        valor = valor.replaceAll("\\.", ",").trim();
        return valor;
    }

    @Override
    public String parse(String message) {
        try {
            Object checksum = null;
            int pos = message.length() - 1;
            if (pos == 0) {
                this.fireExcecaoEncontrada(String.format("Erro ao receber bloco de dados: Tamanho do bloco incorreto (%s)!", message));
                return "Erro ao receber bloco de dados: Tamanho do bloco incorreto!";
            }
            message = message.substring(1, pos);
            String[] msg = message.split(String.valueOf('\r'));
            boolean i = false;
            int indexCr = message.indexOf(String.valueOf('\r'));
            if (indexCr == -1 || msg.length < 0) {
                this.fireExcecaoEncontrada(String.format("Erro ao receber bloco de dados: Tamanho do bloco incorreto (%s)!", message));
                return "Erro ao receber bloco de dados: Tamanho do bloco incorreto!";
            }
            String codRequisicao = msg[17].trim();
            if (!Funcoes.isNumeric(codRequisicao) && Funcoes.textoVazio(codRequisicao)) {
                this.fireExcecaoEncontrada(String.format("Erro ao receber bloco de dados: Tamanho do bloco incorreto (%s)!", message));
                return "Erro ao receber bloco de dados: Tamanho do bloco incorreto!";
            }
            this.parseRecord(codRequisicao, msg);
            return "";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), String.format("AbstractABXInterfaceamento: parse messsage=\"%s\"", message));
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractABXInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        this.setIdle();
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (message.startsWith("\n")) {
                message = message.substring(1, message.length());
            }
            if (!message.isEmpty() && message.startsWith(this.getMsgStart())) {
                this.addListaRecebimento(message);
            } else {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractABXInterfaceamento: evento de dados recebidos");
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
                }
            };
            SwingUtilities.invokeLater(run);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    protected void restartThreadRecebimento() {
        if (!Funcoes.objectIsNull(this.threadRecebimento) && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (!this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        this.threadRecebimento.start();
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    protected void aguardarProximoFrame() throws Exception {
        this.setRX(this.TIME_RX);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return null;
    }
}

