/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.maxcell500dauto;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.maxcell500dauto.MessageOrrO02;
import jalis.laboratorio.interfaceamento.interfaces.maxcell500dauto.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Factory;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegment;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegmentType;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrmO01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends InterfaceHl7Listener {
    public Factory messageFactory;
    private static final String IMAGE_BMP_BASE64 = "^Image^BMP^Base64^";
    private static final String IMAGE_PNG_BASE64 = "^Image^PNG^Base64^";
    private HashMap<String, String> parametros = new HashMap();
    private Map<String, String> warning = new HashMap<String, String>();

    public InterfaceListener() {
        super("maxcell500dauto");
        this.parametros.put("6690-2^WBC^LN", "leucocitos");
        this.parametros.put("704-7^BAS#^LN", "basofilos_contagem");
        this.parametros.put("706-2^BAS%^LN", "basofilos_percentual");
        this.parametros.put("751-8^NEU#^LN", "neutrofilo_contagem");
        this.parametros.put("770-8^NEU%^LN", "neutrofilo_percentual");
        this.parametros.put("711-2^EOS#^LN", "eosinofilos_contagem");
        this.parametros.put("713-8^EOS%^LN", "eosinofilos_percentual");
        this.parametros.put("731-0^LYM#^LN", "linfocitos_tipicos_contagem");
        this.parametros.put("736-9^LYM%^LN", "linfocitos_tipicos_percentual");
        this.parametros.put("742-7^MON#^LN", "monocitos_contagem");
        this.parametros.put("5905-5^MON%^LN", "monocitos_percentual");
        this.parametros.put("26477-0^*ALY#^LN", "linfocitos_atipicos_contagem");
        this.parametros.put("13046-8^*ALY%^LN", "linfocitos_atipicos_percentual");
        this.parametros.put("789-8^RBC^LN", "hemacias");
        this.parametros.put("718-7^HGB^LN", "hgb");
        this.parametros.put("787-2^MCV^LN", "vcm");
        this.parametros.put("785-6^MCH^LN", "hcm");
        this.parametros.put("786-4^MCHC^LN", "mchc");
        this.parametros.put("788-0^RDW-CV^LN", "rdw_cv");
        this.parametros.put("21000-5^RDW-SD^LN", "rdw_sd");
        this.parametros.put("4544-3^HCT^LN", "hct");
        this.parametros.put("777-3^PLT^LN", "plaquetas");
        this.parametros.put("32623-1^MPV^LN", "vpm");
        this.parametros.put("32207-3^PDW^LN", "pdw");
        this.parametros.put("11003^PCT^99MRC", "pct");
        this.parametros.put("11002^*LIC%^99MRC", "bastonados_percentual");
        this.parametros.put("11001^*LIC#^99MRC", "bastonados_contagem");
        this.parametros.put("48386-7^P-LCR^LN", "plaquetas_lcr");
        this.parametros.put("34167-7^P-LCC^LN", "plaquetas_lcc");
        this.parametros.put("12003^WBC Histogram. BMP^99MRC", "celldyn_histograma_wb1");
        this.parametros.put("12053^RBC Histogram. BMP^99MRC", "celldyn_histograma_rbc");
        this.parametros.put("12103^PLT Histogram. BMP^99MRC", "celldyn_histograma_plt");
        this.warning.put("13101^Leucocytosis^99MRC", "Leucocytosis");
        this.warning.put("13102^Leucopenia^99MRC", "Leucopenia");
        this.warning.put("13103^Neutrophilia^99MRC", "Neutrophilia");
        this.warning.put("13104^Neutropenia^99MRC", "Neutropenia");
        this.warning.put("13110^Neutrophilia^99MRC", "Neutrophilia");
        this.warning.put("13111^Neutropenia^99MRC", "Neutropenia");
        this.warning.put("13105^Lymphocytosis^99MRC", "Lymphocytosis");
        this.warning.put("13106^Lymphopenia^99MRC", "Lymphopenia");
        this.warning.put("13107^Monocytosis^99MRC^", "Monocytosis");
        this.warning.put("13108^Eosinophilia^99MRC", "Eosinophilia");
        this.warning.put("13109^Basophilia^99MRC", "Basophilia");
        this.warning.put("13113^Increased Mid Cells^99MRC", "Increased Mid Cells");
        this.warning.put("13112^Decreased Mid Cells^99MRC", "Decreased Mid Cells");
        this.warning.put("13001^Background/Aspiration Abn.^99MRC", "Background/Aspiration Abn");
        this.warning.put("13005^Abnormal WBC Channel^99MRC", "Abnormal WBC Channel");
        this.warning.put("13006^Abnormal DIFF Channel^99MRC", "Abnormal DIFF Channel");
        this.warning.put("13202^RBC Clump?^99MRC", "RBC Clump?");
        this.warning.put("13203^Iron Deficiency?^99MRC", "Iron Deficiency?");
        this.warning.put("13205^Abnormal RBC Channel^99MRC", "Abnormal RBC Channel");
        this.warning.put("13206^Abnormal HGB Channel^99MRC", "Abnormal HBG Channel");
        this.warning.put("13701^CRP Increased^99MRC", "CRP Increased");
        this.warning.put("13702^HS-CRP Increased^99MRC", "HS-CRP Increased");
        this.warning.put("13601^Abnormal CRP Channel^99MRC", "Abnormal CRP Channel");
        this.warning.put("34525-6^rstRBC^LN", "rstRBC");
        this.warning.put("17790-7^WBC Left Shift?^LN", "WBC Left Shift");
        this.warning.put("34165-1^ImmGranulocytes?^LN", "IMM Granulocytes");
        this.warning.put("15192-8^Atypical Lymphs?^LN", "Atypical Lymphs");
        this.warning.put("13002^WBC Abnormal^99MRC", "WBC Abnormal");
        this.warning.put("13003^WBC Abnormal scattergram^99MRC", "WBC Abnormal scattergram");
        this.warning.put("13004^WBC Abnormal histogram^99MRC", "WBC Abnormal histogram");
        this.warning.put("13002^WBC Abnormal^99MRC", "WBC Abnormal");
        this.warning.put("15150-6^Anisocytosis^LN", "Anisocytosis");
        this.warning.put("15198-5^Macrocytes^LN", "Macrocytes");
        this.warning.put("15199-3^Microcytes^LN", "Mycrocytes");
        this.warning.put("15180-3^Hypochromia^LN", "Hypochromia");
        this.warning.put("13301^Erythrocytosis^99MRC", "Erythrocytosis");
        this.warning.put("13302^Anemia^99MRC", "Anemia");
        this.warning.put("10379-6^RBC Dual Pop^LN", "RBC Dual Pop");
        this.warning.put("13201^RBC Abnormal distribution^99MRC", "RBC Abnormal distribution");
        this.warning.put("13204^HGB Interfere^99MRC", "HGB Interfere");
        this.warning.put("13501^Thrombocytos is^99MRC", "Thrombocytosis");
        this.warning.put("13502^Thrombopenia^99MRC", "Thrombopenia");
        this.warning.put("13401^PLT Abnormal Distribution^99MRC", "PLT Abnormal Distribution");
        this.warning.put("7796-6^Platelet Clump?^LN", "Platelet Clump?");
        this.parametros.putAll(this.warning);
    }

    @Override
    protected String getPacienteDataNascimento(String filial, String requisicao) {
        Date nasc = BDUtil.getDataNacimentoPaciente(filial, requisicao);
        if (Funcoes.objectIsNull(nasc)) {
            return "";
        }
        return Funcoes.formataData("yyyyMMdd", nasc) + "000000";
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = oruR01.getObr().getFilterOrderNumber();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx obx;
                String emiAlternativo;
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), recCodigo, emiAlternativo = (obx = this.buscaObxPeloObservationID(oruR01.getObxList(), "02003^Test Mode^99MRC")).getObservationValue());
                if (Funcoes.textoVazio(intCodigo)) {
                    this.fireExcecaoEncontrada("N\u00e3o foi poss\u00ed\u00advel encontrar a interface para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + emiAlternativo);
                    return;
                }
                ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                if (Funcoes.objectIsNull(exame)) {
                    this.fireExcecaoEncontrada("Nenhum exame foi encontrado para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + emiAlternativo);
                    return;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                ArrayList<String> flags = new ArrayList<String>();
                ArrayList<String> listaWarning = new ArrayList<String>();
                int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                for (String p : this.parametros.keySet()) {
                    obx = this.buscaObxPeloObservationID(oruR01.getObxList(), p);
                    if (Funcoes.objectIsNull(obx)) continue;
                    if (!Funcoes.objectIsNull((Object)obx.getAbnormalFlag()) && !obx.getAbnormalFlag().equals((Object)MessageSegmentObx.AbnormalFlag.NORMAL)) {
                        flags.add(this.tratarDescricao(p) + " - " + obx.getAbnormalFlag().toString());
                    }
                    String campo = this.parametros.get(p);
                    String resultado = obx.getObservationValue();
                    this.retornaAlerta(campo, resultado, listaWarning);
                    if (resultado.length() > IMAGE_PNG_BASE64.length() && resultado.substring(0, IMAGE_PNG_BASE64.length()).equalsIgnoreCase(IMAGE_PNG_BASE64)) {
                        resultado = resultado.substring(IMAGE_PNG_BASE64.length());
                        resultado = this.convertImg(reqCodigo, resultado, p, "png");
                    } else if (resultado.length() > IMAGE_BMP_BASE64.length() && resultado.substring(0, IMAGE_BMP_BASE64.length()).equalsIgnoreCase(IMAGE_BMP_BASE64)) {
                        resultado = resultado.substring(IMAGE_BMP_BASE64.length());
                        resultado = this.convertImg(reqCodigo, resultado, p, "bmp");
                    } else {
                        resultado = resultado.replace('.', ',');
                    }
                    dados.put(campo, resultado);
                }
                flags.addAll(listaWarning);
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                for (BDExame exa : exames) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exa.getExame(), exa.getMaterial(), intCodigo, dados, flags);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
            ackR01.getMsa().setTextMessage("Erro ao receber a mensagem");
            ackR01.getMsa().setErrorCondition(ErrorCondition.APPLICATION_INTERNAL_ERROR);
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    private String convertImg(String reqCodigo, String resultado, String p, String extensaoArquivo) throws IOException {
        Base64 b64 = new Base64();
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(b64.decode(resultado)));
        ImageIO.getCacheDirectory();
        File img = File.createTempFile("maxcel500dauto_" + reqCodigo + "_" + new Date().getTime(), "." + extensaoArquivo);
        ImageIO.write((RenderedImage)image, extensaoArquivo, img);
        BufferedImage imgNew = ImageIO.read(img);
        resultado = b64.encodeAsString(ImagemUtils.imageToByte(imgNew));
        img.delete();
        return resultado;
    }

    private void retornaAlerta(String campo, String resultado, List<String> listaWarning) {
        if (this.warning.containsValue(campo)) {
            listaWarning.add(campo);
        }
    }

    private String tratarDescricao(String p) {
        String[] campo = p.split("\\^");
        return campo != null && campo.length > 1 ? campo[1] : p;
    }

    private jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx buscaObxPeloObservationID(List<jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx> listObx, String observationID) {
        for (jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx obx : listObx) {
            if (!obx.getObservationId().equals(observationID)) continue;
            return obx;
        }
        return null;
    }

    @Override
    protected void messageOrmO01Recebida(MessageOrmO01 ormO01) {
        block17: {
            String messageId = ormO01.getMsh().getMessageControlId();
            MessageOrrO02 orrO02 = new MessageOrrO02();
            try {
                String tuboId = ormO01.getOrc().getFilterOrderNumber();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (!Funcoes.objectIsNull(tuboId) && !tuboId.trim().isEmpty() && tuboId != "null" && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                        aba = this.equipamento.getTab(1);
                    }
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                        aba = this.equipamento.getTab(2);
                    }
                    if (req == null) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        return;
                    }
                    String exames = (String)req[aba.getColIndice("Exame")];
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    String pacNasc = this.getPacienteDataNascimento(filCodigo, reqCodigo);
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (n == 0 || n == 1) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<String> tests = new HashSet<String>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test == null || test.trim().isEmpty()) continue;
                        tests.add(test);
                    }
                    if (tests.isEmpty()) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(filCodigo).append(reqCodigo).append("^^^^");
                        Date dataHoraRequisicao = new Date();
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        orrO02.getPid().setId(1);
                        orrO02.getPid().setPatientName("^" + pacNome);
                        orrO02.getPid().setSex(pacSexo);
                        orrO02.getPid().setDataOfBirth(pacNasc);
                        orrO02.getPid().setPatientIdentifierList(stringBuilder.toString());
                        orrO02.getOrc().setOrderControl("AF");
                        orrO02.getOrc().setFilterOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getOrc().setOrderStatus("IP");
                        orrO02.getObr().setFilterOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setRequestDateTime(dataHoraRequisicao);
                        orrO02.getObr().setCollectorIdentifier("MA");
                        orrO02.getObr().setSpecimenReceiveDateTime(dataHoraRequisicao);
                        orrO02.getObr().setDiagnosticServSect("HM");
                        MessageSegmentObx obx = new MessageSegmentObx();
                        obx.setId(1);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("02001^Take Mode^99MRC");
                        obx.setObservationValue("A");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        obx = new MessageSegmentObx();
                        obx.setId(2);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("02002^Blood Mode^99MRC");
                        obx.setObservationValue("W");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        for (String alternativo : tests) {
                            obx = new MessageSegmentObx();
                            obx.setId(3);
                            obx.setValueType(MessageSegmentObx.ValueType.IS);
                            obx.setObservationId("02003^Test Mode^99MRC");
                            obx.setObservationValue(alternativo);
                            obx.setObserveResultStatus("F");
                            orrO02.addObx(obx);
                        }
                        obx = new MessageSegmentObx();
                        obx.setId(4);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("03001^Ref Group^99MRC");
                        obx.setObservationValue("General");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        this.enviaMensagem(messageId, orrO02);
                        this.alteraSituacaoParaPendentes((InfoExameRequisicao)this.examesEnviadosPorSid.get(tuboId));
                        this.examesEnviadosPorSid.remove(tuboId);
                    }
                    break block17;
                }
                orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                this.enviaMensagem(messageId, orrO02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    @Override
    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setSendingApplication("DH56");
            mensagem.getMsh().setSendingFacility("Dymind");
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.3.1");
            mensagem.getMsh().setCharacterSet("UNICODE");
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            this.getPortaCOM().write(this.messageToText(mensagem, this.fieldSeparator));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    @Override
    public String parse(String text) {
        try {
            Message message = this.messageParser.textToMessage(text);
            this.mensagemRecebida(message);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    public void teste() {
        String tubo = Funcoes.showDigitacao(null, "Aten\u00e7\u00e3o", "Informe o tubo.", "fil + req + tubo");
        if (!tubo.trim().isEmpty()) {
            if (Funcoes.showPerguntaOpcoes(null, "Informe o tipo de Opera\u00e7\u00e3o", new String[]{"Query", "Resultado"}) == 0) {
                this.query(tubo);
            } else {
                this.resultado(tubo);
            }
        }
    }

    private void query(String tubo) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[SB]MSH|^~\\&|DF5x|Dymind|||20200319160223||ORM^O01|20200319_160223_292|P|2.3.1||||||UNICODE").append("[CR]");
        buffer.append("ORC|RF||").append(tubo).append("||IP").append("[CR]");
        buffer.append("[EB][CR]");
        this.parse(TestesInterface.arruma(buffer.toString()));
    }

    public final String messageToText(Message message, char fieldSeparator) {
        StringBuilder builder = new StringBuilder();
        this.messageToText(message, fieldSeparator, builder);
        return builder.toString();
    }

    public final void messageToText(Message message, char fieldSeparator, StringBuilder builder) {
        builder.append('\u000b');
        for (MessageSegment messageSegment : message.getMessageSegments()) {
            this.messageSegmentToText(messageSegment, fieldSeparator, builder);
            if (messageSegment.getType().equals((Object)MessageSegmentType.PID)) {
                builder.append('\r');
                builder.append("PV1|1|Inpatient|Surgical^1^2|||||||||||||||||Self-paid");
            }
            builder.append('\r');
        }
        builder.append('\u001c').append('\r');
    }

    public final void messageSegmentToText(MessageSegment messageSegment, char fieldSeparator, StringBuilder text) {
        String[] fields = messageSegment.getFields();
        text.append(messageSegment.getType().toString());
        for (int i = 0; i < fields.length; ++i) {
            text.append(fieldSeparator);
            if (fields[i] == null) continue;
            text.append(fields[i]);
        }
        text.append(fieldSeparator);
    }

    public void resultado(String tubo) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[SB]MSH|^~\\&|DF5x|Dymind|||20220413142804||ORU^R01|20220413_142651_750|P|2.3.1||||||UNICODE[CR]");
        buffer.append("PID|1||010005422416^^^^MR||^TESTEEEE|||F[CR]");
        buffer.append("PV1|1|Inpatient|Internal medicine^1^2|||||||||||||||||Self-paid[CR]");
        buffer.append("OBR|1||").append(tubo).append("|01001^Automated Count^99MRC||20220413142605|20220413142651|||MA||||20220413142605||||||||||HM||||||||admin[CR]");
        buffer.append("OBX|1|IS|02001^Take Mode^99MRC||O||||||F[CR]");
        buffer.append("OBX|2|IS|02002^Blood Mode^99MRC||W||||||F[CR]");
        buffer.append("OBX|3|IS|02003^Test Mode^99MRC||CBC+DIFF||||||F[CR]");
        buffer.append("OBX|4|NM|30525-0^Age^LN|||yr|||||F[CR]");
        buffer.append("OBX|5|IS|09001^Remark^99MRC||||||||F[CR]");
        buffer.append("OBX|6|IS|03001^Ref Group^99MRC||General||||||F[CR]");
        buffer.append("OBX|7|NM|6690-2^WBC^LN||2,15|10*3/uL|3,50-9,50|L~A|||F[CR]");
        buffer.append("OBX|8|NM|770-8^NEU%^LN||62,7|%|40,0-75,0|~N|||F[CR]");
        buffer.append("OBX|9|NM|736-9^LYM%^LN||27,3|%|20,0-50,0|~N|||F[CR]");
        buffer.append("OBX|10|NM|5905-5^MON%^LN||8,4|%|3,0-10,0|~N|||F[CR]");
        buffer.append("OBX|11|NM|713-8^EOS%^LN||0,3|%|0,4-8,0|L~A|||F[CR]");
        buffer.append("OBX|12|NM|706-2^BAS%^LN||1,3|%|0,0-1,0|H~A|||F[CR]");
        buffer.append("OBX|13|NM|751-8^NEU#^LN||1,34|10*3/uL|1,80-6,30|L~A|||F[CR]");
        buffer.append("OBX|14|NM|731-0^LYM#^LN||0,59|10*3/uL|1,10-3,20|L~A|||F[CR]");
        buffer.append("OBX|15|NM|742-7^MON#^LN||0,18|10*3/uL|0,10-0,60|~N|||F[CR]");
        buffer.append("OBX|16|NM|711-2^EOS#^LN||0,01|10*3/uL|0,02-0,52|L~A|||F[CR]");
        buffer.append("OBX|17|NM|704-7^BAS#^LN||0,03|10*3/uL|0,00-0,06|~N|||F[CR]");
        buffer.append("OBX|18|NM|26477-0^*ALY#^LN||0,02|10*3/uL|0,00-0,20|~N|||F[CR]");
        buffer.append("OBX|19|NM|13046-8^*ALY%^LN||1,0|%|0,0-2,0|~N|||F[CR]");
        buffer.append("OBX|20|NM|11001^*LIC#^99MRC||0,01|10*3/uL|0,00-0,20|~N|||F[CR]");
        buffer.append("OBX|21|NM|11002^*LIC%^99MRC||0,4|%|0,0-2,5|~N|||F[CR]");
        buffer.append("OBX|22|NM|789-8^RBC^LN||4,76|10*6/uL|3,80-5,80|~N|||F[CR]");
        buffer.append("OBX|23|NM|718-7^HGB^LN||12,1|g/dL|11,5-17,5|~N|||F[CR]");
        buffer.append("OBX|24|NM|4544-3^HCT^LN||38,4|%|35,0-50,0|~N|||F[CR]");
        buffer.append("OBX|25|NM|787-2^MCV^LN||80,7|fL|82,0-100,0|L~A|||F[CR]");
        buffer.append("OBX|26|NM|785-6^MCH^LN||25,4|pg|27,0-34,0|L~A|||F[CR]");
        buffer.append("OBX|27|NM|786-4^MCHC^LN||31,5|g/dL|31,6-35,4|L~A|||F[CR]");
        buffer.append("OBX|28|NM|788-0^RDW-CV^LN||12,6|%|11,0-16,0|~N|||F[CR]");
        buffer.append("OBX|29|NM|21000-5^RDW-SD^LN||42,0|fL|35,0-56,0|~N|||F[CR]");
        buffer.append("OBX|30|NM|777-3^PLT^LN||199|10*3/uL|125-350|~N|||F[CR]");
        buffer.append("OBX|31|NM|32623-1^MPV^LN||9,1|fL|6,5-12,0|~N|||F[CR]");
        buffer.append("OBX|32|NM|32207-3^PDW^LN||11,6|fL|9,0-17,0|~N|||F[CR]");
        buffer.append("OBX|33|NM|11003^PCT^99MRC||0,181|%|0,108-0,282|~N|||F[CR]");
        buffer.append("OBX|34|IS|17790-7^WBC Left Shift?^LN||T||||||F[CR]");
        buffer.append("[EB][CR]");
        this.parse(TestesInterface.arruma(buffer.toString()));
    }
}

