/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.manual;

import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.abas.AbaExcecoes;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.interfaces.manual.AbaNaoEnviados;
import jalis.laboratorio.interfaceamento.interfaces.manual.AbaPendente;
import jalis.laboratorio.interfaceamento.interfaces.manual.InterfaceConfiguracao;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class Manual
extends AbstractInterfaceamento {
    private boolean envioPorRack = false;
    private boolean imprimirMapa = false;
    private boolean imprimirEtiquetaColeta = false;
    private boolean imprimirEtiquetaColetaAutomatica = false;
    private boolean digitarDadosBrutos = false;
    private boolean ativarContadorCelula = false;

    public Manual(JFrame parent) {
        super(parent);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
        configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.digitarDadosBrutos = configuracao.isDigitarDadosBrutos();
        this.ativarContadorCelula = configuracao.isAtivarContadorCelulas();
    }

    @Override
    public PanelAbaAbstrata getAbaNaoEnviados() {
        if (this.examesNaoEnviados == null) {
            ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
            InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
            configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
            this.envioPorRack = configuracao.isEnvioPorRack();
            this.imprimirMapa = configuracao.isImprimirMapa();
            this.imprimirEtiquetaColeta = configuracao.isImprimirEtiquetaColeta();
            this.imprimirEtiquetaColetaAutomatica = configuracao.isImprimirEtiquetaColetaAutomatica();
            this.digitarDadosBrutos = configuracao.isDigitarDadosBrutos();
            this.examesNaoEnviados = new AbaNaoEnviados(this.parent, this, this.envioPorRack, this.imprimirEtiquetaColetaAutomatica);
            if (this.envioPorRack) {
                int index = this.examesNaoEnviados.getColIndice("Exame");
                this.examesNaoEnviados.addColVisivel(++index, "Rack", "rack_position", false);
                this.examesNaoEnviados.forceColSize(index, 70);
            }
        }
        return this.examesNaoEnviados;
    }

    @Override
    public PanelAbaAbstrata getAbaPendentes() {
        if (this.examesPendentes == null) {
            this.examesPendentes = new AbaPendente(this.parent, this, this.envioPorRack, this.imprimirMapa, this.imprimirEtiquetaColeta, this.digitarDadosBrutos);
        }
        if (this.envioPorRack) {
            int index = this.examesPendentes.getColIndice("Exame");
            this.examesPendentes.addColVisivel(++index, "Rack", "rack_position", false);
            this.examesPendentes.forceColSize(index, 70);
        }
        return this.examesPendentes;
    }

    @Override
    public PanelAbaAbstrata getAbaProntos() {
        if (this.examesProntos == null) {
            this.examesProntos = new AbaDefaultProntos(this.parent, this);
        }
        return this.examesProntos;
    }

    @Override
    public AbaExcecoes getAbaExcecoes() {
        return new AbaExcecoes(this.parent, this);
    }

    public ImageIcon getLogoEquipamento() {
        return null;
    }

    @Override
    public String getName() {
        return "Equipamento Manual";
    }

    @Override
    public boolean isAutoEnvio() {
        return true;
    }

    @Override
    public boolean isContadorEnvio() {
        return false;
    }

    @Override
    public boolean isContadorCelula() {
        return this.ativarContadorCelula;
    }

    @Override
    public boolean isPesquisaExamesComExcecao() {
        return false;
    }

    @Override
    public boolean isAutoImportador() {
        return true;
    }

    @Override
    public boolean digitarDadosBrutos() {
        return this.digitarDadosBrutos;
    }
}

