/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.manual;

import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.util.StringUtil;
import jalis.util.xml.XMLStringBuilder;
import jalis.util.xml.XMLStringBuilderException;

public class InterfaceConfiguracao
extends InterfaceamentoConfiguracao {
    private String ENVIO_POR_RACK = "envioPorRack";
    private String IMPRIMIR_MAPA = "imprimirMapa";
    private String IMPRIMIR_ETIQUETA_COLETA = "imprimirEtiquetaColeta";
    private String IMPRIMIR_ETIQUETA_COLETA_AUTOMATICA = "imprimirEtiquetaColetaAutomatica";
    private String DIGITAR_DADOS_BRUTOS = "digitarDadosBrutos";
    private String ATIVAR_CONTADOR_CELULAS = "ativarContadorCelulas";
    private boolean envioPorRack;
    private boolean imprimirMapa;
    private boolean imprimirEtiquetaColeta;
    private boolean imprimirEtiquetaColetaAutomatica;
    private boolean digitarDadosBrutos = false;
    private boolean ativarContadorCelulas;

    @Override
    public String getXmlVariaveis() {
        String str = super.getXmlVariaveis();
        try {
            XMLStringBuilder xml = new XMLStringBuilder();
            xml.abrir("variavel");
            xml.escrever("nome", this.ENVIO_POR_RACK);
            xml.escrever("valor", this.isEnvioPorRack() ? "1" : "0");
            xml.escrever("tipo", CHECK);
            xml.fechar("variavel");
            xml.abrir("variavel");
            xml.escrever("nome", this.IMPRIMIR_MAPA);
            xml.escrever("valor", this.isImprimirMapa() ? "1" : "0");
            xml.escrever("tipo", CHECK);
            xml.fechar("variavel");
            xml.abrir("variavel");
            xml.escrever("nome", this.IMPRIMIR_ETIQUETA_COLETA);
            xml.escrever("valor", this.isImprimirEtiquetaColeta() ? "1" : "0");
            xml.escrever("tipo", CHECK);
            xml.fechar("variavel");
            xml.abrir("variavel");
            xml.escrever("nome", this.IMPRIMIR_ETIQUETA_COLETA_AUTOMATICA);
            xml.escrever("valor", this.isImprimirEtiquetaColetaAutomatica() ? "1" : "0");
            xml.escrever("tipo", CHECK);
            xml.fechar("variavel");
            xml.abrir("variavel");
            xml.escrever("nome", this.DIGITAR_DADOS_BRUTOS);
            xml.escrever("valor", this.isDigitarDadosBrutos() ? "1" : "0");
            xml.escrever("tipo", CHECK);
            xml.fechar("variavel");
            xml.abrir("variavel");
            xml.escrever("nome", this.ATIVAR_CONTADOR_CELULAS);
            xml.escrever("valor", this.isAtivarContadorCelulas() ? "1" : "0");
            xml.escrever("tipo", CHECK);
            xml.fechar("variavel");
            return str + xml.getXML();
        }
        catch (XMLStringBuilderException e) {
            e.printStackTrace();
            return str;
        }
    }

    @Override
    public void setXmlVariaveis(String xml) {
        String[] variaveis;
        for (String s : variaveis = StringUtil.getValores(xml, "variavel")) {
            String nome = StringUtil.getValor(s, "nome");
            String valor = StringUtil.getValor(s, "valor");
            if (nome.equalsIgnoreCase(this.ENVIO_POR_RACK)) {
                this.setEnvioPorRack(StringUtil.getValor(s, "valor").equalsIgnoreCase("1"));
                continue;
            }
            if (nome.equalsIgnoreCase(this.IMPRIMIR_MAPA)) {
                this.setImprimirMapa(StringUtil.getValor(s, "valor").equalsIgnoreCase("1"));
                continue;
            }
            if (nome.equalsIgnoreCase(this.IMPRIMIR_ETIQUETA_COLETA)) {
                this.setImprimirEtiquetaColeta(StringUtil.getValor(s, "valor").equalsIgnoreCase("1"));
                continue;
            }
            if (nome.equalsIgnoreCase(this.IMPRIMIR_ETIQUETA_COLETA_AUTOMATICA)) {
                this.setImprimirEtiquetaColetaAutomatica(StringUtil.getValor(s, "valor").equalsIgnoreCase("1"));
                continue;
            }
            if (nome.equalsIgnoreCase(this.DIGITAR_DADOS_BRUTOS)) {
                this.setDigitarDadosBrutos(StringUtil.getValor(s, "valor").equalsIgnoreCase("1"));
                continue;
            }
            if (!nome.equalsIgnoreCase(this.ATIVAR_CONTADOR_CELULAS)) continue;
            this.setAtivarContadorCelulas(StringUtil.getValor(s, "valor").equalsIgnoreCase("1"));
        }
        super.setXmlVariaveis(xml);
    }

    @Override
    public String getNomeVariavel(String variavel) {
        if (variavel.equalsIgnoreCase(this.IMPRIMIR_MAPA)) {
            return "Imprimir mapa";
        }
        if (variavel.equalsIgnoreCase(this.IMPRIMIR_ETIQUETA_COLETA)) {
            return "Imprimir etiqueta de coleta";
        }
        if (variavel.equalsIgnoreCase(this.IMPRIMIR_ETIQUETA_COLETA_AUTOMATICA)) {
            return "Imprimir etiqueta de coleta autom\u00e1tica";
        }
        if (variavel.equalsIgnoreCase(this.ENVIO_POR_RACK)) {
            return "Utilizar envio por rack";
        }
        if (variavel.equalsIgnoreCase(this.DIGITAR_DADOS_BRUTOS)) {
            return "Digitar dados brutos";
        }
        if (variavel.equals(this.ATIVAR_CONTADOR_CELULAS)) {
            return "Habilitar contador de c\u00e9lulas";
        }
        return super.getNomeVariavel(variavel);
    }

    public boolean isEnvioPorRack() {
        return this.envioPorRack;
    }

    public void setEnvioPorRack(boolean envioPorRack) {
        this.envioPorRack = envioPorRack;
    }

    public boolean isDigitarDadosBrutos() {
        return this.digitarDadosBrutos;
    }

    public boolean isAtivarContadorCelulas() {
        return this.ativarContadorCelulas;
    }

    public void setDigitarDadosBrutos(boolean digitarDadosBrutos) {
        this.digitarDadosBrutos = digitarDadosBrutos;
    }

    public void setAtivarContadorCelulas(Boolean ativarContadorCelulas) {
        this.ativarContadorCelulas = ativarContadorCelulas;
    }

    public boolean isImprimirMapa() {
        return this.imprimirMapa;
    }

    public boolean isImprimirEtiquetaColeta() {
        return this.imprimirEtiquetaColeta;
    }

    public boolean isImprimirEtiquetaColetaAutomatica() {
        return this.imprimirEtiquetaColetaAutomatica;
    }

    public void setImprimirEtiquetaColeta(boolean b) {
        this.imprimirEtiquetaColeta = b;
    }

    public void setImprimirMapa(boolean b) {
        this.imprimirMapa = b;
    }

    public void setImprimirEtiquetaColetaAutomatica(boolean b) {
        this.imprimirEtiquetaColetaAutomatica = b;
    }
}

