/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.manual;

import jalis.comum.Acesso;
import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultPendentes;
import jalis.laboratorio.interfaceamento.interfaces.manual.AbaNaoEnviados;
import jalis.laboratorio.interfaceamento.interfaces.manual.ExameLote;
import jalis.laboratorio.interfaceamento.interfaces.manual.RequisicaoRack;
import jalis.laboratorio.interfaceamento.resultados.EditarDadosBrutos;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.util.Funcoes;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;

public class AbaPendente
extends AbaDefaultPendentes {
    private JButton buttonLote = new BotaoNavegavel("Lote", 'L');
    private JButton buttonRack = new BotaoNavegavel("Rack", 'A');
    private JButton buttonMapa = new BotaoNavegavel("Mapa", 'M');
    private JButton buttonDadosBrutos = new BotaoNavegavel("Dados brutos", 'D');
    private JButton buttonEtiquetaColeta = new BotaoNavegavel("Etiqueta", 'E');
    private boolean envioPorRack = false;
    private boolean imprimirEtiquetaColeta = false;
    private boolean imprimirMapa = false;
    private boolean dadosBrutos = false;

    public AbaPendente(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip);
        this.configPanelLote();
    }

    public AbaPendente(JFrame parent, AbstractInterfaceamento equip, boolean envioPorRack, boolean imprimirMapa, boolean imprimirEtiquetaColeta, boolean dadosBrutos) {
        super(parent, equip);
        this.imprimirMapa = imprimirMapa;
        this.imprimirEtiquetaColeta = imprimirEtiquetaColeta;
        this.dadosBrutos = dadosBrutos;
        if (envioPorRack) {
            this.configPanelRack();
        } else {
            this.configPanelLote();
        }
    }

    private void configPanelLote() {
        this.button_panel.remove(this.jButtonReenviar);
        this.button_panel.remove(this.jButtonResultado);
        this.button_panel.add((Component)this.buttonLote, 0);
        int pos = 2;
        if (this.imprimirMapa) {
            this.button_panel.add((Component)this.buttonMapa, pos);
            ++pos;
        }
        if (this.imprimirEtiquetaColeta) {
            this.button_panel.add((Component)this.buttonEtiquetaColeta, pos);
            ++pos;
        }
        if (this.dadosBrutos) {
            this.button_panel.add((Component)this.buttonDadosBrutos, pos);
        }
        this.buttonLote.setMargin(new Insets(2, 5, 2, 5));
        this.buttonLote.setPreferredSize(new Dimension(50, 20));
        this.buttonMapa.setMargin(new Insets(2, 5, 2, 5));
        this.buttonMapa.setPreferredSize(new Dimension(50, 20));
        this.buttonEtiquetaColeta.setMargin(new Insets(2, 5, 2, 5));
        this.buttonEtiquetaColeta.setPreferredSize(new Dimension(80, 20));
        this.buttonDadosBrutos.setMargin(new Insets(2, 5, 2, 5));
        this.buttonDadosBrutos.setPreferredSize(new Dimension(110, 20));
        this.buttonLote.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaPendente.this.lote();
            }
        });
        this.buttonMapa.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final int linha = AbaPendente.this.tabelaExames.getSelectedRow();
                if (linha > -1) {
                    new Thread("Thread - imprimir mapa"){

                        @Override
                        public void run() {
                            try {
                                String requisicao = (String)AbaPendente.this.tabelaExames.getValueAt(linha, AbaPendente.this.getColIndice("C\u00f3digo"));
                                String exame = (String)AbaPendente.this.tabelaExames.getValueAt(linha, AbaPendente.this.getColIndice("Exame"));
                                String material = (String)AbaPendente.this.tabelaExames.getValueAt(linha, AbaPendente.this.getColIndice("C\u00f3d. Mat."));
                                String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                                requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
                                Impressao.imprimirMapa(filial, requisicao, new String[]{exame}, new int[]{Integer.parseInt(material)}, true, false, -1);
                                Conexao.arquivaSQL();
                            }
                            catch (Exception ex) {
                                try {
                                    Conexao.anulaSQL();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbaPendente (87)");
                            }
                        }
                    }.start();
                }
            }
        });
        this.buttonEtiquetaColeta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final int linha = AbaPendente.this.tabelaExames.getSelectedRow();
                if (linha > -1) {
                    new Thread("Thread - imprimir etq coleta"){

                        @Override
                        public void run() {
                            try {
                                String requisicao = (String)AbaPendente.this.tabelaExames.getValueAt(linha, AbaPendente.this.getColIndice("C\u00f3digo"));
                                String exame = (String)AbaPendente.this.tabelaExames.getValueAt(linha, AbaPendente.this.getColIndice("Exame"));
                                String material = (String)AbaPendente.this.tabelaExames.getValueAt(linha, AbaPendente.this.getColIndice("C\u00f3d. Mat."));
                                String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                                requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
                                Impressao.imprimirEtiquetaColeta(filial, requisicao, exame, Integer.parseInt(material), true);
                                Conexao.arquivaSQL();
                            }
                            catch (Exception ex) {
                                try {
                                    Conexao.anulaSQL();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbaPendente (99)");
                            }
                        }
                    }.start();
                }
            }
        });
        this.buttonDadosBrutos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaPendente.this.dadosBrutos();
            }
        });
    }

    private void configPanelRack() {
        this.button_panel.remove(this.jButtonReenviar);
        this.button_panel.remove(this.jButtonResultado);
        this.button_panel.add((Component)this.buttonRack, 0);
        this.buttonRack.setMargin(new Insets(2, 5, 2, 5));
        this.buttonRack.setPreferredSize(new Dimension(50, 20));
        this.buttonRack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaPendente.this.rack();
            }
        });
    }

    @Override
    protected void tabelaExames_keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32) {
            this.enviarParaProntos();
        } else {
            super.tabelaExames_keyPressed(e);
        }
    }

    private void enviarParaProntos() {
        int row = this.tabelaExames.getSelectedRow();
        if (row >= 0 && this.tabelaExames.getRowCount() > 0) {
            this.transmiteExames(row);
            this.reloadExames();
            if (this.tabelaExames.getRowCount() == row) {
                if (--row > -1) {
                    this.tabelaExames.setRowSelectionInterval(row, row);
                }
            } else if (row > -1) {
                this.tabelaExames.setRowSelectionInterval(row, row);
            }
        }
    }

    protected void lote() {
        if (Acesso.getAcesso(1001001003L) && this.exames != null && this.exames.size() > 0) {
            ExameLote tela = new ExameLote(this.parent, this.exames, this.getColIndice("C\u00f3digo"), this.getColIndice("Tubo"), this.getColIndice("Paciente"), this.getColIndice("Exame"), this.getColIndice("Contador"), this.equipamento);
            tela.setVisible(true);
            ArrayList requisicoes = tela.getRequisicoes();
            for (int i = 0; i < requisicoes.size(); ++i) {
                Object[] req = (Object[])requisicoes.get(i);
                String requisicao = req[this.getColIndice("C\u00f3digo")].toString();
                String tubo = req[this.getColIndice("Tubo")].toString();
                String exame = req[this.getColIndice("Exame")].toString();
                for (int j = 0; j < this.tabelaExames.getRowCount(); ++j) {
                    String requisicaoExame = this.tabelaExames.getValueAt(j, this.getColIndice("C\u00f3digo")).toString();
                    String tuboExame = this.tabelaExames.getValueAt(j, this.getColIndice("Tubo")).toString();
                    String exameExame = this.tabelaExames.getValueAt(j, this.getColIndice("Exame")).toString();
                    if (!requisicao.equalsIgnoreCase(requisicaoExame) || !tubo.equalsIgnoreCase(tuboExame) || !exame.equals(exameExame)) continue;
                    this.transmiteExames(j, exame);
                }
            }
            this.reloadExames();
        }
    }

    private void rack() {
        RequisicaoRack tela = new RequisicaoRack(this.parent, this.equipamento, this.exames, this.getColIndice("C\u00f3digo"), this.getColIndice("Paciente"), this.getColIndice("Exame"), this.getColIndice("Rack"), this.getColIndice("Tubo"), false, this, 0, true);
        tela.setVisible(true);
    }

    @Override
    protected void loadExames() {
        super.loadExames();
        if (this.envioPorRack) {
            ArrayList exames = this.getExames();
            for (int i = 0; i < exames.size(); ++i) {
                Object[] exame = (Object[])exames.get(i);
                String rack = (String)exame[this.getColIndice("Rack")];
                if (rack == null || !Funcoes.isNumeric(rack) || Integer.parseInt(rack) <= ((AbaNaoEnviados)this.equipamento.examesNaoEnviados).getContador()) continue;
                ((AbaNaoEnviados)this.equipamento.examesNaoEnviados).setContador(Integer.parseInt(rack));
            }
        }
    }

    private void dadosBrutos() {
        int linha = this.tabelaExames.getSelectedRow();
        if (linha < 0 || this.tabelaExames.getRowCount() == 0) {
            return;
        }
        String requisicao = (String)this.tabelaExames.getValueAt(linha, this.getColIndice("C\u00f3digo"));
        String exame = (String)this.tabelaExames.getValueAt(linha, this.getColIndice("Exame"));
        String material = (String)this.tabelaExames.getValueAt(linha, this.getColIndice("C\u00f3d. Mat."));
        String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
        requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial());
        EditarDadosBrutos ed = EditarDadosBrutos.novaInstancia(Laboratorio.getInstancia());
        if (ed != null) {
            ed.setRequisicao(filial, requisicao, exame, material);
            ed.setVisible(true);
        }
    }
}

