/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.manual;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Tipos;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultNaoEnviados;
import jalis.laboratorio.interfaceamento.componentes.PanelBotoes;
import jalis.laboratorio.interfaceamento.interfaces.manual.RequisicaoRack;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.util.impressao.Impressao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JFrame;

public class AbaNaoEnviados
extends AbaDefaultNaoEnviados {
    private JButton buttonRack = new BotaoNavegavel("Rack", 'A');
    private JButton buttonZeraContador = new BotaoNavegavel("Zera contador", 'C');
    PanelBotoes panel_rack = new PanelBotoes("Rack");
    private int contador = 0;
    private boolean envioPorRack = false;
    private boolean imprimirEtiquetaColetaAutomatica = false;

    public int getContador() {
        return this.contador;
    }

    public void setContador(int contador) {
        this.contador = contador;
    }

    public AbaNaoEnviados(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip);
    }

    public AbaNaoEnviados(JFrame parent, AbstractInterfaceamento equip, boolean envioPorRack, boolean imprimirColetaAutomatica) {
        super(parent, equip);
        this.imprimirEtiquetaColetaAutomatica = imprimirColetaAutomatica;
        if (envioPorRack) {
            this.configPanelRack();
        }
    }

    protected void configPanelRack() {
        this.panel_rack.addButton(this.buttonRack, null, 'a', "Faz o envio por rack");
        this.panel_rack.addButton(this.buttonZeraContador, new Insets(2, 0, 2, 0), 'c', "Zera o contador de envio por rack");
        this.jPanelHeader.add((Component)this.panel_rack, "West");
        this.buttonRack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaNaoEnviados.this.rack();
            }
        });
        this.buttonZeraContador.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaNaoEnviados.this.setContador(0);
            }
        });
    }

    private void rack() {
        RequisicaoRack tela = new RequisicaoRack(this.parent, this.equipamento, this.exames, this.getColIndice("C\u00f3digo"), this.getColIndice("Paciente"), this.getColIndice("Exame"), this.getColIndice("Rack"), this.getColIndice("Tubo"), false, this, ++this.contador, false);
        tela.setVisible(true);
        if (tela.isOk()) {
            this.setContador(tela.getLastRack());
        } else {
            this.setContador(this.getContador() - 1);
        }
    }

    @Override
    public void transmiteExames(int row, String exames) {
        if (row >= 0 && this.tabelaExames.getRowCount() > 0) {
            String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
            String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
            final String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
            String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("S"));
            String pac_idade = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Ide"));
            String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Paciente"));
            String pac_exames = Funcoes.textoVazio(exames) ? (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame")) : exames;
            String hora = TempoUtil.getCurrentTime();
            String data = TempoUtil.getCurrentDateBr();
            String rackpos = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Rack"));
            final String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
            final String requisicao = req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            final String examesColeta = pac_exames;
            try {
                String resposta = this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackpos, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, "N");
                if (resposta != null) {
                    this.equipamento.novaMensagem(resposta, 0, resposta.startsWith("Erro") ? 5000 : 10000);
                    if (resposta.indexOf("Erro") >= 0 && this.equipamento.configuracao.getPularLinhaErroAutoenvio()) {
                        String req = fil_codigo + req_codigo;
                        req = req + Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
                        this.equipamento.addLinhaErro(req, pac_exames);
                    }
                    if (this.imprimirEtiquetaColetaAutomatica) {
                        new Thread("Thread - imprimir etq coleta automatica"){

                            @Override
                            public void run() {
                                try {
                                    Impressao.imprimirEtiquetaColeta(fil_codigo, requisicao, examesColeta.split(" ", 0), new int[]{Integer.parseInt(mco_codigo)}, true);
                                    Conexao.arquivaSQL();
                                }
                                catch (Exception ex) {
                                    try {
                                        Conexao.anulaSQL();
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbaNaoEnviados (150)");
                                }
                            }
                        }.start();
                    }
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace(), "AbaNaoEnviados (158)");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadExames() {
        this.setAmpulheta(true);
        PreparedStatement ps = null;
        try {
            ArrayList dados_temp = new ArrayList();
            String recente = String.valueOf(0);
            StringBuilder query = new StringBuilder();
            query.append("select exr.exr_excluido, b.req_excluida ,a.fil_codigo, a.req_codigo, a.exa_codigo, a.mco_codigo, a.rec_codigo, b.req_data, ");
            query.append("b.req_hora, b.req_anomes, b.req_idade, c.pac_nome, c.pac_sexo, d.mco_abreviatura, ");
            query.append("a.ier_rackpos, a.int_codigo, exr.exr_situacao, ");
            query.append(" pegaAlternativoExameInterface(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.int_codigo) as emi_alternativo, ");
            query.append(" pegaDataEntregaExame(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.req_codigo) as exr_dataentregaprev, ");
            query.append("(b.req_urgente or (coalesce(pegaUrgenteExame(a.fil_codigo, a.exa_codigo, a.mco_codigo, a.req_codigo), false))) as req_urgente ");
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                query.append(", pegaCodigoMultiguiaMae(a.fil_codigo, a.req_codigo) as multiguia ");
            }
            if (this.exr_codigoapoiado) {
                query.append("  ,( case when (erc.ere_codigoapoiado is not null) then cast(erc.ere_codigoapoiado as varchar) else cast(exr.exr_codigoapoiado as varchar) end) as codigoApoiado  ");
            }
            query.append(", (SELECT  ARRAY (select rec_kodigo from interfaceexamerequisicaodesm");
            query.append(" where fil_codigo = a.fil_codigo and req_codigo = a.req_codigo and rec_codigo = a.rec_codigo and exa_codigo = a.exa_codigo and mco_codigo = a.mco_codigo and int_codigo = a.int_codigo)) as tubosFilhos ");
            query.append("from interfaceexamerequisicao a ");
            query.append("left join requisicao b on a.fil_codigo=b.fil_codigo and a.req_codigo=b.req_codigo ");
            query.append("left join examerequisicao exr on exr.fil_codigo = a.fil_codigo and exr.req_codigo = b.req_codigo and exr.exa_codigo = a.exa_codigo and exr.mco_codigo = a.mco_codigo ");
            if (this.exr_codigoapoiado) {
                query.append(" left join examerequisicaorecipiente erc on erc.fil_codigo = b.fil_codigo and erc.req_codigo = exr.req_codigo and erc.rec_kodigo = a.rec_codigo and erc.exa_codigo = a.exa_codigo and erc.mco_codigo = a.mco_codigo ");
            }
            query.append("left join paciente c on a.fil_codigo=c.fil_codigo and b.pac_codigo=c.pac_codigo ");
            query.append("left join materialcoleta d on a.fil_codigo=d.fil_codigo and a.mco_codigo=d.mco_codigo ");
            query.append("where ").append(BDUtil.montaSQLEquipamentoFilial());
            query.append(" and a.ier_situacao = ");
            query.append(recente);
            if (Variaveis.equipamentos.get(0).getFiltroColetas() != null && Variaveis.equipamentos.get(0).getFiltroColetas().length > 0) {
                query.append(" and b.col_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroColetas(), "', '", query);
                query.append("')");
            }
            if (Variaveis.equipamentos.get(0).getFiltroDestinos() != null && Variaveis.equipamentos.get(0).getFiltroDestinos().length > 0) {
                query.append(" and b.des_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroDestinos(), "', '", query);
                query.append("')");
            }
            if (Variaveis.equipamentos.get(0).getFiltroSituacoesReq() != null && Variaveis.equipamentos.get(0).getFiltroSituacoesReq().length > 0) {
                query.append(" and b.sit_codigo in ('");
                StringUtil.implode(Variaveis.equipamentos.get(0).getFiltroSituacoesReq(), "', '", query);
                query.append("')");
            }
            if (!this.equipamento.configuracao.getNaoUtilizarOrdenacaoPorBanco()) {
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    query.append(" order by a.fil_codigo, multiguia, a.rec_codigo, a.int_codigo, a.exa_codigo");
                } else {
                    query.append(" order by a.fil_codigo, a.req_codigo, a.rec_codigo, a.int_codigo, a.exa_codigo");
                }
            }
            ps = Conexao.getPreparedStatement(query.toString());
            try (ResultSet rs = null;){
                rs = ps.executeQuery();
                while (rs != null && rs.next()) {
                    ArrayList<String> tubosFilhos;
                    boolean exameDesmembrado;
                    String situacao = rs.getString("exr_situacao");
                    boolean reqExcluida = rs.getBoolean("req_excluida");
                    boolean exameExcluido = rs.getBoolean("exr_excluido");
                    if (situacao.equals("T") || situacao.equals("A") || situacao.equals("F") || situacao.equals("R") || situacao.equals("N") || reqExcluida || exameExcluido) continue;
                    Object[] linha = new Object[this.getColCount()];
                    String req_codigo = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                    req_codigo = req_codigo + Funcoes.preencheZero(rs.getInt("req_codigo"), ParametrosGerais.getDigitosTuboRequisicao());
                    String idade = String.valueOf(rs.getInt("req_idade")) + " " + Tipos.tipoIdade(rs.getString("req_anomes"));
                    Date ddata = rs.getDate("req_data");
                    Time hhora = rs.getTime("req_hora");
                    String data = ddata == null ? "" : new SimpleDateFormat("dd/MM/yyyy").format(ddata);
                    String hora = hhora == null ? "" : new SimpleDateFormat("HH:mm").format(hhora);
                    String nome = this.limparNomePaciente(rs.getString("pac_nome"));
                    if (Funcoes.textoVazio(nome.trim())) {
                        nome = req_codigo + " Nome nao compativel com interfaceamento";
                    }
                    linha[this.getColIndice((String)"C\u00f3digo")] = req_codigo;
                    linha[this.getColIndice((String)"Exame")] = rs.getString("exa_codigo");
                    linha[this.getColIndice((String)"Paciente")] = nome;
                    linha[this.getColIndice((String)"S")] = rs.getString("pac_sexo");
                    linha[this.getColIndice((String)"Data")] = data;
                    linha[this.getColIndice((String)"Hora")] = hora;
                    linha[this.getColIndice((String)"Ide")] = idade;
                    linha[this.getColIndice((String)"Mat.")] = rs.getString("mco_abreviatura");
                    linha[this.getColIndice((String)"C\u00f3d. Mat.")] = rs.getString("mco_codigo");
                    linha[this.getColIndice((String)"Tubo")] = rs.getString("rec_codigo");
                    linha[this.getColIndice((String)"Previs\u00e3o")] = rs.getTimestamp("exr_dataentregaprev");
                    linha[this.getColIndice((String)"Rack")] = rs.getString("ier_rackpos");
                    linha[this.getColIndice((String)"Urgente")] = rs.getBoolean("req_urgente");
                    linha[this.getColIndice((String)"Interface")] = rs.getString("int_codigo");
                    linha[this.getColIndice((String)"Alternativo")] = rs.getString("emi_alternativo");
                    linha[this.getColIndice((String)"Cod. Apoiado")] = "";
                    if (this.exr_codigoapoiado) {
                        linha[this.getColIndice((String)"Cod. Apoiado")] = rs.getString("codigoApoiado");
                    }
                    if (ParametrosGerais.isAgruparGuiasInterface()) {
                        String multiguia = Funcoes.preencheZero(rs.getInt("fil_codigo"), ParametrosGerais.getDigitosTuboFilial());
                        multiguia = multiguia + Funcoes.preencheZero(rs.getInt("multiguia"), ParametrosGerais.getDigitosTuboRequisicao());
                        linha[this.getColIndice((String)"Multiguia")] = multiguia;
                        linha[this.getColIndice((String)"C\u00f3digo Temp.")] = req_codigo;
                    }
                    boolean bl = exameDesmembrado = (tubosFilhos = this.getTubosFilhos(rs)).size() > 0;
                    if (exameDesmembrado) {
                        linha[this.getColIndice((String)"Tubos Filhos")] = tubosFilhos;
                    }
                    dados_temp.add(linha);
                }
            }
            dados_temp = ParametrosGerais.isAgruparGuiasInterface() ? this.agrupaExamesMultiGuia(dados_temp) : this.agrupaExamesMesmaRequisicao(dados_temp);
            this.tabelaExames.setData(dados_temp);
            this.tabelaExames.sortRowsByColumn(this.tabelaExames.getColunaOrdenada() == -1 ? 0 : this.tabelaExames.getColunaOrdenada(), false, false);
            this.tabelaExames.grabFocus();
            this.exames = dados_temp;
            ps.close();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(this, ex.getMessage(), ex.getStackTrace());
        }
        this.setAmpulheta(false);
    }
}

