/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.maglumi2000plus;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.maglumi2000plus.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    protected boolean hostQuery = false;
    protected String hostFilCodigo = null;
    protected String hostReqCodigo = null;
    protected String hostRecCodigo = null;

    public InterfaceListener() {
        RecordParser recordMaglumi2000Plus = new RecordParser();
        recordMaglumi2000Plus.setInterfaceASTMListener(this);
        super.setASTMRecordParser(recordMaglumi2000Plus);
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        ((PortaSocketServer)portaCOM).setEscreverEmBytes(true);
        super.setPortaCOM(portaCOM);
    }

    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String pacExames, String acao, HashMap<String, String> mapaParametros) {
        try {
            this.tx_list.clear();
            this.rx_list.clear();
            this.req_codigo = reqCodigo;
            this.fil_codigo = filCodigo;
            this.int_codigo = intCodigo;
            this.pac_nome = pacNome;
            this.pac_sexo = pacSexo;
            this.req_idade = pacIdade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mcoCodigo;
            this.rec_codigo = recCodigo;
            this.pac_exames = pacExames;
            this.exames = pacExames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            ExameMaterial[] alternativos = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String shortName = StringUtil.removerAcentos(pacNome.trim());
            filCodigo = StringUtil.preencheString(filCodigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(filCodigo).append(reqCodigo);
            StringBuilder sampleId = new StringBuilder(filCodigo).append(reqCodigo);
            recCodigo = StringUtil.preencheString(recCodigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(recCodigo);
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            ExameMaterial[] exaLista = ExamesUtil.anexarCodigoMaterial(this.exames, mcoCodigo);
            String tipoAmostra = "";
            ArrayList<ExameMaterial> exaListaCurva = new ArrayList<ExameMaterial>();
            exaLista = ExamesUtil.separaExamesCurva(filCodigo, intCodigo, mcoCodigo, exaLista, exaListaCurva);
            if (exaLista != null) {
                exaLista = ExamesUtil.desmembrarExames(st, filCodigo, intCodigo, exaLista);
                alternativos = ExamesUtil.getAlternativos(st, filCodigo, intCodigo, exaLista);
                alternativos = ExamesUtil.removeDuplicados(alternativos);
            }
            if (!exaListaCurva.isEmpty()) {
                ArrayList<String> exameCurva = new ArrayList<String>();
                for (ExameMaterial exameMaterial : exaListaCurva) {
                    exameCurva.add(exameMaterial.getNomeExame());
                }
                if (Funcoes.textoVazio(this.rec_tuboPai)) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(filCodigo, reqCodigo, recCodigo, intCodigo, (String)exameCurva.get(0), mcoCodigo);
                }
                alternativosCurva = ExamesUtil.getAlternativosCurva(filCodigo, intCodigo, reqCodigo, mcoCodigo, String.valueOf(Integer.parseInt(recCodigo)), st, exaListaCurva, this.rec_tuboPai, true, this.examesFilho);
            }
            this.tx_list.add(this.getMsgStart());
            buf.append(this.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION, "1394-97"));
            StringBuilder patientId = new StringBuilder();
            patientId.append(filCodigo).append(reqCodigo);
            Date dataNasc = BDUtil.getDataNacimentoPaciente(filCodigo, reqCodigo);
            String sex = "U";
            if (!Funcoes.textoVazio(pacSexo) && pacSexo.equalsIgnoreCase("M")) {
                sex = "M";
            } else if (!Funcoes.textoVazio(pacSexo) && pacSexo.equalsIgnoreCase("F")) {
                sex = "F";
            }
            buf.append(this.getPatientRecord(1, patientId.toString(), shortName, sex, dataNasc));
            int seq = 0;
            if (alternativos != null) {
                for (int i = 0; i < alternativos.length; ++i) {
                    if (alternativos[i] == null) continue;
                    buf.append(this.getOrderRecord(++seq, codigo.toString(), "", "", codigo.toString(), alternativos[i], "R", tipoAmostra, this.hostQuery ? "Q" : "O"));
                }
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sampleId.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sampleId.setLength(0);
                    sampleId.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    for (ExameMaterial exameMaterial : alternativosCurva.get(key)) {
                        buf.append(this.getOrderRecord(++seq, codigo.toString(), "", "", sampleId.append(tubo).toString(), exameMaterial, "R", tipoAmostra, this.hostQuery ? "Q" : "O"));
                    }
                }
            }
            buf.append(this.getTerminationRecord());
            this.tx_list.add(buf.toString());
            this.tx_list.add(String.valueOf('\u0003'));
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pacNome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public String getDefaultHeaderRecord(String delimiters, String password, String senderIdName, String senderIdSystem, String control, String receiverIdName, String receiverIdSystem, String versionNumber) {
        StringBuilder headerRecord = new StringBuilder("H|");
        headerRecord.append(delimiters == null ? "" : delimiters);
        headerRecord.append("||");
        headerRecord.append(password == null ? "PSWD" : password);
        headerRecord.append("|");
        headerRecord.append("Maglumi");
        headerRecord.append("|||||");
        headerRecord.append(senderIdName == null ? "" : "^" + senderIdName);
        headerRecord.append("||");
        headerRecord.append("P|");
        headerRecord.append(versionNumber);
        headerRecord.append("|");
        headerRecord.append(InterfaceListener.getCurrentMoment());
        headerRecord.append('\r');
        return headerRecord.toString();
    }

    private String getTerminationRecord() {
        StringBuilder terminationRecord = new StringBuilder("L|1|N");
        terminationRecord.append('\r');
        return terminationRecord.toString();
    }

    private String getOrderRecord(int orderSequence, String sampleId, String sampleTray, String samplePos, String codBarra, ExameMaterial alternativos, String prioridade, String tipoAmostra, String reportType) {
        StringBuilder orderRecord = new StringBuilder("O|");
        orderRecord.append(orderSequence).append("|");
        orderRecord.append(sampleId).append("||");
        if (alternativos != null) {
            orderRecord.append("^^^");
            orderRecord.append(alternativos.getNomeExame());
        }
        orderRecord.append("|");
        orderRecord.append(prioridade);
        orderRecord.append('\r');
        return orderRecord.toString();
    }

    private String getPatientRecord(int patientSequence, String patientId, String pacNome, String pacSexo, Date dataNasc) {
        StringBuilder pacienteRecord = new StringBuilder("P|");
        pacienteRecord.append(patientSequence).append("||");
        pacienteRecord.append("||");
        pacienteRecord.append(pacNome).append("|||");
        pacienteRecord.append(pacSexo).append(String.valueOf('\r'));
        return pacienteRecord.toString();
    }

    @Override
    public void responderRequest(String startingRange, String endingRange, String testId) {
        try {
            String sampleId = startingRange.substring(1).trim();
            this.hostQuery = true;
            if (Funcoes.textoVazio(sampleId)) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                return;
            }
            if (sampleId.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                return;
            }
            this.hostFilCodigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            sampleId = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
            this.hostReqCodigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.hostRecCodigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Smart prime: Host Query Response");
        }
    }

    @Override
    public MemoryList<String> makeFrames(MemoryList<String> rawList) throws Exception {
        try {
            MemoryList<String> newList = new MemoryList<String>();
            this.frame_num = 0;
            if (rawList != null) {
                while (!rawList.isEmpty() && rawList.size() > 0) {
                    String[] slices = StringUtil.dividir(rawList.remove(0), 300);
                    for (int j = 0; j < slices.length; ++j) {
                        StringBuilder temp = new StringBuilder(String.valueOf(this.nextFrameNum()));
                        temp.append(slices[j]);
                        temp.append(j < slices.length - 1 ? String.valueOf('\u0017') : String.valueOf('\u0003'));
                        temp.append(Checksum.getChecksumMod256(temp.toString()));
                        temp = new StringBuilder(this.getMsgStart()).append((CharSequence)temp);
                        temp.append(this.getMsgEnd());
                        newList.add(temp.toString());
                    }
                }
                return newList;
            }
            return new MemoryList<String>();
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Erro ao recuperar lista de frames (size:" + rawList.size() + ")");
            return new MemoryList<String>();
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(String.valueOf('\r'));
            if (!message.equals("")) {
                String retorno = this.parse(message);
                this.getPortaCOM().write(retorno.startsWith("Erro") ? String.valueOf('\u0015') : String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stxIndex = this.getMsgStart(message);
            if (stxIndex >= 0 && message.length() > 5) {
                if (stxIndex >= 0) {
                    message = message.substring(stxIndex);
                } else if (stxIndex < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    String last = (String)this.rx_list.get(this.rx_list.getUltimoInserido());
                    message = last.substring(0, last.length() - 1) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                if (message.contains(String.valueOf('\r'))) {
                    String[] tmp;
                    for (String s : tmp = message.split(String.format("[%s]", Character.valueOf('\r')))) {
                        if (s.length() <= 1) continue;
                        this.rx_list.add(s);
                    }
                } else {
                    this.rx_list.add(message);
                }
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                ArrayList buffer = new ArrayList(this.rx_list);
                while (!buffer.isEmpty()) {
                    String buf = (String)buffer.remove(0);
                    if (buf.length() <= 1) continue;
                    this.recordParser.recordFound(buf);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    public Integer getMsgStart(String message) {
        Integer posicao = -1;
        if (message.contains("H") && message.indexOf("H") < 3) {
            posicao = message.indexOf("H");
        } else if (message.contains("Q") && message.indexOf("Q") < 3) {
            posicao = message.indexOf("Q");
        } else if (message.contains("O") && message.indexOf("O") < 3) {
            posicao = message.indexOf("O");
        } else if (message.contains("P") && message.indexOf("P") < 3) {
            posicao = message.indexOf("P");
        } else if (message.contains("L") && message.indexOf("L") < 3) {
            posicao = message.indexOf("L");
        } else if (message.contains("R") && message.indexOf("R") < 3) {
            posicao = message.indexOf("R");
        }
        return posicao;
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String filCodigo = this.hostFilCodigo;
            String reqCodigo = this.hostReqCodigo;
            String recCodigo = this.hostRecCodigo;
            String pacNome = null;
            String pacSexo = null;
            String pacIdade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String intCodigo = null;
            String mcoCodigo = null;
            String pacExames = null;
            String acao = "A";
            if (Funcoes.textoVazio(filCodigo) || Funcoes.textoVazio(reqCodigo) || Funcoes.textoVazio(recCodigo)) {
                return;
            }
            Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pacExames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pacExames) && req != null && aba != null) {
                    pacExames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pacExames = pacExames + " ";
                    reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                    for (Object[] r : reqs) {
                        pacExames = pacExames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pacExames = pacExames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                pacExames = "";
                if (req != null) {
                    reqs = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2 || Integer.parseInt((String)r[aba.getColIndice("Sit")]) >= 7) continue;
                        pacExames = pacExames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pacExames = pacExames.trim();
                }
                if (Funcoes.textoVazio(pacExames)) {
                    req = null;
                }
            }
            this.hostFilCodigo = null;
            this.hostReqCodigo = null;
            this.hostRecCodigo = null;
            if (req != null) {
                pacNome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pacSexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                intCodigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mcoCodigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.enviarRequisicao(pacNome, pacSexo, pacIdade, data, hora, "", prioridade, filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, pacExames, acao);
            } else {
                this.enviarRequisicaoSemExame(filCodigo, reqCodigo, recCodigo);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Maglumi 2000 Plus: Host Query Response");
            this.hostQuery = false;
        }
    }

    private void enviarRequisicaoSemExame(String filCodigo, String reqCodigo, String recCodigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            StringBuilder patientId = new StringBuilder();
            patientId.append(filCodigo).append(reqCodigo);
            this.tx_list.add(this.getPatientRecord(1, patientId.toString(), "", "", null));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o paciente de envio");
            }
            this.tx_list.add(this.getOrderRecord(1, "", "", "", filCodigo + reqCodigo + recCodigo, null, "R", "", this.hostQuery ? "Q" : "O"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o paciente de envio");
            }
            this.tx_list.add(this.getTerminationRecord());
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (!(Funcoes.textoVazio(this.req_codigo) || Funcoes.textoVazio(this.pac_exames) || Funcoes.textoVazio(this.rec_codigo) || Funcoes.textoVazio(this.fil_codigo) || Funcoes.textoVazio(this.mco_codigo))) {
            if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                Statement st = Conexao.getStatement();
                if (this.exames != null) {
                    for (int i = 0; i < this.exames.length; ++i) {
                        int situacao;
                        if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                            for (String exame : this.examesFilho) {
                                int situacao2 = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                                BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                                situacao2 = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, exame, this.mco_codigo, this.rec_codigo);
                                this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exame, this.mco_codigo, this.int_codigo, null, situacao2 < 2 ? 1 : 3);
                            }
                            situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                            if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                            this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                            continue;
                        }
                        if (!this.examesFilho.isEmpty()) {
                            situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                            this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                            BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                            continue;
                        }
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                    }
                    Conexao.arquivaSQL();
                    String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                    this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
                } else {
                    this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
                }
            }
            this.interromperTimer();
            if (this.hostQuery) {
                this.getPortaCOM().write(String.valueOf('\u0004'));
            }
            if (this.ultima_acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
            this.limpaDadosRequisicao();
            this.fireAtualizarTabela();
            this.fireAtualizarTabela(0);
            this.setIdle();
        } else {
            this.interromperTimer();
            this.getPortaCOM().write(String.valueOf('\u0004'));
            this.limpaDadosRequisicao();
            this.fireAtualizarTabela();
            this.fireAtualizarTabela(0);
            this.setIdle();
        }
        this.hostQuery = false;
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        if (op == 0) {
            String idAmostra = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "010051439101");
            this.testeQuery(idAmostra);
        } else if (op == 1) {
            this.handShakeCharReceived('\u0006');
        } else if (op == 2) {
            String idAmostra = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "010051439101");
            this.testeResultado(idAmostra);
        } else if (op == 3) {
            this.handShakeCharReceived('\u0004');
        }
    }

    private void testeQuery(String requisicao) {
        this.getPortaCOM().read(String.valueOf('\u0005'), String.valueOf('\u0005').length());
        this.getPortaCOM().read(String.valueOf('\u0002'), String.valueOf('\u0002').length());
        String queryH = TestesInterface.arruma("[STX]H|\\^&||PSWD|Maglumi[SP]User|||||Lis||P|E1394-97|20200107[CR]");
        this.getPortaCOM().read(queryH, queryH.length());
        String queryQ = TestesInterface.arruma("[STX]Q|1|^" + requisicao + "||ALL||||||||O[CR]");
        this.getPortaCOM().read(queryQ, queryQ.length());
        String queryL = TestesInterface.arruma("[STX]L|1|N[CR]");
        this.getPortaCOM().read(queryL, queryL.length());
        this.getPortaCOM().read(String.valueOf('\u0003'), String.valueOf('\u0003').length());
        this.getPortaCOM().read(String.valueOf('\u0004'), String.valueOf('\u0004').length());
    }

    private void testeResultado(String requisicao) {
        this.getPortaCOM().read(String.valueOf('\u0005'), String.valueOf('\u0005').length());
        this.getPortaCOM().read(String.valueOf('\u0002'), String.valueOf('\u0002').length());
        String resultadoH = TestesInterface.arruma("[STX]H|\\^&||PSWD|Maglumi[SP]User|||||JALIS||P|E1394-97|20200108[CR]");
        this.getPortaCOM().read(resultadoH, resultadoH.length());
        String resultadoP = TestesInterface.arruma("[STX]P|1[CR]");
        this.getPortaCOM().read(resultadoP, resultadoP.length());
        String resultadoO = TestesInterface.arruma("[STX]O|1|" + requisicao + "||^^^TSH[CR]");
        this.getPortaCOM().read(resultadoO, resultadoO.length());
        String resultadoR = TestesInterface.arruma("[STX]R|1|^^^TSH|5.171|uIU/mL|0.3[SP]to[SP]4.5|H||||||20200120124052[CR]");
        this.getPortaCOM().read(resultadoR, resultadoR.length());
        String resultadoL = TestesInterface.arruma("[STX]L|1|N[CR]");
        this.getPortaCOM().read(resultadoL, resultadoL.length());
        this.getPortaCOM().read(String.valueOf('\u0003'), String.valueOf('\u0003').length());
        this.getPortaCOM().read(String.valueOf('\u0004'), String.valueOf('\u0004').length());
    }

    public static String getCurrentMoment() {
        return new SimpleDateFormat("yyyyMMdd").format(new Date(System.currentTimeMillis()));
    }
}

