/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.maglumi2000;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.maglumi2000.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    protected boolean hostQuery = false;
    private ThreadRecebimento threadRecebimento;
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.threadRecebimento = new ThreadRecebimento(this);
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        ((PortaSocketServer)portaCOM).setEscreverEmBytes(true);
        super.setPortaCOM(portaCOM);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            this.tx_list.clear();
            this.rx_list.clear();
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            ExameMaterial[] alternativos = null;
            ExameMaterial[] listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome.trim());
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            Statement st = Conexao.getStatement();
            StringBuilder buf = new StringBuilder();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String exame = exa_lista[0].toString();
            String tipoAmostra = "";
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            if (exa_lista != null) {
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.removeDuplicados(alternativos);
            }
            if (!exa_listaCurva.isEmpty()) {
                ArrayList<String> exameCurva = new ArrayList<String>();
                for (ExameMaterial exameMaterial : exa_listaCurva) {
                    exameCurva.add(exameMaterial.getNomeExame());
                }
                if (Funcoes.textoVazio(this.rec_tuboPai)) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, (String)exameCurva.get(0), mco_codigo);
                }
                listaCurva = ExamesUtil.anexarCodigoMaterial(exameCurva.toArray(new String[exameCurva.size()]), mco_codigo);
                listaCurva = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, String.valueOf(Integer.parseInt(rec_codigo)), st, exa_listaCurva, this.rec_tuboPai, true, this.examesFilho);
            }
            this.tx_list.add(this.getMsgStart());
            buf.append(this.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION, "1394-97"));
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            Date dataNasc = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String sex = "U";
            if (!Funcoes.textoVazio(pac_sexo) && pac_sexo.equalsIgnoreCase("M")) {
                sex = "M";
            } else if (!Funcoes.textoVazio(pac_sexo) && pac_sexo.equalsIgnoreCase("F")) {
                sex = "F";
            }
            buf.append(this.getPatientRecord(1, patient_id.toString(), short_name, sex, dataNasc));
            int seq = 0;
            if (alternativos != null) {
                for (int i = 0; i < alternativos.length; ++i) {
                    if (alternativos[i] == null) continue;
                    buf.append(this.getOrderRecord(++seq, codigo.toString(), "", "", codigo.toString(), alternativos[i], "R", tipoAmostra, this.hostQuery ? "Q" : "O"));
                }
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    for (ExameMaterial exameMaterial : alternativosCurva.get(key)) {
                        buf.append(this.getOrderRecord(++seq, codigo.toString(), "", "", sample_id.append(tubo).toString(), exameMaterial, "R", tipoAmostra, this.hostQuery ? "Q" : "O"));
                    }
                }
            }
            buf.append(this.getTerminationRecord());
            this.tx_list.add(buf.toString());
            this.tx_list.add(String.valueOf('\u0003'));
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public String getDefaultHeaderRecord(String delimiters, String password, String sender_id_name, String sender_id_system, String control, String receiver_id_name, String receiver_id_system, String version_number) {
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("||");
        record.append(password == null ? "PSWD" : password);
        record.append("|");
        record.append("Maglumi");
        record.append("|||||");
        record.append(sender_id_name == null ? "" : "^" + sender_id_name);
        record.append("||");
        record.append("P|");
        record.append(version_number);
        record.append("|");
        record.append(InterfaceListener.getCurrentMoment());
        record.append('\r');
        return record.toString();
    }

    private String getTerminationRecord() {
        StringBuilder record = new StringBuilder("L|1|N");
        record.append('\r');
        return record.toString();
    }

    private String getOrderRecord(int order_sequence, String sampleId, String sampleTray, String samplePos, String codBarra, ExameMaterial alternativos, String prioridade, String tipoAmostra, String reportType) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence).append("|");
        record.append(sampleId).append("||");
        if (alternativos != null) {
            record.append("^^^");
            record.append(alternativos.getNomeExame());
        }
        record.append("|");
        record.append(prioridade);
        record.append('\r');
        return record.toString();
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String pac_nome, String pac_sexo, Date dataNasc) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence).append("||");
        record.append("||");
        record.append(pac_nome).append("|||");
        record.append(pac_sexo).append(String.valueOf('\r'));
        return record.toString();
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            String sampleId = starting_range.substring(1).trim();
            this.hostQuery = true;
            if (Funcoes.textoVazio(sampleId)) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                return;
            }
            if (sampleId.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                return;
            }
            this.host_fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            sampleId = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Smart prime: Host Query Response");
        }
    }

    @Override
    public MemoryList<String> makeFrames(MemoryList<String> raw_list) throws Exception {
        try {
            MemoryList<String> new_list = new MemoryList<String>();
            this.frame_num = 0;
            if (raw_list != null) {
                while (!raw_list.isEmpty() && raw_list.size() > 0) {
                    String[] slices = StringUtil.dividir(raw_list.remove(0), 300);
                    for (int j = 0; j < slices.length; ++j) {
                        StringBuilder temp = new StringBuilder(String.valueOf(this.nextFrameNum()));
                        temp.append(slices[j]);
                        temp.append(j < slices.length - 1 ? String.valueOf('\u0017') : String.valueOf('\u0003'));
                        temp.append(Checksum.getChecksumMod256(temp.toString()));
                        temp = new StringBuilder(this.getMsgStart()).append((CharSequence)temp);
                        temp.append(this.getMsgEnd());
                        new_list.add(temp.toString());
                    }
                }
                return new_list;
            }
            return null;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Erro ao recuperar lista de frames (size:" + raw_list.size() + ")");
            return null;
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().removeInputString(String.valueOf('\r'));
            if (!message.equals("")) {
                String retorno = this.parse(message);
                this.getPortaCOM().write(retorno.startsWith("Erro") ? String.valueOf('\u0015') : String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = this.getMsgStart(message);
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index >= 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    String last = (String)this.rx_list.get(this.rx_list.getUltimoInserido());
                    message = last.substring(0, last.length() - 1) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                if (message.contains(String.valueOf('\r'))) {
                    String[] tmp;
                    for (String s : tmp = message.split(String.format("[%s]", Character.valueOf('\r')))) {
                        if (s.length() <= 1) continue;
                        this.rx_list.add(s);
                    }
                } else {
                    this.rx_list.add(message);
                }
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                ArrayList buffer = new ArrayList(this.rx_list);
                while (!buffer.isEmpty()) {
                    String buf = (String)buffer.remove(0);
                    if (buf.length() <= 1) continue;
                    this.recordParser.recordFound(buf);
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    public Integer getMsgStart(String message) {
        Integer posicao = -1;
        if (message.contains("H") && message.indexOf("H") < 3) {
            posicao = message.indexOf("H");
        } else if (message.contains("Q") && message.indexOf("Q") < 3) {
            posicao = message.indexOf("Q");
        } else if (message.contains("O") && message.indexOf("O") < 3) {
            posicao = message.indexOf("O");
        } else if (message.contains("P") && message.indexOf("P") < 3) {
            posicao = message.indexOf("P");
        } else if (message.contains("L") && message.indexOf("L") < 3) {
            posicao = message.indexOf("L");
        } else if (message.contains("R") && message.indexOf("R") < 3) {
            posicao = message.indexOf("R");
        }
        return posicao;
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "A";
            if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(rec_codigo)) {
                return;
            }
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames) && req != null && aba != null) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                pac_exames = "";
                if (req != null) {
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) >= 7) continue;
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
                if (Funcoes.textoVazio(pac_exames)) {
                    req = null;
                }
            }
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
            } else {
                this.enviarRequisicaoSemExame(fil_codigo, req_codigo, rec_codigo);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Smart Prime: Host Query Response");
            this.hostQuery = false;
        }
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo, String rec_codigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            this.tx_list.add(this.getPatientRecord(1, patient_id.toString(), "", "", null));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o paciente de envio");
            }
            this.tx_list.add(this.getOrderRecord(1, "", "", "", fil_codigo + req_codigo + rec_codigo, null, "R", "", this.hostQuery ? "Q" : "O"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o paciente de envio");
            }
            this.tx_list.add(this.getTerminationRecord());
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (!(Funcoes.textoVazio(this.req_codigo) || Funcoes.textoVazio(this.pac_exames) || Funcoes.textoVazio(this.rec_codigo) || Funcoes.textoVazio(this.fil_codigo) || Funcoes.textoVazio(this.mco_codigo))) {
            if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                Statement st = Conexao.getStatement();
                if (this.exames != null) {
                    for (int i = 0; i < this.exames.length; ++i) {
                        int situacao;
                        if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                            for (String exame : this.examesFilho) {
                                int situacao2 = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                                BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                                situacao2 = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, exame, this.mco_codigo, this.rec_codigo);
                                this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exame, this.mco_codigo, this.int_codigo, null, situacao2 < 2 ? 1 : 3);
                            }
                            situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                            if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                            this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                            continue;
                        }
                        if (!this.examesFilho.isEmpty()) {
                            situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                            this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                            BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                            continue;
                        }
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                    }
                    Conexao.arquivaSQL();
                    String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                    this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
                } else {
                    this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
                }
            }
            this.interromperTimer();
            if (this.hostQuery) {
                this.getPortaCOM().write(String.valueOf('\u0004'));
            }
            if (this.ultima_acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
            this.limpaDadosRequisicao();
            this.fireAtualizarTabela();
            this.fireAtualizarTabela(0);
            this.setIdle();
        } else {
            this.interromperTimer();
            this.getPortaCOM().write(String.valueOf('\u0004'));
            this.limpaDadosRequisicao();
            this.fireAtualizarTabela();
            this.fireAtualizarTabela(0);
            this.setIdle();
        }
        this.hostQuery = false;
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        if (op == 0) {
            String idAmostra = JOptionPane.showInputDialog(null, "Informe o Id da amostra?", "010001154641");
            this.testeQuery(idAmostra);
        } else if (op == 1) {
            this.handShakeCharReceived('\u0006');
        } else if (op == 2) {
            this.testeResultado("");
        } else if (op == 3) {
            this.handShakeCharReceived('\u0004');
        }
    }

    private void testeQuery(String idAmostra) {
        this.getPortaCOM().read(String.valueOf('\u0006'), String.valueOf('\u0006').length());
        this.getPortaCOM().read(String.valueOf('\u0002'), String.valueOf('\u0002').length());
        this.getPortaCOM().read(String.valueOf('\u0006'), String.valueOf('\u0006').length());
        this.getPortaCOM().read(String.valueOf("H|\\^&||PSWD|Maglumi[SP]User|||||Lis||P|E1394-97|20200107" + String.valueOf('\r')), String.valueOf("H|\\^&||PSWD|Maglumi[SP]User|||||Lis||P|E1394-97|20200107" + String.valueOf('\r')).length());
        this.getPortaCOM().read(String.valueOf("Q|1|^010005927804||ALL||||||||O" + String.valueOf('\r')), String.valueOf("Q|1|^010005927804||ALL||||||||O" + String.valueOf('\r')).length());
        this.getPortaCOM().read(String.valueOf("L|1|N" + String.valueOf('\r')), String.valueOf("L|1|N" + String.valueOf('\r')).length());
        this.getPortaCOM().read(String.valueOf('\u0003'), String.valueOf('\u0003').length());
        this.getPortaCOM().read(String.valueOf('\u0004'), String.valueOf('\u0004').length());
    }

    private void testeResultado(String idAmostra) {
        StringBuilder buf = new StringBuilder();
        this.getPortaCOM().read(String.valueOf('\u0002'), String.valueOf('\u0002').length());
        buf.append(this.equipamento.arruma("H|\\^&||PSWD|Maglumi[SP]User|||||JALIS||P|E1394-97|20200108[CR]"));
        this.getPortaCOM().read(buf.toString(), buf.toString().length());
        buf.delete(0, buf.length());
        buf.append(this.equipamento.arruma("O|1|010005927804||^^^TSH\\^^^FT4\\^^^PSA\\^^^Vit[SP]B12\\^^^25-OH[SP]Vit[SP]D[CR]"));
        this.getPortaCOM().read(buf.toString(), buf.toString().length());
        buf.delete(0, buf.length());
        buf.append(this.equipamento.arruma("R|1|^^^TSH|5.171|uIU/mL|0.3[SP]to[SP]4.5|H||||||20200120124052[CR]"));
        buf.append(this.equipamento.arruma("R|2|^^^FT4|1.318|ng/mL|0.89[SP]to[SP]1.72|N||||||20200120123846[CR]"));
        buf.append(this.equipamento.arruma("[ACK]"));
        this.getPortaCOM().read(buf.toString(), buf.toString().length());
        buf.delete(0, buf.length());
        buf.append(this.equipamento.arruma("R|3|^^^PSA|0.337|ng/mL|0[SP]to[SP]4|N||||||20200120124258[CR]"));
        buf.append(this.equipamento.arruma("R|4|^^^Vit[SP]B12|214.1|pg/ml|200[SP]to[SP]1100|N||||||20200120124504[CR]"));
        buf.append(this.equipamento.arruma("R|5|^^^25-OH[SP]Vit[SP]D|25.19|ng/mL|30[SP]to[SP]100|L||||||20200120124710[CR]"));
        buf.append(this.equipamento.arruma("L|1|N[CR][ACK][ETX]"));
        buf.append(this.equipamento.arruma("[ETX][EOT]"));
        this.getPortaCOM().read(buf.toString(), buf.toString().length());
        this.getPortaCOM().read(String.valueOf('\u0002'), String.valueOf('\u0002').length());
        buf.append(this.equipamento.arruma("H|\\^&||PSWD|Maglumi[SP]User|||||JALIS||P|E1394-97|20200108[CR]"));
        this.getPortaCOM().read(buf.toString(), buf.toString().length());
        buf.delete(0, buf.length());
        buf.append(this.equipamento.arruma("O|1|010005919704||^^^TSH\\^^^25-OH[SP]Vit[SP]D[CR]"));
        this.getPortaCOM().read(buf.toString(), buf.toString().length());
        buf.delete(0, buf.length());
        buf.append(this.equipamento.arruma("R|1|^^^TSH|7.171|uIU/mL|0.3[SP]to[SP]4.5|H||||||20200120124052[CR]"));
        buf.append(this.equipamento.arruma("[ACK]"));
        this.getPortaCOM().read(buf.toString(), buf.toString().length());
        buf.delete(0, buf.length());
        buf.append(this.equipamento.arruma("R|2|^^^25-OH[SP]Vit[SP]D|55.19|ng/mL|30[SP]to[SP]100|L||||||20200120124710[CR]"));
        buf.append(this.equipamento.arruma("L|1|N[CR][ACK][ETX]"));
        buf.append(this.equipamento.arruma("[ETX][EOT]"));
        this.getPortaCOM().read(buf.toString(), buf.toString().length());
    }

    public static String getCurrentMoment() {
        return new SimpleDateFormat("yyyyMMdd").format(new Date(System.currentTimeMillis()));
    }
}

