/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.liaisonxl;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.selectraflexor.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends InterfaceASTMListener {
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;
    private List<String> tubos = new ArrayList<String>();

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            Statement st = Conexao.getStatement();
            if (acao.equals("C") && this.equipamento.getSelectedTab() instanceof AbaDefaultProntos) {
                StringBuilder exaRemover = new StringBuilder();
                for (String exa : pac_exames.split(" ", 0)) {
                    int situacao = this.getExameSituacaoAba(fil_codigo, int_codigo, req_codigo, rec_codigo, exa, 2);
                    if (situacao == 2 || situacao == 7) continue;
                    exaRemover.append(exa).append(" ");
                }
                pac_exames = exaRemover.toString();
                if (Funcoes.textoVazio(pac_exames)) {
                    return null;
                }
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            ExameMaterial[] alternativos = null;
            Object listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            Date dateNascPac = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String dtNascPac = "";
            if (dateNascPac != null) {
                dtNascPac = Funcoes.formataData("yyyyMMdd", dateNascPac);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            if (exa_lista != null) {
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            } else {
                exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
                if (this.hostQuery) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_lista[0].getNomeExame(), mco_codigo);
                }
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
            }
            alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            if (!exa_listaCurva.isEmpty()) {
                if (alternativos != null && alternativos.length == 1) {
                    alternativos = null;
                }
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, st, exa_listaCurva, this.rec_tuboPai, this.hostQuery, this.examesFilho);
            }
            String nome = short_name;
            String sobrenome = null;
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = req_codigo;
            String laboratory_pid = null;
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                this.tx_list.add(ASTMStandard.getDefaultOrderRecord(1, codigo.toString(), alternativos, null, null, "R", acao, tipo_amostra, "O"));
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    this.tx_list.add(ASTMStandard.getDefaultOrderRecord(++seq, sample_id.append(tubo).toString(), alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()]), null, null, "R", acao, tipo_amostra, "O"));
                }
            }
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private int getExameSituacaoAba(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo, String exa_codigo, int abaSelecionada) {
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            String tubo = (String)req[aba.getColIndice("Tubo")];
            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            String equip = (String)req[aba.getColIndice("Interface")];
            String exame = (String)req[aba.getColIndice("Exame")];
            if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(filial) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(requisicao) || Funcoes.textoVazio(rec_codigo) || Funcoes.textoVazio(tubo) || Funcoes.textoVazio(exa_codigo) || Funcoes.textoVazio(int_codigo) || Funcoes.textoVazio(equip) || !fil_codigo.equalsIgnoreCase(filial) || !req_codigo.equalsIgnoreCase(requisicao) || !rec_codigo.equalsIgnoreCase(tubo) || !exa_codigo.equalsIgnoreCase(exame) || !int_codigo.equalsIgnoreCase(equip) || exame.indexOf(" ") != -1) continue;
            return Integer.parseInt((String)req[aba.getColIndice("Sit")]);
        }
        return -1;
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            starting_range = starting_range.replace("\\", "|");
            String[] tubos = starting_range.split("[|]");
            if (tubos != null && tubos.length > 0) {
                for (String tubo : tubos) {
                    if (tubo.length() == ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                        this.tubos.add(tubo);
                        continue;
                    }
                    this.fireExcecaoEncontrada(String.format("C\u00f3digo da amostra solicitada fora do padr\u00e3o: %s", tubo));
                }
            } else {
                this.fireExcecaoEncontrada(String.format("Nenhuma amostra solicitada pelo equipamento: %s", starting_range));
                return;
            }
            this.hostQuery = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Liaison XL: Host Query Response");
        }
    }

    @Override
    protected void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
                if (this.tubos.size() > 0) {
                    this.enviaProximaAmostra();
                    this.responseHostQuery();
                }
            } else {
                this.enviarProximoFrame();
            }
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void enviaProximaAmostra() {
        String amostra = this.tubos.remove(0);
        this.host_fil_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
        amostra = amostra.substring(ParametrosGerais.getDigitosTuboFilial());
        this.host_req_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
        this.host_rec_codigo = amostra.substring(ParametrosGerais.getDigitosTuboRequisicao());
        this.hostQuery = true;
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        super.encerrarTransmissao();
        if (this.tubos.size() == 0) {
            this.fireAtualizarTabela(0);
        }
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames) && req != null && aba != null) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (Funcoes.textoVazio(pac_exames)) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
            } else {
                this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
                this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
                this.tx_list = this.makeFrames(this.tx_list);
                this.tx_list.resetUltimoLido();
                this.setTX(this.TIME_TX);
                this.tx_counter = 0;
                this.getPortaCOM().write(String.valueOf('\u0005'));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Selectra Flexor: Host Query Response");
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery && this.tubos.size() == 0) {
            this.hostQuery = false;
        }
        if (this.hostQuery) {
            this.enviaProximaAmostra();
            this.responseHostQuery();
        }
    }
}

