/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.liaison;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.liaison.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.liaison.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

public class InterfaceListener
extends InterfaceASTMListener {
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    public InterfaceConfiguracao getConfiguracao() {
        return this.configuracao;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            Statement st = Conexao.getStatement();
            if (acao.equals("C") && this.equipamento.getSelectedTab() instanceof AbaDefaultProntos) {
                StringBuilder exaRemover = new StringBuilder();
                for (String exa : pac_exames.split(" ", 0)) {
                    int situacao = this.getExameSituacaoAba(fil_codigo, int_codigo, req_codigo, rec_codigo, exa, 2);
                    if (situacao == 2 || situacao == 7) continue;
                    exaRemover.append(exa).append(" ");
                }
                pac_exames = exaRemover.toString();
                if (Funcoes.textoVazio(pac_exames)) {
                    return null;
                }
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            String nome = short_name;
            String sobrenome = null;
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = req_codigo;
            String laboratory_pid = null;
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(ASTMStandard.getDefaultOrderRecord(1, codigo.toString(), alternativos, null, null, "R", acao, tipo_amostra, "O"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private int getExameSituacaoAba(String fil_codigo, String int_codigo, String req_codigo, String rec_codigo, String exa_codigo, int abaSelecionada) {
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            String tubo = (String)req[aba.getColIndice("Tubo")];
            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            String equip = (String)req[aba.getColIndice("Interface")];
            String exame = (String)req[aba.getColIndice("Exame")];
            if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(filial) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(requisicao) || Funcoes.textoVazio(rec_codigo) || Funcoes.textoVazio(tubo) || Funcoes.textoVazio(exa_codigo) || Funcoes.textoVazio(int_codigo) || Funcoes.textoVazio(equip) || !fil_codigo.equalsIgnoreCase(filial) || !req_codigo.equalsIgnoreCase(requisicao) || !rec_codigo.equalsIgnoreCase(tubo) || !exa_codigo.equalsIgnoreCase(exame) || !int_codigo.equalsIgnoreCase(equip) || exame.indexOf(" ") != -1) continue;
            return Integer.parseInt((String)req[aba.getColIndice("Sit")]);
        }
        return -1;
    }

    @Override
    public void teste() {
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
        this.handShakeCharReceived('\u0006');
    }
}

