/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.lh750;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.lh750.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.stks.InterfaceListener {
    private static final String HISTOGRAM_PLTF = "PLTF";
    private static final String HISTOGRAM_PLTH = "PLTH";
    private static final String HISTOGRAM_RBC = "RBCH";
    private int grupoInicial = 6;

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
        configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        if (Funcoes.isNumeric(configuracao.getGrupoInicialFlags())) {
            this.grupoInicial = Integer.parseInt(configuracao.getGrupoInicialFlags());
        }
    }

    @Override
    public void recordFound(String record) throws Exception {
        StringTokenizer stks = new StringTokenizer(record, this.LINE);
        HashMap<String, Object> lines = new HashMap<String, Object>();
        int qtdeD1C = 0;
        ArrayList<String> flags = new ArrayList<String>();
        while (stks.hasMoreTokens()) {
            String token = stks.nextToken();
            int indexSP = token.indexOf(String.valueOf(this.SP));
            if (indexSP <= 0) {
                if (token.indexOf(String.valueOf('\u0011')) <= -1) continue;
                ++qtdeD1C;
                continue;
            }
            if (qtdeD1C >= this.grupoInicial) {
                flags.add(token);
                continue;
            }
            String cmd = token.substring(0, indexSP).trim();
            String value = "";
            if (token.length() > 0) {
                value = token.substring(token.indexOf(String.valueOf(this.SP)), token.length()).trim();
            }
            lines.put(cmd, value);
        }
        this.trataResultado(lines, flags);
    }

    protected void trataResultado(HashMap<String, Object> lines, ArrayList<String> flags) throws Exception {
        Statement st = Conexao.getStatement();
        String req_codigo = null;
        if (lines.isEmpty() || lines.get("ID1") == null || !Funcoes.isNumeric((String)lines.get("ID1"))) {
            this.fireExcecaoEncontrada("Registro ID1 n\u00e3o encontrado na mensagem transmitida!");
            return;
        }
        req_codigo = ((String)lines.get("ID1")).trim();
        if (req_codigo != null && req_codigo.indexOf("-") >= 0) {
            if (!lines.isEmpty() && lines.get("ID2") != null && Funcoes.isNumeric((String)lines.get("ID1"))) {
                req_codigo = ((String)lines.get("ID2")).trim();
            } else {
                this.fireExcecaoEncontrada("Registro ID2 n\u00e3o encontrado na mensagem transmitida!");
                return;
            }
        }
        if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
            this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o com ID da amostra diferente do padr\u00e3o: " + req_codigo);
            return;
        }
        String codigoEquipamento = req_codigo;
        String fil_codigo = codigoEquipamento.substring(0, ParametrosGerais.getDigitosTuboFilial());
        req_codigo = codigoEquipamento.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = codigoEquipamento.substring(codigoEquipamento.length() - ParametrosGerais.getDigitosTuboTubo());
        HashMap<String, Object> dados = new HashMap<String, Object>();
        dados.put("leucocitos", this.parseValor(lines.get("WBC")));
        dados.put("hemacias", this.parseValor(lines.get("RBC")));
        dados.put("hgb", this.parseValor(lines.get("HGB")));
        dados.put("hct", this.parseValor(lines.get("HCT")));
        dados.put("vcm", this.parseValor(lines.get("MCV")));
        dados.put("hcm", this.parseValor(lines.get("MCH")));
        dados.put("chcm", this.parseValor(lines.get("MCHC")));
        dados.put("rdw", this.parseValor(lines.get("RDW")));
        dados.put("plaquetas", this.parseValor(lines.get("PLT")));
        dados.put("pct", this.parseValor(lines.get("PCT")));
        dados.put("vpm", this.parseValor(lines.get("MPV")));
        dados.put("pdw", this.parseValor(lines.get("PDW")));
        dados.put("linfocitos_tipicos_contagem", this.parseValor(lines.get("LY#")));
        dados.put("monocitos_contagem", this.parseValor(lines.get("MO#")));
        dados.put("segmentados_contagem", this.parseValor(lines.get("NE#")));
        dados.put("eosinofilos_contagem", this.parseValor(lines.get("EO#")));
        dados.put("basofilos_contagem", this.parseValor(lines.get("BA#")));
        dados.put("linfocitos_tipicos_percentual", this.parseValor(lines.get("LY%")));
        dados.put("monocitos_percentual", this.parseValor(lines.get("MO%")));
        dados.put("segmentados_percentual", this.parseValor(lines.get("NE%")));
        dados.put("eosinofilos_percentual", this.parseValor(lines.get("EO%")));
        dados.put("basofilos_percentual", this.parseValor(lines.get("BA%")));
        dados.put("linfocitos_atipicos_percentual", this.parseValor(lines.get("LY%")));
        if (lines.containsKey(HISTOGRAM_PLTF)) {
            dados.put("lh_histograma_pltf", InterfaceListener.convertImg(this.criarImagem(this.leResultado(lines.get(HISTOGRAM_PLTF).toString()))));
        }
        if (lines.containsKey(HISTOGRAM_PLTH)) {
            dados.put("lh_histograma_plth", InterfaceListener.convertImg(this.criarImagem(this.leResultado(lines.get(HISTOGRAM_PLTH).toString()))));
        }
        if (lines.containsKey(HISTOGRAM_RBC)) {
            dados.put("lh_histograma_rbc", InterfaceListener.convertImg(this.criarImagem(this.leResultado(lines.get(HISTOGRAM_RBC).toString()))));
        }
        String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, this.EXAME_PADRAO);
        ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, this.EXAME_PADRAO);
        List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
        if (exame == null && exames == null) {
            this.fireExcecaoEncontrada(fil_codigo + " " + req_codigo + " " + rec_codigo + " " + "N\u00e3o foi encontrada");
            return;
        }
        for (BDExame ex : exames) {
            this.atualizarDadosExame(st, fil_codigo, ex.getRequisicao(), ex.getRecipiente(), ex.getExame(), ex.getMaterial(), int_codigo, dados, flags);
        }
    }

    private ArrayList<Integer> leResultado(String resultado) {
        int conti = 0;
        int contf = 2;
        String letra = "";
        ArrayList<Integer> decimal = new ArrayList<Integer>();
        for (int i = 0; i < resultado.length(); ++i) {
            if (contf > resultado.length()) continue;
            letra = resultado.substring(conti, contf);
            conti = contf;
            contf += 2;
            int teste = Integer.parseInt(letra, 16);
            decimal.add(teste);
        }
        return decimal;
    }

    protected BufferedImage criarImagem(ArrayList<Integer> decimal) {
        Integer[] c = new Integer[256];
        for (int i = 0; i < decimal.size(); ++i) {
            c[i] = decimal.get(i);
        }
        BufferedImage buffer = new BufferedImage(255, 150, 1);
        Graphics2D g = buffer.createGraphics();
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, 255, 255);
        g.setColor(Color.BLACK);
        int x1 = 0;
        int y1 = 128;
        for (int x2 = 0; x2 < decimal.size(); ++x2) {
            int y2 = 128 - c[x2];
            g.drawLine(x1, y1, x2 + 1, y2);
            x1 = x2 + 1;
            y1 = y2;
        }
        return buffer;
    }

    private static String convertImg(BufferedImage image) throws IOException {
        return new Base64().encodeAsString(ImagemUtils.imageToByte(image));
    }

    @Override
    protected Object parseValor(Object valor) {
        String tmp;
        if (valor == null) {
            return new String("");
        }
        String value = valor.toString();
        int idx = value.indexOf(this.NUL);
        if (idx > 0) {
            value = value.substring(0, idx);
        }
        if (value.indexOf(".") > 0) {
            value = value.replaceFirst("\\.", ",");
        }
        if (!Funcoes.textoVazio(tmp = value.replaceAll("[a-zA-Z]", ""))) {
            value = tmp.trim();
        }
        return value;
    }
}

