/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.leitorapetrifilm;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.padroes.arquivo.InterfaceArquivoListener;
import jalis.util.Funcoes;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JFileChooser;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class InterfaceListener
extends InterfaceArquivoListener {
    private ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
    private String diretorioImportacao = "";

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.diretorioImportacao = c.getDiretorioImportacao();
    }

    @Override
    public void buscarResultados(Date inicio, Date termino) {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser("Arquivo para importa\u00e7\u00e3o", this.diretorioImportacao);
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de Planilha de resultado", "xlsx"));
            if (chooser.showOpenDialog(null) == 0) {
                String path = chooser.getSelectedFile().getPath();
                this.parse(path);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    @Override
    public String parse(String path) {
        File file = new File(path);
        try {
            Statement st = Conexao.getStatement();
            List<List<Object>> planilhaResultado = this.lerXlsx(file, "", true);
            for (int i = 1; i < planilhaResultado.size(); ++i) {
                String alternativo;
                String rec_codigo;
                String req_codigo;
                List<Object> cabecalho = planilhaResultado.get(0);
                List<Object> retorno = planilhaResultado.get(i);
                String amostra = retorno.get(1).toString().trim();
                Integer tamanhoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (amostra.length() < tamanhoTubo) {
                    amostra = "0" + amostra;
                }
                if (amostra.isEmpty()) continue;
                if (amostra.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                    this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada %s.", amostra));
                    continue;
                }
                String fil_codigo = amostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo = amostra.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo = amostra.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()), alternativo = retorno.get(3).toString());
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada %s %s %s.", fil_codigo, req_codigo, rec_codigo));
                    continue;
                }
                Map<String, Object> resultadosMap = null;
                try {
                    resultadosMap = this.resultadoMap(retorno, cabecalho);
                    ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, alternativo);
                    if (exame != null) {
                        this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, resultadosMap);
                        Conexao.arquivaSQL();
                    } else {
                        this.fireExcecaoEncontrada(String.format("Amostra n\u00e3o localizada para o exame SALIVA %s %s %s.", fil_codigo, req_codigo, rec_codigo));
                    }
                    this.fireAtualizarTabela();
                    continue;
                }
                catch (Exception e) {
                    this.fireExcecaoEncontrada("Resultado n\u00e3o encontrado " + e.getMessage());
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Resultado n\u00e3o encontrado no arquivo " + file.getName() + e.getMessage());
        }
        return null;
    }

    private Map<String, Object> resultadoMap(List<Object> retorno, List<Object> cabecalho) throws Exception {
        Integer comentario = retorno.size() > 10 ? 12 : 9;
        if (!Funcoes.textoVazio(retorno.get(comentario).toString())) {
            throw new Exception(" Amostra: " + retorno.get(1) + " " + retorno.get(comentario).toString());
        }
        HashMap<String, Object> resultadosMap = new HashMap<String, Object>();
        resultadosMap.put("Contagem Bruta Vermelho", retorno.get(6));
        resultadosMap.put("Contagem Editada Vermelho", retorno.get(7));
        resultadosMap.put("Contagem Calculada Vermelho", retorno.get(8));
        if (retorno.size() > 10) {
            resultadosMap.put("Contagem Bruta Vermelho com g?s", retorno.get(9));
            resultadosMap.put("Contagem Editada Vermelho com g?s", retorno.get(10));
            resultadosMap.put("Contagem Calculada Vermelho com g?s", retorno.get(11));
        }
        return resultadosMap;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            for (String s : exms = exames.split(" ", 0)) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, s, mco_codigo, int_codigo, null, 1);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }

    public List<List<Object>> lerXlsx(File file, String planilha, boolean retornaValor) throws Exception {
        ArrayList<List<Object>> linhas = new ArrayList<List<Object>>();
        XSSFWorkbook rb = new XSSFWorkbook((InputStream)new FileInputStream(file));
        XSSFSheet plan1 = rb.getSheetAt(0);
        for (int i = 0; i <= plan1.getLastRowNum(); ++i) {
            if (plan1.getRow(i) == null) continue;
            linhas.add(this.getCelulaValorXlsx(plan1.getRow(i), retornaValor));
        }
        return linhas;
    }

    public List<Object> getCelulaValorXlsx(XSSFRow xssfRow, boolean retornaValor) {
        ArrayList<Object> colunas = new ArrayList<Object>();
        for (Cell cell : xssfRow) {
            try {
                switch (cell.getCellType()) {
                    case 3: {
                        colunas.add("");
                        break;
                    }
                    case 4: {
                        colunas.add(new Boolean(cell.getBooleanCellValue()));
                        break;
                    }
                    case 5: {
                        colunas.add(cell.getErrorCellValue());
                        break;
                    }
                    case 2: {
                        colunas.add(retornaValor ? Double.valueOf(cell.getNumericCellValue()) : cell.getCellFormula());
                        break;
                    }
                    case 0: {
                        Double valor = cell.getNumericCellValue();
                        String valorFormatado = new BigDecimal(valor).toString();
                        colunas.add(valorFormatado);
                        break;
                    }
                    case 1: {
                        colunas.add(cell.getStringCellValue());
                        break;
                    }
                    default: {
                        colunas.add(cell.getStringCellValue());
                        break;
                    }
                }
            }
            catch (Exception e) {
                colunas.add("");
            }
        }
        return colunas;
    }
}

