/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.landwindlwc200iplus;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageDsrQ03;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQckQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQryQ02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentDsp;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentQak;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;

public class InterfaceListener
extends InterfaceHl7Listener {
    public InterfaceListener() {
        super("LWC 200");
        this.receivingApplication = "LandWind";
    }

    public InterfaceListener(String modelo) {
        super(modelo);
        this.receivingApplication = "LandWind";
    }

    @Override
    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setSendingApplication("Mindray");
            mensagem.getMsh().setSendingFacility(this.modelo);
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.5");
            mensagem.getMsh().setCharacterSet("UNICODE");
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            this.getPortaCOM().write(this.messageParser.messageToText(mensagem, this.fieldSeparator));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    @Override
    public void teste() {
        this.resultado();
    }

    private void resultado() {
        StringBuilder buf = new StringBuilder();
        String amostra = "010003069304";
        buf.append("[SB]MSH|^~\\&|LandWind||||20151030094049||ORU^R01|LWC999999|P|2.5||||||UNICODE[CR]");
        buf.append("OBR||").append(amostra).append("|1||||||||||||SERUM||||||||||||||||||||||1[CR]");
        buf.append("OBX|0|NM|ALB^ALB||4.91|^g/dl|35-55|0|||||||||||20151029084853[CR]");
        buf.append("OBX|1|NM|CREA^CREA||5.51|^mg/dl|0,3-1,3|0|||||||||||20151029084853[CR]");
        buf.append("OBX|2|NM|FERRO^FERRO||189.8|^Ug/dl|40-155|1|||||||||||20151029084853[CR]");
        buf.append("OBX|3|NM|FOSFORO^FOSFORO||9.7|^mg/dl|2-7|0|||||||||||20151029084853[CR]");
        buf.append("OBX|4|NM|PROT^PROT||3.28|^g/dl|6-8|0|||||||||||20151029084853[CR]");
        buf.append("OBX|5|NM|TGO^TGO||192|^U/L|4-40|0|||||||||||20151029084853[CR]");
        buf.append("OBX|6|NM|TGP^TGP||81|^U/L|4-40|0|||||||||||20151029084853[CR]");
        buf.append("OBX|7|NM|TRI^TRI||130.0|^mg/dl|60-150|0|||||||||||20151029084853[CR]");
        buf.append("OBX|8|NM|UREIA^UREIA||175|^mg/dl|10-40|0|||||||||||20151029084853[CR]");
        buf.append("OBX|9|NM|MAG^MAG||3.8|^mg/dl|1,9-3,5|0|||||||||||20151029084853[CR]");
        buf.append("OBX|10|NM|GLIC^GLIC||420|^mg/dl|60-100|0|||||||||||20151029084853[CR]");
        buf.append("OBX|11|NM|GGT^GGT||158.9|^U/L|5-60|0|||||||||||20151029084853[CR]");
        buf.append("OBX|12|NM|CALC^CALC||20.1|^mg/dl|8-11|1|||||||||||20151029084853[CR]");
        buf.append("OBX|13|NM|URICO^URICO||15.4|^mg/dl|1,5-7|0|||||||||||20151029084853[CR]");
        buf.append("OBX|14|NM|COL^COL||170|^mg/dl|80-240|0|||||||||||20151029084853[CR]");
        buf.append("[EB][CR]");
        this.parse(TestesInterface.arruma(buf.toString()));
    }

    private void solicitacaoOrder() {
        String amostra = "010003068304";
        StringBuilder buf = new StringBuilder();
        buf.append("[SB]MSH|^~\\&|LandWind||||20151030094452||QRY^Q02|LWC999999|P|2.5||||||UNICODE[CR]");
        buf.append("QRD|20151030094452||||||||||").append(amostra).append("[CR]");
        buf.append("[EB][CR]");
        this.parse(TestesInterface.arruma(buf.toString()));
    }

    @Override
    public void messageQryQ02Recebida(MessageQryQ02 qryQ02) {
        block24: {
            String messageId = qryQ02.getMsh().getMessageControlId();
            MessageQckQ02 qckQ02 = new MessageQckQ02();
            qckQ02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
            qckQ02.getMsa().setTextMessage("Mensagem aceita");
            qckQ02.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
            qckQ02.getErr().setErrorCode(0);
            qckQ02.getQak().setQueryTag("SR");
            try {
                String tuboId = qryQ02.getQrd().getWhatDataCodeValueQual();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (tuboId != null && !tuboId.trim().isEmpty() && tuboId != "null" && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    String exames = "";
                    StringBuilder examesFilho = new StringBuilder();
                    if (req != null) {
                        exames = (String)req[aba.getColIndice("Exame")];
                    }
                    if (req == null && Funcoes.textoVazio(exames = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1), aba = this.equipamento.getTab(1), exames, 1)) && req != null) {
                        if (!Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
                            exames = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, exames, 1);
                        }
                    }
                    if (req == null && Funcoes.textoVazio(exames = this.getExames(filCodigo, reqCodigo, recCodigo, req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2), aba = this.equipamento.getTab(2), exames, 2)) && req != null) {
                        if (!Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(recCodigo)) {
                            exames = this.getExames(filCodigo, reqCodigo, (String)req[aba.getColIndice("Tubo")], req, aba, exames, 2);
                        }
                    }
                    if (req == null) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        return;
                    }
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String recTuboPai = (String)req[aba.getColIndice("Tubo")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.trim().split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        boolean curva = BDUtil.isExameCurva(filCodigo, intCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            int sitFilho;
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (!(n != 0 && n != 1 || curva)) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            if (curva) {
                                for (ExameMaterial exameFilho : examesFilhos) {
                                    sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recTuboPai, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    String tuboFilho = BDUtil.getExameDesmembradoTubo(filCodigo, reqCodigo, recTuboPai, intCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                    if (sitFilho != 0 && sitFilho != 1 && sitFilho != 3 || !Funcoes.preencheZero(tuboFilho, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo)) continue;
                                    examesFilho.append(exameFilho.getNomeExame()).append(" ");
                                    examesParaEnviar.add(exameFilho);
                                }
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<String> tests = new HashSet<String>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test != null && !test.trim().isEmpty()) {
                            tests.add(test);
                            continue;
                        }
                        System.out.println("Exames para enviar sem alternativo: " + exameMaterial.getNomeExame());
                    }
                    if (tests.isEmpty()) {
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.NO_DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        infoExameRequisicao.setInterface(intCodigo);
                        if (!Funcoes.preencheZero(recTuboPai, ParametrosGerais.getDigitosTuboTubo()).equals(recCodigo) && !Funcoes.textoVazio(examesFilho.toString().trim())) {
                            infoExameRequisicao.setTuboPai(recTuboPai);
                            infoExameRequisicao.setExamesFilho(examesFilho.toString().trim());
                            infoExameRequisicao.setCurva(true);
                        }
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        MessageDsrQ03 messageDsrQ03 = new MessageDsrQ03();
                        messageDsrQ03.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        messageDsrQ03.getMsa().setTextMessage("Mensagem aceita");
                        messageDsrQ03.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
                        messageDsrQ03.getErr().setErrorCode(0);
                        messageDsrQ03.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
                        messageDsrQ03.getQak().setQueryTag("SR");
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp(pacNome));
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp(pacSexo));
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp(tuboId));
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        messageDsrQ03.addDsp(new MessageSegmentDsp());
                        String tmp = "";
                        for (String test : tests) {
                            tmp = tmp + test + "^^^";
                            messageDsrQ03.addDsp(new MessageSegmentDsp(test + "^^^"));
                        }
                        qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.DATA_FOUND);
                        this.enviaMensagem(messageId, qckQ02);
                        this.enviaMensagem(messageId, messageDsrQ03);
                    }
                    break block24;
                }
                qckQ02.getQak().setQueryResponseStatus(MessageSegmentQak.QueryResponseStatus.APPLICATION_REJECT);
                this.enviaMensagem(messageId, qckQ02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }
}

