/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.labotech;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final int TIME_OUT = 10000;
    private static final int TIME_OUT_ENVIO = 60000;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    private static final String END = "end";
    private static final String OK = "ok";
    private static final int CODPAZ = 0;
    private static final int CODANA = 1;
    private static final int RISNUM = 2;
    private static final int RISVAL = 3;
    private static final int FILLER = 4;
    private String ultimoEnvio = "";
    protected InfoExameRequisicao ultimo_enviado = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);

    public void dataChanged(String message) {
        try {
            if (message.length() == 2 && message.equalsIgnoreCase(OK)) {
                if (!Funcoes.textoVazio(this.ultimoEnvio)) {
                    this.getPortaCOM().write(this.ultimoEnvio);
                    this.setIdle();
                }
            } else if (message.length() == 3 && message.equalsIgnoreCase(END)) {
                this.confirmaTransmissao();
            }
            if (message.endsWith(this.getMsgEnd())) {
                message = this.getPortaCOM().removeInputString(this.getMsgEnd());
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                this.getPortaCOM().write(OK);
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equalsIgnoreCase(OK)) {
                if (!Funcoes.textoVazio(this.ultimoEnvio)) {
                    this.getPortaCOM().write(this.ultimoEnvio);
                    this.setIdle();
                }
            } else if (message.length() == 3 && message.equalsIgnoreCase(END)) {
                this.confirmaTransmissao();
            }
            if (message.endsWith(this.getMsgEnd())) {
                message = this.getPortaCOM().removeInputString(this.getMsgEnd());
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                this.getPortaCOM().write(OK);
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private String[] getRecord(String message) {
        String[] record = new String[5];
        if (message.length() == 64) {
            record[0] = message.substring(0, 15).trim();
            record[1] = message.substring(15, 23).trim();
            record[2] = message.substring(23, 25).trim();
            record[3] = message.substring(25, 40).trim();
            record[4] = message.substring(40, 64).trim();
        }
        return record;
    }

    public static String getRecord(String[] record) {
        StringBuilder message = new StringBuilder();
        message.append(Funcoes.preencheVazio(record[0], 15, 2));
        message.append(Funcoes.preencheVazio(record[1], 8, 2));
        message.append(Funcoes.preencheVazio(record[2], 2, 2));
        message.append(Funcoes.preencheVazio(record[3], 15, 2));
        message.append(Funcoes.preencheVazio(record[4], 24, 2));
        return message.toString();
    }

    private String getMsgWorkList(String[] record) {
        StringBuilder message = new StringBuilder();
        message.append(Funcoes.preencheVazio(record[0], 10, 2).substring(0, 10));
        message.append(Funcoes.preencheVazio(record[1], 15, 2).substring(0, 15));
        message.append(Funcoes.preencheVazio(record[2], 5, 2).substring(0, 5));
        message.append(Funcoes.preencheVazio(record[3], 8, 2).substring(0, 8));
        message.append(Funcoes.preencheVazio(record[4], 2, 2).substring(0, 2));
        for (int i = 5; i < record.length; i += 2) {
            message.append(Funcoes.preencheVazio(record[i] != null ? record[i] : "", 8, 2).substring(0, 8));
            message.append(record[i + 1] != null ? record[i + 1].charAt(0) : (char)' ');
        }
        message.append(this.getMsgEnd());
        return message.toString();
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return LINE;
    }

    @Override
    public String getMsgStart() {
        return null;
    }

    @Override
    public String parse(String message) {
        try {
            String[] record = this.getRecord(message);
            String sampleId = record[0];
            String emi_alternativo = record[1];
            String valorResultado = record[3];
            valorResultado = valorResultado.replaceAll("\\.", ",");
            String fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboFilial(), sampleId.length() - ParametrosGerais.getDigitosTuboTubo());
            String rec_codigo = sampleId.substring(sampleId.length() - ParametrosGerais.getDigitosTuboTubo());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
            if (exame == null) {
                String excecao = String.format("C\u00f3digo LIS do exame %s n\u00e3o encontrado para requisi\u00e7\u00e3o %s %s %s", emi_alternativo, fil_codigo, req_codigo, rec_codigo);
                this.fireExcecaoEncontrada(excecao);
                return excecao;
            }
            Statement st = Conexao.getStatement();
            String exa_codigo = exame.getNomeExame();
            String mco_codigo = exame.getCodigoMaterial();
            String campoQuanti = "resultado_quantitativo";
            String campoQuali = "resultado_qualitativo";
            int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
            if (situacao == 2 || situacao == 7 || situacao == 4) {
                this.fireExcecaoEncontrada(String.format("Interfaceamento do exame %s para requisi\u00e7\u00e3o %s %s %s com situa\u00e7\u00e3o %s ", exame.getNomeExame(), fil_codigo, req_codigo, rec_codigo, situacao == 2 ? "pronto " : (situacao == 4 ? "j\u00e1 repetido " : "validado ")));
                return null;
            }
            if (situacao == 3) {
                campoQuanti = "repeticao_quantitativo";
                campoQuali = "repeticao_qualitativo";
            }
            this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, valorResultado);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                return "Erro ao inserir resultados recebidos ao banco de dados";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                return "Erro ao inserir resultados recebidos ao banco de dados";
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.toString() + "\n" + e.getMessage(), e.getStackTrace());
            return "Erro ao realizar parse dos dados recebidos";
        }
        return null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String message;
            String[] record = new String[25];
            Statement st = Conexao.getStatement();
            this.getPortaCOM().clearInputString();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            if (alternativos.length > 10) {
                String excecao = String.format("N\u00e3o \u00e9 poss\u00edvel enviar a requisi\u00e7\u00e3o %s %s %s pois ela possui mais de 10 exames ", fil_codigo, req_codigo, rec_codigo);
                this.fireExcecaoEncontrada(excecao);
                return excecao;
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            int pos = 0;
            record[pos++] = String.format("%s%s%s", fil_codigo, req_codigo, rec_codigo);
            record[pos++] = StringUtil.removerAcentos(pac_nome).substring(0, 15);
            record[pos++] = "";
            record[pos++] = "";
            record[pos++] = String.valueOf(alternativos.length);
            for (ExameMaterial exameMaterial : alternativos) {
                record[pos++] = exameMaterial.getNomeExame();
                record[pos++] = "0";
            }
            this.ultimoEnvio = message = this.getMsgWorkList(record);
            this.ultimo_enviado = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, exames);
            this.getPortaCOM().write(String.format("1%s", this.getMsgEnd()));
            this.setTX(10000);
            return "Enviando " + pac_nome + " para o equipamento";
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        if (this.isTX()) {
            this.setIdle();
            this.ultimoEnvio = "";
            this.equipamento.mensagemEnviada("Erro ao enviar exame nenhuma resposta da interface " + this.ultimo_enviado.getNome(), 1, 5000);
            this.ultimo_enviado = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);
        }
    }

    private void confirmaTransmissao() {
        try {
            String[] exames;
            if (this.ultimo_enviado == null || this.ultimo_enviado.getExames() == null) {
                this.equipamento.mensagemEnviada("Erro ao receber resposta do equipamento", 1, 5000);
                this.ultimoEnvio = "";
                return;
            }
            Statement st = Conexao.getStatement();
            for (String exame : exames = this.ultimo_enviado.getExames().split(" ", 0)) {
                String rec_codigo;
                String int_codigo;
                String fil_codigo = this.ultimo_enviado.getFilial();
                String req_codigo = this.ultimo_enviado.getCodigo();
                String mco_codigo = this.ultimo_enviado.getMaterial();
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo = this.ultimo_enviado.getRecipiente(), exame, mco_codigo), req_codigo, exame, mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                if (!req_codigo.equals(this.ultimo_enviado.getCodigo())) continue;
                this.firePacienteEnviado(this.ultimo_enviado.getCodigo(), this.ultimo_enviado.getNome(), this.ultimo_enviado.getSexo(), this.ultimo_enviado.getIdade(), this.ultimo_enviado.getData(), this.ultimo_enviado.getHora(), this.ultimo_enviado.getExames());
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
            this.ultimoEnvio = "";
            this.equipamento.mensagemEnviada("Exame enviado com sucesso para " + this.ultimo_enviado.getNome(), 1, 5000);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(10000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

