/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.labmax560;

import jalis.comum.Conexao;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    private static final String REPETICAO = "repeticao";
    LinkedList<Map<String, String>> flags = new LinkedList();

    public RecordParser() {
        HashMap<String, String> technicalRangeCode = new HashMap<String, String>();
        technicalRangeCode.put("01", "Technical range over \"High\"");
        technicalRangeCode.put("02", "Technical range over \"Low\"");
        HashMap<String, String> normalRangeCode = new HashMap<String, String>();
        normalRangeCode.put("01", "Normal range over \"High\"");
        normalRangeCode.put("02", "Normal range over \"Low\"");
        HashMap<String, String> errorFlagCode = new HashMap<String, String>();
        errorFlagCode.put("01", "Sample short");
        errorFlagCode.put("02", "Sample liquid level detection out of range at aspiration.");
        errorFlagCode.put("03", "Sample liquid level not detected at aspiration");
        errorFlagCode.put("04", "Sample liquid level detection out of range at dispensation");
        errorFlagCode.put("05", "Sample short (diluted sample)");
        errorFlagCode.put("06", "Sample liquid level detection out of range at aspiration (diluted sample)");
        errorFlagCode.put("07", "R1 short");
        errorFlagCode.put("08", "R1 liquid level detection out of range at aspiration");
        errorFlagCode.put("09", "R2 short");
        errorFlagCode.put("10", "R2 liquid level detection out of range at aspiration");
        errorFlagCode.put("15", "Diluent short");
        errorFlagCode.put("16", "Diluent liquid level detection out of range at aspiration");
        errorFlagCode.put("17", "Wash solution short");
        errorFlagCode.put("18", "Wash solution liquid level detection out of range at aspiration");
        errorFlagCode.put("19", "R1 reagent bottle not registered.");
        errorFlagCode.put("20", "R1 reagent no inventory");
        errorFlagCode.put("21", "R2 reagent bottle not registered.");
        errorFlagCode.put("22", "R2 reagent no inventory");
        errorFlagCode.put("27", "Diluent bottle not registered.");
        errorFlagCode.put("28", "Diluent no inventory");
        errorFlagCode.put("29", "Wash solution bottle not registered.");
        errorFlagCode.put("30", "Wash solution no inventory");
        errorFlagCode.put("31", "Sampling stop due to error");
        errorFlagCode.put("32", "Reagent lot number mismatch");
        errorFlagCode.put("33", "SPT wash failure");
        errorFlagCode.put("34", "RPT wash between methods failed (R1)");
        errorFlagCode.put("35", "RPT wash between methods failed (R2)");
        errorFlagCode.put("38", "SPT clot");
        errorFlagCode.put("40", "IRU temperature less than 35 degrees centigrade.");
        errorFlagCode.put("41", "IRU temperature more than 39 degrees centigrade.");
        errorFlagCode.put("42", "RCU temperature more than 15 degrees centigrade.");
        errorFlagCode.put("50", "Measured with expired reagent");
        errorFlagCode.put("51", "Measured with expired onboard stability reagent");
        errorFlagCode.put("52", "Terms of validity of calibration is expired");
        errorFlagCode.put("53", "Control expired");
        errorFlagCode.put("54", "Calibrator expired");
        errorFlagCode.put("60", "No response from ISE module.");
        errorFlagCode.put("61", "No measurement results from ISE module.");
        errorFlagCode.put("62", "ISE unit abnormal");
        errorFlagCode.put("70", "Concentration calculation failure");
        errorFlagCode.put("71", "Calibrator out of valid range error");
        errorFlagCode.put("72", "Linearity Limit error");
        errorFlagCode.put("73", "Prozone Limit error");
        errorFlagCode.put("74", "Absorbance Limit1 error");
        errorFlagCode.put("75", "Absorbance Limit2 error");
        errorFlagCode.put("76", "Duplicate Limit error");
        errorFlagCode.put("77", "Sensitivity Limit error");
        errorFlagCode.put("78", "Calibration failed");
        errorFlagCode.put("82", "Sample type mismatch");
        errorFlagCode.put("83", "Reagent lot mismatch");
        errorFlagCode.put("84", "Measurement is not performed due to reagent mismatch.");
        HashMap<String, String> rerunResultCode = new HashMap<String, String>();
        rerunResultCode.put("00", "Primeiro Resultado");
        rerunResultCode.put("01", "Segundo resultado");
        technicalRangeCode.put("1", "Current result exceeds 2SD");
        technicalRangeCode.put("2", "Current result exceeds 3SD");
        technicalRangeCode.put("3", "Current result exceeds 4SD");
        technicalRangeCode.put("4", "Last two results exceed 2SD range");
        technicalRangeCode.put("5", "2 results out of 3 last results exceed 2SD");
        technicalRangeCode.put("6", "Range for a defined period exceeds 4SD");
        technicalRangeCode.put("7", "Any 3 results for a defined period exceed 1SD");
        technicalRangeCode.put("8", "Any 4 results for a defined period exceed 1SD");
        technicalRangeCode.put("9", "Last 10 results higher or lower than mean");
        technicalRangeCode.put("10", "Last 7 results trend");
        this.flags.add(technicalRangeCode);
        this.flags.add(normalRangeCode);
        this.flags.add(errorFlagCode);
        this.flags.add(rerunResultCode);
        this.flags.add(technicalRangeCode);
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        String[] listaFlags;
        Statement st;
        int sit;
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        Hashtable result_fields = ASTMStandard.parseDefaultResultRecord(record);
        String result_status = (String)result_fields.get(ASTMStandard.RESULT_FIELD_RESULT_STATUS);
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
        String mco_codigo = (String)this.exame_atual.get(MCO_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        if ((resultado = resultado.replaceAll("\\.", ",")).startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        String campo = (sit = this.equip.getExameSituacao(st = Conexao.getStatement(), fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo)) < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !Funcoes.textoVazio(flags) && (listaFlags = flags.split("\\^")) != null && listaFlags.length > 4) {
            if (!this.exame_atual.containsKey("flag")) {
                this.exame_atual.put("flag", new ArrayList());
            }
            ((ArrayList)this.exame_atual.get("flag")).add(this.flags.get(0).get(listaFlags[0]));
            ((ArrayList)this.exame_atual.get("flag")).add(this.flags.get(1).get(listaFlags[1]));
            ((ArrayList)this.exame_atual.get("flag")).add(this.flags.get(2).get(listaFlags[2]));
            if (listaFlags[3].equals("01") && sit == 2) {
                this.equip.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, null, 3);
                campo = "repeticao_quantitativo";
            }
        }
        this.exame_atual.put(campo, resultado);
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        ArrayList flags = (ArrayList)this.exame_atual.get("flag");
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados, flags);
    }
}

