/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.labmax450i;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.labmax450i.DadosRequisicao;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageQbp011;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceHl7Listener {
    private HashMap<String, String> mapaParametros = new HashMap();

    public InterfaceListener() {
        super("Labmax 450I");
    }

    @Override
    public synchronized void dataChanged() {
        String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
        if (!Funcoes.textoVazio(message) && this.messageParser.checkMessage(message)) {
            this.parse(message);
            if (this.getPortaCOM().getInputString().length() > 0) {
                this.dataChanged();
            }
        }
    }

    @Override
    public String parse(String text) {
        try {
            Message message = this.messageParser.textToMessageLabmax450I(text);
            if (message != null) {
                this.mensagemRecebida(message);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    protected void mensagemRecebida(Message message) {
        switch (message.getType()) {
            case ORU_R01: {
                this.messageOruR01Recebida((MessageOruR01)message);
                break;
            }
            case QBP_011: {
                this.messageQBPRecebida((MessageQbp011)message);
                break;
            }
            default: {
                this.fireExcecaoEncontrada("Mensagem de tipo desconhecido recebida");
            }
        }
    }

    private void messageQBPRecebida(MessageQbp011 message) {
        String messageId = message.getMsh().getMessageControlId();
        try {
            String tuboId = message.getQpd().getValue();
            tuboId = tuboId.replace("^", "");
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            if (tuboId != null && !tuboId.trim().isEmpty() && tuboId != "null" && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                DadosRequisicao dados = this.extrairTuboId(tuboId);
                Object[] req = this.getRequisicaoAba(dados.getFilCodigo(), dados.getReqCodigo(), dados.getRecCodigo(), 0);
                PanelAbaAbstrata aba = this.equipamento.getTab(0);
                if (req == null) {
                    req = this.getRequisicaoAba(dados.getFilCodigo(), dados.getReqCodigo(), dados.getRecCodigo(), 1);
                    aba = this.equipamento.getTab(1);
                }
                if (req == null) {
                    req = this.getRequisicaoAba(dados.getFilCodigo(), dados.getReqCodigo(), dados.getRecCodigo(), 2);
                    aba = this.equipamento.getTab(2);
                }
                if (req == null) {
                    this.fireExcecaoEncontrada("Nenhuma requisi\u00e7\u00e3o encontrada.");
                    return;
                }
                String exames = this.extrairExames(dados, req, aba);
                dados.setMcoCodigo((String)req[aba.getColIndice("C\u00f3d. Mat.")]);
                dados.setIntCodigo((String)req[aba.getColIndice("Interface")]);
                dados.setPacNome((String)req[aba.getColIndice("Paciente")]);
                dados.setPacIdade((String)req[aba.getColIndice("Ide")]);
                dados.setPacSexo((String)req[aba.getColIndice("S")]);
                dados.setRecTuboPai((String)req[aba.getColIndice("Tubo")]);
                dados.setData(TempoUtil.getCurrentDateBr());
                dados.setHora(TempoUtil.getCurrentTime());
                StringBuilder examesFilho = new StringBuilder();
                Set<String> tests = this.examesParaEnviar(exames, dados, examesFilho);
                if (this.possuiExames(tests)) {
                    InfoExameRequisicao exame = new InfoExameRequisicao(dados.getFilCodigo(), dados.getReqCodigo(), dados.getMcoCodigo(), dados.getRecCodigo(), dados.getPacNome(), dados.getPacIdade(), dados.getPacSexo(), dados.getData(), dados.getHora(), exames);
                    exame.setInterface(dados.getIntCodigo());
                    if (!Funcoes.preencheZero(dados.getRecTuboPai(), ParametrosGerais.getDigitosTuboTubo()).equals(dados.getRecCodigo()) && !Funcoes.textoVazio(examesFilho.toString().trim())) {
                        exame.setTuboPai(dados.getRecTuboPai());
                        exame.setExamesFilho(examesFilho.toString().trim());
                        exame.setCurva(true);
                    }
                    this.examesEnviadosPorSid.put(tuboId, exame);
                    this.examesEnviadosPorMid.put(messageId, exame);
                    String pacNasc = this.getPacienteDataNascimento(dados.getFilCodigo(), dados.getReqCodigo());
                    String nome = StringUtil.removerAcentos(dados.getPacNome());
                    String pacienteId = BDUtil.getCodigoPaciente(dados.getFilCodigo(), dados.getReqCodigo());
                    dados.setPacNome(nome);
                    if (!Funcoes.textoVazio(dados.getPacNome()) && dados.getPacNome().length() > 30) {
                        dados.setPacNome(dados.getPacNome().substring(0, 30));
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append('\u000b');
                    buf.append(this.montaMSH(dados));
                    buf.append(this.montaMSA());
                    buf.append(this.montaQAK());
                    buf.append(this.montaQPD(tuboId, pacienteId));
                    buf.append(this.montaSPM());
                    buf.append(this.montaOBR());
                    Integer contador = 0;
                    for (String test : tests) {
                        Integer n = contador;
                        Integer n2 = contador = Integer.valueOf(contador + 1);
                        buf.append(this.montaOBX(contador, test));
                    }
                    buf.append('\u001c').append('\r');
                    ((PortaSocketServer)this.getPortaCOM()).write(buf.toString());
                    this.enviarRequisicao(dados.getPacNome(), dados.getPacSexo(), dados.getPacIdade(), dados.getData(), dados.getHora(), null, null, dados.getFilCodigo(), dados.getIntCodigo(), dados.getReqCodigo(), dados.getMcoCodigo(), dados.getRecCodigo(), exames, "A");
                }
            } else {
                this.fireExcecaoEncontrada("Nenhum c\u00f3digo de requisi\u00e7\u00e3o encontrado;");
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        if (acao.equals("A") || acao.equals("N")) {
            Statement st = Conexao.getStatement();
            try {
                String[] stringArray = exames.split(" ");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String exame;
                    int situacao = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame = stringArray[i], mcoCodigo, recCodigo);
                    this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela(0);
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    @Override
    protected String getPacienteDataNascimento(String filial, String requisicao) {
        Date dateNascPac = BDUtil.getDataNacimentoPaciente(filial, requisicao);
        String dtNascPac = "";
        if (dateNascPac != null) {
            dtNascPac = Funcoes.formataData("yyyyMMdd", dateNascPac);
        }
        return dtNascPac;
    }

    private Object montaOBX(Integer contador, String alternativo) {
        StringBuilder buf = new StringBuilder();
        buf.append("OBX|").append(contador).append("||").append(alternativo);
        buf.append("||||||||||||||||");
        buf.append('\r');
        return buf.toString();
    }

    private String montaOBR() {
        StringBuilder buf = new StringBuilder();
        buf.append("OBR|||||||||||||||||||||||||||||||||||||||||||||||||");
        buf.append('\r');
        return buf.toString();
    }

    private String montaSPM() {
        StringBuilder buf = new StringBuilder();
        buf.append("SPM||||SER|||||||||||||||||||||||||");
        buf.append('\r');
        return buf.toString();
    }

    private String montaMSH(DadosRequisicao dados) {
        StringBuilder buf = new StringBuilder();
        String hora = dados.getHora();
        String data = Funcoes.formataData("yyyyMMdd", Funcoes.getDataServidor());
        buf.append("MSH|^~\\&|^Jalis||^Labmax450i||").append(data).append("||RSP^WOS^RSP_K11|").append(data).append("||2.5||||||ASCII|||").append('\r');
        return buf.toString();
    }

    private String montaMSA() {
        StringBuilder buf = new StringBuilder();
        String datahora = Funcoes.formataData("yyyyMMddHHmmss", Funcoes.getDataHoraServidor());
        buf.append("MSA|AA|").append("||||");
        buf.append('\r');
        return buf.toString();
    }

    private String montaQAK() {
        StringBuilder buf = new StringBuilder();
        buf.append("QAK||OK|^^^^^^^^|||");
        buf.append('\r');
        return buf.toString();
    }

    private String montaQPD(String tuboID, String pacienteID) {
        StringBuilder buf = new StringBuilder();
        buf.append("QPD|^^^^^^^^|||");
        buf.append(tuboID).append("|");
        buf.append('\r');
        return buf.toString();
    }

    private String montaPID(String tuboId, String dataNascimento, String nome, String sexo) {
        StringBuilder buf = new StringBuilder();
        buf.append("PID|||").append(tuboId);
        buf.append("||");
        buf.append(nome.replaceAll(" ", "^")).append("||").append(dataNascimento).append("|").append(sexo).append("|||||||||||||||||||||||||||||||");
        buf.append('\r');
        return buf.toString();
    }

    private String extrairExames(DadosRequisicao dados, Object[] req, PanelAbaAbstrata aba) {
        String exames = "";
        if (req != null) {
            exames = (String)req[aba.getColIndice("Exame")];
        }
        if (req == null) {
            req = this.getRequisicaoAba(dados.getFilCodigo(), dados.getReqCodigo(), dados.getRecCodigo(), 1);
            aba = this.equipamento.getTab(1);
            exames = this.getExames(dados.getFilCodigo(), dados.getReqCodigo(), dados.getRecCodigo(), req, aba, exames, 1);
            if (Funcoes.textoVazio(exames) && req != null) {
                if (!Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(dados.getRecCodigo())) {
                    exames = this.getExames(dados.getFilCodigo(), dados.getReqCodigo(), (String)req[aba.getColIndice("Tubo")], req, aba, exames, 1);
                }
            }
        }
        if (req == null) {
            req = this.getRequisicaoAba(dados.getFilCodigo(), dados.getReqCodigo(), dados.getRecCodigo(), 2);
            aba = this.equipamento.getTab(2);
            exames = this.getExames(dados.getFilCodigo(), dados.getReqCodigo(), dados.getRecCodigo(), req, aba, exames, 2);
            if (Funcoes.textoVazio(exames) && req != null) {
                if (!Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboFilial()).equals(dados.getRecCodigo())) {
                    exames = this.getExames(dados.getFilCodigo(), dados.getReqCodigo(), (String)req[aba.getColIndice("Tubo")], req, aba, exames, 2);
                }
            }
        }
        return exames;
    }

    private DadosRequisicao extrairTuboId(String tuboId) {
        DadosRequisicao dados = new DadosRequisicao();
        dados.setFilCodigo(tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial()));
        dados.setReqCodigo(tuboId.substring(ParametrosGerais.getDigitosTuboFilial()));
        dados.setRecCodigo(dados.getReqCodigo().substring(ParametrosGerais.getDigitosTuboRequisicao()));
        dados.setReqCodigo(dados.getReqCodigo().substring(0, ParametrosGerais.getDigitosTuboRequisicao()));
        DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
        if (etiqueta != null) {
            dados.setFilCodigo(Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial()));
            dados.setReqCodigo(Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()));
            dados.setRecCodigo(Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo()));
        }
        return dados;
    }

    private Set<String> examesParaEnviar(String exames, DadosRequisicao dados, StringBuilder examesFilho) throws SQLException {
        ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
        for (String string : exames.trim().split(" ", 0)) {
            examesDaRequisicao.add(new ExameMaterial(string, new Integer(dados.getMcoCodigo())));
        }
        Date dataColeta = null;
        ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
        for (ExameMaterial exameMaterial : examesDaRequisicao) {
            if (dataColeta == null) {
                dataColeta = BDUtil.getExmColeta(dados.getFilCodigo(), dados.getReqCodigo(), exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
            }
            int n = this.getExameSituacao(Conexao.getStatement(), dados.getFilCodigo(), dados.getIntCodigo(), dados.getReqCodigo(), exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), dados.getRecCodigo());
            boolean curva = BDUtil.isExameCurva(dados.getFilCodigo(), dados.getIntCodigo(), exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
            if (BDUtil.isExameDesmembrado(dados.getFilCodigo(), dados.getIntCodigo(), exameMaterial.getString(), dados.getMcoCodigo())) {
                int sitFilho;
                List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(dados.getFilCodigo(), dados.getIntCodigo(), exameMaterial.getString(), dados.getMcoCodigo()));
                if (!(n != 0 && n != 1 || curva)) {
                    examesParaEnviar.addAll(examesFilhos);
                    continue;
                }
                if (curva) {
                    for (ExameMaterial exameFilho : examesFilhos) {
                        sitFilho = BDUtil.getDesmSituacao(dados.getFilCodigo(), dados.getIntCodigo(), dados.getReqCodigo(), exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), dados.getRecTuboPai(), exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                        String tuboFilho = BDUtil.getExameDesmembradoTubo(dados.getFilCodigo(), dados.getReqCodigo(), dados.getRecTuboPai(), dados.getIntCodigo(), exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                        if (sitFilho != 0 && sitFilho != 1 && sitFilho != 3 || !Funcoes.preencheZero(tuboFilho, ParametrosGerais.getDigitosTuboTubo()).equals(dados.getRecCodigo())) continue;
                        examesFilho.append(exameFilho.getNomeExame()).append(" ");
                        examesParaEnviar.add(exameFilho);
                    }
                    continue;
                }
                for (ExameMaterial exameFilho : examesFilhos) {
                    sitFilho = BDUtil.getDesmSituacao(dados.getFilCodigo(), dados.getIntCodigo(), dados.getReqCodigo(), exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), dados.getRecCodigo(), exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                    if (sitFilho != 3) continue;
                    examesParaEnviar.add(exameFilho);
                }
                continue;
            }
            if (n != 0 && n != 1 && n != 3) continue;
            examesParaEnviar.add(exameMaterial);
        }
        HashSet<String> tests = new HashSet<String>();
        for (ExameMaterial exameMaterial : examesParaEnviar) {
            String test = BDUtil.getExmCodigoAlternativo(dados.getFilCodigo(), exameMaterial.getNomeExame(), dados.getMcoCodigo(), dados.getIntCodigo());
            if (test == null || test.trim().isEmpty()) continue;
            tests.add(test);
        }
        return tests;
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        this.confirmaRecebimentoResultado(oruR01);
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = oruR01.getObr().getPlacerOrderNumber();
            if (Funcoes.textoVazio(tuboId) || tuboId.length() != digitosCodigoTubo) {
                tuboId = oruR01.getSac().getId().trim().replace("^", "");
            }
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(tuboId);
                if (etiqueta != null) {
                    filCodigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                    reqCodigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                    recCodigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                }
                for (MessageSegmentObx obx : oruR01.getObxList()) {
                    String intCodigo;
                    ExameMaterial exame;
                    String emiAlternativo = String.valueOf(obx.getObservationId());
                    if (!Funcoes.textoVazio(emiAlternativo)) {
                        int index = emiAlternativo.indexOf("^");
                        emiAlternativo = emiAlternativo.substring(0, index);
                    }
                    if ((exame = this.getReqExameLIS(filCodigo, intCodigo = this.getIntCodigo(filCodigo, reqCodigo, recCodigo, emiAlternativo), reqCodigo, recCodigo, emiAlternativo)) != null) {
                        HashMap<String, Object> dados = new HashMap<String, Object>();
                        ArrayList<String> flags = new ArrayList<String>();
                        if (obx.getAbnormalFlag() != null) {
                            flags.add(obx.getAbnormalFlag().toString());
                        }
                        int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                        String campo = "resultado_quantitativo";
                        String resultado = "";
                        campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                        resultado = obx.getObservationValue().replace("^", "");
                        resultado = this.arrendondaValor(resultado, filCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, reqCodigo);
                        resultado = resultado.replace('.', ',');
                        dados.put(campo, resultado);
                        this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados, flags);
                        continue;
                    }
                    this.fireExcecaoEncontrada("Exame " + emiAlternativo + " n\u00e3o localizado para requisi\u00e7\u00e3o: " + reqCodigo);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    private void confirmaRecebimentoResultado(MessageOruR01 oruR01) {
        try {
            StringBuilder buf = new StringBuilder();
            buf.append('\u000b');
            buf.append("MSH|^~\\&|^Jalis^||^Labmax450i^||").append(Funcoes.formataData("yyyyMMdd", new Date())).append("||ACK^R23^ACK|").append(Funcoes.formataData("yyyyMMdd", Funcoes.getDataServidor())).append("||2.5||||||ASCII|||");
            buf.append('\r');
            buf.append("MSA|AA||||").append('\r');
            buf.append('\u001c');
            buf.append('\r');
            ((PortaSocketServer)this.getPortaCOM()).write(buf.toString());
        }
        catch (IOException e) {
            this.fireExcecaoEncontrada("Falha ao enviar a confirma\u00e7\u00e3o de recebimento do resultado.");
        }
    }

    @Override
    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setReceivingApplication(this.receivingApplication);
            mensagem.getMsh().setReceivingFacility(this.modelo);
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.3.1");
            mensagem.getMsh().setCharacterSet("ASCII");
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            ((PortaSocketServer)this.getPortaCOM()).write(this.messageParser.messageToTextLabmax450i(mensagem, this.fieldSeparator));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    private boolean possuiExames(Set<String> tests) {
        return !tests.isEmpty();
    }

    private void confirmaRecebimentoMensagem(MessageQbp011 message, String dataNascimento, String nome, String sexo) {
        try {
            String tuboId = message.getQpd().getValue();
            tuboId = tuboId.replace("^", "");
            StringBuilder buft = new StringBuilder();
            buft.append('\u000b');
            buft.append("MSH|^~\\&|^Jalis||^Labmax450i||");
            buft.append(Funcoes.formataData("yyyyMMdd", Funcoes.getDataServidor()));
            buft.append("||ADT^A08^ADT_A01|");
            buft.append(Funcoes.formataData("yyyyMMdd", Funcoes.getDataServidor())).append("||2.5");
            buft.append("||||||UNICODE UTF-8|||").append('\r');
            buft.append("EVN||").append(Funcoes.formataData("yyyyMMddhhmmss", Funcoes.getDataHoraServidor())).append("||||").append('\r');
            buft.append(this.montaPID(tuboId, dataNascimento, nome, sexo));
            buft.append('\u001c').append('\r');
            ((PortaSocketServer)this.getPortaCOM()).write(buft.toString());
        }
        catch (IOException e) {
            this.fireExcecaoEncontrada("Falha ao enviar a confirma\u00e7\u00e3o para interface;");
        }
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT", "ENK"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            try {
                ((PortaSocketServer)this.getPortaCOM()).write(String.valueOf('\u0005'));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (op == 2) {
            this.resultado();
        } else if (op == 3) {
            try {
                ((PortaSocketServer)this.getPortaCOM()).write(String.valueOf('\u0005'));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (op == 4) {
            try {
                ((PortaSocketServer)this.getPortaCOM()).write(String.valueOf('\u0005'));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void resultado() {
        StringBuilder buf = new StringBuilder();
        buf.append('\u000b').append("MSH|^~\\&|^Labmax450i^||^Jalis^||20210614^||OUL^R23^OUL_R23|20210614165347407||2.5^&&&&&&&&^&&&&&&&&||||||ASCII|||").append('\r');
        buf.append("PID|||^^^&&^^&&^^^&&&&&&&&^&&&&&&&&||&&&&^^^^^^^^&&&&&&&&^^^&^&^||^||||||||||||||||||||||||||||||||").append('\r');
        buf.append("SPM||||SER^^^^^^^^|||||||||||||||||||||||||").append('\r');
        buf.append("SAC|||010007627810^^^||||||||1^1^^|||||||||||||||||||||||||||||||||").append('\r');
        buf.append("OBR|||||||||||||||||||||||||||||||||||||||||||||||||").append('\r');
        buf.append("OBX|1|CWE|26^COL76^^^^^^^|1|281^^^^^^^^|mg/dL^^^^^^^^|||||F||^1|20210614165347^|||||").append('\r');
        buf.append("OBX|2|CWE|79^K^^^^^^^|1|4.3^^^^^^^^|mEq/L^^^^^^^^|||||F||^1|20180130092122^|||||").append('\r');
        buf.append("OBX|3|CWE|80^Cl^^^^^^^|1|101^^^^^^^^|mEq/L^^^^^^^^|||||F||^1|20180130092122^|||||").append('\r');
        buf.append('\u001c').append('\r');
        this.parse(this.equipamento.arruma(buf.toString()));
    }

    private void query() {
        String requisicao = JOptionPane.showInputDialog("Informe o c\u00f3digo ");
        StringBuilder tmp = new StringBuilder();
        tmp.append('\u000b').append("MSH|^~\\&|^Labmax450i^||^Jalis^||20180130^||QBP^WOS^QBP_Q11|20180130091821815||2.5^&&&&&&&&^&&&&&&&&||||||ASCII|||").append('\r');
        tmp.append("QPD|^^^^^^^^||^^^&&^^&&^^^&&&&&&&&^&&&&&&&&|").append(requisicao).append("^^^|1^1^^").append('\r');
        tmp.append("RCP|||||||").append('\r');
        tmp.append('\u001c').append('\r');
        this.parse(tmp.toString());
    }
}

