/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.labmax400;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.labmax400.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.labmax400.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.CodString;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends InterfaceASTMListener {
    private boolean recebendoDados = false;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;
    private boolean enviando = false;
    private boolean recebeuEOT = false;
    InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.MAX_PATIENT_NAME_CHARS = 36;
        this.HOST_NAME = "HOST";
        this.INSTRUMENT_NAME = "Analyzer";
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            String sampleId = starting_range.trim();
            this.hostQuery = true;
            if (Funcoes.textoVazio(sampleId)) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                return;
            }
            if (sampleId.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                return;
            }
            this.host_fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            sampleId = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
            if (this.recebeuEOT) {
                this.recebeuEOT = false;
                this.responseHostQuery();
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Labmax 400: Host Query Response");
        }
    }

    public void responseHostQuery() {
        try {
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "A";
            if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(rec_codigo)) {
                return;
            }
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames) && req != null && aba != null) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            ArrayList<String> examesRepetir = new ArrayList<String>();
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2, this.configuracao.getPesquisarRepeticaoAbaProntos())) != null) {
                aba = this.equipamento.getTab(2);
                if (Funcoes.textoVazio(pac_exames)) {
                    pac_exames = "";
                }
                if (req != null) {
                    List<Object[]> reqs = null;
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        String exame = "";
                        if (!this.configuracao.getPesquisarRepeticaoAbaProntos()) continue;
                        String situacao = (String)r[aba.getColIndice("Sit")];
                        boolean isRepetir = Integer.parseInt(situacao) == 3 || Integer.parseInt(situacao) == 5;
                        exame = (String)r[aba.getColIndice("Exame")] + " ";
                        int_codigo = (String)r[aba.getColIndice("Interface")];
                        mco_codigo = (String)r[aba.getColIndice("C\u00f3d. Mat.")];
                        rec_codigo = (String)r[aba.getColIndice("Tubo")];
                        if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exame.trim(), mco_codigo)) {
                            Statement st = Conexao.getStatement();
                            ExameMaterial[] desm = new ExameMaterial[]{new ExameMaterial(exame.trim(), Integer.parseInt(mco_codigo))};
                            for (ExameMaterial exameMaterial : desm = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, desm)) {
                                int sit = BDUtil.getExmSituacaoFilho(fil_codigo, int_codigo, req_codigo, exameMaterial.getNomeExame(), mco_codigo, rec_codigo);
                                boolean bl = isRepetir = sit == 3 || sit == 5;
                                if (!isRepetir) continue;
                                if (!examesRepetir.contains(exameMaterial.getNomeExame())) {
                                    examesRepetir.add(exameMaterial.getNomeExame());
                                }
                                exame = "";
                            }
                        } else if (isRepetir && !examesRepetir.contains(exame.trim())) {
                            examesRepetir.add(exame.trim());
                        }
                        if (isRepetir) continue;
                    }
                    pac_exames = StringUtil.implode(examesRepetir, " ");
                }
            }
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
            } else {
                this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
                this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
                this.tx_list = this.makeFrames(this.tx_list);
                this.tx_list.resetUltimoLido();
                this.setTX(this.TIME_TX);
                this.tx_counter = 0;
                this.getPortaCOM().write(String.valueOf('\u0005'));
                this.enviando = true;
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Labmax 400: Host Query Response");
        }
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.enviando = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            Object exameCurva;
            this.tx_list.clear();
            this.rx_list.clear();
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            if (!this.hostQuery && acao.equalsIgnoreCase("A") && this.configuracao.getPesquisarRepeticaoAbaProntos()) {
                this.marcarExamesParaRepetir();
                return "";
            }
            ExameMaterial[] alternativos = null;
            ExameMaterial[] listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String exame = exa_lista[0].toString();
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            String tipo_amostra = "";
            if (exa_lista != null) {
                tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, (exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista))[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exame, mco_codigo, int_codigo);
                }
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.removeDuplicados(alternativos);
            }
            if (!exa_listaCurva.isEmpty()) {
                exameCurva = new ArrayList();
                for (ExameMaterial exameMaterial : exa_listaCurva) {
                    exameCurva.add(exameMaterial.getNomeExame());
                }
                ArrayList<String> requisicoes = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
                for (String req : requisicoes) {
                    if (Funcoes.textoVazio(this.rec_tuboPai)) {
                        this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req, rec_codigo, int_codigo, (String)exameCurva.get(0), mco_codigo);
                    }
                    if (Funcoes.textoVazio(tipo_amostra)) {
                        tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((ExameMaterial)exa_listaCurva.get(0)).getString(), ((ExameMaterial)exa_listaCurva.get(0)).getCodigo().toString(), int_codigo);
                    }
                    listaCurva = ExamesUtil.anexarCodigoMaterial(exameCurva.toArray(new String[exameCurva.size()]), mco_codigo);
                    listaCurva = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
                    alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req, mco_codigo, String.valueOf(Integer.parseInt(rec_codigo)), st, exa_listaCurva, this.rec_tuboPai, true, this.examesFilho);
                    if (null == alternativosCurva || alternativosCurva.isEmpty()) continue;
                    break;
                }
            }
            if (Funcoes.textoVazio(tipo_amostra)) {
                if (exa_lista != null) {
                    Object ex;
                    void var28_36;
                    exameCurva = exa_lista;
                    int requisicoes = ((ExameMaterial[])exameCurva).length;
                    boolean bl = false;
                    while (var28_36 < requisicoes && Funcoes.textoVazio(tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((CodString)(ex = exameCurva[var28_36])).getString(), ((CodString)ex).getCodigo().toString(), int_codigo))) {
                        ++var28_36;
                    }
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    for (String exFilho : this.examesFilho) {
                        tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exFilho, mco_codigo, int_codigo);
                    }
                }
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            Date dataNasc = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String string = null;
            String t = this.getPatientRecord(1, patient_id.toString(), string, short_name, pac_sexo, dataNasc);
            this.tx_list.add(t);
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                t = this.getOrderRecord(++seq, codigo.toString(), alternativos, acao, tipo_amostra);
                this.tx_list.add(t);
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    t = this.getOrderRecord(++seq, sample_id.append(tubo).toString(), alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()]), acao, tipo_amostra);
                    this.tx_list.add(t);
                }
            }
            t = ASTMStandard.getDefaultTerminationRecord("N");
            this.tx_list.add(t);
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.enviando = true;
            return "Enviando requisi??o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private void marcarExamesParaRepetir() throws SQLException {
        Statement st = Conexao.getStatement();
        if (this.exames != null && !Funcoes.textoVazio(this.mco_codigo)) {
            for (int i = 0; i < this.exames.length; ++i) {
                int situacao;
                if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                    for (String exame : this.examesFilho) {
                        int situacao2 = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                        BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                    }
                    situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                    if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                    this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                    continue;
                }
                if (!this.examesFilho.isEmpty()) {
                    situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                    this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                    BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                    continue;
                }
                situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
            this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
        } else {
            this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
        }
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String laboratory_pid, String pac_nome, String pac_sexo, Date dataNasc) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|");
        record.append(laboratory_pid == null ? "" : laboratory_pid);
        record.append("||");
        record.append(pac_nome);
        record.append("||");
        record.append(dataNasc == null ? "" : Funcoes.formataData("yyyyMMdd", dataNasc));
        record.append("|");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append("|");
        record.append('\r');
        return record.toString();
    }

    private String getOrderRecord(int order_sequence, String sample_id, ExameMaterial[] test_item_numbers, String action_code, String sample_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence).append("|");
        record.append(sample_id == null ? "" : sample_id).append("|");
        record.append("|");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            record.append("^^^");
            record.append(test_item_numbers[0].getNomeExame());
            for (int i = 1; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                record.append("\\^^^");
                record.append(test_item_numbers[i].getNomeExame());
            }
        }
        record.append(StringUtil.repeteCaractere('|', 7));
        record.append(action_code == null ? "" : action_code);
        record.append(StringUtil.repeteCaractere('|', 4));
        record.append(sample_type == null ? "" : sample_type);
        record.append("|");
        record.append(sample_type == null ? "" : sample_type);
        record.append(StringUtil.repeteCaractere('|', 14));
        record.append('\r');
        return record.toString();
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        this.recebeuEOT = true;
        if (this.hostQuery || !Funcoes.textoVazio(this.host_fil_codigo) && !Funcoes.textoVazio(this.host_req_codigo) && !Funcoes.textoVazio(this.host_rec_codigo)) {
            this.responseHostQuery();
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        super.encerrarTransmissao();
        if (this.enviando) {
            this.enviando = false;
            this.hostQuery = false;
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                this.getPortaCOM().write(String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void teste() {
        String reqs1 = "0101198904";
        this.query(reqs1);
    }

    private void resultado(String reqs1) {
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||Analyzer|||||||||20160407092254[CR][ETX]C5[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2P|1|0100019827|||LABMAX^400^TESTE||20010808|M|||||||0||||||||||^^^|[CR][ETX]0B[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3C|1|I||G[CR][ETX]37[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4O|1|" + reqs1 + "||^^^59|||20160407000000||0|||||||02[CR][ETX]A7[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5C|1|I||G[CR][ETX]39[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|1|^^^59|107|U/L||N||||||20160407092253[SP][SP][SP][SP][SP][SP][CR][ETX]5A[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4O|1|" + reqs1 + "||^^^02|||20160407000000||0|||||||02[CR][ETX]A7[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5C|1|I||G[CR][ETX]39[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|1|^^^02|257|U/L||N||||||20160407092253[SP][SP][SP][SP][SP][SP][CR][ETX]5A[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4O|1|" + reqs1 + "||^^^10|||20160407000000||0|||||||02[CR][ETX]A7[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5C|1|I||G[CR][ETX]39[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|1|^^^10|357|U/L||N||||||20160407092253[SP][SP][SP][SP][SP][SP][CR][ETX]5A[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4O|1|" + reqs1 + "||^^^61|||20160407000000||0|||||||02[CR][ETX]A7[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5C|1|I||G[CR][ETX]39[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|1|^^^61|457|U/L||N||||||20160407092253[SP][SP][SP][SP][SP][SP][CR][ETX]5A[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4O|1|" + reqs1 + "||^^^57|||20160407000000||0|||||||02[CR][ETX]A7[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5C|1|I||G[CR][ETX]39[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|1|^^^57|557|U/L||N||||||20160407092253[SP][SP][SP][SP][SP][SP][CR][ETX]5A[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4O|1|" + reqs1 + "||^^^64|||20160407000000||0|||||||02[CR][ETX]A7[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5C|1|I||G[CR][ETX]39[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|1|^^^64|6.4|U/L||N||||||20160407092253[SP][SP][SP][SP][SP][SP][CR][ETX]5A[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4O|1|" + reqs1 + "||^^^65|||20160407000000||0|||||||02[CR][ETX]A7[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5C|1|I||G[CR][ETX]39[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|1|^^^65|6.5|U/L||N||||||20160407092253[SP][SP][SP][SP][SP][SP][CR][ETX]5A[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4O|1|" + reqs1 + "||^^^05|||20160407000000||0|||||||02[CR][ETX]A7[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5C|1|I||G[CR][ETX]39[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|1|^^^05|5.0|U/L||N||||||20160407092253[SP][SP][SP][SP][SP][SP][CR][ETX]5A[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7L|1[CR][ETX]40[LINE]"));
    }

    protected void query(String reqs1) {
        int i;
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||BiOLiS[SP]NEO^SYSTEM1|||||HOST^P_1||P|1|20151127154951[CR][ETX]F6[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2Q|1|" + reqs1 + "||ALL||||||||O[CR][ETX]16[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR][ETX]06[LINE]"));
        this.handShakeCharReceived('\u0004');
        for (i = 0; i < 10; ++i) {
            this.handShakeCharReceived('\u0006');
        }
        this.handShakeCharReceived('\u0006');
        for (i = 0; i < 10; ++i) {
            this.handShakeCharReceived('\u0006');
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        public boolean listaDeExamesProcessando() {
            return this.listaRecebimento.size() > 0;
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
                if (!InterfaceListener.this.equipamento.getStatusFecharInterfaceamento().isExportando()) {
                    InterfaceListener.this.fireAtualizarTabela(2);
                }
            }
            catch (InterruptedException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
    }
}

