/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.labmax240premium.astm;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.TimeOutException;
import jalis.laboratorio.interfaceamento.comunicacao.TimedHandshaker;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.labmax240premium.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class InterfaceASTMListener
extends AbstractInterfaceamentoListener {
    protected int MAX_PATIENT_NAME_CHARS = 20;
    protected int TIME_RX_ABORTADO = 3000;
    protected int TIME_TX_ABORTADO = 5000;
    protected int TIME_TX = 15000;
    protected int TIME_RX = 15000;
    protected int TIME_ENQUIRY = 30000;
    protected int TIME_ENQ_ABORTADO = 20000;
    protected int TIME_TO_REFRESH = 2000;
    protected String DELIMITERS = "\\^&";
    protected String HOST_NAME = "JALIS";
    protected String HOST_SYSTEM_VERSION = "1.0";
    protected String INSTRUMENT_NAME = null;
    protected String INSTRUMENT_SYSTEM_VERSION = null;
    protected String PASSWORD = null;
    protected int MAX_TENTATIVAS = 6;
    protected int MAX_TENTATIVAS_RX = 6;
    public final String PRIORIDADE_STAT = "S";
    public final String PRIORIDADE_IN_A_HURRY = "A";
    public final String PRIORIDADE_ROUTINE = "R";
    public final String PRIORIDADE_CALL_BACK = "C";
    public final String PRIORIDADE_PRE_OPERATION = "P";
    public final String ACAO_PENDENTE = "P";
    public final String ACAO_RESERVA_COMPLETA = "L";
    public final String ACAO_EM_ANDAMENTO = "X";
    public final String ACAO_CONTROLE_QUALIDADE = "Q";
    public final String REPORT_TIPO_PEDIDO = "O";
    public final String REPORT_TIPO_CORRECAO = "C";
    public final String REPORT_TIPO_RESULTADO_PRELIMINAR = "P";
    public final String REPORT_TIPO_RESULTADO_FINAL = "F";
    public final String REPORT_TIPO_RESULTADO_IMENSURAVEL = "X";
    public final String REPORT_TIPO_PENDENTE = "I";
    public final String REPORT_TIPO_TESTE_SEM_PEDIDO = "Y";
    public final String REPORT_TIPO_PACIENTE_SEM_RECORD = "Z";
    public final String REPORT_TIPO_RESPOSTA = "Q";
    public final String REQUISICAO_CORRECAO_RESULTADO_ANTERIOR = "C";
    public final String REQUISICAO_RESULTADOS_PRELIMINARES = "P";
    public final String REQUISICAO_RESULTADOS_FINAIS = "F";
    public final String REQUISICAO_RESULTADO_IMENSURAVEL = "X";
    public final String REQUISICAO_PENDENTE = "I";
    public final String REQUISICAO_RESULTADOS_PARCIAIS = "S";
    public final String REQUISICAO_RESULTADO_NIVEL_MIC = "M";
    public final String REQUISICAO_RESULTADO_RETRANSMITIDO = "R";
    public final String REQUISICAO_ABORTAR_ULTIMA_REQUISICAO = "A";
    public final String REQUISICAO_NOVOS_E_EDITADOS = "N";
    public final String REQUISICAO_PEDIDOS_E_DEMOGRAFICOS = "O";
    public final String REQUISICAO_DEMOGRAFICOS_SOMENTE = "D";
    public final String TERMINO_NORMAL = "N";
    public final String TERMINO_TRANSMISSOR_ABORTOU = "T";
    public final String TERMINO_RECEPTOR_REQUISITOU_ABORTO = "R";
    public final String TERMINO_ERRO_DESCONHECIDO = "E";
    public final String TERMINO_ERRO_NO_ULTIMO_PEDIDO = "Q";
    public final String TERMINO_INFORMACAO_INDISPONIVEL = "I";
    public final String TERMINO_FIM_PROCESSAMENTO = "F";
    public final String RESULT_STATUS_CORRECAO = "C";
    public final String RESULT_STATUS_PRELIMINAR = "P";
    public final String RESULT_STATUS_FINAL = "F";
    public final String RESULT_STATUS_IMENSURAVEL = "X";
    public final String RESULT_STATUS_PENDENTE = "I";
    public final String RESULT_STATUS_PARCIAL = "S";
    public final String RESULT_STATUS_NIVEL_MIC = "M";
    public final String RESULT_STATUS_RETRANSMISSAO = "R";
    public final String RESULT_STATUS_NOVO = "N";
    public final String RESULT_STATUS_RESPOSTA_PEDIDO = "Q";
    public final String RESULT_STATUS_VALIDADO_PELO_OPERADOR = "V";
    public final Integer PATIENT_NAME_LAST = new Integer(1);
    public final Integer PATIENT_NAME_FIRST = new Integer(2);
    public final Integer PATIENT_NAME_MIDDLE = new Integer(3);
    public final Integer PATIENT_NAME_SUFFIX = new Integer(4);
    public final Integer PATIENT_NAME_TITLE = new Integer(5);
    public final Integer TEST_ID = new Integer(1);
    public final Integer TEST_NAME = new Integer(2);
    public final Integer TEST_TYPE = new Integer(3);
    public final Integer TEST_ITEM_NUMBER = new Integer(4);
    public final Integer TEST_ITEM_NAME = new Integer(5);
    public final Integer TEST_DILUTION = new Integer(6);
    public final Integer TEST_DILUTION_RATIO = new Integer(7);
    public final Integer TEST_REPLICATE_NUMBER = new Integer(8);
    public final Integer TEST_RESULT_ASPECTS = new Integer(9);
    public final Integer ORDER_SYS_SAMPLE_ID = new Integer(1);
    public final Integer ORDER_SYS_SAMPLE_RACK_POS = new Integer(3);
    public final Integer ORDER_SYS_SAMPLE_RACK_ID = new Integer(2);
    public final int CAMPO_NOME_PRIMEIRO_NOME = 0;
    public final int CAMPO_NOME_SOBRENOME = 1;
    public final int CAMPO_NOME_DO_MEIO = 2;
    public final int CAMPO_NOME_DEFAULT = 0;
    public final int CAMPO_PACIENTE_PATIENT_ID = 0;
    public final int CAMPO_PACIENTE_LABORATORY_PID = 1;
    public final int CAMPO_PACIENTE_SYSTEM_PID = 2;
    public final int CAMPO_PACIENTE_DEFAULT = 1;
    protected String[] exames;
    protected boolean curva = false;
    protected List<String> examesFilho = new LinkedList<String>();
    protected String rec_tuboPai = "";
    protected String ultima_acao = "N";
    protected String int_codigo = "";
    protected String fil_codigo;
    protected String req_codigo;
    protected String mco_codigo;
    protected String rec_codigo;
    protected String pac_nome;
    protected String pac_exames;
    protected String pac_sexo;
    protected String req_idade;
    protected String req_data;
    protected String req_hora;
    protected int tx_counter = 0;
    protected int rx_counter = 0;
    protected int frame_num = 0;
    boolean request_received = false;
    protected MemoryList<String> tx_list = new MemoryList();
    protected MemoryList<String> rx_list = new MemoryList();
    protected static String FIL_CODIGO = "fil_codigo";
    protected static String INT_CODIGO = "int_codigo";
    protected static String REQ_CODIGO = "req_codigo";
    protected static String REC_CODIGO = "rec_codigo";
    protected static String EXA_CODIGO = "exa_codigo";
    protected static String MCO_CODIGO = "mco_codigo";
    protected static String ACTION_CODE = "action_code";
    protected static String REPORT_TYPE = "report_type";
    protected boolean middleFrame = false;
    private List<String> msgResultado = new ArrayList<String>();

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            if (mapaParametros != null && !Funcoes.textoVazio(mapaParametros.get("codigoApoiado"))) {
                codigo.setLength(0);
                codigo.append(mapaParametros.get("codigoApoiado"));
            }
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            String nome = short_name;
            String sobrenome = null;
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = req_codigo;
            String laboratory_pid = null;
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(ASTMStandard.getDefaultOrderRecord(1, codigo.toString(), alternativos, exa_lista, null, "R", acao, tipo_amostra, "O"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public abstract String getErroTraduzido(String var1);

    public void responderRequest(String starting_range, String ending_range, String test_id) {
    }

    public Map<Integer, String> parsePatientNameField(String name_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(name_field), 4, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.PATIENT_NAME_LAST, tokens[0]);
            components.put(this.PATIENT_NAME_FIRST, tokens[1]);
            components.put(this.PATIENT_NAME_MIDDLE, tokens[2]);
            components.put(this.PATIENT_NAME_SUFFIX, tokens[3]);
            components.put(this.PATIENT_NAME_TITLE, tokens[4]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse de Patient Name Field (Patient Frame)");
            return null;
        }
    }

    public Map<Integer, String> parseOrderSystemSID(String instrumentSID_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(instrumentSID_field), 2, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.ORDER_SYS_SAMPLE_ID, tokens[0]);
            components.put(this.ORDER_SYS_SAMPLE_RACK_ID, tokens[1]);
            components.put(this.ORDER_SYS_SAMPLE_RACK_POS, tokens[2]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse de Instrument Specimen ID (Order Frame)");
            return null;
        }
    }

    public Map<Integer, String> parseOrderTestIDField(String test_id_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(test_id_field), 5, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.TEST_ID, tokens[0]);
            components.put(this.TEST_NAME, tokens[1]);
            components.put(this.TEST_TYPE, tokens[2]);
            components.put(this.TEST_ITEM_NUMBER, tokens[3]);
            components.put(this.TEST_ITEM_NAME, tokens[4]);
            components.put(this.TEST_DILUTION, tokens[5]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse de Test ID Field (Order Frame)");
            return null;
        }
    }

    public Map<Integer, String> parseResultTestIDField(String test_id_field) {
        try {
            StringBuilder temp = StringUtil.preencheStringOcorrencias(new StringBuilder(test_id_field), 5, '^', 0);
            HashMap<Integer, String> components = new HashMap<Integer, String>();
            String[] tokens = temp.toString().split("\\^", -1);
            components.put(this.TEST_ID, tokens[0]);
            components.put(this.TEST_NAME, tokens[1]);
            components.put(this.TEST_TYPE, tokens[2]);
            components.put(this.TEST_ITEM_NUMBER, tokens[3]);
            components.put(this.TEST_ITEM_NAME, tokens[4]);
            components.put(this.TEST_DILUTION, tokens[5]);
            return components;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse de Test ID Field (Result Frame)");
            return null;
        }
    }

    public String getMiddleFrameEnd() {
        return String.valueOf('\u0017');
    }

    public String getFinalFrameEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String getMsgEnd() {
        return LINE;
    }

    protected int nextFrameNum() {
        return ++this.frame_num % 8;
    }

    public MemoryList<String> makeFrames(MemoryList<String> raw_list) throws Exception {
        try {
            MemoryList<String> new_list = new MemoryList<String>();
            this.frame_num = 0;
            if (raw_list != null) {
                while (!raw_list.isEmpty() && raw_list.size() > 0) {
                    String[] slices = StringUtil.dividir(raw_list.remove(0), 240);
                    for (int j = 0; j < slices.length; ++j) {
                        StringBuilder temp = new StringBuilder(String.valueOf(this.nextFrameNum()));
                        temp.append(slices[j]);
                        temp.append(j < slices.length - 1 ? String.valueOf('\u0017') : String.valueOf('\u0003'));
                        temp.append(Checksum.getChecksumMod256(temp.toString()));
                        temp = new StringBuilder(this.getMsgStart()).append((CharSequence)temp);
                        temp.append(this.getMsgEnd());
                        new_list.add(temp.toString());
                    }
                }
                return new_list;
            }
            return null;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Erro ao recuperar lista de frames (size:" + raw_list.size() + ")");
            return null;
        }
    }

    public boolean checkCRC(String message, String checksum) {
        return true;
    }

    protected void limpaDadosRequisicao() {
        this.rx_list.clear();
        this.tx_list.clear();
        this.fil_codigo = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
        this.request_received = false;
    }

    protected void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(this.TIME_RX_ABORTADO);
        this.fireMensagemEnviada("Tempo esgotado ao receber dados do equipamento", 1, 10000);
    }

    protected void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(this.TIME_TX_ABORTADO);
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    protected void encerrarTransmissao() throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            Statement st = Conexao.getStatement();
            if (this.exames != null && !Funcoes.textoVazio(this.mco_codigo)) {
                for (int i = 0; i < this.exames.length; ++i) {
                    int situacao;
                    if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                        for (String exame : this.examesFilho) {
                            int situacao2 = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                            BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                        }
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    if (!this.examesFilho.isEmpty()) {
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                        BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                    this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
            } else {
                this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
            }
        }
        this.interromperTimer();
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.getPortaCOM().clearInputString();
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void fcTimedOut(EventObject e) {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
                return;
            }
            if (this.isRX()) {
                if (this.rx_list.isEmpty()) {
                    this.setIdle();
                    return;
                } else {
                    this.abortarRecepcao();
                }
                return;
            }
            if (!this.isIdle()) return;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: timeout no controle de fluxo");
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    protected void tratarNegativeAck() throws Exception {
        if (this.isTX()) {
            this.verificarNegacao();
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    protected void retransmitirRecusado() throws Exception {
        if (this.tx_counter >= this.MAX_TENTATIVAS) {
            this.encerrarTransmissao();
            return;
        }
        int next = this.tx_list.getUltimoLido();
        if (next < this.tx_list.size()) {
            this.setTX(this.TIME_TX);
            this.getPortaCOM().write(this.tx_list.get(next));
        }
        ++this.tx_counter;
    }

    protected void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            if (!this.tx_list.isEmpty() && this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
            } else {
                this.enviarProximoFrame();
            }
        } else if (!this.isRX()) {
            this.caracterNaoEsperado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    protected void tratarEnquiry() throws Exception {
        if (this.isTX()) {
            this.abortarParaReceber();
        } else if (!this.isRX()) {
            this.prepararParaReceber();
        } else {
            this.prepararParaReceber();
        }
    }

    protected void prepararParaReceber() throws Exception {
        this.rx_list.clear();
        this.getPortaCOM().clearInputString();
        this.setRX(this.TIME_ENQUIRY);
        this.fireMensagemEnviada("Aguardando envio de dados pelo equipamento", 0, 10000);
        this.getPortaCOM().write(String.valueOf('\u0006'));
    }

    protected void tratarEndOfTX() throws Exception {
        if (this.isTX()) {
            if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                this.encerrarTransmissao();
            } else {
                this.enviarProximoFrame();
            }
        } else {
            this.encerrarRecepcao();
        }
    }

    protected void encerrarRecepcao() {
        this.limpaDadosRequisicao();
        this.getPortaCOM().clearInputString();
        this.setIdle();
    }

    protected void enviarProximoFrame() throws Exception {
        int next;
        this.rx_list.clear();
        int n = next = this.tx_list.getUltimoLido() < 0 ? 0 : this.tx_list.getUltimoLido() + 1;
        if (this.tx_list.size() > 0) {
            String frame = this.tx_list.get(next);
            this.setTX(this.TIME_TX);
            ++this.tx_counter;
            this.getPortaCOM().write(frame);
        } else {
            this.encerrarTransmissao();
        }
    }

    protected void verificarNegacao() throws Exception {
        if (this.isTX()) {
            if (this.tx_list.getUltimoLido() >= 0) {
                this.retransmitirRecusado();
            } else {
                this.abortarTransmissao();
            }
        } else if (this.isRX()) {
            this.caracterNaoEsperado();
        }
    }

    protected void abortarParaReceber() throws Exception {
        this.setRX(this.TIME_ENQ_ABORTADO);
        this.fireMensagemEnviada("Abortando transmiss\u00e3o de dados ao equipamento.", 1, 5000);
    }

    protected void caracterNaoEsperado() throws Exception {
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    if (this.isTX() || this.tx_list.size() > 0 && this.rx_counter < this.MAX_TENTATIVAS_RX) {
                        this.getPortaCOM().write(String.valueOf('\u0015'));
                        ++this.rx_counter;
                        break;
                    }
                    this.rx_counter = 0;
                    this.tratarEnquiry();
                    break;
                }
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    this.tratarEndOfTX();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de caracter de handshake recebido");
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            if (this.tx_list.size() > 0) {
                this.limpaDadosRequisicao();
            }
            this.setIdle();
        }
    }

    protected void aguardarProximoFrame() throws Exception {
        this.setRX(this.TIME_RX);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    public void sendRequestAllResultsRecord() throws Exception {
        TimedHandshaker h = new TimedHandshaker();
        this.getClass();
        String record = ASTMStandard.getDefaultEnquiryRecord("ALL", null, "ALL", null, null, "F");
        this.setTX(this.TIME_TX);
        try {
            char c = h.sendAndWaitResponse(String.valueOf('\u0005'), this.TIME_TX);
            if (c != '\u0006') {
                this.interromperTimer();
                this.fireMensagemEnviada("Requisi\u00e7\u00e3o de resultados negada pelo equipamento", 1, 5000);
                return;
            }
            c = h.sendAndWaitResponse(record, this.TIME_TX);
            if (c != '\u0006') {
                this.interromperTimer();
                this.fireMensagemEnviada("Requisi\u00e7\u00e3o de resultados negada pelo equipamento", 1, 5000);
                return;
            }
            this.getPortaCOM().write(String.valueOf('\u0004'));
        }
        catch (TimeOutException ex) {
            this.fireMensagemEnviada("Tempo esgotado ao requisitar resultados ao equipamento", 1, 5000);
        }
        this.interromperTimer();
        this.setIdle();
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(1, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size() && !this.rx_list.isEmpty()) {
                    message = this.rx_list.getUltimoInserido() > -1 ? this.rx_list.get(this.rx_list.getUltimoInserido()) + message : message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                this.rx_list.add(message);
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                boolean query = false;
                while (!this.rx_list.isEmpty()) {
                    String s = this.rx_list.remove(0);
                    String record = s.substring(1, s.length() - 1);
                    String record_type = ASTMStandard.getRecordTypeIdentifier(record);
                    if (record_type == null) continue;
                    if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                        this.msgResultado.add(s);
                        ArrayList<String> resultado = new ArrayList<String>(this.msgResultado);
                        this.parseRes(resultado);
                        this.msgResultado.clear();
                        continue;
                    }
                    this.msgResultado.add(s);
                }
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    private synchronized void parseRes(List<String> resultado) throws Exception {
        RecordParser recordParser = new RecordParser();
        recordParser.setInterfaceASTMListener(this);
        Map<String, Object> exameAtual = new HashMap<String, Object>();
        exameAtual = new HashMap();
        boolean isOrdem = false;
        for (String s : resultado) {
            if (!s.contains("O|")) continue;
            isOrdem = true;
        }
        if (!isOrdem) {
            String log = StringUtil.implode(resultado, "\n");
            StringUtil.escreverArquivoTexto(System.getProperty("user.home") + System.getProperty("file.separator") + "logErroComunicacaoJalis_" + Funcoes.formataData("dd_MM_yyyy_HH_mm_ss_SSS", new Date()) + ".txt", log);
            this.fireExcecaoEncontrada("Nenhuma identifica\u00e7\u00e3o da amostra foi encontrado na comunica\u00e7\u00e3o do aparelho.");
            return;
        }
        for (String s : resultado) {
            exameAtual = recordParser.recordFound(s, exameAtual);
        }
        Conexao.arquivaSQL();
        RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
    }

    public synchronized void parseQuery(List<String> resultado) throws Exception {
        for (int i = 0; i < resultado.size(); ++i) {
            String message = resultado.get(i);
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index < 0 || message.length() <= 5) continue;
            if (stx_index > 0) {
                message = message.substring(stx_index);
            }
            message = message.substring(1, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            resultado.set(i, message);
        }
        RecordParser recordParser = new RecordParser();
        recordParser.setInterfaceASTMListener(this);
        Map<String, Object> exameAtual = new HashMap<String, Object>();
        exameAtual = new HashMap();
        for (String s : resultado) {
            exameAtual = recordParser.recordFound(s, exameAtual);
        }
        Conexao.arquivaSQL();
        RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                String retorno = this.parse(message);
                this.getPortaCOM().write(retorno.startsWith("Erro") ? String.valueOf('\u0015') : String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public String reenviarExames(String req_codigo, String rec_codigo, String pac_sexo, String pac_idade, String pac_nome, String hora, String data, String fil_codigo, String int_codigo, ArrayList<ExameMaterial> exames, String acao, String rackposition, String prioridade) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, exames.get(0).getCodigoMaterial(), rec_codigo, exames.get(0).getCodigo().toString(), acao);
    }
}

