/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.labmax240premium;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.labmax240premium.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    boolean exr_codigoapoiado = false;
    private Map<String, String> flagsResultado = new HashMap<String, String>();

    public RecordParser() {
        this.flagsResultado.put("L", "Lower than the lower limit.");
        this.flagsResultado.put("H", "Higher than the higher limit.");
        this.flagsResultado.put("PL", "Lower then the panic range.");
        this.flagsResultado.put("PH", "Higher then the panic range.");
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
    }

    @Override
    protected Map<String, Object> trataHeaderRecord(String record, Map<String, Object> exame_atual) {
        return exame_atual;
    }

    @Override
    protected Map<String, Object> trataTerminationRecord(Map<String, Object> exame_atual) throws Exception {
        if (exame_atual == null) {
            return exame_atual;
        }
        this.salvaExame(exame_atual);
        return exame_atual;
    }

    @Override
    protected Map<String, Object> trataOrderRecord(String record, Map<String, Object> exame_atual) throws Exception {
        if (exame_atual != null && exame_atual.get(INT_CODIGO) != null) {
            this.salvaExame(exame_atual);
        }
        exame_atual = new HashMap<String, Object>();
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
        if (req_codigo == null || req_codigo.equals("")) {
            req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
        }
        try {
            Long.parseLong(req_codigo);
        }
        catch (Exception ex) {
            StringBuilder msg = new StringBuilder();
            msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
            msg.append(req_codigo);
            this.equip.fireExcecaoEncontrada(msg.toString());
            exame_atual = null;
            return exame_atual;
        }
        int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        req_codigo = Funcoes.preencheZero(req_codigo, qtde);
        String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
        String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
        exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
        String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        exame_atual.put(FIL_CODIGO, fil_codigo);
        exame_atual.put(REC_CODIGO, rec_codigo);
        exame_atual.put(REQ_CODIGO, req_codigo);
        return exame_atual;
    }

    @Override
    protected Map<String, Object> trataResultRecord(String record, Map<String, Object> exame_atual) throws SQLException {
        int sit;
        String resultado;
        String mco_codigo;
        String exa_codigo;
        String int_codigo;
        Statement st;
        String req_codigo;
        String rec_codigo;
        String fil_codigo;
        Hashtable result_fields;
        block28: {
            block27: {
                String[] exames;
                if (exame_atual == null) {
                    return exame_atual;
                }
                String action_code = (String)exame_atual.get(ACTION_CODE);
                String report_type = (String)exame_atual.get(REPORT_TYPE);
                if (action_code != null) {
                    this.equip.getClass();
                    if (action_code.equals("Q")) {
                        return exame_atual;
                    }
                }
                if (report_type != null) {
                    this.equip.getClass();
                    if (report_type.equals("X")) {
                        return exame_atual;
                    }
                }
                result_fields = ASTMStandard.parseDefaultResultRecord(record);
                Map<Integer, String> components = this.equip.parseOrderTestIDField((String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID));
                String emi_alternativo = components.get(this.equip.TEST_ITEM_NUMBER) + "^" + components.get(this.equip.TEST_ITEM_NAME);
                if (exame_atual.get(FIL_CODIGO) == null || exame_atual.get(REC_CODIGO) == null || exame_atual.get(REQ_CODIGO) == null) {
                    this.equip.fireExcecaoEncontrada("Dados incompletos para exame com alternativo " + emi_alternativo + " (" + String.valueOf(exame_atual.size()) + ")");
                    return exame_atual;
                }
                fil_codigo = exame_atual.get(FIL_CODIGO).toString();
                rec_codigo = exame_atual.get(REC_CODIGO).toString();
                req_codigo = exame_atual.get(REQ_CODIGO).toString();
                st = Conexao.getStatement();
                int_codigo = this.localizarIntCodigo(emi_alternativo, fil_codigo, rec_codigo, req_codigo);
                DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(fil_codigo + req_codigo + rec_codigo);
                if (dce != null) {
                    String fil = Funcoes.preencheZero(dce.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                    String req = Funcoes.preencheZero(dce.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                    String rec = Funcoes.preencheZero(dce.getTubo(), ParametrosGerais.getDigitosTuboTubo());
                    if (!(fil.equalsIgnoreCase(fil_codigo) && req.equalsIgnoreCase(req_codigo) && rec.equalsIgnoreCase(rec_codigo))) {
                        fil_codigo = fil;
                        req_codigo = req;
                        rec_codigo = rec;
                        if (int_codigo == null) {
                            int_codigo = this.localizarIntCodigo(emi_alternativo, fil, rec, req);
                        }
                    }
                }
                if (int_codigo == null) {
                    this.equip.fireExcecaoEncontrada("C\u00f3digo do interfaceamento do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo + " n\u00e3o localizado.");
                    return exame_atual;
                }
                ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                exame_atual.put(INT_CODIGO, int_codigo);
                if (exame == null) {
                    this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    return exame_atual;
                }
                exame_atual.put(EXA_CODIGO, exame.getNomeExame());
                exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
                exa_codigo = exame.getNomeExame();
                mco_codigo = exame.getCodigoMaterial();
                if (this.exr_codigoapoiado && (exames = BDUtil.getCodigoJalis(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_codigo, mco_codigo)) != null && !Funcoes.textoVazio(exames[0])) {
                    fil_codigo = exames[0];
                    req_codigo = exames[1];
                    rec_codigo = exames[2];
                }
                if (this.equip.getPortaCOM() instanceof PortaCOM) {
                    String porta = ((PortaCOM)this.equip.getPortaCOM()).getPorta_atual();
                    exame_atual.put("enderecoPorta", porta);
                }
                String result_status = (String)result_fields.get(ASTMStandard.RESULT_FIELD_RESULT_STATUS);
                resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
                if (result_status != null) {
                    this.equip.getClass();
                    if (!result_status.equals("F")) {
                        this.equip.getClass();
                        if (!result_status.equals("R")) {
                            this.equip.getClass();
                            if (!result_status.equals("P")) {
                                this.equip.getClass();
                                if (!result_status.equals("X")) {
                                    this.equip.fireExcecaoEncontrada(String.format("Resultado anormal desconsiderado exame %s Resultado %s %s %s %s ", emi_alternativo, resultado, fil_codigo, req_codigo, rec_codigo));
                                    return exame_atual;
                                }
                            }
                        }
                    }
                }
                if (resultado.startsWith(".")) {
                    resultado = "0" + resultado;
                }
                if (resultado.charAt(resultado.length() - 1) == '.') {
                    resultado = resultado + "0";
                }
                resultado = this.equip.arrendondaValor(resultado, fil_codigo, exa_codigo, mco_codigo, int_codigo);
                this.equip.getClass();
                if (result_status.equals("F")) break block27;
                this.equip.getClass();
                if (!result_status.equals("P")) break block27;
                this.equip.getClass();
                if (result_status.equals("X")) break block28;
            }
            resultado = resultado.replaceAll("\\.", ",");
        }
        String campo = (sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo)) < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
        exame_atual.put(campo, resultado);
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !flags.equals("") && !flags.equals("N")) {
            exame_atual.put("flag_alerta", this.flagsResultado.get(flags));
        }
        if (exame_atual != null) {
            try {
                String filial = (String)exame_atual.get(FIL_CODIGO);
                String requisicao = (String)exame_atual.get(REQ_CODIGO);
                String tubo = (String)exame_atual.get(REC_CODIGO);
                this.salvaExame(exame_atual);
                exame_atual.put(FIL_CODIGO, filial);
                exame_atual.put(REQ_CODIGO, requisicao);
                exame_atual.put(REC_CODIGO, tubo);
                exame_atual.remove(campo);
            }
            catch (Exception e) {
                StringBuilder msg = new StringBuilder(e.getMessage());
                msg.append("\n").append("Erro ao receber resultado ");
                msg.append("\n").append(fil_codigo).append(" ").append(req_codigo).append(" ").append(rec_codigo);
                msg.append("\n").append(record);
                ErrorLogger.mostraMensagem(null, msg.toString(), e.getStackTrace());
            }
        }
        return exame_atual;
    }

    @Override
    protected synchronized void salvaExame(Map<String, Object> dados) throws Exception {
        String[] codigoJalis;
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        if (this.exr_codigoapoiado && !Funcoes.textoVazio((codigoJalis = BDUtil.getCodigoJalis(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_codigo, mco_codigo))[0]) && !Funcoes.textoVazio(codigoJalis[1]) && !Funcoes.textoVazio(codigoJalis[2])) {
            fil_codigo = codigoJalis[0];
            req_codigo = codigoJalis[1];
            rec_codigo = codigoJalis[2];
        }
        this.salvaExame(dados, fil_codigo, req_codigo, rec_codigo, int_codigo, exa_codigo, mco_codigo);
    }

    private synchronized void salvaExame(Map<String, Object> dados, String fil_codigo, String req_codigo, String rec_codigo, String int_codigo, String exa_codigo, String mco_codigo) throws Exception {
        Statement st = Conexao.getStatement();
        ArrayList<String> flag = new ArrayList<String>();
        if (!Funcoes.objectIsNull(dados.get("flag_alerta"))) {
            flag.add(dados.get("flag_alerta").toString());
        }
        this.equip.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados, flag);
    }

    private synchronized String localizarIntCodigo(String emi_alternativo, String fil_codigo, String rec_codigo, String req_codigo) throws SQLException {
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (int_codigo == null) {
            int_codigo = BDUtil.getInterfaceExameAlternativo(fil_codigo, req_codigo, rec_codigo, emi_alternativo, true);
        }
        return int_codigo;
    }

    @Override
    public synchronized Map<String, Object> recordFound(String record, Map<String, Object> exame_atual) throws Exception {
        return super.recordFound(record, exame_atual);
    }

    @Override
    protected Map<String, Object> trataCommentRecord(String record, Map<String, Object> exame_atual) {
        if (exame_atual == null) {
            return exame_atual;
        }
        Hashtable comment_fields = ASTMStandard.parseDefaultCommentRecord(record);
        String type = (String)comment_fields.get(ASTMStandard.COMMENT_FIELD_TYPE);
        String exception = (String)comment_fields.get(ASTMStandard.COMMENT_FIELD_TEXT);
        if (type != null && type.equals("I")) {
            String[] erros;
            for (String erro : erros = exception.split(",")) {
                String erro_traduzido = this.equip.getErroTraduzido(erro);
                if (erro_traduzido == null) continue;
                String exa_codigo = (String)exame_atual.get(EXA_CODIGO);
                String req_codigo = (String)exame_atual.get(REQ_CODIGO);
                String exame = exa_codigo != null ? " (" + exa_codigo + ") " : "";
                StringBuilder buf = new StringBuilder("");
                if (!Funcoes.textoVazio(req_codigo)) {
                    buf.append(req_codigo);
                }
                buf.append(exame).append(" - ");
                buf.append(erro_traduzido);
                this.equip.fireExcecaoEncontrada(buf.toString());
            }
        }
        return exame_atual;
    }
}

