/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.labmax240premium;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.labmax240premium.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.CodString;
import jalis.util.DBUtil;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends InterfaceASTMListener {
    private ThreadRecebimento threadRecebimento;
    private List<String> request = new ArrayList<String>();
    protected boolean hostQuery = false;
    private InterfaceamentoConfiguracao configuracao = new InterfaceamentoConfiguracao();
    private List<String> mensagens = new ArrayList<String>();
    private boolean query = false;
    private Map<String, String> flags = new HashMap<String, String>();
    boolean exr_codigoapoiado = false;

    public InterfaceListener() {
        this.MAX_PATIENT_NAME_CHARS = 100;
        this.threadRecebimento = new ThreadRecebimento(this, 150);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        Statement st = Conexao.getStatement();
        this.exr_codigoapoiado = DBUtil.campoExiste(st, "examerequisicao", "exr_codigoapoiado");
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.INSTRUMENT_NAME = "BIOLIS NEO^System1";
        this.HOST_NAME = "HOST";
        this.HOST_SYSTEM_VERSION = "P_1";
        if (c.getPortaCOM() instanceof PortaCOM) {
            ((PortaCOM)c.getPortaCOM()).setBuscaHandshakeMensagemInteira(true);
        }
        this.flags.put("1", "A shortage of R1 reagent");
        this.flags.put("2", "A shortage of R2 reagent");
        this.flags.put("0", "Shortage of R1 and R2");
        this.flags.put("A", "Shortage of sample, R1 and R2");
        this.flags.put("3", "Shortage of sample and R1");
        this.flags.put("4", "Shortage of sample and R2");
        this.flags.put("S", "A shortage of sample");
        this.flags.put("C", "The cell blank value is over 0.3700 Abs. or lower than 0.001 Abs. (The cuvette is unreliable.)");
        this.flags.put("P", "The value exceeded the upper limit/the lower limit by prozone check.");
        this.flags.put("E", "The value exceeded the end point limit in the end point assay.");
        this.flags.put("B", "All the points of the measurement range (main wavelength) or the absorbance of the first point is lower than the ABS limit Low.");
        this.flags.put("G", "All the points of the measurement range (main wavelength) or the absorbance of the first point is higher than the ABS limit High.");
        this.flags.put("T", "The temperature of the reaction tray under measurement exceeded \u00b11\u00b0C to the set temperature.");
        this.flags.put("t", "The measurement data under warming up.");
        this.flags.put("L", "The value exceeded the linearity limit in the rate assay.");
        this.flags.put("ISE Error", "5 digits error code. Refer to Appendix E (In case ISE module is assembled)");
        this.flags.put("ASTM", "Erro no envio do registros verifique ");
        this.flags.put("A1", "The measurement order registration error (system error)");
        this.flags.put("A2", "The designated sample for which measurement order entry was done is under measurement, or has been finished to measure.");
        this.flags.put("A3", "Sample position error. Measurement order entry of patient sample or control sample was performed to STAT sample position. Measurement order entry of patient sample or STAT sample was performed to control sample position");
        this.flags.put("A4", "No designated sample. Cancelation for un-registered measurement order in BiOLiS was done.");
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            String sampleId = starting_range.substring(1).trim();
            this.hostQuery = true;
            if (!Funcoes.textoVazio(sampleId)) {
                ArrayList<Object> amostras = new ArrayList<String>();
                if (sampleId.contains("\\")) {
                    amostras = StringUtil.explode(sampleId, "\\");
                } else {
                    amostras.add(sampleId);
                }
                for (String string : amostras) {
                    if (Funcoes.textoVazio(string)) {
                        this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                        continue;
                    }
                    if (string.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                        this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                        continue;
                    }
                    if (this.request.contains(string)) continue;
                    this.request.add(string);
                }
                if (!this.request.isEmpty()) {
                    this.hostQuery = true;
                } else {
                    this.fireExcecaoEncontrada(String.format("Pedido de amostra do aparelho sem nenhum Sample ID: %s", starting_range));
                }
            } else {
                this.fireExcecaoEncontrada("Pedido de amostra do aparelho sem nenhum Sample ID");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    public void responseHostQuery() {
        try {
            String sampleId;
            if (this.request.isEmpty()) {
                return;
            }
            String codigoEtiqueta = sampleId = this.request.remove(0);
            String fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            sampleId = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            String rec_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao());
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            StringBuilder pac_exames = new StringBuilder("");
            String acao = "N";
            DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(codigoEtiqueta);
            if (dce != null) {
                fil_codigo = Funcoes.preencheZero(dce.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                req_codigo = Funcoes.preencheZero(dce.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                rec_codigo = Funcoes.preencheZero(dce.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            }
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames.append((String)req[aba.getColIndice("Exame")]);
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames.toString()) && req != null && aba != null) {
                    pac_exames.append((String)req[aba.getColIndice("Exame")]).append(" ");
                }
                if (req != null) {
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                    }
                }
            }
            String situacao = null;
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    String tuboPai = Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboTubo());
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) >= 7) continue;
                        situacao = (String)r[aba.getColIndice("Sit")];
                        String exame = (String)r[aba.getColIndice("Exame")];
                        mco_codigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                        int_codigo = (String)req[aba.getColIndice("Interface")];
                        if (BDUtil.isGrupoInteiroRepetido(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai)) {
                            pac_exames.append(exame).append(" ");
                            acao = "A";
                            continue;
                        }
                        BDExame[] filhos = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai);
                        if (filhos == null) continue;
                        for (BDExame bdExame : filhos) {
                            if (!Funcoes.preencheZero(bdExame.getRecipienteFilho(), ParametrosGerais.getDigitosTuboTubo()).equals(rec_codigo) || bdExame.getSituacao() <= 2 || bdExame.getSituacao() >= 7) continue;
                            pac_exames.append(bdExame.getExame()).append(" ");
                            acao = "A";
                        }
                    }
                }
            }
            if (req != null && !Funcoes.textoVazio(pac_exames.toString())) {
                String req_codigoapoio = null;
                if (this.exr_codigoapoiado) {
                    if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                        if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
                            if (ParametrosGerais.isAgruparGuiasInterface()) {
                                requisicao = (String)req[aba.getColIndice("Multiguia")];
                            }
                            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
                            String tubo = (String)req[aba.getColIndice("Tubo")];
                            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
                            if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                                if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                                    req_codigoapoio = (String)req[aba.getColIndice("Cod. Apoiado")];
                                }
                            }
                            fil_codigo = filial;
                            req_codigo = requisicao;
                            rec_codigo = tubo;
                        }
                    }
                }
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                HashMap<String, String> map = new HashMap<String, String>();
                if (!Funcoes.textoVazio(req_codigoapoio)) {
                    map.put("codigoApoiado", req_codigoapoio);
                    map.put("codigoEtiqueta", codigoEtiqueta);
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao, map);
                } else {
                    map.put("codigoEtiqueta", codigoEtiqueta);
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao, map);
                }
            } else {
                this.fireExcecaoEncontrada(String.format("Nenhuma requisi\u00e7\u00e3o encontrada para a amostra %s %s %s", fil_codigo, req_codigo, rec_codigo));
                if (!this.request.isEmpty()) {
                    this.responseHostQuery();
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    public void limparWorklistEnvio() {
        this.request.clear();
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            this.tx_list.add(this.getPatientRecord(1, fil_codigo + req_codigo, fil_codigo + req_codigo, "", "", ""));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames, acao, null);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            Object exameCurva;
            this.tx_list.clear();
            this.rx_list.clear();
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            Object fil_codigoapoio = null;
            Object rec_codigoapoio = null;
            ExameMaterial[] alternativos = null;
            ExameMaterial[] listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            if (mapaParametros != null && mapaParametros.containsKey("codigoEtiqueta") && !Funcoes.textoVazio(mapaParametros.get("codigoEtiqueta")) && !mapaParametros.get("codigoEtiqueta").equals(codigo.toString())) {
                codigo.setLength(0);
                codigo.append(mapaParametros.get("codigoEtiqueta"));
            } else if (mapaParametros != null && mapaParametros.containsKey("codigoApoiado") && !Funcoes.textoVazio(mapaParametros.get("codigoApoiado"))) {
                codigo.setLength(0);
                codigo.append(mapaParametros.get("codigoApoiado"));
            }
            sample_id = new StringBuilder(codigo.substring(0, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao()));
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String exame = exa_lista[0].toString();
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            String tipo_amostra = "";
            if (exa_lista != null) {
                tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, (exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista))[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exame, mco_codigo, int_codigo);
                }
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.removeDuplicados(alternativos);
            }
            if (Funcoes.textoVazio(tipo_amostra)) {
                tipo_amostra = "Serum";
            }
            if (!exa_listaCurva.isEmpty()) {
                ExameMaterial[] exFilho;
                exameCurva = new ArrayList();
                for (ExameMaterial exameMaterial : exa_listaCurva) {
                    exameCurva.add(exameMaterial.getNomeExame());
                }
                if (Funcoes.textoVazio(this.rec_tuboPai)) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, (String)exameCurva.get(0), mco_codigo);
                }
                if ((exFilho = BDUtil.getExameMaterialRecipiente(fil_codigo, req_codigo, rec_codigo, int_codigo)) != null) {
                    if (exFilho.length == 0) {
                        String exa = !Funcoes.textoVazio(exame) && exame.contains("-") ? exame.split("-")[0] : "";
                        this.fireExcecaoEncontrada(String.format("Nenhum exame desmembrado foi encontrado para o tubo: %s.", fil_codigo + req_codigo + rec_codigo, exa) + (!Funcoes.textoVazio(exa) ? " Exame: " + exa : ""));
                        return null;
                    }
                    String tipo_amostra_curva = BDUtil.getExmEquipamentoMaterial(fil_codigo, exFilho[0].getString(), exFilho[0].getCodigo().toString(), int_codigo);
                    if (!Funcoes.textoVazio(tipo_amostra_curva)) {
                        tipo_amostra = tipo_amostra_curva;
                    }
                }
                listaCurva = ExamesUtil.anexarCodigoMaterial(exameCurva.toArray(new String[exameCurva.size()]), mco_codigo);
                listaCurva = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, String.valueOf(Integer.parseInt(rec_codigo)), st, exa_listaCurva, this.rec_tuboPai, true, this.examesFilho);
            }
            if (Funcoes.textoVazio(tipo_amostra)) {
                if (exa_lista != null) {
                    Object ex;
                    exameCurva = exa_lista;
                    int exFilho = ((ExameMaterial[])exameCurva).length;
                    for (int tipo_amostra_curva = 0; tipo_amostra_curva < exFilho && Funcoes.textoVazio(tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((CodString)(ex = exameCurva[tipo_amostra_curva])).getString(), ((CodString)ex).getCodigo().toString(), int_codigo)); ++tipo_amostra_curva) {
                    }
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    for (String exFilho : this.examesFilho) {
                        tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exFilho, mco_codigo, int_codigo);
                    }
                }
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            Date dataNasc = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            Object laboratory_pid = null;
            String t = this.getPatientRecord(1, codigo.toString(), short_name, "", pac_sexo, Funcoes.formataData("yyyyMMdd", dataNasc));
            this.tx_list.add(t);
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                for (ExameMaterial exameMaterial : alternativos) {
                    t = this.getOrderRecord(++seq, codigo.toString(), exameMaterial, "R", tipo_amostra, "");
                    this.tx_list.add(t);
                }
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    t = this.getOrderRecord(++seq, sample_id.append(tubo).toString(), alternativosCurva.get(key).get(0), "R", tipo_amostra, "");
                    this.tx_list.add(t);
                }
            }
            t = ASTMStandard.getDefaultTerminationRecord("N");
            this.tx_list.add(t);
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    protected void tratarNegativeAck() throws Exception {
        super.tratarNegativeAck();
    }

    private String getOrderRecord(int order_sequence, String sample_id, ExameMaterial test_item_numbers, String priority, String material, String tipoPaciente) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("|");
        record.append(sample_id == null ? "" : "");
        record.append("|");
        if (test_item_numbers != null) {
            String tmp = test_item_numbers.getNomeExame();
            if (tmp != null && !tmp.matches("\\^\\d+\\^\\w+\\^\\d+")) {
                record.append("^^^").append(test_item_numbers.getNomeExame()).append("^0");
            } else {
                record.append(tmp);
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("|");
        record.append("|||||");
        record.append("A");
        record.append("||||");
        record.append(material);
        record.append("|||");
        record.append(tipoPaciente);
        record.append("|||||||O");
        record.append('\r');
        return record.toString();
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento(this);
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery && !this.request.isEmpty()) {
            this.responseHostQuery();
        }
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String pac_nome, String pac_sobrenome, String pac_sexo, String pac_nascimento) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|");
        record.append("||");
        record.append(pac_sobrenome == null ? "" : pac_sobrenome);
        record.append(pac_nome == null ? "" : pac_nome + " " + patient_id);
        record.append("||");
        record.append(pac_nascimento == null ? "" : pac_nascimento);
        record.append("|");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append("|||||");
        record.append('\r');
        return record.toString();
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            if (!(Funcoes.textoVazio(this.fil_codigo) || Funcoes.textoVazio(this.req_codigo) || Funcoes.textoVazio(this.rec_codigo) || Funcoes.textoVazio(this.mco_codigo) || this.exames == null)) {
                Statement st = Conexao.getStatement();
                for (int i = 0; i < this.exames.length; ++i) {
                    Integer recKodigo;
                    int situacao;
                    if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                        for (String exame : this.examesFilho) {
                            int situacao2 = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                            boolean sit = this.ultima_acao.equals("A") && situacao2 == 2;
                            BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao2 < 2 || !sit ? 1 : 3);
                        }
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        if (situacao == -1) {
                            situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.pac_exames, this.mco_codigo, this.rec_tuboPai);
                        }
                        if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    if (!this.examesFilho.isEmpty()) {
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                        BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                    if (situacao == -1 && (recKodigo = BDUtil.getTuboFilho(this.fil_codigo, this.req_codigo, this.rec_codigo, this.int_codigo, this.exames[i], this.mco_codigo)) != null && BDUtil.existeDesmembramento(this.fil_codigo, this.int_codigo, this.req_codigo, recKodigo.toString(), this.exames[i], this.mco_codigo)) {
                        this.curva = true;
                        ExameMaterial[] exaPai = BDUtil.getDesmExamesPai(this.fil_codigo, this.int_codigo, this.req_codigo, recKodigo.toString(), this.exames[i], this.mco_codigo);
                        if (exaPai != null && exaPai.length > 0) {
                            situacao = BDUtil.getExmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, exaPai[0].getNomeExame(), this.mco_codigo, this.rec_codigo);
                            this.rec_codigo = recKodigo.toString();
                        }
                    }
                    this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
            } else {
                this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
            }
        }
        this.interromperTimer();
        this.getPortaCOM().write(String.valueOf('\u0004'));
        this.getPortaCOM().clearInputString();
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    public void dataChanged(String message) {
        try {
            if (!message.equals("")) {
                if (message.charAt(0) == '\u0005' && message.length() > 1 && message.charAt(message.length() - 1) == '\u0005') {
                    this.getPortaCOM().clearInputString();
                    this.handShakeCharReceived('\u0005');
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    if (this.isRX()) {
                        this.aguardarProximoFrame();
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("H")) {
                        this.query = false;
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("Q")) {
                        this.query = true;
                    }
                    this.mensagens.add(message);
                    if (message.substring(2, 3).equalsIgnoreCase("L")) {
                        if (this.query && this.mensagens.size() > 0) {
                            this.parseQuery(this.mensagens);
                            this.mensagens.clear();
                        }
                        this.query = false;
                        while (this.mensagens.size() > 0) {
                            this.addListaRecebimento(this.mensagens.remove(0));
                        }
                        this.restartThreadRecebimento();
                    }
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
                }
            });
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                if (message.charAt(0) == '\u0005' && message.length() > 1 && message.charAt(message.length() - 1) == '\u0005') {
                    this.getPortaCOM().clearInputString();
                    this.handShakeCharReceived('\u0005');
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    if (this.isRX()) {
                        this.aguardarProximoFrame();
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("H")) {
                        this.query = false;
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("Q")) {
                        this.query = true;
                    }
                    this.mensagens.add(message);
                    if (message.substring(2, 3).equalsIgnoreCase("L")) {
                        if (this.query && this.mensagens.size() > 0) {
                            this.parseQuery(this.mensagens);
                            this.mensagens.clear();
                        }
                        this.query = false;
                        while (this.mensagens.size() > 0) {
                            this.addListaRecebimento(this.mensagens.remove(0));
                        }
                        this.restartThreadRecebimento();
                    }
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
                }
            });
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        if (this.flags.containsKey(erro)) {
            return this.flags.get(erro);
        }
        if (erro.startsWith("ASTM")) {
            return this.flags.get("ASTM") + erro;
        }
        return null;
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            this.confirmacaoACK();
        } else if (op == 2) {
            this.resultado();
        } else if (op == 3) {
            this.finalizaTransmissao();
        }
    }

    protected void finalizaTransmissao() {
        this.handShakeCharReceived('\u0004');
    }

    protected void confirmacaoACK() {
        for (int i = 0; i < 10; ++i) {
            this.handShakeCharReceived('\u0006');
        }
    }

    private void query() {
        String idAmosta = JOptionPane.showInputDialog("Informe o Id da amostra?");
        this.dataChanged(this.equipamento.arruma("[STX]1H|\\^&|||BiOLiS[SP]NEO^SYSTEM1|||||HOST^P_1||P|1|20151130163021[CR][ETX]E4[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]2Q|1|^" + idAmosta + "||ALL||||||||O[CR][ETX]15[LINE]"));
        this.dataChanged(this.equipamento.arruma("[STX]3L|1|N[CR]"));
        this.finalizaTransmissao();
    }

    private void resultado() {
        String idAmostra = JOptionPane.showInputDialog("Informe o Id da amostra?");
        String alternativo = JOptionPane.showInputDialog("Informe o alternativo do exame?");
        if (Funcoes.textoVazio(idAmostra) || Funcoes.textoVazio(alternativo)) {
            return;
        }
        this.parse(this.equipamento.arruma("[STX]0H|\\^&|||Miura||||||Laboratorio[SP]Vicenlab[SP]|P|LIS2-A2|20140906103004[ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1P|1||0101114302|||||M|W|||||||||||||||||||U|S|||||A[ETX]C3[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2O|1||" + idAmostra + "|C^CR^NONE^1|R||||||N||||S||||||||||O||||||[ETX]57[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3R|1|C^" + alternativo + "^NONE^1|1.246159|mg/dl|0.700000:1.200000|H||F||VICENLAB1|||Miura[ETX]07[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4C|1|I|ONO|I[ETX]19[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5L|1|N[ETX]FB[LINE]"));
    }

    @Override
    public String parse(String message) {
        return this.parseMsg(message);
    }

    public synchronized String parseMsg(String message) {
        return super.parse(message);
    }

    private void resultadoTeste1(String amostra) {
        this.dataChanged(TestesInterface.arruma("[STX]1H|\\^&|||BIOLIS[SP]NEO^SYSTEM1|||||HOST^P_1||P|1|20151013160907[CR][ETX]AE[LINE]"));
        this.dataChanged(TestesInterface.arruma("[STX]2P|1|" + amostra + "|||^Maria[SP]Victoria[SP]Sturiao[SP]Meneghe||20050105|F|||||[CR][ETX]67[LINE]"));
        this.dataChanged(TestesInterface.arruma("[STX]3O|1|" + amostra + "|^1^26|^^^57^COL76^0\\^^^58^GLI84^0\\^^^59^TGR87^0\\^^^61^HDL98^0|R||||||||||Serum||||||||||F[CR][ETX]E6[LINE]"));
        this.dataChanged(TestesInterface.arruma("[STX]6R|2|^^^40^ALB84^0|74|mg/dL||N||F||||20151013135026[CR][ETX]C5[LINE]"));
        this.dataChanged(TestesInterface.arruma("[STX]7R|3|^^^57^COL76^0|93|mg/dL||N||F||||20151013135041[CR][ETX]DA[LINE]"));
        this.dataChanged(TestesInterface.arruma("[STX]1L|1|N[CR][ETX]04[LINE]"));
    }

    private void resultadoTeste2(String amostra, boolean repeticao) {
        this.parse(TestesInterface.arruma("[STX]1H|\\^&|||BIOLIS[SP]NEO^SYSTEM1|||||HOST^P_1||P|1|20151013151442[CR][ETX]A8[LINE]"));
        this.parse(TestesInterface.arruma("[STX]2P|1|" + amostra + "|||^Elita[SP]Lidia[SP]Marques||19370416|F|||||[CR][ETX]37[LINE]"));
        this.parse(TestesInterface.arruma("[STX]3O|1|" + amostra + "|^1^19|^^^18^CRE96^0\\^^^57^COL76^0\\^^^58^GLI84^0\\^^^59^TGR87^0\\^^^60^ACU73^0\\^^^61^HDL98^0|R||||||||||Serum||||||||||F[CR][ETX]00[LINE]"));
        this.parse(TestesInterface.arruma("[STX]4R|1|^^^18^CRE96^0|0.94|mg/dL||N||F||||20151013133911[CR][ETX]20[LINE]"));
        this.parse(TestesInterface.arruma("[STX]5R|2|^^^57^COL76^0|263|mg/dL||N||F||||20151013133926[CR][ETX]FD[LINE]"));
        this.parse(TestesInterface.arruma("[STX]6R|3|^^^58^GLI84^0|133|mg/dL||N||F||||20151013133941[CR][ETX]F6[LINE]"));
        this.parse(TestesInterface.arruma("[STX]7R|4|^^^59^TGR87^0|123|mg/dL||N||F||||20151013133956[CR][ETX]12[LINE]"));
        this.parse(TestesInterface.arruma("[STX]0R|5|^^^60^ACU73^0|2.75|mg/dL||N||F||||20151013134011[CR][ETX]10[LINE]"));
        this.parse(TestesInterface.arruma("[STX]1R|6|^^^61^HDL98^0|71|mg/dL||N||F||||20151013134026[CR][ETX]BB[LINE]"));
        if (repeticao) {
            this.parse(TestesInterface.arruma("[STX]2R|7|^^^57^COL76^0|040|mg/dL||N||F||||20151013151428[CR][ETX]FF[LINE]"));
        }
        this.parse(TestesInterface.arruma("[STX]1L|1|N[CR][ETX]04[LINE]"));
    }
}

