/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.labmax240;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.labmax240.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.labmax240.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.CodString;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    Hashtable<String, String> hash_excecoes = new Hashtable();
    InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
    private boolean recebendoDados = false;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    private boolean enviando;
    protected boolean hostQuery = false;
    protected String hostFilCodigo = null;
    protected String hostReqCodigo = null;
    protected String hostRecCodigo = null;
    private List<InfoExameRequisicao> examesEnviados = new ArrayList<InfoExameRequisicao>();

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.MAX_PATIENT_NAME_CHARS = 29;
        this.HOST_NAME = "HOST";
        this.HOST_SYSTEM_VERSION = "P_1";
        this.INSTRUMENT_NAME = "Prestige24i";
        this.INSTRUMENT_SYSTEM_VERSION = "System1";
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.fillHashExcecoes();
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                this.addListaRecebimento(message);
                this.restartThreadRecebimento();
                this.getPortaCOM().write(String.valueOf('\u0006'));
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (!this.threadRecebimento.isAlive()) {
                this.restartThreadRecebimento();
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void fillHashExcecoes() {
        this.hash_excecoes.put("R1", "Falta do reagente R1");
        this.hash_excecoes.put("R2", "Falta do reagente R2");
        this.hash_excecoes.put("S", "Falta de amostra (sample)");
        this.hash_excecoes.put("C", "O valor do 'espa\u00e7o' celular est\u00e1 fora do intervalo de limite 1");
        this.hash_excecoes.put("E", "O valor excedeu o limite superior/inferior pela verifica\u00e7\u00e3o por prozone");
        this.hash_excecoes.put("D", "O valor excedeu o limite do ponto final no exame de ponto final");
        this.hash_excecoes.put("B", "Todos os pontos L1 do intervalo de medi\u00e7\u00e3o ou do primeiro ponto abaixo do limite ABS");
        this.hash_excecoes.put("G", "Todos os pontos L1 do intervalo de medi\u00e7\u00e3o ou do primeiro ponto excedem o limite ABS");
        this.hash_excecoes.put("b", "Um ou mais pontos do intervalo de medi\u00e7\u00e3o abaixo do limite ABS");
        this.hash_excecoes.put("g", "Um ou mais pontos do intervalo de medi\u00e7\u00e3o excedem o limite ABS");
        this.hash_excecoes.put("T", "Temperatura da bandeja de rea\u00e7\u00e3o sob medi\u00e7\u00e3o excedeu +/- 1 grau da temperatura configurada");
        this.hash_excecoes.put("t", "Em aquecimento");
        this.hash_excecoes.put("c", "O valor do 'espa\u00e7o' celular est\u00e1 fora do intervalo de limite 2");
        this.hash_excecoes.put("R", "O valor excedeu o limite da linearidade da taxa do exame");
        this.hash_excecoes.put("ASTM", "Erro do bloco de dados enviado");
        this.hash_excecoes.put("A1", "Erro no registro do pedido de exame (Erro de sistema)");
        this.hash_excecoes.put("A2", "A amostra designada para o exame pedido est\u00e1 em medi\u00e7\u00e3o ou j\u00e1 foi examinada");
        this.hash_excecoes.put("A3", "Posi\u00e7\u00e3o inexistente ou inadequada ao tipo/prioridade do exame");
        this.hash_excecoes.put("A4", "Nenhuma amostra designada");
    }

    @Override
    public String getErroTraduzido(String erro_codigo) {
        if (erro_codigo.indexOf("ASTM") >= 0) {
            if (erro_codigo.equalsIgnoreCase("ASTM_9_4_16")) {
                return "Material alternativo n\u00e3o definido para o exame";
            }
            if (erro_codigo.equalsIgnoreCase("ASTM_9_4_5")) {
                return "Alternativo definido para o exame esta incorreto";
            }
            if (erro_codigo.equalsIgnoreCase("ASTM_9_4_4")) {
                return "Equipamento n\u00e3o esta habilitado para receber solicita\u00e7\u00f5es";
            }
            return this.hash_excecoes.get("ASTM");
        }
        int limite = erro_codigo.indexOf(",");
        return this.hash_excecoes.get(erro_codigo.substring(0, limite > 0 ? limite : erro_codigo.length()));
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            Object exameCurva;
            if (!Funcoes.textoVazio(this.configuracao.getTempoEntreEnvioDePacientes()) && Funcoes.isNumeric(this.configuracao.getTempoEntreEnvioDePacientes())) {
                this.aguardaProximaMensagem();
            }
            if (!this.configuracao.getModoHostQuery()) {
                this.tx_counter = 0;
                this.tx_list.clear();
                this.rx_list.clear();
            }
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            ExameMaterial[] alternativos = null;
            ExameMaterial[] listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String exame = exa_lista[0].toString();
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            String tipo_amostra = "";
            if (exa_lista != null) {
                tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, (exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista))[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exame, mco_codigo, int_codigo);
                }
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.removeDuplicados(alternativos);
            }
            if (!exa_listaCurva.isEmpty()) {
                exameCurva = new ArrayList();
                for (ExameMaterial exameMaterial : exa_listaCurva) {
                    exameCurva.add(exameMaterial.getNomeExame());
                }
                if (Funcoes.textoVazio(this.rec_tuboPai)) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, (String)exameCurva.get(0), mco_codigo);
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((ExameMaterial)exa_listaCurva.get(0)).getString(), ((ExameMaterial)exa_listaCurva.get(0)).getCodigo().toString(), int_codigo);
                }
                listaCurva = ExamesUtil.anexarCodigoMaterial(exameCurva.toArray(new String[exameCurva.size()]), mco_codigo);
                listaCurva = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, String.valueOf(Integer.parseInt(rec_codigo)), st, exa_listaCurva, this.rec_tuboPai, true, this.examesFilho);
            }
            if (Funcoes.textoVazio(tipo_amostra)) {
                if (exa_lista != null) {
                    Object ex;
                    exameCurva = exa_lista;
                    int n = ((ExameMaterial[])exameCurva).length;
                    for (int exameMaterial = 0; exameMaterial < n && Funcoes.textoVazio(tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((CodString)(ex = exameCurva[exameMaterial])).getString(), ((CodString)ex).getCodigo().toString(), int_codigo)); ++exameMaterial) {
                    }
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    for (String exFilho : this.examesFilho) {
                        tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exFilho, mco_codigo, int_codigo);
                    }
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    this.fireExcecaoEncontrada(String.format("Nenhum dos exames est\u00e1 com o material alternativo configurado por verifique a configura\u00e7\u00e3o %s %s %s", fil_codigo, req_codigo, rec_codigo));
                    return "Nenhum dos exames est\u00e1 com o material alternativo configurado por verifique a configura\u00e7\u00e3o";
                }
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            String laboratory_pid = null;
            String t = this.getDefaultPatientRecord(1, patient_id.toString(), laboratory_pid, short_name, pac_sexo);
            this.tx_list.add(t);
            if (!Funcoes.textoVazio(rackposition) && !rackposition.startsWith("\\^")) {
                rackposition = "^" + rackposition;
            }
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                t = InterfaceListener.getDefaultOrderRecord(++seq, codigo.toString(), rackposition, alternativos, null, "0", "R", acao, tipo_amostra, "O");
                this.tx_list.add(t);
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    t = ASTMStandard.getDefaultOrderRecord(++seq, sample_id.append(tubo).toString(), rackposition, alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()]), null, "0", "R", acao, tipo_amostra, "O");
                    this.tx_list.add(t);
                }
            }
            t = ASTMStandard.getDefaultTerminationRecord("N");
            this.tx_list.add(t);
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.enviando = true;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public String getDefaultPatientRecord(int patient_sequence, String patient_id, String laboratory_pid, String pac_nome, String pac_sexo) {
        String separadorNome = this.configuracao.isSeparadorNomePacienteSP() ? "[SP]" : "^";
        String[] nomeCompleto = pac_nome == null ? new String[]{} : pac_nome.split(" ");
        String nome = nomeCompleto.length > 0 ? nomeCompleto[0] : "";
        String sobreNome = nomeCompleto.length > 1 ? nomeCompleto[nomeCompleto.length - 1] : "";
        nome = nomeCompleto[0];
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence);
        record.append("|");
        record.append(patient_id == null ? "" : patient_id);
        record.append("|");
        record.append(laboratory_pid == null ? "" : laboratory_pid);
        record.append("||");
        record.append(Funcoes.textoVazio(nome) ? "" : this.insereAcentuacaoInicialNomePaciente(nome));
        if (!Funcoes.textoVazio(sobreNome)) {
            record.append(separadorNome).append(sobreNome);
        }
        record.append("|||");
        record.append(pac_sexo == null ? "" : pac_sexo);
        record.append("|");
        record.append('\r');
        return record.toString();
    }

    private void aguardaProximaMensagem() throws NumberFormatException, InterruptedException, IOException {
        int cont = 0;
        if (!this.configuracao.getModoHostQuery()) {
            while (this.tx_list.size() > 0) {
                Thread.sleep(200L);
                if (!this.possuiMensagem(cont++)) continue;
                this.getPortaCOM().write(String.valueOf('\u0005'));
                cont = 0;
            }
        } else {
            Thread.sleep(Long.parseLong(this.configuracao.getTempoEntreEnvioDePacientes()));
        }
    }

    private String insereAcentuacaoInicialNomePaciente(String nome) {
        if (this.configuracao.isInserirAcentoInicio()) {
            return "^" + nome;
        }
        return nome;
    }

    private boolean possuiMensagem(int cont) {
        return this.tx_list.size() >= 4 && cont == 20;
    }

    public boolean isRecebendoDados() {
        if (this.rx_counter > this.MAX_TENTATIVAS_RX && !this.isRX() && this.isIdle()) {
            this.recebendoDados = false;
        }
        ++this.rx_counter;
        return this.recebendoDados || this.isRX();
    }

    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0005': {
                    this.recebendoDados = true;
                    if (this.isTX() || this.tx_list.size() > 0 && this.rx_counter < this.MAX_TENTATIVAS_RX) {
                        this.getPortaCOM().write(String.valueOf('\u0015'));
                        ++this.rx_counter;
                        break;
                    }
                    this.rx_counter = 0;
                    this.tratarEnquiry();
                    break;
                }
                case '\u0006': {
                    this.tratarAcknowledge();
                    break;
                }
                case '\u0015': {
                    this.tratarNegativeAck();
                    break;
                }
                case '\u0004': {
                    this.recebendoDados = false;
                    this.tratarEndOfTX();
                    break;
                }
                default: {
                    this.caracterNaoEsperado();
                    break;
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de caracter de handshake recebido");
            this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento: " + ex.getMessage(), 1, 5000);
            if (this.tx_list.size() > 0) {
                this.limpaDadosRequisicao();
            }
            this.setIdle();
        }
    }

    public boolean isEnviando() {
        return this.enviando || this.isTX();
    }

    @Override
    protected void limpaDadosRequisicao() {
        if (!this.enviando) {
            super.limpaDadosRequisicao();
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (this.examesEnviados.isEmpty()) {
            if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                Statement st = Conexao.getStatement();
                if (this.exames != null) {
                    for (int i = 0; i < this.exames.length; ++i) {
                        int situacao;
                        if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                            situacao = -1;
                            for (String exame : this.examesFilho) {
                                situacao = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                                BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao < 2 ? 1 : 3);
                            }
                            if (situacao >= 2) {
                                this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, 3);
                                continue;
                            }
                            situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                            if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                            this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                            continue;
                        }
                        if (!this.examesFilho.isEmpty()) {
                            situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                            this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                            BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                            continue;
                        }
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                    }
                    Conexao.arquivaSQL();
                    String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                    this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
                } else {
                    this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
                }
            }
            this.interromperTimer();
            this.getPortaCOM().write(String.valueOf('\u0004'));
            this.enviando = false;
            this.getPortaCOM().clearInputString();
            if (this.ultima_acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
            this.fireAtualizarTabela();
            this.fireAtualizarTabela(0);
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.setIdle();
        } else {
            while (!this.examesEnviados.isEmpty()) {
                this.encerrarTransmissao(this.examesEnviados.remove(0));
            }
        }
    }

    private void encerrarTransmissao(InfoExameRequisicao infoExame) throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            Statement st = Conexao.getStatement();
            if (infoExame != null) {
                String[] exames = infoExame.getExames().split(" ");
                String fil_codigo = infoExame.getFilial();
                String int_codigo = infoExame.getInterface();
                String req_codigo = infoExame.getCodigo();
                String mco_codigo = infoExame.getMaterial();
                String rec_tuboPai = infoExame.getTuboPai();
                String rec_codigo = infoExame.getRecipiente();
                boolean curva = infoExame.isCurva();
                for (int i = 0; i < exames.length; ++i) {
                    int situacao;
                    String[] examesFilho = infoExame.getExamesFilho().split(" ");
                    if (!Funcoes.textoVazio(rec_tuboPai) && curva && examesFilho != null && examesFilho.length > 0) {
                        for (String exame : examesFilho) {
                            int situacao2 = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_tuboPai, exame, mco_codigo);
                            BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, exame, mco_codigo, rec_tuboPai, situacao2 < 2 ? 1 : 3);
                        }
                        situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                        if (!BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_tuboPai)) continue;
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_tuboPai, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    if (examesFilho != null && examesFilho.length > 0) {
                        situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                        BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exames[i], mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exames[i], mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
            } else {
                this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
            }
        }
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(infoExame.getCodigo(), infoExame.getNome(), infoExame.getSexo(), infoExame.getIdade(), infoExame.getData(), infoExame.getHora(), infoExame.getExames());
        }
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public List<Object[]> getTodasRequisicaoAba(String fil_codigo, String req_codigo, String rec_codigo, int abaSelecionada) {
        ArrayList exames = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        boolean isMultiguia = true;
        ArrayList<Object[]> requisicoesEncontradas = new ArrayList<Object[]>();
        for (int i = 0; i < exames.size(); ++i) {
            Object[] req = (Object[])exames.get(i);
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
            String tubo = (String)req[aba.getColIndice("Tubo")];
            tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
            int col = aba.getColIndice("Cod. Apoiado");
            String codigoAp = "";
            if (col > -1) {
                codigoAp = (String)req[col];
            }
            String codigoApoiado = String.format("%s%s%s", fil_codigo, req_codigo, rec_codigo);
            boolean apoiado = false;
            if (!Funcoes.textoVazio(codigoAp) && codigoApoiado.equals(codigoAp)) {
                apoiado = true;
            }
            if (fil_codigo.equalsIgnoreCase(filial) && req_codigo.equalsIgnoreCase(requisicao) && rec_codigo.equalsIgnoreCase(tubo) || apoiado) {
                requisicoesEncontradas.add(req);
                continue;
            }
            ArrayList tubos = (ArrayList)req[aba.getColIndice("Tubos Filhos")];
            if (tubos == null) continue;
            for (String t : tubos) {
                if (Funcoes.textoVazio(t)) continue;
                t = Funcoes.preencheZero(t, ParametrosGerais.getDigitosTuboTubo());
                if (!fil_codigo.equalsIgnoreCase(filial) || !req_codigo.equalsIgnoreCase(requisicao) || !rec_codigo.equalsIgnoreCase(t)) continue;
                requisicoesEncontradas.add(req);
            }
        }
        if (isMultiguia && ParametrosGerais.isAgruparGuiasInterface()) {
            ArrayList<String> guias = null;
            if (Funcoes.isNumeric(fil_codigo) && Funcoes.isNumeric(req_codigo)) {
                try {
                    guias = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
                if (guias != null) {
                    for (String guia : guias) {
                        Object[] req;
                        if (Integer.parseInt(guia) == Integer.parseInt(req_codigo) || (req = this.getRequisicaoAba(fil_codigo, Funcoes.preencheZero(guia, ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo, abaSelecionada, false, false)) == null) continue;
                        requisicoesEncontradas.add(req);
                    }
                }
            }
        }
        return requisicoesEncontradas;
    }

    public static String getDefaultOrderRecord(int order_sequence, String sample_id, String sample_id_type, ExameMaterial[] test_item_numbers, ExameMaterial[] test_item_names, String dilution, String priority, String action_code, String sample_type, String report_type) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence);
        record.append("|");
        record.append(sample_id == null ? "" : sample_id);
        record.append("|");
        record.append(sample_id_type == null ? "" : sample_id_type);
        record.append("|");
        if (test_item_numbers != null && test_item_numbers[0] != null) {
            record.append("^^^");
            record.append(test_item_numbers[0].getNomeExame());
            record.append(test_item_names == null || test_item_names[0] == null ? "" : "^" + test_item_names[0].getNomeExame());
            record.append(dilution == null ? "" : "^" + dilution);
            for (int i = 1; i < test_item_numbers.length; ++i) {
                if (test_item_numbers[i] == null) continue;
                record.append("\\^^^");
                record.append(test_item_numbers[i].getNomeExame());
                record.append(test_item_names == null || test_item_names[i] == null ? "" : "^" + test_item_names[i].getNomeExame());
                record.append(dilution == null ? "" : "^" + dilution);
            }
        }
        record.append("|");
        record.append(priority == null ? "" : priority);
        record.append("||||||");
        record.append(action_code == null ? "" : action_code);
        record.append("||||");
        record.append(sample_type == null ? "" : sample_type);
        record.append("||||||||||");
        record.append(report_type == null ? "" : report_type);
        record.append("|");
        record.append('\r');
        return record.toString();
    }

    public void responseHostQuery() {
        try {
            String filCodigo = this.hostFilCodigo;
            String reqCodigo = this.hostReqCodigo;
            String recCodigo = this.hostRecCodigo;
            String pacNome = null;
            String pacSexo = null;
            String pacIdade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String intCodigo = null;
            String mcoCodigo = null;
            String pacExames = "";
            String acao = "A";
            if (Funcoes.textoVazio(filCodigo) || Funcoes.textoVazio(reqCodigo) || Funcoes.textoVazio(recCodigo)) {
                return;
            }
            List<Object[]> listaRequisicoes = this.getTodasRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            this.hostFilCodigo = null;
            this.hostReqCodigo = null;
            this.hostRecCodigo = null;
            if (!listaRequisicoes.isEmpty()) {
                for (Object[] req : listaRequisicoes) {
                    if (!pacExames.isEmpty()) {
                        pacExames = pacExames.concat(" ");
                    }
                    pacNome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                    pacSexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                    data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                    hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                    intCodigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                    mcoCodigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                    pacExames = pacExames.concat((String)req[aba.getColIndice("Exame")]);
                }
                this.enviando = true;
                this.enviarRequisicao(pacNome, pacSexo, pacIdade, data, hora, "", prioridade, filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, pacExames, acao);
            } else {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo %s n\u00e3o foi localizado.", filCodigo.concat(reqCodigo).concat(recCodigo)));
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Labmax 400: Host Query Response");
        }
    }

    @Override
    public void responderRequest(String startingRange, String endingRange, String testID) {
        try {
            String sampleId = startingRange.trim();
            this.hostQuery = true;
            if (Funcoes.textoVazio(sampleId)) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                return;
            }
            if (sampleId.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                return;
            }
            this.hostFilCodigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            sampleId = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
            this.hostReqCodigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.hostRecCodigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao());
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Labmax 240: Host Query Response");
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery || !Funcoes.textoVazio(this.hostFilCodigo) && !Funcoes.textoVazio(this.hostReqCodigo) && !Funcoes.textoVazio(this.hostRecCodigo)) {
            this.responseHostQuery();
        }
    }

    protected void confirmacaoACK() {
        for (int i = 0; i < 10; ++i) {
            this.handShakeCharReceived('\u0006');
        }
    }

    protected void finalizaTransmissao() {
        this.handShakeCharReceived('\u0004');
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(Laboratorio.getInstancia(), "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            this.confirmacaoACK();
        } else if (op == 2) {
            this.resultado();
        } else if (op == 3) {
            this.finalizaTransmissao();
        }
    }

    private void query() {
        String idAmostra;
        String codigoTubo = "";
        PanelAbaAbstrata aba = this.equipamento.getTab(0);
        if (aba.getSelectedRow() >= 0) {
            codigoTubo = codigoTubo.concat(aba.getValueAt(aba.getSelectedRow(), aba.getColIndice("C\u00f3digo")).toString());
            codigoTubo = codigoTubo.concat(aba.getValueAt(aba.getSelectedRow(), aba.getColIndice("Tubo")).toString());
        }
        if (Funcoes.textoVazio(idAmostra = JOptionPane.showInputDialog(Laboratorio.getInstancia(), "Informe o Id da amostra?", codigoTubo))) {
            return;
        }
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||Prestige24i^System1|||||Host^PC1||P|1|20000530192631[CR][ETX]E4[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2Q|1|".concat(idAmostra).concat("||ALL||||||||O[CR][ETX]15[LINE]")));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR]"));
        this.finalizaTransmissao();
        this.confirmacaoACK();
    }

    private void resultado() {
        String idAmostra;
        String codigoTubo = "";
        PanelAbaAbstrata aba = this.equipamento.getTab(1);
        if (aba.getSelectedRow() >= 0) {
            codigoTubo = codigoTubo.concat(aba.getValueAt(aba.getSelectedRow(), aba.getColIndice("C\u00f3digo")).toString());
            codigoTubo = codigoTubo.concat(aba.getValueAt(aba.getSelectedRow(), aba.getColIndice("Tubo")).toString());
        }
        if (Funcoes.textoVazio(idAmostra = JOptionPane.showInputDialog(Laboratorio.getInstancia(), "Informe o Id da amostra?", codigoTubo))) {
            return;
        }
        this.parse(this.equipamento.arruma("[STX]0H|\\^&|||Prestige24i^System1|||||Host^PC1||P|1|20000530192631[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1P|1|[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2O|1||".concat(idAmostra).concat("|^^^1^GOT^0\\^^^2^GPT^0\\^^^27^TG^0|R||||||||N||||20000530|Serum|||||||||||F[CR][ETX]4F[LINE]")));
        this.parse(this.equipamento.arruma("[STX]3R|1|^^^1^GOT^0|21.5143|IU/L|8 TO 38|N||F||||20010530192515[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|2|^^^2^GPT^0|8.5793|IU/L|4 TO 44|N||F||||20010530192517[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]5C|1|I|Operator's Comment|G[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]6R|3|^^^27^TG^0|381.596|mg/dl|50 TO 130|H||F||||20010530192520[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]7L|1|N[CR][ETX]4F[LINE]"));
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        public boolean listaDeExamesProcessando() {
            return this.listaRecebimento.size() > 0;
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
                if (!InterfaceListener.this.equipamento.getStatusFecharInterfaceamento().isExportando()) {
                    InterfaceListener.this.fireAtualizarTabela(2);
                }
            }
            catch (InterruptedException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            }
        }
    }
}

