/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.labmax240;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultProntos;
import jalis.laboratorio.interfaceamento.abas.SelecionaExame;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.interfaces.labmax240.InterfaceListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JFrame;

public class AbaProntos
extends AbaDefaultProntos {
    public AbaProntos(JFrame parent, AbstractInterfaceamento equip) {
        super(parent, equip);
    }

    @Override
    public void repetirExame() {
        String mco_codigo;
        int row = this.tabelaExames.getSelectedRow();
        if (row < 0) {
            return;
        }
        ArrayList requisicaoExames = this.getRequisicaoExames(row, this.exames);
        if ((requisicaoExames = (ArrayList)requisicaoExames.clone()).size() > 1) {
            SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
            tela.setVisible(true);
            requisicaoExames = tela.getRequisicaoExames();
        } else {
            Object[] exame = (Object[])requisicaoExames.get(0);
            String aux = (String)exame[this.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                aux = (String)exame[this.getColIndice("Multiguia")];
            }
            String fil_codigo = aux.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = (String)exame[this.getColIndice("Interface")];
            String exa_codigo = (String)exame[this.getColIndice("Exame")];
            mco_codigo = (String)exame[this.getColIndice("C\u00f3d. Mat.")];
            try {
                if (BDUtil.isExameDesmembrado(fil_codigo, int_codigo, exa_codigo, mco_codigo)) {
                    SelecionaExame tela = new SelecionaExame(this.equipamento, requisicaoExames, this.colunas, this.colunasVisiveis, this.colunasOcultas);
                    tela.setVisible(true);
                    requisicaoExames = tela.getRequisicaoExames();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        String exames = " ";
        ArrayList<Integer> linhas = new ArrayList<Integer>();
        HashMap<String, String> examesCurva = new HashMap<String, String>();
        for (int i = 0; i < requisicaoExames.size(); ++i) {
            Object[] linhaRepeticao = (Object[])requisicaoExames.get(i);
            String reqRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                reqRepetir = (String)linhaRepeticao[this.getColIndice("Multiguia")];
            }
            String exaRepetir = (String)linhaRepeticao[this.getColIndice("Exame")];
            String matRepetir = (String)linhaRepeticao[this.getColIndice("C\u00f3d. Mat.")];
            String int_codigo = (String)linhaRepeticao[this.getColIndice("Interface")];
            for (int j = 0; j < this.tabelaExames.getRowCount(); ++j) {
                ArrayList desmembrado;
                Object[] linhaProntos = this.tabelaExames.getRow(j);
                String reqPronto = (String)linhaProntos[this.getColIndice("C\u00f3digo")];
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    reqPronto = (String)linhaProntos[this.getColIndice("Multiguia")];
                }
                String fil_codigo = reqPronto.substring(0, ParametrosGerais.getDigitosTuboFilial());
                if (!reqRepetir.equalsIgnoreCase(reqPronto)) continue;
                String exaPronto = (String)linhaProntos[this.getColIndice("Exame")];
                String matPronto = (String)linhaProntos[this.getColIndice("C\u00f3d. Mat.")];
                String tubo = (String)linhaProntos[this.getColIndice("Tubo")];
                if (!exaRepetir.equalsIgnoreCase(exaPronto) || !matRepetir.equalsIgnoreCase(matPronto)) continue;
                boolean curva = false;
                try {
                    desmembrado = (ArrayList)linhaRepeticao[linhaRepeticao.length - 1];
                    curva = BDUtil.isExameCurva(fil_codigo, int_codigo, exaPronto, matPronto);
                }
                catch (Exception e) {
                    desmembrado = null;
                }
                if (desmembrado != null) {
                    for (int k = 0; k < desmembrado.size(); ++k) {
                        String tuboFilho;
                        Object[] exame = (Object[])desmembrado.get(k);
                        String situacao = (String)exame[exame.length - 1];
                        if (!situacao.equalsIgnoreCase(SelecionaExame.SIT_REPETIR)) continue;
                        exames = exames + exame[1] + " ";
                        if (!curva) continue;
                        try {
                            String exa = exame[1].toString();
                            tuboFilho = BDUtil.getExameDesmembradoTubo(fil_codigo, reqPronto.substring(ParametrosGerais.getDigitosTuboFilial()), tubo, int_codigo, exa, matPronto);
                            if (Funcoes.textoVazio(tuboFilho)) continue;
                            examesCurva.put(exa, tuboFilho);
                            continue;
                        }
                        catch (SQLException e) {
                            tuboFilho = "";
                            e.printStackTrace();
                        }
                    }
                    linhas.add(j);
                    this.tabelaExames.getRow(j);
                    continue;
                }
                String sit = (String)linhaRepeticao[this.getColIndice("Sit")];
                if (!sit.equalsIgnoreCase(SelecionaExame.SIT_REPETIR) && (requisicaoExames.size() != 1 || !sit.equalsIgnoreCase(SelecionaExame.SIT_PRONTO))) continue;
                exames = exames + exaPronto + " ";
                linhas.add(j);
            }
        }
        if (exames.trim().length() > 0) {
            try {
                String req_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3digo"));
                String rec_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Tubo"));
                mco_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3d. Mat."));
                String pac_sexo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("S"));
                String pac_idade = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Ide"));
                String exame = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Exame"));
                String pac_nome = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Paciente"));
                String rack = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("Rack"));
                String hora = TempoUtil.getCurrentTime();
                String data = TempoUtil.getCurrentDateBr();
                if (ParametrosGerais.isAgruparGuiasInterface()) {
                    req_codigo = (String)this.tabelaExames.getValueAt((Integer)linhas.get(0), this.getColIndice("C\u00f3digo Temp."));
                }
                String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
                req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
                if (!examesCurva.isEmpty()) {
                    ConfiguracaoSerial c = this.equipamento.getSelectedTab().getConfiguracaoPorta(fil_codigo, int_codigo);
                    InterfaceListener lis = null;
                    if (c != null && c.getInterfacementoListener() != null && c.getInterfacementoListener() instanceof InterfaceListener) {
                        lis = (InterfaceListener)c.getInterfacementoListener();
                    }
                    for (String key : examesCurva.keySet()) {
                        String resposta = this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, null, fil_codigo, int_codigo, req_codigo, mco_codigo, (String)examesCurva.get(key), exame.trim(), "A");
                        char ack = '\u0006';
                        if (lis != null) {
                            lis.handShakeCharReceived(ack);
                            lis.handShakeCharReceived(ack);
                            lis.handShakeCharReceived(ack);
                            lis.handShakeCharReceived(ack);
                            lis.handShakeCharReceived(ack);
                            lis.handShakeCharReceived(ack);
                        }
                        if (resposta != null) {
                            this.equipamento.novaMensagem(resposta, 0, resposta.startsWith("Erro") ? 5000 : 10000);
                        }
                        if (lis == null) continue;
                        while (lis.isEnviando()) {
                            Thread.sleep(4000L);
                        }
                    }
                } else {
                    String resposta = this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, exames.trim(), "A");
                    if (resposta != null) {
                        this.equipamento.novaMensagem(resposta, 0, resposta.startsWith("Erro") ? 5000 : 10000);
                    }
                }
                for (Integer i : linhas) {
                    this.reloadLinha(i);
                }
                this.revalidate();
                this.repaint();
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace());
            }
        }
    }
}

