/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.labmax240;

import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamento;
import jalis.laboratorio.interfaceamento.abas.AbaDefaultNaoEnviados;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.interfaces.labmax240.InterfaceListener;
import jalis.laboratorio.interfaceamento.interfaces.labmax240.RequisicaoRack;
import jalis.util.Funcoes;
import jalis.util.TempoUtil;
import jalis.util.componentes.BotaoNavegavel;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class AbaExamesNaoEnviadosRack
extends AbaDefaultNaoEnviados {
    private JButton buttonRack = new BotaoNavegavel("Rack", 'A');
    JPanel panel_rack = new JPanel(new FlowLayout());
    protected JCheckBox check_urgencia = null;
    private boolean curva;
    private int tuboFilho;

    public AbaExamesNaoEnviadosRack(JFrame parent, AbstractInterfaceamento equip, JCheckBox urgencia) {
        super(parent, equip);
        this.check_urgencia = urgencia;
        this.configPanelRack();
    }

    public void setCurva(boolean curva) {
        this.curva = curva;
    }

    public void setTuboFilho(int tuboFilho) {
        this.tuboFilho = tuboFilho;
    }

    private void configPanelRack() {
        TitledBorder b = ComponenteFactory.novoTitledEtchedBorder("Rack");
        this.panel_rack.setBorder(b);
        ((FlowLayout)this.panel_rack.getLayout()).setVgap(0);
        ((FlowLayout)this.panel_rack.getLayout()).setHgap(0);
        this.buttonRack.setMargin(new Insets(2, 5, 2, 5));
        this.buttonRack.setPreferredSize(new Dimension(50, 20));
        this.panel_rack.add(this.buttonRack);
        if (this.check_urgencia != null) {
            this.panel_rack.add(this.check_urgencia);
        }
        this.jPanelHeader.add((Component)this.panel_rack, "West");
        this.buttonRack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbaExamesNaoEnviadosRack.this.rack();
            }
        });
    }

    private void rack() {
        RequisicaoRack tela = new RequisicaoRack(this.parent, this.equipamento, this.exames, this.getColIndice("C\u00f3digo"), this.getColIndice("Paciente"), this.getColIndice("Exame"), this.getColIndice("Rack"), this.getColIndice("Tubo"), false, this, this.getColIndice("Interface"), this.getColIndice("C\u00f3d. Mat."));
        tela.setVisible(true);
    }

    @Override
    public void transmiteExames(int row, String exames) {
        System.out.println("Transmitindo: " + row + " (" + this.tabelaExames.getRowCount() + ")");
        if (row >= 0 && this.tabelaExames.getRowCount() > 0) {
            String req_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3digo"));
            String rec_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Tubo"));
            String mco_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("C\u00f3d. Mat."));
            String pac_sexo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("S"));
            String pac_idade = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Ide"));
            String pac_nome = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Paciente"));
            if (this.curva) {
                rec_codigo = String.valueOf(this.tuboFilho);
            }
            String pac_exames = Funcoes.textoVazio(exames) ? (String)this.tabelaExames.getValueAt(row, this.getColIndice("Exame")) : exames;
            String hora = TempoUtil.getCurrentTime();
            String data = TempoUtil.getCurrentDateBr();
            String rackpos = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Rack"));
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String int_codigo = (String)this.tabelaExames.getValueAt(row, this.getColIndice("Interface"));
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            try {
                ConfiguracaoSerial c = this.equipamento.getSelectedTab().getConfiguracaoPorta(fil_codigo, int_codigo);
                if (c != null && c.getInterfacementoListener() != null && c.getInterfacementoListener() instanceof InterfaceListener) {
                    InterfaceListener lis = (InterfaceListener)c.getInterfacementoListener();
                    while (lis.isRecebendoDados()) {
                        Thread.sleep(2000L);
                    }
                }
                System.out.println("Enviando " + req_codigo);
                String resposta = this.equipamento.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackpos, null, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, "N");
                if (resposta != null) {
                    this.equipamento.novaMensagem(resposta, 0, resposta.startsWith("Erro") ? 5000 : 10000);
                    if (resposta.indexOf("Erro") >= 0 && this.equipamento.configuracao.getPularLinhaErroAutoenvio()) {
                        String req = fil_codigo + req_codigo;
                        req = req + Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
                        this.equipamento.addLinhaErro(req, pac_exames);
                    }
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(this.parent, ex.getMessage(), ex.getStackTrace(), "AbaDefaultNaoEnviados (152)");
            }
        }
    }
}

