/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.labmax100;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ResolvedorResultado;
import jalis.laboratorio.interfaceamento.interfaces.labmax100.Resultado;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.SplashMensagem;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static Connection connectionAccess;
    private static String driveX64;
    private static String driveX86;

    public void buscarResultados() {
        try {
            ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
            String diretorioImportacao = c.getDiretorioImportacao();
            if (!Funcoes.diretorioExiste(diretorioImportacao)) {
                Funcoes.mensagem(Laboratorio.getInstancia(), "Diret\u00f3rio de importa\u00e7\u00e3o n\u00e3o encontrado. Verifique as configura\u00e7\u00f5es do equipamento.", 2);
                return;
            }
            for (File file : new File(diretorioImportacao).listFiles()) {
                File pastaImportados;
                if (!file.getName().toUpperCase().contains(".MDB")) continue;
                String diretorio = file.getAbsolutePath();
                if (!Funcoes.isLinux()) {
                    Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
                    try {
                        connectionAccess = DriverManager.getConnection("jdbc:odbc:".concat(driveX64).concat(";DBQ=").concat(diretorio), "Administrador", "2836540");
                    }
                    catch (Exception e) {
                        try {
                            connectionAccess = DriverManager.getConnection("jdbc:odbc:".concat(driveX86).concat(";DBQ=").concat(diretorio), "Administrador", "2836540");
                        }
                        catch (Exception exception) {
                            throw new ClassNotFoundException(exception.getMessage(), exception.getCause());
                        }
                    }
                    connectionAccess.setAutoCommit(false);
                    connectionAccess.setTransactionIsolation(2);
                } else {
                    Funcoes.mensagem(null, "Para equipamento com conex\u00e3o ODBC \u00e9 necess\u00e1rio Windows para funcionamento verifique", 2);
                }
                ArrayList<String> lista = new ArrayList<String>();
                this.getRequisicoes(lista, 1);
                int qtdeBusca = 0;
                StringBuilder requisicoes = new StringBuilder();
                SplashMensagem msg = SplashMensagem.getInstancia(Laboratorio.getInstancia());
                msg.mostrar("Buscando resultados das requisi\u00e7\u00f5es, por favor aguarde ");
                for (int i = 0; i < lista.size(); ++i) {
                    requisicoes.append("'R-").append((String)lista.get(i)).append("'");
                    if (++qtdeBusca > 50) {
                        qtdeBusca = 0;
                        this.buscaRequisicoes(requisicoes.toString());
                        requisicoes.setLength(0);
                        continue;
                    }
                    requisicoes.append(", ");
                }
                if (qtdeBusca > 0) {
                    this.buscaRequisicoes(requisicoes.deleteCharAt(requisicoes.length() - 2).toString());
                }
                if (!(pastaImportados = new File(diretorioImportacao.concat(File.separator).concat("importados"))).exists()) {
                    pastaImportados.mkdir();
                }
                msg.apagar();
                connectionAccess.commit();
                connectionAccess.close();
                break;
            }
            this.fireAtualizarTabela();
        }
        catch (ClassNotFoundException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "LabMax100:Interfacelistener:112");
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "LabMax100:Interfacelistener:115");
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    private void getRequisicoes(List<String> lista, int abaSelecionada) {
        ArrayList examesPendentes = this.getExamesAba(abaSelecionada);
        PanelAbaAbstrata aba = this.getAba(abaSelecionada);
        for (int i = 0; i < examesPendentes.size(); ++i) {
            Object[] req = (Object[])examesPendentes.get(i);
            if (abaSelecionada == 2) {
                if (!"3;4;5".contains((String)req[aba.getColIndice("Sit")])) continue;
            }
            String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
            if (ParametrosGerais.isAgruparGuiasInterface()) {
                requisicao = (String)req[aba.getColIndice("Multiguia")];
            }
            String tubo = Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboTubo());
            ArrayList tubosFilho = new ArrayList();
            if (this.tuboValido(req)) {
                tubosFilho = (ArrayList)req[20];
                if (!this.contemTubos(tubosFilho)) continue;
                for (Object tuboFilho : tubosFilho) {
                    String requisicaoFormatada = "";
                    tubo = Funcoes.preencheZero((String)tuboFilho, ParametrosGerais.getDigitosTuboTubo());
                    requisicaoFormatada = String.format("%s%s", requisicao, tubo);
                    if (lista.contains(requisicaoFormatada)) continue;
                    lista.add(requisicaoFormatada);
                }
                continue;
            }
            if (lista.contains(requisicao = String.format("%s%s", requisicao, tubo))) continue;
            lista.add(requisicao);
        }
    }

    private boolean tuboValido(Object[] req) {
        return !Funcoes.objectIsNull(req) && req.length > 0 && !Funcoes.objectIsNull(req[20]) && Funcoes.isNumeric(StringUtil.removeCaracteresNaoNumericos(req[20].toString()));
    }

    private boolean contemTubos(ArrayList tubos) {
        return !Funcoes.objectIsNull(tubos) && !tubos.isEmpty();
    }

    private void buscaRequisicoes(String requisicoes) throws SQLException, Exception {
        if (Funcoes.textoVazio(requisicoes)) {
            return;
        }
        List<Resultado> resultados = this.pegaResultadosV2(requisicoes);
        Statement st = Conexao.getStatement();
        for (Resultado resultado : resultados) {
            String req_codigo = resultado.id;
            if (!Funcoes.isNumeric(req_codigo) || req_codigo.length() < ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o fora do padr\u00e3o do jalis (%s) ou n\u00e3o interfaceada", req_codigo));
                continue;
            }
            String fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), rec_codigo, resultado.alternativo);
            if (Funcoes.objectIsNull(int_codigo)) {
                this.fireExcecaoEncontrada("Interfaceamento do exame " + resultado.alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                continue;
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, resultado.alternativo);
            if (Funcoes.objectIsNull(exame)) {
                this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + resultado.alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                continue;
            }
            HashMap<String, Object> dados = new HashMap<String, Object>();
            int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
            resultado.valor = this.arrendondaValor(resultado.valor, fil_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo);
            String campo = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
            dados.put(campo, resultado.valor);
            this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, null, sit < 3 ? 2 : 4);
            this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
            if (!BDUtil.existeExame(fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo)) continue;
            ResolvedorResultado.salvaDados(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo, null, null, dados, null, false, (AbstractInterfaceamentoListener)this);
        }
    }

    private List<Resultado> pegaResultadosV2(String requisicoes) throws SQLException {
        ArrayList<Resultado> resultados = new ArrayList<Resultado>();
        StringBuilder sql = new StringBuilder();
        sql.append("select AssayName, SampleID, Conc from tbTest");
        sql.append(" where SampleID in(").append(requisicoes).append(") ");
        sql.append(" order by SampleID, AssayName");
        Statement stResults = this.createStatement();
        ResultSet rs = this.executeQuery(sql, stResults);
        while (!Funcoes.objectIsNull(rs) && rs.next()) {
            String res;
            Resultado resultado = new Resultado();
            resultado.id = res = rs.getString("SampleID");
            if (res.contains("R-")) {
                resultado.id = res.substring(res.indexOf("-") + 1);
            }
            resultado.alternativo = rs.getString("AssayName");
            resultado.valor = rs.getString("Conc");
            if (Funcoes.textoVazio(resultado.valor)) {
                this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o %s com resultado valor de null alternativo %s", resultado.id, resultado.alternativo));
                continue;
            }
            StringBuilder r = new StringBuilder();
            for (char c : resultado.valor.toCharArray()) {
                if (!Character.isDigit(c) && c != '.') break;
                if (c == '.') {
                    r.append(",");
                    continue;
                }
                r.append(c);
            }
            resultado.valor = r.toString();
            resultados.add(resultado);
        }
        return resultados;
    }

    private Statement createStatement() throws SQLException {
        if (!Funcoes.objectIsNull(connectionAccess)) {
            return connectionAccess.createStatement(1004, 1007);
        }
        return null;
    }

    private ResultSet executeQuery(StringBuilder sql, Statement stResults) throws SQLException {
        if (!Funcoes.objectIsNull(connectionAccess)) {
            return stResults.executeQuery(sql.toString().trim());
        }
        return null;
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return null;
    }

    @Override
    public String getMsgStart() {
        return null;
    }

    @Override
    public String parse(String message) {
        return null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exs;
            for (String exame : exs = exames.split(" ")) {
                this.atualizarSituacaoExame(Conexao.getStatement(), fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, 1);
            }
            if (this.getAbaSelecionada() == 0 || this.getAbaSelecionada() == 1) {
                this.fireAtualizarTabela();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }

    static {
        driveX64 = "DRIVER={Microsoft Access Driver (*.mdb, *.accdb)}";
        driveX86 = "DRIVER={Microsoft Access Driver (*.mdb)}";
    }
}

