/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.kx21n;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private String NOME_EXAME = "HEMOG";
    protected int MAX_PATIENT_NAME_CHARS = 16;
    public static final int EQUIP_TIMEOUT = 5000;
    public static final int MAX_TENTATIVAS = 2;
    public static final int TIPO_REQ_NOVO = 0;
    public static final int TIPO_REQ_REPETICAO = 1;
    String int_codigo;
    String fil_codigo;
    String req_codigo;
    String mco_codigo;
    String rec_codigo;
    String pac_nome;
    String pac_exames;
    String pac_sexo;
    String req_idade;
    String req_data;
    String req_hora;
    String acao;
    String frame;
    int tx_counter = 0;

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        this.fil_codigo = fil_codigo;
        this.int_codigo = int_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.acao = acao;
        try {
            this.encerrarTransmissao();
            pac_nome = StringUtil.removerAcentos(pac_nome.length() > this.MAX_PATIENT_NAME_CHARS ? pac_nome.substring(0, this.MAX_PATIENT_NAME_CHARS) : StringUtil.preencheString(pac_nome, this.MAX_PATIENT_NAME_CHARS, ' ', 0));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    void limpaDadosRequisicao() {
        this.frame = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    public synchronized String parse(String message) {
        String retorno = null;
        Object checksum = null;
        if (message.startsWith(this.getMsgStart())) {
            message = message.replaceFirst(this.getMsgStart(), "");
        }
        if (message.endsWith(this.getMsgEnd())) {
            message = message.replaceFirst(this.getMsgEnd(), "");
        }
        if (message.length() != 119) {
            return "";
        }
        try {
            retorno = this.parseResultado(message);
            if (retorno == null) {
                return "";
            }
            if (retorno.startsWith("Erro")) {
                return retorno;
            }
            Conexao.arquivaSQL();
            RefreshTimer.waitAndRefresh(this, 2000);
            return retorno;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
                return "Erro ao inserir resultados recebidos ao banco de dados";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                return "Erro ao inserir resultados recebidos ao banco de dados";
            }
        }
    }

    private String parseResultado(String message) throws SQLException {
        try {
            String id = message.substring(10, 22);
            System.out.print("id: ");
            System.out.println(id);
            message = message.substring(29);
            System.out.print("msg: ");
            System.out.println(message);
            try {
                id = Long.toString(Long.parseLong(id));
                id = Funcoes.preencheZero(id, ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo());
            }
            catch (Exception ex) {
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + id);
                return null;
            }
            Statement st = Conexao.getStatement();
            String fil_codigo = id.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = id.substring(ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, this.NOME_EXAME);
            System.out.println(fil_codigo);
            System.out.println(req_codigo);
            System.out.println(rec_codigo);
            System.out.println(int_codigo);
            if (int_codigo == null) {
                this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface! Verifique configura\u00e7\u00e3o do exame!");
                return null;
            }
            HashMap<String, Object> hemograma = new HashMap<String, Object>();
            String result = message.substring(0, 5);
            result = result.substring(0, 3) + "," + result.substring(3, 4);
            result = this.removerZero(result);
            hemograma.put("leucocitos", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 2) + "," + result.substring(2, 4);
            result = this.removerZero(result);
            hemograma.put("hemacias", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 3) + "," + result.substring(3, 4);
            result = this.removerZero(result);
            hemograma.put("hgb", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 3) + "," + result.substring(3, 4);
            result = this.removerZero(result);
            hemograma.put("hct", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 3) + "," + result.substring(3, 4);
            result = this.removerZero(result);
            hemograma.put("vcm", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 3) + "," + result.substring(3, 4);
            result = this.removerZero(result);
            hemograma.put("hcm", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 3) + "," + result.substring(3, 4);
            result = this.removerZero(result);
            hemograma.put("chcm", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 4);
            result = this.removerZero(result);
            hemograma.put("plaquetas", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 3) + "," + result.substring(3, 4);
            result = this.removerZero(result);
            hemograma.put("linfocitos_tipicos_percentual", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 3) + "," + result.substring(3, 4);
            result = this.removerZero(result);
            hemograma.put("metamielocitos_percentual", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 3) + "," + result.substring(3, 4);
            result = this.removerZero(result);
            hemograma.put("neutrofilo_percentual", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 3) + "," + result.substring(3, 4);
            result = this.removerZero(result);
            hemograma.put("linfocitos_atipicos_contagem", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 2) + "," + result.substring(2, 4);
            result = this.removerZero(result);
            hemograma.put("metamielocitos_contagem", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 3) + "," + result.substring(3, 4);
            result = this.removerZero(result);
            hemograma.put("neutrofilo_contagem", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 3) + "," + result.substring(3, 4);
            result = this.removerZero(result);
            hemograma.put("rdw_sd", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 3) + "," + result.substring(3, 4);
            result = this.removerZero(result);
            hemograma.put("rdw_cv", result);
            message = message.substring(5);
            result = message.substring(0, 5);
            result = result.substring(0, 3) + "," + result.substring(3, 4);
            result = this.removerZero(result);
            hemograma.put("vpm", result);
            hemograma.put("blastos_percentual", "0");
            hemograma.put("blastos_contagem", "0");
            hemograma.put("promielocitos_percentual", "0");
            hemograma.put("promielocitos_contagem", "0");
            hemograma.put("mielocitos_percentual", "0");
            hemograma.put("mielocitos_contagem", "0");
            hemograma.put("linfocitos_tipicos_contagem", "0");
            hemograma.put("linfocitos_atipicos_percentual", "0");
            hemograma.put("segmentados_contagem", "0");
            hemograma.put("bastonados_percentual", "0");
            hemograma.put("monocitos_percentual", "0");
            hemograma.put("monocitos_contagem", "0");
            hemograma.put("eosinofilos_percentual", "0");
            hemograma.put("eosinofilos_contagem", "0");
            hemograma.put("basofilos_percentual", "0");
            hemograma.put("basofilos_contagem", "0");
            hemograma.put("rdw", "0");
            hemograma.put("hdw", "0");
            hemograma.put("reticulocitos_percentual", "0");
            hemograma.put("reticulocitos_contagem", "0");
            hemograma.put("pct", "0");
            hemograma.put("pdw", "0");
            List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
            if (exames == null || exames.isEmpty()) {
                this.fireExcecaoEncontrada(req_codigo + " - " + "N\u00e3o foi encontrada");
            } else {
                for (BDExame exame : exames) {
                    this.atualizarDadosExame(st, fil_codigo, exame.getRequisicao(), exame.getRecipiente(), exame.getExame(), exame.getMaterial(), int_codigo, hemograma);
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    public void encerrarTransmissao() throws Exception {
        if (this.tx_counter < 2) {
            Statement st = Conexao.getStatement();
            this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
            if (this.acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
        }
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    private void retransmitirRecusado() throws Exception {
        if (this.tx_counter >= 2) {
            this.encerrarTransmissao();
            return;
        }
        this.setTX(5000);
        this.getPortaCOM().write(this.frame);
        ++this.tx_counter;
    }

    public void requisicaoExistente() throws Exception {
        Statement st = Conexao.getStatement();
        this.atualizarSituacaoTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, this.acao.equals("N") ? 1 : 3);
        Conexao.arquivaSQL();
        this.fireMensagemEnviada("Pedido(s) re-enviado(s) com sucesso para " + this.pac_nome + ".", 0, 10000);
        this.interromperTimer();
        this.getPortaCOM().clearInputString();
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela();
        this.setIdle();
    }

    public void alertarWorklistFull() throws Exception {
        this.tx_counter = 2;
        this.encerrarTransmissao();
        this.fireMensagemEnviada("Erro: O worklist est\u00e1 cheio ou o c\u00f3digo de barras est\u00e1 desligado.", 1, 5000);
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(5000);
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
    }

    public void caracterNaoEsperado() throws Exception {
    }

    private void tratarAcknowledge() throws Exception {
        if (this.isTX()) {
            this.encerrarTransmissao();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarNegativeAck() throws Exception {
        if (this.isTX()) {
            this.retransmitirRecusado();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarCancel() throws Exception {
        if (this.isTX()) {
            this.alertarWorklistFull();
        } else {
            this.caracterNaoEsperado();
        }
    }

    private void tratarDelete() throws Exception {
        if (this.isTX()) {
            this.requisicaoExistente();
        } else {
            this.caracterNaoEsperado();
        }
    }

    @Override
    public void handShakeCharReceived(final char c) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    switch (c) {
                        case '\u0006': {
                            InterfaceListener.this.tratarAcknowledge();
                            break;
                        }
                        case '\u0015': {
                            InterfaceListener.this.tratarNegativeAck();
                            break;
                        }
                        case '\u0018': {
                            InterfaceListener.this.tratarCancel();
                            break;
                        }
                        case '\u007f': {
                            InterfaceListener.this.tratarDelete();
                            break;
                        }
                        default: {
                            InterfaceListener.this.caracterNaoEsperado();
                            break;
                        }
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao estabelecer comunica\u00e7\u00e3o com o equipamento.", 1, 5000);
                    InterfaceListener.this.setIdle();
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = InterfaceListener.this.getPortaCOM().removeInputString(InterfaceListener.this.getMsgEnd());
                    if (!message.equals("")) {
                        String retorno = InterfaceListener.this.parse(message);
                        if (retorno != null && !retorno.equals("")) {
                            if (retorno.startsWith("Erro")) {
                                InterfaceListener.this.fireExcecaoEncontrada(retorno);
                            }
                            InterfaceListener.this.fireMensagemEnviada(retorno, 0, 10000);
                        }
                        InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0006'));
                        if (InterfaceListener.this.isRX()) {
                            InterfaceListener.this.aguardarProximoFrame();
                        }
                    } else if (InterfaceListener.this.isRX()) {
                        InterfaceListener.this.aguardarProximoFrame();
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else if (this.isRX()) {
                if (this.frame != null) {
                    this.abortarRecepcao();
                } else {
                    this.setIdle();
                }
            } else {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    private String removerZero(String valor) {
        while (valor.indexOf("0") == 0) {
            valor = valor.substring(1);
        }
        return valor;
    }
}

