/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.kc4;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final int TIME_RX = 5000;
    private static final String EXAME = "exame";
    private static final String ID = "id";
    private static final String VALUE1 = "value1";
    private static final String VALUE2 = "value2";
    private static final String RESULTADO = "resultado";
    private static final String UNIT = "unit";
    private static final String FLAG = "flag";
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    @Override
    public void dataChanged() {
        String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
        if (!Funcoes.textoVazio(message)) {
            this.addListaRecebimento(message);
            this.restartThreadRecebimento();
        } else if (this.isRX()) {
            try {
                this.aguardarProximoFrame();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        if (message.startsWith(this.getMsgStart()) && message.endsWith(this.getMsgEnd())) {
            try {
                HashMap<String, String> fields = this.parseFields(message);
                String emi_alternativo = fields.get(EXAME).trim();
                String id = fields.get(ID);
                String sampleID = this.getRequisicaoRack(id);
                if (Funcoes.textoVazio(sampleID)) {
                    this.fireExcecaoEncontrada(String.format(" Id da rack %s n\u00e3o localizada ", id));
                    return "";
                }
                String fil_codigo = sampleID.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String rec_codigo = sampleID.substring(sampleID.length() - ParametrosGerais.getDigitosTuboTubo());
                String req_codigo = sampleID.substring(ParametrosGerais.getDigitosTuboFilial(), sampleID.length() - ParametrosGerais.getDigitosTuboTubo());
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada(String.format("N\u00e3o encontrado o c\u00f3digo da interface para o alternativo %s amostra %s %s %s", emi_alternativo, fil_codigo, req_codigo, rec_codigo));
                    return "";
                }
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada(String.format("N\u00e3o encontrado exame para o alternativo %s amostra %s %s %s", emi_alternativo, fil_codigo, req_codigo, rec_codigo));
                    return "";
                }
                String exa_codigo = exame.getNomeExame();
                String mco_codigo = exame.getCodigoMaterial();
                String resultado = fields.get(RESULTADO).trim();
                String value1 = fields.get(VALUE1).trim();
                String value2 = fields.get(VALUE2).trim();
                resultado = resultado.replaceAll("\\.", ",");
                String flag = fields.get(FLAG).trim();
                if (flag != null && flag.equals("E")) {
                    this.fireExcecaoEncontrada("Exame " + exa_codigo + " para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo + " com erro");
                    return "";
                }
                Statement st = Conexao.getStatement();
                int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
                String resultType = fields.get(UNIT).trim();
                String campo = "";
                if (resultType.equalsIgnoreCase("GL")) {
                    campo = "concentration";
                } else if (resultType.equalsIgnoreCase("%")) {
                    campo = "acl_activity";
                } else if (resultType.equalsIgnoreCase("S")) {
                    campo = "time";
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                dados.put(campo, resultado);
                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, dados);
                this.fireAtualizarTabela(2);
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        } else {
            this.fireExcecaoEncontrada("Mensagem incompleta pois n\u00e3o possui caracter inicial do bloco de resultado!");
        }
        return null;
    }

    private HashMap<String, String> parseFields(String message) {
        HashMap<String, String> fields = new HashMap<String, String>();
        fields.put(EXAME, message.substring(1, 6));
        fields.put(ID, message.substring(7, 16));
        fields.put(VALUE1, message.substring(17, 22));
        fields.put(VALUE2, message.substring(23, 28));
        fields.put(RESULTADO, message.substring(29, 34));
        fields.put(UNIT, message.substring(35, 37));
        fields.put(FLAG, message.substring(38, 39));
        System.out.println("exame= " + (String)fields.get(EXAME) + " size " + ((String)fields.get(EXAME)).length());
        System.out.println("id= " + (String)fields.get(ID) + " size " + ((String)fields.get(ID)).length());
        System.out.println("value1= " + (String)fields.get(VALUE1) + " size " + ((String)fields.get(VALUE1)).length());
        System.out.println("value2= " + (String)fields.get(VALUE2) + " size " + ((String)fields.get(VALUE2)).length());
        System.out.println("resultado= " + (String)fields.get(RESULTADO) + " size " + ((String)fields.get(RESULTADO)).length());
        System.out.println("unit= " + (String)fields.get(UNIT) + " size " + ((String)fields.get(UNIT)).length());
        System.out.println("flag= " + (String)fields.get(FLAG) + " size " + ((String)fields.get(FLAG)).length());
        return fields;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            String[] exmes;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            int digitosRequisicao = ParametrosGerais.getDigitosTuboRequisicao();
            int tamanho = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
            if (tamanho > 9) {
                int dif = tamanho - 9;
                digitosRequisicao = ParametrosGerais.getDigitosTuboRequisicao() - dif;
            }
            rackposition = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(Integer.parseInt(req_codigo), digitosRequisicao);
            String[] stringArray = exmes = exames.split(" ", 0);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String exame;
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame = stringArray[i], mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, rackposition, situacao < 2 ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        public boolean listaDeExamesProcessando() {
            return this.listaRecebimento.size() > 0;
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
                if (!InterfaceListener.this.equipamento.getStatusFecharInterfaceamento().isExportando()) {
                    InterfaceListener.this.fireAtualizarTabela(2);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

