/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.integra;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final int BLOCK_SYNC = 0;
    private static final int BLOCK_PATIENT_RESULT = 4;
    private static final int BLOCK_RESULT_REQUEST = 9;
    private static final int BLOCK_ORDER_ENTRY = 10;
    private static final int BLOCK_ORDER_RESPONSE = 19;
    private static final int BLOCK_MULTI_CONFIGURATION = 60;
    private static final int BLOCK_SAMPLE_TUBO_INFO = 62;
    private static final int BLOCK_SERVICE_REQUEST_RESPONSE = 69;
    private static final int BLOCK_CONTROLE_MESSAGE = 99;
    public static final String INSTRUMENT_CODE = "14";
    public static final String INSTRUMENT_IDENTIFIER = "COBAS INTEGRA400";
    public static final int INSTRUMENT_TIMEOUT = 10000;
    public static final int MAX_PATIENT_NAME_CHARS = 15;
    InfoExameRequisicao ultimo_enviado = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);
    String ultimo_enviado_acao = null;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    private ArrayList<RequisacaoRack> listaEnvio = new ArrayList();
    private boolean syncCounter = false;
    private Date dateLastMessageReceive = null;
    protected boolean curva = false;
    protected String rec_tuboPai = "";
    protected List<String> examesFilho = new LinkedList<String>();

    public InterfaceListener() {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(2000L);
                    while (true) {
                        if (InterfaceListener.this.dateLastMessageReceive == null || (new Date().getTime() - InterfaceListener.this.dateLastMessageReceive.getTime()) / 1000L >= 20L) {
                            InterfaceListener.this.sincronizar();
                            continue;
                        }
                        Thread.sleep(30000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return;
                }
            }
        }.start();
    }

    @Override
    public String getMsgEnd() {
        StringBuilder msg = new StringBuilder();
        msg.append('\u0004').append('\n');
        return msg.toString();
    }

    @Override
    public String getMsgStart() {
        StringBuilder msg = new StringBuilder();
        msg.append('\u0001').append('\n');
        return msg.toString();
    }

    @Override
    public String parse(String message) {
        if (message.startsWith(this.getMsgStart())) {
            String[] temp = message.split(String.valueOf('\n'));
            ArrayList<String> lines = new ArrayList<String>();
            for (String t : temp) {
                lines.add(t);
            }
            lines.remove(0);
            String heading = (String)lines.remove(0);
            int block_type = Integer.parseInt(heading.substring(heading.length() - 2));
            switch (block_type) {
                case 0: {
                    return this.parseBlockSync(lines);
                }
                case 62: {
                    return this.parseBlockHostQuery(lines);
                }
                case 69: {
                    return this.parseBlockServiceRequestResponse(lines);
                }
                case 19: {
                    return this.parseOrderResponse(lines);
                }
                case 4: {
                    return this.parsePatientResult(lines);
                }
                case 99: {
                    this.sincronizar();
                    return "";
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        if (acao.equals("A")) {
            Statement st = Conexao.getStatement();
            try {
                String[] stringArray = exames.split(" ");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String exame;
                    int sitAtual = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame = stringArray[i], mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, sitAtual < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    private void enviarProximaRequisicao() {
        try {
            RequisacaoRack requisicao = this.listaEnvio.remove(0);
            String codigo = requisicao.getRequisicao().trim();
            if (codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("C\u00f3digo recebido \u00e9 inv\u00e1lido " + codigo);
                return;
            }
            String rack = requisicao.getRack().trim();
            String fil_codigo = codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = codigo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String rec_codigo = codigo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            String exames = "";
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList<String>();
            if (req != null) {
                exames = (String)req[aba.getColIndice("Exame")];
            } else {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (req != null) {
                    exames = exames + " ";
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        exames = exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    exames = exames.trim();
                }
            }
            if (req == null) {
                if (this.listaEnvio.size() > 0) {
                    this.enviarProximaRequisicao();
                    return;
                }
                this.sincronizar();
                return;
            }
            String[] examesEnviar = exames.split(" ");
            String mco_codigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
            String int_codigo = (String)req[aba.getColIndice("Interface")];
            String pac_nome = (String)req[aba.getColIndice("Paciente")];
            String pac_idade = (String)req[aba.getColIndice("Ide")];
            String pac_sexo = (String)req[aba.getColIndice("S")];
            String data = TempoUtil.getCurrentDateBr();
            String hora = TempoUtil.getCurrentTime();
            this.setTX(10000);
            String retorno = "Enviando " + pac_nome + " para o equipamento";
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            if (codigo.length() < 15) {
                while (codigo.length() < 15) {
                    codigo = codigo + " ";
                }
            }
            pac_nome = StringUtil.removerAcentos(pac_nome.length() > 15 ? pac_nome.substring(0, 15) : StringUtil.preencheString(pac_nome, 15, ' ', 0));
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(exames.split(" ", 0), mco_codigo);
            Statement st = Conexao.getStatement();
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            if ((exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva)) != null) {
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            } else {
                String nomeExame = "";
                exa_lista = ExamesUtil.anexarCodigoMaterial(examesEnviar, mco_codigo);
                if (exa_lista != null && exa_lista.length > 0) {
                    nomeExame = exa_lista[0].getNomeExame();
                }
                if (this.isNull(fil_codigo, req_codigo, rec_codigo, int_codigo, nomeExame, mco_codigo)) {
                    this.fireExcecaoEncontrada("Existem par\u00e2metros passados ao exame desmembrado com valor nulo ou vazio.\n " + exa_lista[0].getNomeExame() + " " + req_codigo);
                    return;
                }
                this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_lista[0].getNomeExame(), mco_codigo);
                exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
            }
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            if (!exa_listaCurva.isEmpty()) {
                if (alternativos != null && alternativos.length == 1) {
                    alternativos = null;
                }
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, st, exa_listaCurva, this.rec_tuboPai, true, this.examesFilho);
            }
            StringBuilder blockData = new StringBuilder();
            blockData.append("53").append(String.valueOf(' ')).append(codigo.toString()).append(String.valueOf(' ')).append(data).append(String.valueOf(' ')).append("???").append(String.valueOf('\n'));
            blockData.append("54").append(String.valueOf(' ')).append("000").append(String.valueOf(' ')).append("00").append(String.valueOf(' ')).append("A").append(String.valueOf('\n'));
            if (alternativos != null) {
                for (ExameMaterial temp : alternativos) {
                    if (temp == null || Funcoes.textoVazio(temp.getNomeExame())) continue;
                    blockData.append("55").append(String.valueOf(' ')).append(Funcoes.preencheVazio(temp.getNomeExame(), 3, 1)).append(String.valueOf('\n'));
                }
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    for (ExameMaterial temp : alternativosCurva.get(key)) {
                        if (temp == null || Funcoes.textoVazio(temp.getNomeExame())) continue;
                        blockData.append("55").append(String.valueOf(' ')).append(Funcoes.preencheVazio(temp.getNomeExame(), 3, 1)).append(String.valueOf('\n'));
                    }
                }
            }
            String worklist = this.makeFrame(10, blockData.toString());
            this.ultimo_enviado = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, exames, rack);
            this.ultimo_enviado.setInterface(int_codigo);
            this.ultimo_enviado_acao = "N";
            this.getPortaCOM().write(worklist);
            Conexao.arquivaSQL();
            this.setIdle();
            this.fireMensagemEnviada("Enviando " + pac_nome + " para o equipamento", 0, 10000);
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            this.fireMensagemEnviada("Erro ao enviar exames: " + e.toString(), 0, 10000);
        }
    }

    private boolean isNull(String fil_codigo, String req_codigo, String rec_codigo, String int_codigo, String nomeExame, String mco_codigo) {
        return Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(rec_codigo) || Funcoes.textoVazio(int_codigo) || Funcoes.textoVazio(nomeExame) || Funcoes.textoVazio(mco_codigo);
    }

    private boolean isNull() {
        return false;
    }

    private void deleteOrderRequest(String codigo, String rack) {
        StringBuilder blockData = new StringBuilder();
        blockData.append("53").append(String.valueOf(' ')).append(codigo.toString()).append(String.valueOf(' ')).append(TempoUtil.getCurrentDateBr()).append(String.valueOf(' ')).append("???").append(String.valueOf('\n'));
        String worklist = this.makeFrame(10, blockData.toString());
        try {
            this.getPortaCOM().write(worklist);
        }
        catch (Exception e) {
            this.fireMensagemEnviada("Erro ao enviar block de sincronismo para o equipamento (" + e.getMessage() + ").", 1, 5000);
            e.printStackTrace();
        }
    }

    private void sincronizar() {
        StringBuilder msg = new StringBuilder();
        msg.append(this.getMsgStart());
        msg.append(INSTRUMENT_CODE).append(String.valueOf(' ')).append(INSTRUMENT_IDENTIFIER).append(String.valueOf(' ')).append(Funcoes.preencheZero(0, 2)).append(String.valueOf('\n'));
        msg.append('\u0002').append(String.valueOf('\n'));
        msg.append('\u0003').append(String.valueOf('\n'));
        msg.append('\u0004').append(String.valueOf('\n'));
        try {
            Thread.sleep(5000L);
            this.getPortaCOM().write(msg.toString());
        }
        catch (Exception e) {
            this.fireMensagemEnviada("Erro ao enviar block de sincronismo para o equipamento (" + e.getMessage() + ").", 1, 5000);
            e.printStackTrace();
        }
    }

    private String parseBlockSync(ArrayList<String> lines) {
        lines.remove(0);
        lines.remove(0);
        String SC = lines.remove(0);
        this.syncCounter = SC.equalsIgnoreCase("0");
        if (this.syncCounter) {
            this.sendRequestWorklist();
        } else {
            this.sendRequestResults();
        }
        return "";
    }

    private void sendRequestWorklist() {
        StringBuilder data = new StringBuilder();
        data.append("40 1").append(String.valueOf('\n'));
        String msg = this.makeFrame(60, data.toString());
        try {
            Thread.sleep(5000L);
            this.getPortaCOM().write(msg.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendRequestResults() {
        StringBuilder data = new StringBuilder();
        data.append("10 7").append(String.valueOf('\n'));
        String msg = this.makeFrame(9, data.toString());
        try {
            Thread.sleep(5000L);
            this.getPortaCOM().write(msg.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String parseBlockHostQuery(ArrayList<String> lines) {
        lines.remove(0);
        while (lines.size() > 0) {
            String line = lines.remove(0);
            if (line.length() < 23) continue;
            String lineCode = line.substring(0, 2);
            String rack = line.substring(2, 9);
            String codigo = line.substring(12, 27);
            RequisacaoRack req = new RequisacaoRack(rack, codigo);
            this.listaEnvio.add(req);
        }
        if (this.listaEnvio.size() > 0) {
            this.enviarProximaRequisicao();
        } else {
            this.sincronizar();
        }
        return "";
    }

    private String parseBlockServiceRequestResponse(ArrayList<String> lines) {
        lines.remove(0);
        String line = lines.remove(0);
        lines.remove(0);
        String SC = lines.remove(0);
        this.syncCounter = SC.equalsIgnoreCase("0");
        int lineCode = Integer.parseInt(line.substring(0, 2));
        int errorCode = Integer.parseInt(line.substring(3, 5));
        switch (errorCode) {
            case 61: {
                this.sendRequestResults();
                return "Host-Query vazio";
            }
        }
        return "";
    }

    private String parseOrderResponse(ArrayList<String> lines) {
        this.equipamento.getAbaNaoEnviados().reloadExames();
        this.equipamento.getAbaProntos().reloadExames();
        lines.remove(0);
        String retorno = "";
        try {
            Statement st = Conexao.getStatement();
            String ier_rackpos = this.ultimo_enviado.getRack();
            String fil_codigo = this.ultimo_enviado.getFilial();
            String req_codigo = this.ultimo_enviado.getCodigo();
            String rec_codigo = this.ultimo_enviado.getRecipiente();
            String mco_codigo = this.ultimo_enviado.getMaterial();
            String examesEnviados = this.ultimo_enviado.getExames();
            String int_codigo = this.ultimo_enviado.getInterface();
            if (int_codigo == null) {
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, examesEnviados.split(" ")[0].trim());
            }
            if (Funcoes.textoVazio(examesEnviados)) {
                this.fireExcecaoEncontrada("N\u00e3o foi encontrado os exames enviados para a requisi\u00e7\u00e3o :" + fil_codigo + " " + req_codigo + " " + rec_codigo);
                return "Erro ao receber confirma\u00e7\u00e3o de worklist.";
            }
            ArrayList<String> examesRecusados = new ArrayList<String>();
            while (lines.size() > 0) {
                String line = lines.remove(0);
                if (!line.startsWith("55")) continue;
                examesRecusados.add(line.substring(3, 6));
            }
            if (examesRecusados.size() > 0) {
                for (int i = 0; i < examesRecusados.size(); ++i) {
                    String recusado = (String)examesRecusados.get(i);
                    ExameMaterial exa_codigo = BDUtil.getReqExameLIS(st, fil_codigo, int_codigo, req_codigo, rec_codigo, recusado);
                    if (exa_codigo == null) continue;
                    examesRecusados.set(i, exa_codigo.getNomeExame());
                }
            }
            ExameMaterial[] last_tests = ExamesUtil.anexarCodigoMaterial(examesEnviados.split(" ", 0), mco_codigo);
            ExameMaterial[] last_tests_alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, last_tests);
            boolean enviou = false;
            for (int i = 0; i < last_tests.length; ++i) {
                int situacao;
                ExameMaterial exa_codigo = last_tests[i];
                int sit = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo.getNomeExame(), exa_codigo.getCodigoMaterial(), rec_codigo);
                if (examesRecusados.contains(exa_codigo.getNomeExame())) {
                    StringBuilder msg = new StringBuilder("Requisi\u00e7\u00e3o (").append(req_codigo).append(") - O exame ").append(exa_codigo).append(" foi recusado pelo equipamento.");
                    this.fireExcecaoEncontrada(msg.toString());
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo.getNomeExame(), exa_codigo.getCodigoMaterial(), int_codigo, null, sit);
                    continue;
                }
                if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                    for (String exame : this.examesFilho) {
                        int situacao2 = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, exa_codigo.getNomeExame(), mco_codigo, this.rec_tuboPai, exame, mco_codigo);
                        BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exa_codigo.getNomeExame(), mco_codigo, exame, mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                    }
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo.getNomeExame(), mco_codigo, rec_codigo);
                    if (BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exa_codigo.getNomeExame(), mco_codigo, this.rec_tuboPai)) {
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, this.rec_tuboPai, exa_codigo.getNomeExame(), mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                    }
                } else if (!this.examesFilho.isEmpty()) {
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo.getNomeExame(), mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo.getNomeExame(), mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                    BDUtil.setExmSituacaoTodosFilhos(st, fil_codigo, int_codigo, req_codigo, exa_codigo.getNomeExame(), mco_codigo, rec_codigo, situacao < 2 ? 1 : 3);
                } else {
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo.getNomeExame(), mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo.getNomeExame(), mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                }
                enviou = true;
            }
            Conexao.arquivaSQL();
            if (enviou) {
                String pac_nome = BDUtil.getNomePaciente(fil_codigo, req_codigo);
                retorno = "Exames enviados para " + (pac_nome == null ? req_codigo : pac_nome);
                if (this.ultimo_enviado_acao.equals("N")) {
                    this.firePacienteEnviado(req_codigo, pac_nome, this.ultimo_enviado.getSexo(), this.ultimo_enviado.getIdade(), this.ultimo_enviado.getData(), this.ultimo_enviado.getHora(), this.ultimo_enviado.getExames());
                }
            }
            if (this.listaEnvio.size() > 0) {
                this.enviarProximaRequisicao();
            } else {
                this.sincronizar();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex1) {
                ErrorLogger.mostraMensagem(null, ex1.getMessage(), ex1.getStackTrace());
            }
            retorno = "Erro ao receber confirma\u00e7\u00e3o de worklist.";
        }
        return retorno;
    }

    public String parsePatientResult(ArrayList<String> lines) {
        try {
            lines.remove(0);
            String retorno = null;
            Statement st = Conexao.getStatement();
            String fil_codigo = null;
            String req_codigo = null;
            String rec_codigo = null;
            String emi_alternativo = null;
            String int_codigo = null;
            while (!lines.isEmpty()) {
                String exa_codigo;
                String line = lines.remove(0);
                if (line.startsWith("53")) {
                    String codigo = line.substring(3, 18).trim();
                    if (!Funcoes.isNumeric(codigo.toLowerCase().substring(codigo.length() - 1))) {
                        codigo = codigo.substring(0, codigo.length() - 1);
                    }
                    try {
                        Long.parseLong(codigo);
                    }
                    catch (Exception e) {
                        break;
                    }
                    if (codigo.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                        this.fireExcecaoEncontrada("N\u00e3o foi encontrado nenhuma configura\u00e7\u00e3o de interface para a requisi\u00e7\u00e3o :" + codigo);
                        break;
                    }
                    fil_codigo = codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    req_codigo = codigo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                    rec_codigo = codigo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
                    continue;
                }
                if (line.startsWith("55")) {
                    emi_alternativo = line.substring(3, 6).trim();
                    continue;
                }
                if (!line.startsWith("00")) continue;
                int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                String exr_resultado = line.substring(3, 16);
                if (Funcoes.textoVazio(int_codigo)) {
                    this.fireExcecaoEncontrada("N\u00e3o foi encontrado nenhuma configura\u00e7\u00e3o de interface para a requisi\u00e7\u00e3o :" + fil_codigo + " " + req_codigo + " " + rec_codigo + " com o alternativo " + (emi_alternativo == null ? "" : emi_alternativo));
                    break;
                }
                ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("N\u00e3o foi encontrada nenhum exame como o alternativo: [" + emi_alternativo + "] para a requisi\u00e7\u00e3o " + fil_codigo + " - " + req_codigo + " - " + rec_codigo);
                    break;
                }
                String mco_codigo = exame.getCodigoMaterial();
                exr_resultado = Funcoes.resolverDouble(exr_resultado);
                exr_resultado = this.arrendondaValor(exr_resultado, fil_codigo, exame.getNomeExame(), mco_codigo, int_codigo);
                req_codigo = StringUtil.preencheString(req_codigo, ParametrosGerais.getDigitosTuboRequisicao(), '0', 1);
                rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
                String string = exa_codigo = exame != null ? exame.getNomeExame() : null;
                if (exa_codigo != null) {
                    this.atualizarResultadoExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, exr_resultado.replaceAll("\\.", ","));
                    continue;
                }
                retorno = "Erro ao receber resultado(s) de exame(s) da requisi\u00e7\u00e3o (" + req_codigo + ").";
                String msg = "Erro ao receber resultado (" + req_codigo + ") - Nenhum exame de c\u00f3d. alternativo " + emi_alternativo + " foi encontrado no sistema.";
                this.fireExcecaoEncontrada(msg);
            }
            Conexao.arquivaSQL();
            StringBuilder data = new StringBuilder();
            data.append("10 7").append(String.valueOf('\n'));
            String msg = this.makeFrame(9, data.toString());
            try {
                this.getPortaCOM().write(msg.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return retorno;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return null;
        }
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = InterfaceListener.this.getPortaCOM().getInputString();
                    if (!message.equals("") && message.indexOf(InterfaceListener.this.getMsgEnd()) >= 0) {
                        InterfaceListener.this.dateLastMessageReceive = new Date();
                        message = InterfaceListener.this.getPortaCOM().removeInputString(InterfaceListener.this.getMsgEnd());
                        if (!message.startsWith(InterfaceListener.this.getMsgStart()) && message.indexOf(InterfaceListener.this.getMsgStart()) > 0) {
                            message = message.substring(message.indexOf(InterfaceListener.this.getMsgStart()));
                        }
                        if (!message.startsWith('\n' + InterfaceListener.this.getMsgStart()) && message.indexOf(InterfaceListener.this.getMsgStart()) > 0) {
                            message = message.substring(message.indexOf('\n' + InterfaceListener.this.getMsgStart()));
                        }
                        InterfaceListener.this.addListaRecebimento(message);
                        InterfaceListener.this.restartThreadRecebimento();
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    private void abortarTransmissao() throws Exception {
        this.limpaDadosRequisicao();
        this.fireMensagemEnviada("Tempo esgotado ao transmitir dados ao equipamento", 1, 5000);
    }

    private void limpaDadosRequisicao() {
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        try {
            if (this.isTX()) {
                this.abortarTransmissao();
            } else {
                this.setIdle();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.limpaDadosRequisicao();
            this.setIdle();
        }
    }

    @Override
    public void handShakeCharReceived(char c) {
        if (c == '\u0004') {
            try {
                String message = this.getPortaCOM().getInputString();
                if (!message.equals("")) {
                    this.getPortaCOM().clearInputString();
                    if (!message.endsWith(String.valueOf('\n'))) {
                        message = message + String.valueOf('\n');
                    }
                    if (!message.startsWith(this.getMsgStart()) && message.indexOf(this.getMsgStart()) > 0) {
                        message = message.substring(message.indexOf(this.getMsgStart()));
                    }
                    this.addListaRecebimento(message);
                    this.restartThreadRecebimento();
                }
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                try {
                    Conexao.anulaSQL();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        }
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    private String makeFrame(int block, String data) {
        StringBuilder msg = new StringBuilder();
        msg.append(this.getMsgStart());
        msg.append(INSTRUMENT_CODE).append(String.valueOf(' ')).append(INSTRUMENT_IDENTIFIER).append(String.valueOf(' ')).append(Funcoes.preencheZero(block, 2)).append(String.valueOf('\n'));
        msg.append('\u0002').append(String.valueOf('\n'));
        if (!Funcoes.textoVazio(data)) {
            msg.append(data);
        }
        msg.append('\u0003').append(String.valueOf('\n'));
        msg.append(this.syncCounter ? "1" : "0").append(String.valueOf('\n'));
        String check = this.calculateBlockCheck(msg.toString());
        check = Funcoes.preencheVazio(check, 3, 1);
        msg.append(check).append(String.valueOf('\n'));
        msg.append('\u0004').append(String.valueOf('\n'));
        this.syncCounter = !this.syncCounter;
        return msg.toString();
    }

    private String calculateBlockCheck(String msg) {
        int sum = 0;
        for (int i = 0; i < msg.length(); ++i) {
            sum += (byte)msg.charAt(i);
        }
        return Integer.toString(sum % 1000);
    }

    @Override
    public void teste() {
        StringBuilder tmp = new StringBuilder();
        tmp.append("[SOH][LF]14[SP]COBAS[SP]INTEGRA400[SP]04[LF][STX][LF]53[SP]010006456304[SP][SP][SP][SP]22/05/2013[SP]SER[LF]55[SP]");
        tmp.append("[SP]10[LF]00[SP][SP]1.246265E+02[SP]mg/dl[SP][SP][SP][SP]0[SP][SP][SP]0[SP][SP][SP]0[SP][SP][SP]0[SP][SP]0.0");
        tmp.append("00000E+00[LF][ETX][LF]0[LF]891[LF][EOT][LF]");
        ArrayList<String> req = new ArrayList<String>();
        req.add("STX");
        req.add("10     01ABC   010006456304");
        this.parseBlockHostQuery(req);
    }

    class RequisacaoRack {
        String rack;
        String requisicao;

        public RequisacaoRack(String rack, String requisicao) {
            this.rack = rack;
            this.requisicao = requisicao;
        }

        public String getRack() {
            return this.rack;
        }

        public String getRequisicao() {
            return this.requisicao;
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado == null) continue;
                    InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

