/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.immulite2k;

import jalis.comum.Conexao;
import jalis.laboratorio.interfaceamento.interfaces.immulite2k.InterfaceListener;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Hashtable;

public class RecordParser
extends ASTMRecordParser {
    private String starting_range = null;
    private String ending_range = null;
    private String test_id = null;
    private boolean modoHostQuery = false;
    private boolean receberResultadosRepetidosPeloEquipamento = false;

    public RecordParser(InterfaceListener interfaceListener) {
        super.setInterfaceASTMListener(interfaceListener);
        this.receberResultadosRepetidosPeloEquipamento = this.equip instanceof InterfaceListener && ((InterfaceListener)this.equip).isReceberResultadosRepetidosPeloEquipamento();
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        Hashtable result_fields;
        int sequence;
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        if ((sequence = Integer.parseInt((String)(result_fields = ASTMStandard.parseDefaultResultRecord(record)).get(ASTMStandard.RESULT_FIELD_SEQUENCE_ID))) > 1) {
            return;
        }
        String result_status = (String)result_fields.get(ASTMStandard.RESULT_FIELD_RESULT_STATUS);
        if (result_status != null) {
            this.equip.getClass();
            if (!result_status.equals("F")) {
                this.equip.getClass();
                if (!result_status.equals("R")) {
                    this.equip.getClass();
                    if (!result_status.equals("C")) {
                        this.exame_atual = null;
                        return;
                    }
                }
            }
        }
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String int_codigo = (String)this.exame_atual.get(INT_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String exa_codigo = (String)this.exame_atual.get(EXA_CODIGO);
        String mco_codigo = (String)this.exame_atual.get(MCO_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String resultado = (String)result_fields.get(ASTMStandard.RESULT_FIELD_MEASUREMENT_VALUE);
        resultado = resultado.replaceAll("\\.", ",");
        String flag = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flag != null && (flag.equals("<") || flag.equals(">")) && resultado.charAt(0) != '<' && resultado.charAt(0) != '>') {
            resultado = flag + " " + resultado;
        }
        Statement st = Conexao.getStatement();
        String campoQuanti = "resultado_quantitativo";
        String campoQuali = "resultado_qualitativo";
        if (int_codigo == null) {
            String emi_alternativo = (String)result_fields.get(ASTMStandard.RESULT_FIELD_TEST_ID);
            if (emi_alternativo.contains("^")) {
                emi_alternativo = emi_alternativo.replaceAll("[\\^]", "");
            }
            if ((int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo)) == null) {
                this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                return;
            }
        }
        int sit = this.equip.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exa_codigo, mco_codigo, rec_codigo);
        if (this.receberResultadosRepetidosPeloEquipamento && sit == 2 || sit == 3) {
            campoQuanti = "repeticao_quantitativo";
            campoQuali = "repeticao_qualitativo";
            this.equip.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exa_codigo, mco_codigo, int_codigo, null, 3);
        }
        if (!this.receberResultadosRepetidosPeloEquipamento && sit == 2 || sit == 7 || sit == 4) {
            this.equip.fireExcecaoEncontrada(String.format("Interfaceamento do exame %s para requisi\u00e7\u00e3o %s %s %s com situa\u00e7\u00e3o %s ", exa_codigo, fil_codigo, req_codigo, rec_codigo, sit == 2 ? "pronto " : (sit == 4 ? " j\u00e1 repetido " : "validado ")));
            return;
        }
        this.exame_atual.put(campoQuanti, resultado);
    }

    @Override
    protected void trataRequestRecord(String record) throws Exception {
        Hashtable comps = ASTMStandard.parseDefaultRequestRecord(record);
        this.starting_range = (String)comps.get(ASTMStandard.REQUEST_FIELD_STARTING_RANGE_ID);
        this.ending_range = (String)comps.get(ASTMStandard.REQUEST_FIELD_ENDING_RANGE_ID);
        this.test_id = (String)comps.get(ASTMStandard.REQUEST_FIELD_TEST_ID);
        this.modoHostQuery = true;
    }

    @Override
    protected void trataTerminationRecord() throws Exception {
        if (this.modoHostQuery) {
            this.equip.responderRequest(this.starting_range, this.ending_range, this.test_id);
            this.modoHostQuery = false;
            return;
        }
        if (this.exame_atual == null) {
            return;
        }
        this.salvaExame(this.exame_atual);
        this.exame_atual = null;
    }
}

