/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.immulite2k;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.immulite2k.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.immulite2k.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.CodString;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends InterfaceASTMListener {
    protected int MAX_PATIENT_NAME_CHARS = 30;
    protected int MAX_EXAMES = 10;
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean hostQuery = false;
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        RecordParser record = new RecordParser(this);
        super.setASTMRecordParser(record);
        this.INSTRUMENT_NAME = "IMMULITE2K";
    }

    public boolean isReceberResultadosRepetidosPeloEquipamento() {
        return this.configuracao.isReceberResultadosRepetidosPeloEquipamento();
    }

    @Override
    public String getErroTraduzido(String erro) {
        return erro;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            int i;
            Object exameCurva;
            System.out.println("A\u00e7\u00e3o recebida: " + acao);
            System.out.println("Exame: " + pac_exames);
            System.out.println("Requisicao: " + req_codigo);
            if (acao.equalsIgnoreCase("C")) {
                return "";
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.trim().split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            if (this.configuracao.getModoHostQuery() && !this.hostQuery) {
                if (acao.equalsIgnoreCase("A")) {
                    this.encerrarTransmissao();
                }
            }
            Statement st = Conexao.getStatement();
            if (this.exames.length > this.MAX_EXAMES) {
                String[] exas = new String[this.MAX_EXAMES];
                for (int i2 = 0; i2 < this.MAX_EXAMES; ++i2) {
                    exas[i2] = this.exames[i2];
                }
                this.exames = exas;
            }
            ExameMaterial[] alternativos = null;
            ExameMaterial[] listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            PortaCOM porta = (PortaCOM)this.getPortaCOM();
            String databits = String.valueOf(porta.getDataBits());
            String parity = String.valueOf(porta.getParity());
            String stop = String.valueOf(porta.getStopBits());
            String control = databits + (parity.equals("0") ? "N" : parity) + stop;
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String exame = exa_lista[0].toString();
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            String tipo_amostra = "";
            if (exa_lista != null) {
                tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, (exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista))[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exame, mco_codigo, int_codigo);
                }
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.removeDuplicados(alternativos);
            }
            if (!exa_listaCurva.isEmpty()) {
                exameCurva = new ArrayList();
                for (ExameMaterial exameMaterial : exa_listaCurva) {
                    exameCurva.add(exameMaterial.getNomeExame());
                }
                if (Funcoes.textoVazio(this.rec_tuboPai)) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, (String)exameCurva.get(0), mco_codigo);
                    if (!this.configuracao.getModoHostQuery() && Funcoes.textoVazio(this.rec_tuboPai)) {
                        ArrayList<String> tubos = BDUtil.getExameDesmembradoTubos(fil_codigo, req_codigo, rec_codigo, pac_exames.trim(), mco_codigo, int_codigo);
                        this.rec_tuboPai = rec_codigo;
                    }
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((ExameMaterial)exa_listaCurva.get(0)).getString(), ((ExameMaterial)exa_listaCurva.get(0)).getCodigo().toString(), int_codigo);
                }
                listaCurva = ExamesUtil.anexarCodigoMaterial(exameCurva.toArray(new String[exameCurva.size()]), mco_codigo);
                listaCurva = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, String.valueOf(Integer.parseInt(rec_codigo)), st, exa_listaCurva, this.rec_tuboPai, this.hostQuery, this.examesFilho);
            }
            if (Funcoes.textoVazio(tipo_amostra)) {
                if (exa_lista != null) {
                    Object ex;
                    exameCurva = exa_lista;
                    int tubos = ((ExameMaterial[])exameCurva).length;
                    for (int exameMaterial = 0; exameMaterial < tubos && Funcoes.textoVazio(tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((CodString)(ex = exameCurva[exameMaterial])).getString(), ((CodString)ex).getCodigo().toString(), int_codigo)); ++exameMaterial) {
                    }
                }
                if (Funcoes.textoVazio(tipo_amostra)) {
                    for (String exFilho : this.examesFilho) {
                        tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exFilho, mco_codigo, int_codigo);
                    }
                }
            }
            ArrayList<void> temporario = new ArrayList<void>();
            if (alternativos != null) {
                for (void var35_48 : alternativos) {
                    if (temporario.contains(var35_48)) continue;
                    temporario.add(var35_48);
                }
                alternativos = new ExameMaterial[temporario.size()];
                for (int i3 = 0; i3 < temporario.size(); ++i3) {
                    alternativos[i3] = (ExameMaterial)temporario.get(i3);
                }
            }
            String nome = !Funcoes.textoVazio(short_name) ? ((i = short_name.indexOf(32)) > 0 ? short_name.substring(0, i) : short_name) : null;
            String sobrenome = short_name;
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, null, control, this.INSTRUMENT_NAME, null));
            String patient_id = req_codigo;
            String string = null;
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, patient_id, string, nome, sobrenome, pac_sexo));
            int seq = 0;
            if (alternativos != null) {
                this.tx_list.add(ASTMStandard.getDefaultOrderRecord(++seq, codigo.toString(), alternativos, exa_lista, null, "R", null, null, null));
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    this.tx_list.add(ASTMStandard.getDefaultOrderRecord(++seq, sample_id.append(tubo).toString(), alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()]), null, null, "R", null, null, null));
                }
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Immulite2k: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "Immulite2k: exce\u00e7\u00e3o no envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            starting_range = starting_range.substring(1);
            if (starting_range.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                return;
            }
            this.host_fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
            starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Immulite2k: Host Query Response");
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
    }

    public void responseHostQuery() {
        try {
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = "";
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                String situacao = null;
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        situacao = (String)r[aba.getColIndice("Sit")];
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
            }
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
            if (!Funcoes.textoVazio(pac_exames)) {
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
            } else {
                this.enviarRequisicaoSemExame(fil_codigo, req_codigo, rec_codigo);
                this.fireExcecaoEncontrada(String.format("Nenhum exame para enviar amostra %s %s %s", fil_codigo, req_codigo, rec_codigo));
            }
            this.hostQuery = false;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Immulite2k: Host Query Response");
        }
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo, String rec_codigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String nome = "";
            if (!Funcoes.textoVazio(fil_codigo) && !Funcoes.textoVazio(req_codigo)) {
                nome = BDUtil.getNomePaciente(fil_codigo, req_codigo);
            }
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, req_codigo, null, nome, null, this.pac_sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (this.exames != null) {
            System.out.println(String.format("tx_list: %s", String.valueOf(this.tx_list.getUltimoLido() == this.tx_list.size() - 1)));
            System.out.println(String.format("Fil: %s, Req: %s, Rec: %s, mco: %s, int:%s, Exames: %s", this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, StringUtil.arrayParaString(this.exames)));
        }
        super.encerrarTransmissao();
    }
}

