/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.immage800;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.immage800.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.ThreadRecebimento;
import jalis.util.CodString;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    private ThreadRecebimento threadRecebimento;
    protected boolean hostQuery = false;
    private boolean semExames = false;
    private List<String> request = new ArrayList<String>();

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.MAX_PATIENT_NAME_CHARS = 32;
        this.HOST_NAME = "Jalis";
        this.INSTRUMENT_NAME = "";
        this.INSTRUMENT_SYSTEM_VERSION = "1";
        this.threadRecebimento = new ThreadRecebimento(this);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            Object exameCurva;
            this.tx_list.clear();
            this.rx_list.clear();
            this.req_codigo = req_codigo;
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            this.curva = false;
            this.rec_tuboPai = "";
            this.examesFilho = new LinkedList();
            if (!this.hostQuery) {
                this.encerrarTransmissao();
                return "";
            }
            ExameMaterial[] alternativos = null;
            ExameMaterial[] listaCurva = null;
            Map<String, List<ExameMaterial>> alternativosCurva = null;
            String short_name = StringUtil.removerAcentos(pac_nome.trim());
            String nome1 = "";
            String nome2 = "";
            String nome3 = "";
            if (short_name.indexOf(" ") > 0) {
                String[] names = short_name.split(" ");
                if (names != null && names.length > 0) {
                    nome1 = StringUtil.preencheString(names[0], 20, ' ', 0).substring(0, 18);
                }
                if (names != null && names.length > 1) {
                    nome2 = StringUtil.preencheString(names[1], 20, ' ', 0).substring(0, 15);
                }
                if (names != null && names.length > 2) {
                    nome3 = String.valueOf(names[2].charAt(0));
                }
            } else if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                nome1 = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = StringUtil.preencheString(fil_codigo, ParametrosGerais.getDigitosTuboFilial(), '0', 1);
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            StringBuilder sample_id = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = StringUtil.preencheString(rec_codigo, ParametrosGerais.getDigitosTuboTubo(), '0', 1);
            codigo.append(rec_codigo);
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String exame = exa_lista[0].toString();
            ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
            exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
            String tipoAmostra = "";
            if (exa_lista != null) {
                tipoAmostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, (exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista))[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
                if (Funcoes.textoVazio(tipoAmostra)) {
                    tipoAmostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exame, mco_codigo, int_codigo);
                }
                alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
                alternativos = ExamesUtil.removeDuplicados(alternativos);
            }
            if (!exa_listaCurva.isEmpty()) {
                exameCurva = new ArrayList();
                for (ExameMaterial exameMaterial : exa_listaCurva) {
                    exameCurva.add(exameMaterial.getNomeExame());
                }
                if (Funcoes.textoVazio(this.rec_tuboPai)) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, (String)exameCurva.get(0), mco_codigo);
                }
                if (Funcoes.textoVazio(tipoAmostra)) {
                    tipoAmostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((ExameMaterial)exa_listaCurva.get(0)).getString(), ((ExameMaterial)exa_listaCurva.get(0)).getCodigo().toString(), int_codigo);
                }
                listaCurva = ExamesUtil.anexarCodigoMaterial(exameCurva.toArray(new String[exameCurva.size()]), mco_codigo);
                listaCurva = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
                alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, String.valueOf(Integer.parseInt(rec_codigo)), st, exa_listaCurva, this.rec_tuboPai, true, this.examesFilho);
            }
            if (Funcoes.textoVazio(tipoAmostra)) {
                if (exa_lista != null) {
                    Object ex;
                    exameCurva = exa_lista;
                    int n = ((ExameMaterial[])exameCurva).length;
                    for (int exameMaterial = 0; exameMaterial < n && Funcoes.textoVazio(tipoAmostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, ((CodString)(ex = exameCurva[exameMaterial])).getString(), ((CodString)ex).getCodigo().toString(), int_codigo)); ++exameMaterial) {
                    }
                }
                if (Funcoes.textoVazio(tipoAmostra)) {
                    for (String exFilho : this.examesFilho) {
                        tipoAmostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exFilho, mco_codigo, int_codigo);
                    }
                }
            }
            this.tx_list.add(this.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            StringBuilder patient_id = new StringBuilder();
            patient_id.append(fil_codigo).append(req_codigo);
            Date dataNasc = BDUtil.getDataNacimentoPaciente(fil_codigo, req_codigo);
            String sex = "U";
            if (!Funcoes.textoVazio(pac_sexo) && pac_sexo.equalsIgnoreCase("M")) {
                sex = "M";
            } else if (!Funcoes.textoVazio(pac_sexo) && pac_sexo.equalsIgnoreCase("F")) {
                sex = "F";
            }
            String[] dataPaciente = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            String nomeMedico = BDUtil.buscaMedicoRequisicao(fil_codigo, req_codigo);
            this.tx_list.add(this.getPatientRecord(1, patient_id.toString(), nome1, nome2, nome3, sex, dataNasc, dataPaciente, nomeMedico));
            int seq = 0;
            if (alternativos != null && alternativos.length > 0) {
                this.tx_list.add(this.getOrderRecord(++seq, codigo.toString(), "", "", codigo.toString(), alternativos, "R", tipoAmostra, this.hostQuery ? "Q" : "O", rackposition));
            }
            if (alternativosCurva != null && alternativosCurva.size() > 0) {
                String cod = sample_id.toString();
                this.curva = true;
                for (String key : alternativosCurva.keySet()) {
                    sample_id.setLength(0);
                    sample_id.append(cod);
                    String tubo = Funcoes.preencheZero(key, ParametrosGerais.getDigitosTuboTubo());
                    this.tx_list.add(this.getOrderRecord(++seq, sample_id.append(tubo).toString(), "", "", sample_id.append(tubo).toString(), alternativosCurva.get(key).toArray(new ExameMaterial[alternativosCurva.get(key).size()]), "R", tipoAmostra, this.hostQuery ? "Q" : "O", rackposition));
                }
            }
            this.tx_list.add(this.getTerminationRecord());
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private String getDefaultHeaderRecord(String delimiters, String password, String sender_name, String soft_version) {
        StringBuilder record = new StringBuilder("H|");
        record.append(delimiters == null ? "" : delimiters);
        record.append("||");
        record.append(password == null ? "" : password);
        record.append("|");
        record.append(sender_name == null ? "" : sender_name);
        record.append(soft_version == null ? "" : "^" + soft_version);
        record.append("||||||||1|");
        record.append(ASTMStandard.getCurrentMoment());
        record.append('\r');
        return record.toString();
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo, String rec_codigo) {
        try {
            this.semExames = true;
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String[] dataPaciente = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
            String nomeMedico = BDUtil.buscaMedicoRequisicao(fil_codigo, req_codigo);
            this.tx_list.add(this.getPatientRecord(1, fil_codigo + req_codigo, fil_codigo + req_codigo, "", "", "", null, dataPaciente, nomeMedico));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o paciente de envio");
            }
            this.tx_list.add(this.getOrderRecord(1, "", "", "", fil_codigo + req_codigo + rec_codigo, null, "R", "", this.hostQuery ? "Q" : "O", ""));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o paciente de envio");
            }
            this.tx_list.add(this.getTerminationRecord());
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    private String getOrderRecord(int order_sequence, String sampleId, String sampleTray, String samplePos, String codBarra, ExameMaterial[] alternativos, String prioridade, String tipoAmostra, String reportType, String rackposition) {
        StringBuilder record = new StringBuilder("O|");
        record.append(order_sequence).append("|");
        record.append(sampleId).append("^");
        record.append(rackposition).append("^").append("|");
        if (alternativos != null && alternativos[0] != null) {
            record.append("|^^^");
            record.append(alternativos[0].getNomeExame());
            for (int i = 1; i < alternativos.length; ++i) {
                if (alternativos[i] == null) continue;
                record.append("\\^^^");
                record.append(alternativos[i].getNomeExame());
            }
        }
        record.append("|");
        record.append("S").append("|||");
        record.append(ASTMStandard.getCurrentMoment()).append("|");
        record.append(ASTMStandard.getCurrentMoment()).append("|");
        record.append("|N");
        record.append("||||");
        record.append("S").append("||||");
        record.append("||||||O");
        record.append('\r');
        return record.toString();
    }

    private String getPatientRecord(int patient_sequence, String patient_id, String pac_nome, String pac_nome2, String pac_nome3, String pac_sexo, Date dataNasc, String[] dataPaciente, String nomeMedico) {
        StringBuilder record = new StringBuilder("P|");
        record.append(patient_sequence).append("||");
        record.append(patient_id == null ? "" : StringUtil.preencheString(patient_id, 15, ' ', 0));
        record.append("||");
        record.append(pac_nome).append("^").append(pac_nome2).append("^").append(Funcoes.textoVazio(pac_nome3) ? " " : pac_nome3).append("||");
        record.append(dataNasc == null ? "" : Funcoes.formataData("yyyyMMdd", dataNasc)).append("^").append(dataPaciente[0]).append("^").append(dataPaciente[1]);
        record.append("|").append(pac_sexo).append("|||||");
        record.append(nomeMedico.length() > 18 ? nomeMedico.substring(0, 18) : StringUtil.preencheString(nomeMedico, 18, ' ', 0)).append("||||||||||||||");
        return record.toString();
    }

    private String getTerminationRecord() {
        StringBuilder record = new StringBuilder("L|1N");
        record.append('\r');
        return record.toString();
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    protected void tratarAcknowledge() throws Exception {
        super.tratarAcknowledge();
        if (this.tx_list.isEmpty() && this.request.size() > 0) {
            Thread.sleep(6000L);
            this.responseHostQuery();
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery && !this.request.isEmpty()) {
            this.responseHostQuery();
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            String sampleId = starting_range.trim();
            this.hostQuery = true;
            if (!Funcoes.textoVazio(sampleId)) {
                ArrayList<Object> amostras = new ArrayList<String>();
                if (sampleId.contains("\\")) {
                    amostras = StringUtil.explode(sampleId.replaceAll("\\^", ""), "\\");
                } else {
                    amostras.add(sampleId.replaceAll("\\^", ""));
                }
                if (amostras != null && amostras.size() == 1) {
                    String string = (String)amostras.get(0);
                }
                if (amostras != null) {
                    for (String string : amostras) {
                        if (Funcoes.textoVazio(string)) {
                            this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                            continue;
                        }
                        if (string.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                            this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                            continue;
                        }
                        if (this.request.contains(string)) continue;
                        this.request.add(string);
                    }
                }
                if (!this.request.isEmpty()) {
                    this.hostQuery = true;
                } else {
                    this.fireExcecaoEncontrada(String.format("Pedido de amostra do aparelho sem nenhum Sample ID: %s", starting_range));
                }
            } else {
                this.fireExcecaoEncontrada("Pedido de amostra do aparelho sem nenhum Sample ID");
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            if (this.request.isEmpty()) {
                return;
            }
            String sampleId = this.request.remove(0);
            String fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            sampleId = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            String rec_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao());
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            String pac_exames = null;
            String acao = "A";
            if (Funcoes.textoVazio(fil_codigo) || Funcoes.textoVazio(req_codigo) || Funcoes.textoVazio(rec_codigo)) {
                return;
            }
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames = (String)req[aba.getColIndice("Exame")];
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames) && req != null && aba != null) {
                    pac_exames = (String)req[aba.getColIndice("Exame")];
                }
                if (req != null) {
                    pac_exames = pac_exames + " ";
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
            }
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                pac_exames = "";
                if (req != null) {
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) >= 7) continue;
                        pac_exames = pac_exames + (String)r[aba.getColIndice("Exame")] + " ";
                    }
                    pac_exames = pac_exames.trim();
                }
                if (Funcoes.textoVazio(pac_exames)) {
                    req = null;
                }
            }
            if (req != null) {
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
            } else {
                this.enviarRequisicaoSemExame(fil_codigo, req_codigo, rec_codigo);
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Smart Prime: Host Query Response");
            this.hostQuery = false;
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (!(this.semExames || Funcoes.textoVazio(this.req_codigo) || Funcoes.textoVazio(this.pac_exames) || Funcoes.textoVazio(this.rec_codigo) || Funcoes.textoVazio(this.fil_codigo) || Funcoes.textoVazio(this.mco_codigo))) {
            if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
                Statement st = Conexao.getStatement();
                if (this.exames != null) {
                    for (int i = 0; i < this.exames.length; ++i) {
                        int situacao;
                        if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                            for (String exame : this.examesFilho) {
                                int situacao2 = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                                BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                            }
                            situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                            if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                            this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                            continue;
                        }
                        if (!this.examesFilho.isEmpty()) {
                            situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                            this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                            BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                            continue;
                        }
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                    }
                    Conexao.arquivaSQL();
                    String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                    this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
                } else {
                    this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
                }
            }
            this.interromperTimer();
            if (this.hostQuery) {
                this.getPortaCOM().write(String.valueOf('\u0004'));
            }
            if (this.ultima_acao.equals("N")) {
                this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
            this.limpaDadosRequisicao();
            this.fireAtualizarTabela();
            this.fireAtualizarTabela(0);
            this.setIdle();
        } else {
            this.interromperTimer();
            this.getPortaCOM().write(String.valueOf('\u0004'));
            this.limpaDadosRequisicao();
            this.fireAtualizarTabela();
            this.fireAtualizarTabela(0);
            this.setIdle();
            this.semExames = false;
        }
        if (this.request.size() == 0) {
            this.hostQuery = false;
        } else {
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            this.confirmacaoACK();
        } else if (op == 2) {
            this.resultado();
        } else if (op == 3) {
            this.finalizaTransmissao();
        }
    }

    protected void finalizaTransmissao() {
        this.handShakeCharReceived('\u0004');
    }

    protected void confirmacaoACK() {
        for (int i = 0; i < 10; ++i) {
            this.handShakeCharReceived('\u0006');
        }
    }

    private void query() {
        this.parse(this.equipamento.arruma("[STX]H|\\^&|||sender id text||||||||1|19930630151206[CR][ETX]FF[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2Q|1|^010002701829\\^010002701828||||||||||O[CR][ETX]FF[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3L|1|N[CR][ETX]FF[LINE]"));
        this.finalizaTransmissao();
    }

    private void resultado() {
        String idAmostra = JOptionPane.showInputDialog("Informe o Id da amostra?");
        String alternativo = JOptionPane.showInputDialog("Informe o alternativo do exame?");
        if (Funcoes.textoVazio(idAmostra) || Funcoes.textoVazio(alternativo)) {
            return;
        }
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||Beckman IMMAGE||||||||1|19960830133749[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2P|1|||||||U[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3O|1|010002701828^0^0^^1|||R||19960829000000||0.00||||||S|||1^1.00[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|1|^^^G1^^^1^^0|1.77|mg/dL||||F[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0L|1|N[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]1H|\\^&|||Beckman IMMAGE||||||||1|19960830133749[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]2P|1|||||||U[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]3O|1|010002701829^0^0^^1|||R||19960829000000||0.00||||||S|||1^1.00[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]4R|1|^^^G2^^^1^^0|2.77|mg/dL||||F[CR][ETX]4F[LINE]"));
        this.parse(this.equipamento.arruma("[STX]0L|1|N[CR][ETX]4F[LINE]"));
        this.handShakeCharReceived('\u0004');
        for (int i = 0; i < 6; ++i) {
            this.handShakeCharReceived('\u0006');
        }
    }
}

