/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.icounter5d;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.padroes.json.InterfaceJSONListener;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class InterfaceListener
extends InterfaceJSONListener {
    private static String tagEtiqueta = "identifier";
    private static HashMap<String, String> parametros = new HashMap();
    private static HashMap<String, String> flags = new HashMap();
    private static String tagValor = "value";
    private static String tagUnidade = "unit";
    private static String tagFlag = "flag";
    private static String tagFlagFlai = "flai";

    public InterfaceListener() {
        parametros.put("wbc", "leucocitos");
        parametros.put("lyn", "linfocitos_tipicos_contagem");
        parametros.put("lynp", "linfocitos_tipicos_percentual");
        parametros.put("neu", "neutrofilo_contagem");
        parametros.put("neup", "neutrofilo_percentual");
        parametros.put("rbc", "hemacias");
        parametros.put("hgb", "hgb");
        parametros.put("hib", "hgb");
        parametros.put("hct", "hct");
        parametros.put("mcv", "vcm");
        parametros.put("mch", "hcm");
        parametros.put("mchc", "mchc");
        parametros.put("rdw_cv", "rdw_cv");
        parametros.put("rdw_sd", "rdw_sd");
        parametros.put("plt", "plaquetas");
        parametros.put("mpv", "vpm");
        parametros.put("pct", "pct");
        parametros.put("pdw", "pdw");
        parametros.put("plcr", "plaquetas_lcr");
        parametros.put("bas", "basofilos_contagem");
        parametros.put("basp", "basofilos_percentual");
        parametros.put("mon", "monocitos_contagem");
        parametros.put("monp", "monocitos_percentual");
        parametros.put("eos", "eosinofilos_contagem");
        parametros.put("eosp", "eosinofilos_percentual");
        parametros.put("aly", "linfocitos_atipicos_contagem");
        parametros.put("alyp", "linfocitos_atipicos_percentual");
        flags.put("wbc", "Leuc\u00f3citos");
        flags.put("lyn", "Linf. T\u00edpicos");
        flags.put("lynp", "% Linf. T\u00edpicos");
        flags.put("neu", "Neutr\u00f3filos (Segmentados)");
        flags.put("neup", "% Neutr\u00f3filos (Segmentados)");
        flags.put("rbc", "Hem\u00e1cias (Eritr\u00f3citos)");
        flags.put("hgb", "Hemoglobina");
        flags.put("hib", "Hemoglobina");
        flags.put("hct", "Hemat\u00f3crito");
        flags.put("mcv", "V.C.M.");
        flags.put("mch", "H.C.M.");
        flags.put("mchc", "M.C.H.C.");
        flags.put("rdw_cv", "R.D.W. CV");
        flags.put("rdw_sd", "R.D.W. SD");
        flags.put("plt", "Plaquetas");
        flags.put("mpv", "V.P.M.");
        flags.put("pct", "P.C.T.");
        flags.put("pdw", "P.D.W.");
        flags.put("plcr", "Plaquetas - R\u00e1cio celular");
        flags.put("bas", "Bas\u00f3filos");
        flags.put("basp", "% Bas\u00f3filos");
        flags.put("mon", "Mon\u00f3citos");
        flags.put("monp", "% Mon\u00f3citos");
        flags.put("eos", "Eosin\u00f3filos");
        flags.put("eosp", "% Eosin\u00f3filos");
        flags.put("aly", "Linf. At\u00edpicos");
        flags.put("alyp", "% Linf. At\u00edpicos");
    }

    @Override
    public String parse(String message) {
        StringBuilder mensagem = new StringBuilder();
        try {
            String codigoTubo;
            String codigoRequisicao;
            DescritorCodigoEtiqueta etiqueta;
            JSONObject jsonObject = new JSONObject(message);
            String codigoEtiqueta = null;
            if (!Funcoes.objectIsNull(jsonObject.get(tagEtiqueta)) && !jsonObject.get(tagEtiqueta).toString().equals("null")) {
                codigoEtiqueta = String.valueOf(jsonObject.get(tagEtiqueta));
                int tamanhoCodigoEtiquetaPadrao = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (codigoEtiqueta.length() < tamanhoCodigoEtiquetaPadrao) {
                    codigoEtiqueta = Funcoes.preencheZero(codigoEtiqueta, tamanhoCodigoEtiquetaPadrao);
                }
            }
            if (Funcoes.objectIsNull(etiqueta = DescritorCodigoEtiqueta.getDescritor(codigoEtiqueta))) {
                mensagem.setLength(0);
                mensagem.append("C\u00f3digo da requisi\u00e7\u00e3o '");
                mensagem.append(codigoEtiqueta);
                mensagem.append("' invalida.");
                this.fireExcecaoEncontrada(mensagem.toString());
                return mensagem.toString();
            }
            String codigoFilial = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
            Object[] requisicao = this.getRequisicaoAba(codigoFilial, codigoRequisicao = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao()), codigoTubo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo()), 0);
            if (requisicao == null) {
                requisicao = this.getRequisicaoAba(codigoFilial, codigoRequisicao, codigoTubo, 1);
            }
            if (requisicao == null) {
                mensagem.setLength(0);
                mensagem.append("C\u00f3digo tubo n\u00e3o encontrado '");
                mensagem.append(codigoFilial);
                mensagem.append(" ");
                mensagem.append(codigoRequisicao);
                mensagem.append(" ");
                mensagem.append(codigoTubo);
                mensagem.append("'");
                this.fireExcecaoEncontrada(mensagem.toString());
                return "";
            }
            String exames = (String)requisicao[7];
            String[] listaExames = exames.split(" ");
            String codigoInterface = (String)requisicao[14];
            for (int i = 0; i < listaExames.length; ++i) {
                String codigoAlternativo = (String)requisicao[16];
                if (Funcoes.textoVazio(codigoInterface)) {
                    return "";
                }
                if (Funcoes.textoVazio(codigoInterface)) {
                    mensagem.setLength(0);
                    mensagem.append("C\u00f3digo Interface n\u00e3o encontrado para o exame '");
                    mensagem.append(codigoAlternativo);
                    mensagem.append("' n\u00e3o encontrado na interface para requisi\u00e7\u00e3o '");
                    mensagem.append(codigoFilial);
                    mensagem.append(" ");
                    mensagem.append(codigoRequisicao);
                    mensagem.append(" ");
                    mensagem.append(codigoTubo);
                    mensagem.append("'");
                    this.fireExcecaoEncontrada(mensagem.toString());
                    return mensagem.toString();
                }
                ExameMaterial exame = this.getReqExameLIS(codigoFilial, codigoInterface, codigoRequisicao, codigoTubo, codigoAlternativo);
                if (exame == null) {
                    codigoAlternativo = (String)requisicao[15];
                    exame = this.getReqExameLIS(codigoFilial, codigoInterface, codigoRequisicao, codigoTubo, codigoAlternativo);
                }
                if (Funcoes.objectIsNull(exame)) {
                    mensagem.setLength(0);
                    mensagem.append("C\u00f3digo LIS do exame '");
                    mensagem.append(codigoAlternativo);
                    mensagem.append("' n\u00e3o encontrado para requisi\u00e7\u00e3o '");
                    mensagem.append(codigoFilial);
                    mensagem.append(" ");
                    mensagem.append(codigoRequisicao);
                    mensagem.append(" ");
                    mensagem.append(codigoTubo);
                    mensagem.append("'");
                    this.fireExcecaoEncontrada(mensagem.toString());
                    return mensagem.toString();
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                ArrayList<String> listFlags = new ArrayList<String>();
                Statement st = Conexao.getStatement();
                for (String tagExame : parametros.keySet()) {
                    try {
                        JSONObject jsonExame = jsonObject.getJSONObject(tagExame);
                        dados.put(parametros.get(tagExame), jsonExame.getString(tagValor).replaceAll("\\.", ",").replace("%", "").trim());
                        String flag = "";
                        try {
                            flag = jsonExame.getString(tagFlag);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            if (Funcoes.textoVazio(flag)) {
                                flag = jsonExame.getString(tagFlagFlai);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (!flag.toUpperCase().equals("H") && !flag.toUpperCase().equals("L")) continue;
                        StringBuilder sb = new StringBuilder(flags.get(tagExame)).append(" - ");
                        if (flag.toUpperCase().equals("H")) {
                            sb.append("HIGH");
                        } else {
                            sb.append("LOW");
                        }
                        listFlags.add(sb.toString());
                    }
                    catch (Exception exception) {}
                }
                if (dados.isEmpty()) {
                    mensagem.setLength(0);
                    mensagem.append("Nenhum resultado foi lan\u00e7ado para o exame '");
                    mensagem.append(codigoAlternativo);
                    mensagem.append("' da requisi\u00e7\u00e3o '");
                    mensagem.append(codigoFilial);
                    mensagem.append(" ");
                    mensagem.append(codigoRequisicao);
                    mensagem.append(" ");
                    mensagem.append(codigoTubo);
                    mensagem.append("'");
                    this.fireExcecaoEncontrada(mensagem.toString());
                    return mensagem.toString();
                }
                this.atualizarDadosExame(st, codigoFilial, codigoRequisicao, codigoTubo, exame.getNomeExame(), exame.getCodigoMaterial(), codigoInterface, dados, listFlags);
                this.fireAtualizarTabela();
            }
        }
        catch (JSONException e) {
            mensagem.setLength(0);
            mensagem.append("Erro ao processar a informa\u00e7\u00e3o recebida do equipamento.");
            this.fireExcecaoEncontrada(mensagem.toString());
            return mensagem.toString();
        }
        catch (SQLException e1) {
            mensagem.setLength(0);
            mensagem.append("Erro ao buscar o codigo da interface.");
            return mensagem.toString();
        }
        catch (Exception e) {
            mensagem.setLength(0);
            mensagem.append("Erro ao lan\u00e7ar o resultado do exame.");
            return mensagem.toString();
        }
        return "";
    }
}

