/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.icap6000;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.Laboratorio;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.configuracao.EquipamentoFilial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.icap6000.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.interfaces.icap6000.RequisicaoParaEnviar;
import jalis.laboratorio.interfaceamento.padroes.arquivo.InterfaceArquivoListener;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.componentes.ComponenteFactory;
import jalis.util.logger.ErrorLogger;
import jalis.util.tabela.Registro;
import java.io.File;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;

public class InterfaceListener
extends InterfaceArquivoListener {
    private static final String RESULTADOS = "RESULTADOS";
    private static final String AVG = "Avg";
    private static final String ELEM = "Elem";
    private static final String RESULTS = "[Results]";
    private static final String INTERNAL_STANDARDS = "[Internal Standards]";
    private static final String SAMPLE_HEADER = "[Sample Header]";
    private InterfaceConfiguracao configuracao;
    private String DIRETORIO_EXPORTACAO = "";
    private String DIRETORIO_IMPORTACAO = "";
    private List<String> examesFilho = new ArrayList<String>();
    private Map<String, String> alternativosRecipientes = new HashMap<String, String>();
    private ArrayList<RequisicaoParaEnviar> requisicoesParaEnviar = new ArrayList();

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setDiretorioExportacao(c.getDiretorioExportacao());
        this.configuracao.setDiretorioImportacao(c.getDiretorioImportacao());
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.DIRETORIO_EXPORTACAO = c.getDiretorioExportacao();
        this.DIRETORIO_IMPORTACAO = c.getDiretorioImportacao();
        this.alternativosRecipientes = this.buscaRecipientes();
    }

    private Map<String, String> buscaRecipientes() {
        String int_codigo = "0";
        for (ConfiguracaoSerial c : Variaveis.equipamentos) {
            for (EquipamentoFilial e : c.getEquipamentos()) {
                int_codigo = e.getEquipamento().toString();
            }
        }
        StringBuilder bui = new StringBuilder();
        bui.append("select emi_alternativo, array_to_string(array_agg(distinct rec_codigo), ',') as rec_codigo  ");
        bui.append("  from examematinterface a ");
        bui.append("  left join recipcoleta b on a.fil_codigo = b.fil_codigo and a.exa_codigo = b.exa_codigo and  a.mco_codigo = b.mco_codigo ");
        bui.append(" where a.fil_codigo = ").append(Variaveis.filialPadrao);
        bui.append(" and a.int_codigo = ").append(int_codigo);
        bui.append(" and emi_alternativo is not null and emi_alternativo <> '' ");
        bui.append(" group by emi_alternativo ");
        Statement st = Conexao.getStatement();
        try {
            ResultSet rs = st.executeQuery(bui.toString());
            while (rs.next()) {
                if (Funcoes.textoVazio(rs.getString("emi_alternativo").trim())) continue;
                this.alternativosRecipientes.put(rs.getString("emi_alternativo"), rs.getString("rec_codigo"));
            }
            st.close();
        }
        catch (SQLException e) {
            ErrorLogger.mostraMensagem(Laboratorio.getInstancia(), e.getMessage(), e.getStackTrace());
        }
        return this.alternativosRecipientes;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            if (acao.equals("R")) {
                this.buscarResultados(null, null);
                return "";
            }
            Statement st = Conexao.getStatement();
            rackposition = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            rackposition = rackposition + Funcoes.preencheZero(Long.parseLong(req_codigo), ParametrosGerais.getDigitosTuboRequisicao());
            this.atualizarSituacaoRackTubo(st, fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, 1, rackposition);
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
            this.fireAtualizarTabela(1);
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return "";
        }
    }

    @Override
    public String parse(String message) {
        File file = new File(message);
        if (!file.exists()) {
            this.fireExcecaoEncontrada("Arquivo n\u00e3o localizado: " + message);
            return null;
        }
        try {
            String arquivo = StringUtil.lerArquivoTexto(message, "UTF-16LE");
            ArrayList<Registro> listaDados = new ArrayList<Registro>();
            StringTokenizer token = new StringTokenizer(arquivo, "\n", false);
            Registro reg = null;
            int posAlternativo = -1;
            int posResultado = -1;
            Object alternativo = null;
            Object resultado = null;
            boolean isResultado = false;
            HashMap<String, String> mapResultado = new HashMap<String, String>();
            while (token.hasMoreElements()) {
                String atributos = token.nextToken();
                if (Funcoes.textoVazio(atributos = StringUtil.limpaString(atributos, new String[]{"\r"}).trim()) || atributos.indexOf(ELEM) == 0) continue;
                if (atributos.contains(RESULTS)) {
                    isResultado = true;
                    continue;
                }
                if (reg != null && atributos.contains(INTERNAL_STANDARDS)) {
                    reg.setValor(RESULTADOS, mapResultado);
                    if (reg != null) {
                        listaDados.add(reg.clone());
                    }
                    isResultado = false;
                    continue;
                }
                if (atributos.contains(SAMPLE_HEADER)) {
                    mapResultado = new HashMap();
                    isResultado = false;
                    posAlternativo = -1;
                    posResultado = -1;
                    reg = new Registro();
                    continue;
                }
                String[] campos = atributos.split("=");
                String[] linhaResultado = atributos.split(";");
                if (isResultado) {
                    mapResultado.put(linhaResultado[0], linhaResultado[3]);
                }
                String campo = campos[0];
                String valor = null;
                if (isResultado || campos.length <= 1) continue;
                valor = atributos.split("=")[1];
                if (Funcoes.textoVazio(valor = StringUtil.limpaString(valor, new String[]{"\r", "\n"}).trim())) continue;
                reg.setValor(campo, valor);
            }
            this.parseArquivo(listaDados);
        }
        catch (IOException e) {
            this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel ler o arquivo.\nFormato inv\u00e1lido.");
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel ler o arquivo.");
        }
        return null;
    }

    private int preencheValor(Registro reg, int pos, boolean isResultado, String atributos, String campo) {
        if (isResultado && pos > -1) {
            String valor = atributos.split(";")[pos];
            reg.setValor(campo, valor);
            return -1;
        }
        return pos;
    }

    private boolean parseArquivo(ArrayList<Registro> listaDados) throws Exception {
        boolean contaLinha = false;
        int tamTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao();
        Statement st = Conexao.getStatement();
        String requisicao = "";
        String filial = "";
        String tubo = "";
        String resultadoExame = "";
        Map<String, Object> dadosExame = new HashMap<String, Object>();
        for (Registro reg : listaDados) {
            String tmp = reg.getString("SampleName");
            if (Funcoes.textoVazio(reg.getString("SampleName")) || !Funcoes.isNumeric(tmp)) {
                this.fireExcecaoEncontrada("C\u00f3digo do tubo inv\u00e1lido: " + tmp);
                continue;
            }
            if (tmp.length() < tamTubo) {
                this.fireExcecaoEncontrada("Tubo fora do padr\u00e3o configurado: " + tmp);
                continue;
            }
            filial = tmp.substring(0, ParametrosGerais.getDigitosTuboFilial());
            requisicao = tmp.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            HashMap mapResultado = (HashMap)reg.getValor(RESULTADOS);
            for (String alternativo : mapResultado.keySet()) {
                resultadoExame = (String)mapResultado.get(alternativo);
                if (!this.alternativosRecipientes.containsKey(alternativo) || Funcoes.textoVazio(this.alternativosRecipientes.get(alternativo))) {
                    this.fireExcecaoEncontrada(String.format("Exame do equipamento com alternativo %s n\u00e3o configurado.", alternativo));
                    continue;
                }
                if (Funcoes.textoVazio(alternativo)) continue;
                tubo = this.alternativosRecipientes.get(alternativo);
                String int_codigo = null;
                if (tubo.contains(",")) {
                    String[] tubos;
                    for (String rec : tubos = tubo.split(",")) {
                        tubo = Funcoes.preencheZero(rec, ParametrosGerais.getDigitosTuboTubo());
                        int_codigo = this.getIntCodigo(filial, requisicao, rec, alternativo);
                        if (int_codigo == null) {
                            continue;
                        }
                        break;
                    }
                } else {
                    tubo = Funcoes.preencheZero(this.alternativosRecipientes.get(alternativo), ParametrosGerais.getDigitosTuboTubo());
                    int_codigo = this.getIntCodigo(filial, requisicao, tubo, alternativo);
                }
                if (int_codigo == null) {
                    this.fireExcecaoEncontrada("Interfaceamento do exame " + alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + filial + " " + requisicao + " " + tubo);
                    continue;
                }
                dadosExame = this.resultadosSampleHeader(reg, dadosExame);
                tubo = this.alternativosRecipientes.get(alternativo);
                ExameMaterial exame = null;
                if (tubo.contains(",")) {
                    String rec;
                    String[] tubos;
                    String[] stringArray = tubos = tubo.split(",");
                    int n = stringArray.length;
                    for (int i = 0; i < n && (exame = this.getReqExameLIS(filial, int_codigo, requisicao, tubo = Funcoes.preencheZero(rec = stringArray[i], ParametrosGerais.getDigitosTuboTubo()), alternativo)) == null; ++i) {
                    }
                } else {
                    exame = this.getReqExameLIS(filial, int_codigo, requisicao, tubo, alternativo);
                }
                if (exame == null) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + filial + " " + requisicao + " " + tubo);
                    continue;
                }
                this.atualizarDadosExame(st, filial, requisicao, tubo, exame.getNomeExame(), exame.getCodigoMaterial().toString(), int_codigo, dadosExame, null);
                this.atualizarResultadoExame(st, filial, requisicao, tubo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, this.arrumaValor(resultadoExame));
            }
        }
        return true;
    }

    private Map<String, Object> resultadosSampleHeader(Registro reg, Map<String, Object> dadosExame) {
        String method = reg.getString("Method");
        dadosExame.put("Method", method);
        String user = reg.getString("Username");
        dadosExame.put("Username", user);
        String comment = reg.getString("Comment");
        dadosExame.put("Comment", comment);
        String id1 = reg.getString("Custom ID1");
        dadosExame.put("Custom ID1", id1);
        String id2 = reg.getString("Custom ID2");
        dadosExame.put("Custom ID2", id2);
        String id3 = reg.getString("Custom ID3");
        dadosExame.put("Custom ID3", id3);
        String run = reg.getString("Run Time");
        dadosExame.put("Run Time", run);
        String sample = reg.getString("Sample Type");
        dadosExame.put("Sample Type", sample);
        String mode = reg.getString("Mode");
        dadosExame.put("Mode", mode);
        String corr = reg.getString("CorrFactor");
        dadosExame.put("CorrFactor", corr);
        String repeats = reg.getString("Repeats");
        dadosExame.put("Repeats", repeats);
        return dadosExame;
    }

    private String arrumaValor(String valor) {
        return valor.replaceAll("\\.", ",");
    }

    @Override
    public void buscarResultados(Date inicio, Date termino) {
        try {
            JFileChooser chooser = ComponenteFactory.novoJFileChooser("Arquivo para importa\u00e7\u00e3o", this.DIRETORIO_IMPORTACAO);
            chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
            chooser.setFileFilter(ComponenteFactory.novoFileFilter("Arquivo de Resultado do ICP 600", "txt"));
            if (chooser.showOpenDialog(null) == 0) {
                String path = chooser.getSelectedFile().getPath();
                this.parse(path);
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }
}

