/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.humastar80.util;

import jalis.laboratorio.interfaceamento.interfaces.humastar80.util.DataRecord;
import jalis.laboratorio.interfaceamento.interfaces.humastar80.util.datarecords.PrologueDataRecord;
import jalis.laboratorio.interfaceamento.interfaces.humastar80.util.datarecords.ResultDataRecord;
import jalis.laboratorio.interfaceamento.interfaces.humastar80.util.datarecords.WorkDataRecord;
import jalis.util.Funcoes;
import java.util.ArrayList;
import java.util.List;

public class DataRecordParser {
    public DataRecord stringToDataRecord(Type type, String string) {
        DataRecord dataRecord = this.create(type);
        if (dataRecord != null) {
            List<Integer> sizes = dataRecord.getFieldsSize();
            ArrayList<String> fields = new ArrayList<String>(sizes.size());
            int percorrido = 0;
            for (int size : sizes) {
                if (percorrido + size > string.length()) {
                    fields.add("");
                    continue;
                }
                fields.add(string.substring(percorrido, percorrido + size).trim());
                percorrido += size;
            }
            dataRecord.setFields(fields);
        }
        return dataRecord;
    }

    public void dataRecordToString(DataRecord dataRecord, StringBuilder builder) {
        List<Integer> sizes = dataRecord.getFieldsSize();
        List<Object> fields = dataRecord.getFields();
        for (int i = 0; i < sizes.size(); ++i) {
            String field;
            int size = sizes.get(i);
            String string = field = i < fields.size() && fields.get(i) != null ? fields.get(i).toString() : "";
            if (field.length() > size) {
                field = field.substring(0, size);
            }
            builder.append(Funcoes.preencheVazio(field, sizes.get(i), 1));
        }
    }

    public String dataRecordToString(DataRecord dataRecord) {
        StringBuilder builder = new StringBuilder();
        this.dataRecordToString(dataRecord, builder);
        return builder.toString();
    }

    private DataRecord create(Type type) {
        switch (type) {
            case PROLOGUE: {
                return new PrologueDataRecord();
            }
            case RESULT: {
                return new ResultDataRecord();
            }
            case WORK: {
                return new WorkDataRecord();
            }
        }
        return null;
    }

    public static enum Type {
        PROLOGUE,
        RESULT,
        WORK;

    }
}

