/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.humastar80;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.humastar80.AbaExamesNaoEnviados;
import jalis.laboratorio.interfaceamento.interfaces.humastar80.util.DataRecordParser;
import jalis.laboratorio.interfaceamento.interfaces.humastar80.util.Packet;
import jalis.laboratorio.interfaceamento.interfaces.humastar80.util.PacketParser;
import jalis.laboratorio.interfaceamento.interfaces.humastar80.util.datarecords.PrologueDataRecord;
import jalis.laboratorio.interfaceamento.interfaces.humastar80.util.datarecords.ResultDataRecord;
import jalis.laboratorio.interfaceamento.interfaces.humastar80.util.datarecords.WorkDataRecord;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private int linesToReceive = 0;
    private PacketParser packetParser;
    private DataRecordParser dataRecordParser;
    private List<WorkDataRecord> workDataRecords = new ArrayList<WorkDataRecord>();
    private int digitosCodigoTubo;
    private int TIME_RX = 15000;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        this.digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        this.packetParser = new PacketParser();
        this.dataRecordParser = new DataRecordParser();
    }

    @Override
    public synchronized String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        Statement st = Conexao.getStatement();
        try {
            if (acao.equalsIgnoreCase("A")) {
                this.encerrarTransmissao(filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, exames, st);
                return "";
            }
            String tuboId = Funcoes.preencheZero(filCodigo, ParametrosGerais.getDigitosTuboFilial()) + Funcoes.preencheZero(reqCodigo, ParametrosGerais.getDigitosTuboRequisicao()) + Funcoes.preencheZero(recCodigo, ParametrosGerais.getDigitosTuboTubo());
            ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
            for (String exame : exames.split(" ", 0)) {
                examesDaRequisicao.add(new ExameMaterial(exame, new Integer(mcoCodigo)));
            }
            Integer age = null;
            int sexo = 1;
            if (pacSexo != null && pacSexo.equalsIgnoreCase("M")) {
                sexo = 0;
            }
            ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
            String[] idade = BDUtil.getIdadeNacimentoPaciente(filCodigo, reqCodigo);
            if (idade != null && idade[1].equalsIgnoreCase("A") && Funcoes.isNumeric(idade[0])) {
                age = Integer.parseInt(idade[0]);
            }
            for (ExameMaterial exameMaterial : examesDaRequisicao) {
                int n = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                    List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                    if (n == 0 || n == 1) {
                        examesParaEnviar.addAll(examesFilhos);
                        continue;
                    }
                    for (ExameMaterial exameFilho : examesFilhos) {
                        int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                        if (sitFilho != 3) continue;
                        examesParaEnviar.add(exameFilho);
                    }
                    continue;
                }
                if (n != 0 && n != 1 && n != 3) continue;
                examesParaEnviar.add(exameMaterial);
            }
            HashSet<String> tests = new HashSet<String>();
            for (ExameMaterial exameMaterial : examesParaEnviar) {
                String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                if (test == null || test.trim().isEmpty()) continue;
                tests.add(test);
            }
            for (String string : tests) {
                WorkDataRecord workDataRecord = new WorkDataRecord(tuboId, StringUtil.removerAcentos(pacNome), string);
                workDataRecord.setSex(sexo);
                if (age != null) {
                    workDataRecord.setAge(age);
                }
                this.workDataRecords.add(workDataRecord);
            }
            if (this.workDataRecords.isEmpty()) {
                String string = String.format("Sem teste para enviar verifique o paciente %s %s %s %s", filCodigo, reqCodigo, recCodigo, exames);
                this.fireExcecaoEncontrada(string);
                return string;
            }
            AbaExamesNaoEnviados abaExamesNaoEnviados = (AbaExamesNaoEnviados)this.getAba(0);
            if (!abaExamesNaoEnviados.isLote()) {
                this.enviaWorkDataRecords(this.workDataRecords);
                this.workDataRecords.clear();
            }
            this.encerrarTransmissao(filCodigo, intCodigo, reqCodigo, mcoCodigo, recCodigo, exames, st);
            Conexao.arquivaSQL();
            this.firePacienteEnviado(reqCodigo, pacNome, pacSexo, pacIdade, data, hora, exames);
            if (!abaExamesNaoEnviados.isLote()) {
                this.fireAtualizarTabela(0);
            }
        }
        catch (Exception e) {
            this.workDataRecords.clear();
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            return "Erro ao enviar exames: " + e.getMessage();
        }
        return null;
    }

    private void encerrarTransmissao(String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, Statement st) throws SQLException {
        String[] stringArray = exames.split(" ");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String exame;
            int atual = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame = stringArray[i], mcoCodigo, recCodigo);
            this.atualizarSituacaoExame(st, filCodigo, reqCodigo, recCodigo, exame, mcoCodigo, intCodigo, null, atual < 2 ? 1 : 3);
        }
    }

    private void enviaWorkDataRecords(List<WorkDataRecord> workDataRecords) throws IOException {
        if (!workDataRecords.isEmpty()) {
            int numberOfLines = workDataRecords.size();
            PrologueDataRecord prologueDataRecord = new PrologueDataRecord(numberOfLines);
            ArrayList<Packet> packets = new ArrayList<Packet>();
            packets.add(new Packet('R', this.dataRecordParser.dataRecordToString(prologueDataRecord)));
            for (WorkDataRecord workDataRecord : workDataRecords) {
                packets.add(new Packet('R', this.dataRecordParser.dataRecordToString(workDataRecord)));
            }
            for (Packet packet : packets) {
                this.getPortaCOM().write(this.packetParser.packetToString(packet));
            }
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\r');
    }

    @Override
    public String getMsgStart() {
        return "";
    }

    @Override
    public synchronized String parse(String message) {
        try {
            Packet packet;
            if (message != null && message.endsWith(this.getMsgEnd()) && message.length() > this.getMsgEnd().length() && (packet = this.packetParser.stringToPacket(message)) != null && packet.getHeadChar() == 'R') {
                if (this.linesToReceive == 0) {
                    PrologueDataRecord prologueDataRecord = (PrologueDataRecord)this.dataRecordParser.stringToDataRecord(DataRecordParser.Type.PROLOGUE, packet.getData());
                    if (prologueDataRecord != null) {
                        this.linesToReceive = prologueDataRecord.getNumberOfLines();
                    }
                } else {
                    --this.linesToReceive;
                    ResultDataRecord resultDataRecord = (ResultDataRecord)this.dataRecordParser.stringToDataRecord(DataRecordParser.Type.RESULT, packet.getData());
                    if (resultDataRecord != null) {
                        this.resultadoRecebido(resultDataRecord);
                    }
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(this.TIME_RX);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    @Override
    public void dataChanged() {
        this.dataChanged(this.getPortaCOM().getInputString());
    }

    public void dataChanged(String data) {
        try {
            String[] frames;
            if (!Funcoes.textoVazio(data) && data.contains(this.getMsgEnd()) && (frames = data.split(String.valueOf('\r'))) != null && frames.length > 0 && frames[0].length() > 7) {
                String lines = frames[0].substring(2, 7).trim();
                if (Funcoes.isNumeric(lines) && Integer.parseInt(lines) == frames.length - 1) {
                    for (String line : frames) {
                        if (Funcoes.textoVazio(line) || line.length() < 9) {
                            this.fireExcecaoEncontrada(String.format("Erro ao receber dados do equipamento (%s)", line + String.valueOf('\r')));
                            continue;
                        }
                        this.addListaRecebimento(line + String.valueOf('\r'));
                    }
                    this.restartThreadRecebimento();
                    this.getPortaCOM().clearInputString();
                    this.setIdle();
                } else {
                    this.aguardarProximoFrame();
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento", 1, 5000);
        }
    }

    private void resultadoRecebido(ResultDataRecord resultado) throws Exception {
        if (!resultado.isResultOk()) {
            this.fireExcecaoEncontrada(resultado.getPid() + ": resultado com erro");
            return;
        }
        String tuboId = resultado.getPid().trim();
        if (tuboId != null && tuboId.length() == this.digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
            String emiAlternativo;
            Statement st = Conexao.getStatement();
            String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
            String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            String intCodigo = this.getIntCodigo(filCodigo, reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), recCodigo, emiAlternativo = resultado.getTestName());
            ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
            if (exame != null) {
                HashMap<String, Object> dados = new HashMap<String, Object>();
                int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                String campoQuant = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                String campoQuali = sit < 3 ? "resultado_qualitativo" : "repeticao_qualitativo";
                String valorResultado = resultado.getResult();
                StringBuilder valorResultadoQuant = new StringBuilder();
                for (char c : valorResultado.toCharArray()) {
                    if (c != '.' && !Character.isDigit(c)) break;
                    valorResultadoQuant.append(c);
                }
                dados.put(campoQuant, valorResultadoQuant.toString().replace('.', ','));
                dados.put(campoQuali, valorResultado.replace('.', ','));
                this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados);
            } else {
                this.fireExcecaoEncontrada(String.format("Exame n\u00e3o localizada para a amostra %s alternativo %s", resultado.getPid(), emiAlternativo));
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
        } else {
            this.fireExcecaoEncontrada(resultado.getPid() + ": id da amostra fora do padr\u00e3o ");
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

