/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.humastar600;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.humastar600.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends InterfaceASTMListener {
    protected String host_fil_codigo = null;
    protected String host_req_codigo = null;
    protected String host_rec_codigo = null;
    protected boolean amostraInvalida = false;
    protected boolean hostQuery = false;
    protected boolean hostQueryVazio = false;
    private List<String> mensagens = new ArrayList<String>();
    private boolean query = false;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    public InterfaceListener() {
        RecordParser record = new RecordParser(this);
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        this.INSTRUMENT_SYSTEM_VERSION = "1394-97";
    }

    public void dataChangedTeste(String message) {
        try {
            if (!message.equals("")) {
                if (message.charAt(0) == '\u0005' && message.length() > 1 && message.charAt(message.length() - 1) == '\u0005') {
                    this.getPortaCOM().clearInputString();
                    this.handShakeCharReceived('\u0005');
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    if (this.isRX()) {
                        this.aguardarProximoFrame();
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("H")) {
                        this.query = false;
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("Q")) {
                        this.query = true;
                    }
                    this.mensagens.add(message);
                    if (this.query) {
                        while (this.mensagens.size() > 0) {
                            String resultado = this.parse(this.mensagens.remove(0));
                            System.out.println("Query priorit\u00e1ria");
                            if (resultado == null || !resultado.startsWith("Erro")) continue;
                            this.fireExcecaoEncontrada(resultado);
                        }
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("L")) {
                        this.query = false;
                        while (this.mensagens.size() > 0) {
                            this.addListaRecebimento(this.mensagens.remove(0));
                        }
                        this.restartThreadRecebimento();
                    }
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                if (message.charAt(0) == '\u0005' && message.length() > 1 && message.charAt(message.length() - 1) == '\u0005') {
                    this.getPortaCOM().clearInputString();
                    this.handShakeCharReceived('\u0005');
                } else {
                    this.getPortaCOM().write(String.valueOf('\u0006'));
                    if (this.isRX()) {
                        this.aguardarProximoFrame();
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("H")) {
                        this.query = false;
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("Q")) {
                        this.query = true;
                    }
                    this.mensagens.add(message);
                    if (this.query) {
                        while (this.mensagens.size() > 0) {
                            String resultado = this.parse(this.mensagens.remove(0));
                            if (resultado == null || !resultado.startsWith("Erro")) continue;
                            this.fireExcecaoEncontrada(resultado);
                        }
                    }
                    if (message.substring(2, 3).equalsIgnoreCase("L")) {
                        this.query = false;
                        while (this.mensagens.size() > 0) {
                            this.addListaRecebimento(this.mensagens.remove(0));
                        }
                        this.restartThreadRecebimento();
                    }
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public boolean mensagemValida(String message) {
        int stx_index = message.indexOf(this.getMsgStart());
        if (stx_index >= 0 && message.length() > 5 && message.contains(String.valueOf('\u0003'))) {
            if (stx_index > 0) {
                message = message.substring(stx_index);
            } else if (stx_index < 0) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        try {
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            String nome = short_name;
            String sobrenome = null;
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String patient_id = req_codigo;
            String laboratory_pid = null;
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, patient_id, laboratory_pid, nome, sobrenome, pac_sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(ASTMStandard.getDefaultOrderRecord(1, codigo.toString(), alternativos, exa_lista, null, "R", acao, tipo_amostra, "O"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("N"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String test_id) {
        try {
            starting_range = starting_range.substring(1);
            if (starting_range.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.amostraInvalida = true;
                return;
            }
            this.host_fil_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboFilial());
            starting_range = starting_range.substring(ParametrosGerais.getDigitosTuboFilial());
            this.host_req_codigo = starting_range.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            this.host_rec_codigo = starting_range.substring(ParametrosGerais.getDigitosTuboRequisicao());
            this.hostQuery = true;
            this.hostQueryVazio = false;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Humastar 600: Host Query Response");
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery) {
            this.responseHostQuery();
        }
        if (this.amostraInvalida) {
            this.enviarRequisicaoSemExame("", "");
            this.amostraInvalida = false;
        }
    }

    public void responseHostQuery() {
        try {
            List<Object[]> reqs;
            String fil_codigo = this.host_fil_codigo;
            String req_codigo = this.host_req_codigo;
            String rec_codigo = this.host_rec_codigo;
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String rack = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            StringBuilder pac_exames = new StringBuilder("");
            String acao = "A";
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames.append((String)req[aba.getColIndice("Exame")]);
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (req != null) {
                    List<Object[]> reqs2 = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] objectArray : reqs2) {
                        pac_exames.append((String)objectArray[aba.getColIndice("Exame")]).append(" ");
                    }
                }
            }
            String situacao = null;
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) >= 7) continue;
                        situacao = (String)r[aba.getColIndice("Sit")];
                        pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                    }
                }
            }
            if (req == null) {
                aba.reloadExames();
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
                if (req != null) {
                    pac_exames.append((String)req[aba.getColIndice("Exame")]);
                }
            }
            if (req == null) {
                aba = this.equipamento.getTab(1);
                aba.reloadExames();
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                if (req != null) {
                    reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                    }
                }
            }
            if (req != null) {
                String rec_codigoPai;
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                String string = aba.getColIndice("Tubo") >= 0 ? (String)req[aba.getColIndice("Tubo")] : (rec_codigoPai = null);
                if (Funcoes.textoVazio(pac_exames.toString())) {
                    pac_exames.append(aba.getColIndice("Exame") >= 0 ? (String)req[aba.getColIndice("Exame")] : "");
                }
                String string2 = pac_exames.toString();
                pac_exames.setLength(0);
                for (String exa : string2.trim().split(" ")) {
                    if (BDUtil.isExameCurva(fil_codigo, int_codigo, exa, mco_codigo)) {
                        BDExame[] t;
                        for (BDExame bdExame : t = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exa, mco_codigo, rec_codigoPai, rec_codigo)) {
                            pac_exames.append(bdExame.getExame()).append(" ");
                        }
                        continue;
                    }
                    pac_exames.append(exa).append(" ");
                }
                if (situacao == null) {
                    situacao = aba.getColIndice("Sit") >= 0 ? (String)req[aba.getColIndice("Sit")] : null;
                }
                this.hostQueryVazio = false;
                this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rack, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao, null);
            } else {
                this.fireExcecaoEncontrada(String.format("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado nos dados recebidos %s %s %s", fil_codigo, req_codigo, rec_codigo));
                this.hostQueryVazio = true;
                this.enviarRequisicaoSemExame(fil_codigo, req_codigo);
            }
            this.hostQuery = false;
            this.host_fil_codigo = null;
            this.host_req_codigo = null;
            this.host_rec_codigo = null;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "Access: Host Query Response");
        }
    }

    private void enviarRequisicaoSemExame(String fil_codigo, String req_codigo) {
        try {
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, this.HOST_SYSTEM_VERSION, null, this.INSTRUMENT_NAME, this.INSTRUMENT_SYSTEM_VERSION));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String nome = "";
            try {
                if (!Funcoes.textoVazio(fil_codigo) && !Funcoes.textoVazio(req_codigo)) {
                    nome = BDUtil.getNomePaciente(fil_codigo, req_codigo);
                }
            }
            catch (Exception e) {
                this.fireExcecaoEncontrada(String.format("Paciente n\u00e3o encontrado %s %s %s", fil_codigo, req_codigo, this.rec_codigo));
            }
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, req_codigo, null, nome, null, this.pac_sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord("I"));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    public void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    public void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void teste() {
        String req = "010006434504";
        String alternativo = "UREIA";
        String res = "4.3";
        this.dataChangedTeste(this.equipamento.arruma("[STX]1H|\\^&|||JALIS^1.0|||||^1394-97||P|1|20180126151205|[CR]"));
        this.dataChangedTeste(this.equipamento.arruma("[STX]2P|1|0468852|||^ADELIR[SP]JOSE[SP]BALENA|||M|[CR]"));
        this.dataChangedTeste(this.equipamento.arruma("[STX]3O|1|" + req + "||^^^Ureia^UREIA|R||||||N||||||||||||||O|[CR]"));
        this.dataChangedTeste(this.equipamento.arruma("[STX]4L|1|N|[CR][ETX]83[LINE]"));
        this.dataChangedTeste(this.equipamento.arruma("[STX]1H|\\^&|[CR][ETX]61[LINE]"));
        this.dataChangedTeste(this.equipamento.arruma("[STX]2Q|1|^POS[SP]LIQUOR||ALL||||||||O[CR][ETX]08[LINE]"));
        this.dataChangedTeste(this.equipamento.arruma("[STX]3L|1|N[CR][ETX]06[LINE]"));
        this.dataChangedTeste(this.equipamento.arruma("[EOT][ENQ][EOT][ENQ][EOT]"));
    }

    public void recarregaAbaPendentes() {
        this.getAba(1).reloadExames();
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    System.out.println("Recebido resultado");
                    if (InterfaceListener.this.isRX()) {
                        InterfaceListener.this.aguardarProximoFrame();
                    }
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
                InterfaceListener.this.fireAtualizarTabela();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                this.negaUltimaMsg();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.negaUltimaMsg();
            }
            catch (Exception e) {
                e.printStackTrace();
                this.negaUltimaMsg();
            }
        }

        private void negaUltimaMsg() {
            try {
                InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0015'));
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }
}

