/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.humastar200;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.comunicacao.PortaFILE;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.humastar200.RecordParser;
import jalis.laboratorio.interfaceamento.interfaces.humastar200.Timer;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends InterfaceASTMListener {
    private ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
    private String DIRETORIO_EXPORTACAO = "";
    private String DIRETORIO_IMPORTACAO = "";
    private Timer timer;

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.DIRETORIO_EXPORTACAO = c.getDiretorioExportacao();
        this.DIRETORIO_IMPORTACAO = c.getDiretorioImportacao();
        this.recordParser = new RecordParser(this);
        this.timer = new Timer(this);
    }

    private void extrairResultados(String arquivo) {
        String[] linhas;
        for (String linha : linhas = arquivo.split("\n")) {
            try {
                this.recordParser.recordFound(linha);
            }
            catch (Exception e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            }
        }
    }

    @Override
    public String parse(String message) {
        File file = new File(this.DIRETORIO_IMPORTACAO);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".astm".toUpperCase());
            }
        };
        File[] files = file.listFiles(filter);
        if (files != null) {
            for (File f : files) {
                try {
                    String arquivo = StringUtil.lerArquivoTexto(f);
                    this.extrairResultados(arquivo);
                    f.delete();
                }
                catch (Exception e) {
                    this.fireMensagemEnviada("N\u00e3o foi poss\u00edvel importar o arquivo " + f.getName(), 1, 10000);
                }
            }
        }
        this.fireAtualizarTabela();
        return null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo);
            String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
            String nome = short_name;
            Object sobrenome = null;
            String patient_id = req_codigo;
            Object laboratory_pid = null;
            ArrayList<String> listaDados = new ArrayList<String>();
            listaDados.add(this.getHeader());
            listaDados.add(this.getPatient(codigo.toString(), pac_nome, fil_codigo, req_codigo));
            listaDados.add("C|1|||");
            Integer contador = 1;
            for (ExameMaterial exameMaterial : alternativos) {
                listaDados.add(this.getOrder(contador, exameMaterial));
                Integer n = contador;
                Integer n2 = contador = Integer.valueOf(contador + 1);
            }
            listaDados.add("L||N");
            this.criarArquivo(listaDados, codigo.toString(), pac_exames);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    private void criarArquivo(List<String> listaDados, String codigo, String exames) throws IOException {
        StringBuilder bui = new StringBuilder();
        for (String string : listaDados) {
            bui.append(string).append("\n");
        }
        String arquivo = codigo + Funcoes.formataData("ddMMHHmm", new Date()) + ".astm";
        arquivo = this.DIRETORIO_EXPORTACAO + System.getProperty("file.separator") + arquivo;
        PortaFILE p = (PortaFILE)this.getPortaCOM();
        p.createFile(arquivo);
        p.write(bui.toString());
        p.closeFile();
        this.atualizarExames();
    }

    private void atualizarExames() {
        try {
            String[] exms;
            Statement st = Conexao.getStatement();
            ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(this.pac_exames.split(" ", 0), this.mco_codigo);
            String[] stringArray = exms = this.pac_exames.split(" ", 0);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String s;
                int situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, s = stringArray[i], this.mco_codigo, this.rec_codigo);
                this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, s, this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                if (!this.curva || this.examesFilho.isEmpty()) continue;
                for (String exame : this.examesFilho) {
                    BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, s, this.mco_codigo, exame, this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                }
            }
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + this.pac_nome, 0, 10000);
            this.equipamento.atualizarTabela(0);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    private String getOrder(Integer contador, ExameMaterial exameMaterial) {
        StringBuilder buf = new StringBuilder();
        buf.append("O|");
        buf.append(contador).append("|||");
        buf.append(exameMaterial.getString());
        buf.append("|False").append("||||||||||Serum|||||||||||||||");
        return buf.toString();
    }

    private String getPatient(String codigo, String pac_nome, String fil_codigo, String req_codigo) throws SQLException {
        StringBuilder buf = new StringBuilder();
        buf.append("P|1||").append(codigo).append("||BIOQUIMICA|");
        buf.append(pac_nome.trim()).append("|");
        String[] dadosPaciente = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
        buf.append(Funcoes.formataData("yyyyMMdd", dadosPaciente[2])).append("|HUMAN|");
        buf.append("|||||||||||||");
        return buf.toString();
    }

    private String getHeader() {
        StringBuilder bui = new StringBuilder();
        bui.append("H|\\^&");
        bui.append("|||");
        bui.append("JALIS-2|");
        bui.append("||||Host||P||");
        bui.append(ASTMStandard.getCurrentMoment());
        bui.append("");
        return bui.toString();
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    public void recarregaAbaPendentes() {
        this.getAba(1).reloadExames();
    }
}

