/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.humastar180;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.EventObject;
import java.util.HashMap;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            Statement st = Conexao.getStatement();
            for (String exame : exames.split(" ")) {
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, acao.equals("N") ? 1 : 3);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            return null;
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\r');
    }

    @Override
    public String getMsgStart() {
        return "";
    }

    @Override
    public synchronized String parse(String message) {
        return null;
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public synchronized void dataChanged() {
        try {
            String data = this.getPortaCOM().removeInputString(this.getMsgEnd());
            if (data != null && data.endsWith(this.getMsgEnd())) {
                if (data.length() > this.getMsgEnd().length() && !(data = data.substring(0, data.length() - this.getMsgEnd().length())).startsWith("Humastar 180;")) {
                    this.resultadoRecebido(new Resultado(data));
                }
                if (this.getPortaCOM().getInputString().contains(this.getMsgEnd())) {
                    this.dataChanged();
                }
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            this.fireMensagemEnviada("Erro ao receber dados do equipamento", 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void resultadoRecebido(Resultado resultado) throws Exception {
        int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        String tuboId = resultado.getTubo();
        if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
            String emiAlternativo;
            Statement st = Conexao.getStatement();
            String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
            String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            String intCodigo = this.getIntCodigo(filCodigo, reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), recCodigo, emiAlternativo = resultado.getTeste());
            ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
            if (exame != null) {
                HashMap<String, Object> dados = new HashMap<String, Object>();
                int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                String campoQuant = sit < 3 ? "resultado_quantitativo" : "repeticao_quantitativo";
                String campoQuali = sit < 3 ? "resultado_qualitativo" : "repeticao_qualitativo";
                String valorResultado = resultado.getResultado();
                StringBuilder valorResultadoQuant = new StringBuilder();
                for (char c : valorResultado.toCharArray()) {
                    if (c != '.' && !Character.isDigit(c)) break;
                    valorResultadoQuant.append(c);
                }
                dados.put(campoQuant, valorResultadoQuant.toString().replace('.', ','));
                dados.put(campoQuali, valorResultado.replace('.', ','));
                this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), intCodigo, dados);
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
        }
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        this.getPortaCOM().clearInputString();
    }

    private class Resultado {
        private String tubo;
        private String nome;
        private String teste;
        private String resultado;

        public Resultado(String data) throws ParseException {
            String[] partes = data.split(";", -1);
            this.tubo = partes[0];
            this.nome = partes[1];
            this.teste = partes[2];
            this.resultado = partes[3];
        }

        public String getTubo() {
            return this.tubo;
        }

        public String getNome() {
            return this.nome;
        }

        public String getTeste() {
            return this.teste;
        }

        public String getResultado() {
            return this.resultado;
        }
    }
}

