/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.humalyteplus3;

import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.CamposCoagulacao;
import jalis.laboratorio.interfaceamento.exames.Exame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.humalyteplus3.CamposHumalytePlus3;
import jalis.laboratorio.interfaceamento.resultados.repeticao.AbstractEditarRepeticaoComposta;
import jalis.laboratorio.interfaceamento.resultados.repeticao.MembroExamesComposto;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.JFrame;

public class EditarRepeticaoComposta
extends AbstractEditarRepeticaoComposta {
    public EditarRepeticaoComposta(JFrame parent, String filCodigo, String intCodigo, String reqCodigo, String exaCodigo, String mcoCodigo, String recCodigo, String pacNome, String usrCodigo) {
        super(parent, filCodigo, intCodigo, reqCodigo, exaCodigo, mcoCodigo, recCodigo, pacNome, usrCodigo);
    }

    @Override
    public void instanciaExameELista(String filCodigo, String intCodigo, String reqCodigo, String exaCodigo, String mcoCodigo, String recCodigo) throws Exception {
        this.exame = new Exame(filCodigo, intCodigo, reqCodigo, exaCodigo, mcoCodigo, recCodigo);
        BDExame[] temp = BDUtil.getDesmExamesFilhos(filCodigo, intCodigo, reqCodigo, exaCodigo, mcoCodigo, recCodigo);
        Map<String, Object> valores = this.exame.getDados();
        ArrayList<String> listaOrdenada = new ArrayList<String>();
        for (String k : valores.keySet()) {
            listaOrdenada.add(k);
        }
        Collections.sort(listaOrdenada);
        if (temp.length > 0) {
            for (BDExame exm : temp) {
                if (exm.getSituacao() != 3) continue;
                this.setDesmembrado(true);
                String exaKodigo = exm.getExame();
                String mcoKodigo = exm.getMaterial();
                String keyAux = null;
                for (String key : listaOrdenada) {
                    if (key.contains("repeticao") || key.contains("flag") || !key.contains(exaKodigo)) continue;
                    if (keyAux == null) {
                        keyAux = exaKodigo + "_" + mcoKodigo;
                        this.lista.put(keyAux, new LinkedList());
                    }
                    ExameMaterial exa = new ExameMaterial(exaKodigo, new Integer(mcoKodigo));
                    String parametroRepeticao = key.replace("@", "repeticao_@");
                    String repet = (String)this.exame.getValor(parametroRepeticao);
                    exa.setCampoExame(CamposCoagulacao.getValue(key.substring(0, key.indexOf("@"))));
                    if (!this.lista.containsKey(keyAux)) continue;
                    ((LinkedList)this.lista.get(keyAux)).add(new MembroExamesComposto(exa, valores.get(key).toString(), null, repet, key));
                }
            }
        } else {
            ExameMaterial exa = null;
            String keyAux = null;
            LinkedList<MembroExamesComposto> listaCampos = new LinkedList<MembroExamesComposto>();
            for (String key : listaOrdenada) {
                if (key.contains("repeticao") || key.contains("flag")) continue;
                if (keyAux == null) {
                    keyAux = key;
                }
                String repet = (String)this.exame.getValor("repeticao_" + key);
                exa = new ExameMaterial(exaCodigo, new Integer(mcoCodigo));
                exa.setCampoExame(CamposHumalytePlus3.getValue(key));
                listaCampos.add(new MembroExamesComposto(exa, valores.get(key).toString(), null, repet, key));
            }
            this.lista.put(keyAux, listaCampos);
        }
    }

    @Override
    public void salvaDados(Statement st) throws Exception {
        this.atualizaValores();
        this.exame.salvaDados(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exa_codigo, this.mco_codigo, this.rec_codigo);
    }

    private void atualizaValores() {
        for (String key : this.lista.keySet()) {
            LinkedList itens = (LinkedList)this.lista.get(key);
            for (MembroExamesComposto item : itens) {
                String valor = StringUtil.limpaString(item.getQuanti(), new String[]{" ", ".", ","});
                if (Funcoes.textoVazio(valor)) continue;
                this.exame.setValor(item.getParametro(), item.getCampoFinal().getText());
            }
        }
    }
}

