/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.hitachi917s;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.hitachi917s.Hitachi917s;
import jalis.laboratorio.interfaceamento.interfaces.hitachi917s.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.Checksum;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final String COMMENT_1 = "comment1";
    private static final String COMMENT_2 = "comment2";
    private static final String COMMENT_3 = "comment3";
    private static final String COMMENT_4 = "comment4";
    private static final String COMMENT_5 = "comment5";
    private static final String COMMENT_FLAGS = "commentFlags";
    private static final String RESULT_COUNT = "resultCount";
    private static final String RESULTADOS = "resultados";
    private static final String OPERATOR_ID = "operatorID";
    private static final String COLLECTION_TIME = "collectionTime";
    private static final String COLLECTION_DATE = "collectionDate";
    private static final String SEX = "sex";
    private static final String AGE_UNITS = "ageUnits";
    private static final String AGE = "age";
    private static final String SAMPLE_CUP = "sampleCup";
    private static final String SAMPLE_CLASS = "sampleClass";
    private static final String FRAME = "frame";
    private static final String PACKET_NUMBER = "packetNumber";
    private static final String SENDER_ID = "senderID";
    private static final String RECEIVER_ID = "receiverID";
    private static final String ID_NUMBER = "idNumber";
    private static final String POSITION_NUMBER = "positionNumber";
    private static final String DISK_NUMBER = "diskNumber";
    private static final String SAMPLE_NUMBER = "sampleNumber";
    private static final String FUNCTION_CODE = "functionCode";
    private static final int RETRY_COUNT = 3;
    private static final int RETRY_TIME = 5;
    private static final int TIME_OUT = 5000;
    private static final int TEXT_SIZE = 256;
    private static final String RESULT_REQUEST = "<";
    private static final String TEST_SELECT_REQUEST = ";";
    private static final String TEST_SELECT_DOWNLOAD = ";";
    private static final String RESULT_FRAME_1 = "1";
    private static final String RESULT_FRAME_2 = "2";
    private static final String RESULT_FRAME_3 = "3";
    private static final String RESULT_FRAME_4 = "4";
    private static final String RESULT_FRAME_5 = "5";
    private static final String END_RESULT_FRAME = ":";
    private static final String DATA_ACCEEPTED = ">";
    private static final String REPEAT = "?";
    private static final String DATA_BAD = "@";
    private static final String DATA_ACCEEPTED_SUSPEND = "A";
    private static final String CHANNEL_COUNT = "88";
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();
    private int packetNumber = 0;
    private boolean curva = false;
    private String rec_tuboPai = "";
    private List<String> examesFilho = new LinkedList<String>();
    private static final String MASK_DATA = "MMddyy";
    private static final String MASK_HORA = "hhmm";
    private String frame;
    private List<String> frameResults = new ArrayList<String>();
    private InfoExameRequisicao ultimo_enviado = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public void dataChanged(String msg) {
        try {
            if (msg.length() == 1 && msg.equals(String.valueOf('\u0003'))) {
                this.getPortaCOM().write(String.valueOf('\u0003'));
                return;
            }
            if (!msg.startsWith(String.valueOf(this.getMsgStart())) || !msg.endsWith(String.valueOf(this.getMsgEnd()))) return;
            this.getPortaCOM().clearInputString();
            int index = msg.indexOf(String.valueOf(this.getMsgStart()));
            String frameType = msg.substring(index + 4, index + 5);
            if (!this.validaCheckSum(msg)) {
                this.controlPacket(REPEAT);
                return;
            }
            if (frameType.equals(";")) {
                this.controlPacket(DATA_ACCEEPTED);
                if (!this.validaCheckSum(msg)) return;
                this.responderRequest(msg);
                return;
            }
            if (frameType.equals(RESULT_FRAME_1)) {
                this.frameResults.add(msg);
                this.controlPacket(DATA_ACCEEPTED);
                return;
            }
            if (frameType.equals(RESULT_FRAME_2)) {
                this.frameResults.add(msg);
                this.controlPacket(DATA_ACCEEPTED);
                return;
            }
            if (frameType.equals(END_RESULT_FRAME)) {
                this.controlPacket(DATA_ACCEEPTED);
                StringBuilder msgs = new StringBuilder();
                while (this.frameResults.size() > 0) {
                    msgs.append(this.frameResults.remove(0));
                }
                msgs.append(msg);
                this.addListaRecebimento(msgs.toString());
                return;
            }
            if (frameType.equals(DATA_ACCEEPTED)) {
                this.controlPacket(DATA_ACCEEPTED);
                if (this.frame == null) return;
                this.confirmaTransmissao();
                return;
            }
            if (frameType.equals(REPEAT)) {
                this.retransmitir();
                return;
            }
            if (frameType.equals(DATA_BAD)) {
                this.setPausa(5000);
                return;
            }
            if (!frameType.equals(DATA_ACCEEPTED_SUSPEND)) return;
        }
        catch (IOException e) {
            this.fireExcecaoEncontrada(String.format("Erro ao tentar responder solicita\u00e7\u00e3o para o aparelho (%s - %s)", e.getMessage(), e.getLocalizedMessage()));
            e.printStackTrace();
            return;
        }
        catch (SQLException e) {
            this.fireExcecaoEncontrada(String.format("Erro de SQL ao responder solicita\u00e7\u00e3o para o aparelho (%s - %s)", e.getMessage(), e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    public InterfaceListener() {
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    public void dataChanged() {
        try {
            String msg = this.getPortaCOM().getInputString();
            if (msg.length() == 1 && msg.equals(String.valueOf('\u0003'))) {
                this.getPortaCOM().write(String.valueOf('\u0003'));
            } else if (msg.startsWith(String.valueOf(this.getMsgStart())) && msg.endsWith(String.valueOf(this.getMsgEnd()))) {
                this.getPortaCOM().clearInputString();
                String frameType = msg.substring(4, 5);
                if (!this.validaCheckSum(msg)) {
                    this.controlPacket(REPEAT);
                    return;
                }
                if (frameType.equals(";")) {
                    if (this.validaCheckSum(msg)) {
                        this.responderRequest(msg);
                    }
                } else if (frameType.equals(RESULT_FRAME_1) || frameType.equals(RESULT_FRAME_2) || frameType.equals(RESULT_FRAME_3) || frameType.equals(RESULT_FRAME_4) || frameType.equals(RESULT_FRAME_5)) {
                    this.frameResults.add(msg);
                    this.controlPacket(DATA_ACCEEPTED);
                } else if (frameType.equals(END_RESULT_FRAME)) {
                    this.controlPacket(DATA_ACCEEPTED);
                    StringBuilder msgs = new StringBuilder();
                    while (this.frameResults.size() > 0) {
                        msgs.append(this.frameResults.remove(0));
                    }
                    msgs.append(msg);
                    this.addListaRecebimento(msgs.toString());
                } else if (frameType.equals(DATA_ACCEEPTED)) {
                    this.controlPacket(DATA_ACCEEPTED);
                    if (this.frame != null) {
                        this.confirmaTransmissao();
                    }
                } else if (frameType.equals(REPEAT)) {
                    this.retransmitir();
                } else if (frameType.equals(DATA_BAD)) {
                    this.setPausa(5000);
                }
            }
        }
        catch (IOException e) {
            this.fireExcecaoEncontrada(String.format("Erro ao tentar responder solicita\u00e7\u00e3o para o aparelho (%s - %s)", e.getMessage(), e.getLocalizedMessage()));
            e.printStackTrace();
        }
        catch (SQLException e) {
            this.fireExcecaoEncontrada(String.format("Erro de SQL ao responder solicita\u00e7\u00e3o para o aparelho (%s - %s)", e.getMessage(), e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    private void retransmitir() {
        if (this.frame != null) {
            try {
                this.getPortaCOM().write(this.frame);
            }
            catch (IOException ex) {
                ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "InterfaceListener: 128");
            }
        }
    }

    private void confirmaTransmissao() {
        try {
            String[] exames;
            if (this.ultimo_enviado == null || this.ultimo_enviado.getExames() == null) {
                return;
            }
            Statement st = Conexao.getStatement();
            for (String exame : exames = this.ultimo_enviado.getExames().split(" ", 0)) {
                int situacao;
                String fil_codigo = this.ultimo_enviado.getFilial();
                String req_codigo = this.ultimo_enviado.getCodigo();
                String mco_codigo = this.ultimo_enviado.getMaterial();
                String rec_codigo = this.ultimo_enviado.getRecipiente();
                String recTuboPai = this.ultimo_enviado.getTuboPai();
                String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, exame, mco_codigo);
                if (!Funcoes.textoVazio(recTuboPai) && this.ultimo_enviado.isCurva().booleanValue()) {
                    recTuboPai = Funcoes.preencheZero(recTuboPai, ParametrosGerais.getDigitosTuboTubo());
                    int_codigo = this.getIntCodigo(fil_codigo, req_codigo, recTuboPai, exame, mco_codigo);
                    situacao = -1;
                    String[] stringArray = this.ultimo_enviado.getExamesFilho().split(" ");
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String exameFilho;
                        situacao = BDUtil.getDesmSituacao(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, recTuboPai, exameFilho = stringArray[i], mco_codigo);
                        BDUtil.setExmSituacaoFilho(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, exameFilho, mco_codigo, recTuboPai, situacao < 2 ? 1 : 3);
                    }
                    situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, recTuboPai);
                    if (BDUtil.isGrupoInteiroPendente(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, recTuboPai)) {
                        this.atualizarSituacaoExame(st, fil_codigo, req_codigo, recTuboPai, exame, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                    }
                } else {
                    if (int_codigo == null) {
                        int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, exame, mco_codigo);
                    }
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, (situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame, mco_codigo, rec_codigo)) < 2 ? 1 : 3);
                }
                if (!req_codigo.equals(this.ultimo_enviado.getCodigo())) continue;
                this.firePacienteEnviado(this.ultimo_enviado.getCodigo(), this.ultimo_enviado.getNome(), this.ultimo_enviado.getSexo(), this.ultimo_enviado.getIdade(), this.ultimo_enviado.getData(), this.ultimo_enviado.getHora(), this.ultimo_enviado.getExames());
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
            this.equipamento.mensagemEnviada("Exame enviado com sucesso para " + this.ultimo_enviado.getNome(), 1, 5000);
            this.ultimo_enviado = null;
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private boolean validaCheckSum(String msg) {
        return true;
    }

    private Map<String, String> parseMsgRequest(String msg) {
        HashMap<String, String> request = new HashMap<String, String>();
        int ini = 1;
        int end = 2;
        String receiverID = msg.substring(ini, end);
        String senderID = msg.substring(++ini, ++end);
        String packetNumber = msg.substring(++ini, ++end);
        String frame = msg.substring(++ini, ++end);
        String functionCode = msg.substring(++ini, ++end);
        String sampleClass = msg.substring(++ini, ++end);
        String sampleNumber = msg.substring(++ini, end += 5);
        String diskNumber = msg.substring(ini += 5, end += 5);
        String positionNumber = msg.substring(ini += 5, end += 3);
        String sampleCup = msg.substring(ini += 3, ++end);
        String idNumber = msg.substring(++ini, end += 13);
        String age = msg.substring(ini += 13, end += 3);
        String ageUnits = msg.substring(ini += 3, ++end);
        String sex = msg.substring(++ini, ++end);
        String collectionDate = msg.substring(++ini, end += 6);
        String collectionTime = msg.substring(ini += 6, end += 4);
        request.put(RECEIVER_ID, receiverID);
        request.put(SENDER_ID, senderID);
        request.put(PACKET_NUMBER, packetNumber);
        request.put(FRAME, frame);
        request.put(FUNCTION_CODE, functionCode);
        request.put(SAMPLE_CLASS, sampleClass);
        request.put(SAMPLE_NUMBER, sampleNumber);
        request.put(DISK_NUMBER, diskNumber);
        request.put(POSITION_NUMBER, positionNumber);
        request.put(SAMPLE_CUP, sampleCup);
        request.put(ID_NUMBER, idNumber);
        request.put(AGE, age);
        request.put(AGE_UNITS, ageUnits);
        request.put(SEX, sex);
        request.put(COLLECTION_DATE, collectionDate);
        request.put(COLLECTION_TIME, collectionTime);
        return request;
    }

    public void responderRequest(String msg) throws IOException, SQLException {
        List<Object[]> reqs;
        Map<String, String> request = this.parseMsgRequest(msg);
        String functionCode = request.get(FUNCTION_CODE);
        String sampleNumber = request.get(SAMPLE_NUMBER);
        String diskNumber = request.get(DISK_NUMBER);
        String positionNumber = request.get(POSITION_NUMBER);
        String sampleCup = request.get(SAMPLE_CUP);
        String idNumber = request.get(ID_NUMBER).trim();
        int tam = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        String idAmostra = Funcoes.preencheZero(idNumber.trim(), tam);
        String fil_codigo = idAmostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = idAmostra.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = idAmostra.substring(ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        String age = "  1";
        String ageUnits = RESULT_FRAME_3;
        String sex = "0";
        String data = Funcoes.formataData(MASK_DATA, Calendar.getInstance().getTime());
        String hora = Funcoes.formataData(MASK_HORA, Calendar.getInstance().getTime()).replace(END_RESULT_FRAME, "");
        StringBuilder tests = new StringBuilder(StringUtil.repeteCaractere('0', Integer.parseInt(CHANNEL_COUNT)));
        if (!(Funcoes.isNumeric(fil_codigo) && Funcoes.isNumeric(req_codigo) && Funcoes.isNumeric(rec_codigo) && Integer.parseInt(fil_codigo) != 0)) {
            this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o n\u00e3o interfaceada: %s %s %s", fil_codigo, req_codigo, rec_codigo));
            this.enviaRequisicaoSemExame(functionCode, sampleNumber, diskNumber, positionNumber, idNumber, age, ageUnits, sex, data, hora, tests);
            return;
        }
        idNumber = Funcoes.preencheVazio(idNumber, 13, 1);
        String pac_nome = null;
        String pac_sexo = null;
        String pac_idade = null;
        String rack = null;
        Object prioridade = null;
        String int_codigo = null;
        String mco_codigo = null;
        StringBuilder pac_exames = new StringBuilder("");
        String acao = DATA_ACCEEPTED_SUSPEND;
        String requisicaoMae = req_codigo;
        this.curva = false;
        this.rec_tuboPai = "";
        this.examesFilho = new LinkedList<String>();
        ExameMaterial[] alternativos = null;
        Object listaCurva = null;
        Map<String, List<ExameMaterial>> alternativosCurva = null;
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            requisicaoMae = Funcoes.preencheZero(BDUtil.getReqMultiGuiaMae(fil_codigo, req_codigo), ParametrosGerais.getDigitosTuboRequisicao());
        }
        Object[] req = this.getRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 0);
        PanelAbaAbstrata aba = this.getAba(0);
        if (req != null) {
            reqs = this.getTodasRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 0);
            for (Object[] r : reqs) {
                pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
            }
        }
        if (req == null) {
            req = this.getRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 1);
            aba = this.equipamento.getTab(1);
            if (req != null) {
                reqs = this.getTodasRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 1);
                for (Object[] r : reqs) {
                    pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                }
            }
        }
        if (req == null && (req = this.getRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 2)) != null) {
            aba = this.equipamento.getTab(2);
            if (req != null) {
                reqs = this.getTodasRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 2);
                for (Object[] r : reqs) {
                    if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                    pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                }
            }
        }
        if (req == null) {
            this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o n\u00e3o interfaceada: %s %s %s", fil_codigo, req_codigo, rec_codigo));
            this.enviaRequisicaoSemExame(functionCode, sampleNumber, diskNumber, positionNumber, idNumber, age, ageUnits, sex, data, hora, tests);
            return;
        }
        pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
        pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
        rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
        int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
        String string = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : (mco_codigo = null);
        if (Funcoes.textoVazio(pac_exames.toString())) {
            pac_exames.append((String)req[aba.getColIndice("Exame")]);
        }
        if (pac_sexo != null) {
            sex = pac_sexo.equalsIgnoreCase("M") ? RESULT_FRAME_1 : (pac_sexo.equalsIgnoreCase("F") ? RESULT_FRAME_2 : "0");
        }
        Statement st = Conexao.getStatement();
        String[] exames = pac_exames.toString().split(" ");
        ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(pac_exames.toString().split(" "), mco_codigo);
        exa_lista = ExamesUtil.anexarCodigoMaterial(exames, mco_codigo);
        String tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, exa_lista[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo);
        if (Funcoes.textoVazio(tipo_amostra)) {
            tipo_amostra = RESULT_FRAME_1;
        }
        ArrayList<ExameMaterial> exa_listaCurva = new ArrayList<ExameMaterial>();
        exa_lista = ExamesUtil.separaExamesCurva(fil_codigo, int_codigo, mco_codigo, exa_lista, exa_listaCurva);
        ArrayList<String> reqs2 = null;
        if (exa_lista != null) {
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
        } else {
            exa_lista = ExamesUtil.anexarCodigoMaterial(exames, mco_codigo);
            this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, req_codigo, rec_codigo, int_codigo, exa_lista[0].getNomeExame(), mco_codigo);
            if (!exa_listaCurva.isEmpty() && Funcoes.textoVazio(this.rec_tuboPai)) {
                reqs2 = BDUtil.getReqMultiGuias(fil_codigo, req_codigo);
                for (String requisicao : reqs2) {
                    this.rec_tuboPai = BDUtil.getExameDesmembradoTuboPai(fil_codigo, requisicao, rec_codigo, int_codigo, ((ExameMaterial)exa_listaCurva.get(0)).getNomeExame(), mco_codigo);
                    if (Funcoes.textoVazio(this.rec_tuboPai)) continue;
                    break;
                }
            }
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_listaCurva.toArray(new ExameMaterial[exa_listaCurva.size()]));
        }
        alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
        alternativos = ExamesUtil.removeDuplicados(alternativos);
        if (!exa_listaCurva.isEmpty()) {
            if (alternativos != null && alternativos.length == 1) {
                alternativos = null;
            }
            if ((alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, st, exa_listaCurva, this.rec_tuboPai, true, this.examesFilho)).isEmpty()) {
                String requisicao;
                Iterator<String> iterator = reqs2.iterator();
                while (iterator.hasNext() && (alternativosCurva = ExamesUtil.getAlternativosCurva(fil_codigo, int_codigo, requisicao = iterator.next(), mco_codigo, rec_codigo, st, exa_listaCurva, this.rec_tuboPai, true, this.examesFilho)).isEmpty()) {
                }
            }
        }
        if (alternativosCurva != null && alternativosCurva.size() > 0) {
            this.curva = true;
            alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            alternativos = ExamesUtil.removeDuplicados(alternativos);
        }
        String comment1 = StringUtil.repeteCaractere(' ', 30);
        String comment2 = StringUtil.repeteCaractere(' ', 30);
        if (pac_nome.indexOf(" ") > 0) {
            comment1 = pac_nome.substring(0, pac_nome.indexOf(" ")) + StringUtil.repeteCaractere(' ', 30);
            comment2 = pac_nome.substring(pac_nome.indexOf(" ")) + StringUtil.repeteCaractere(' ', 30);
        }
        comment1 = comment1.substring(0, 30);
        comment2 = comment2.substring(0, 25);
        String comment3 = "";
        String comment4 = "";
        String comment5 = "";
        String[] pac_dados = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
        Object dataNasc = null;
        if (pac_dados != null) {
            age = Funcoes.preencheVazio(pac_dados[0], 3, 1);
            ageUnits = pac_dados[1].equals(DATA_ACCEEPTED_SUSPEND) ? RESULT_FRAME_3 : ageUnits;
            ageUnits = pac_dados[1].equals("M") ? RESULT_FRAME_2 : ageUnits;
            ageUnits = pac_dados[1].equals("D") ? RESULT_FRAME_1 : ageUnits;
        }
        for (ExameMaterial exameMaterial : alternativos) {
            if (!Funcoes.isNumeric(exameMaterial.getNomeExame())) continue;
            int pos = Integer.parseInt(exameMaterial.getNomeExame());
            if (pos > 87) {
                pos = 87;
            }
            tests.replace(pos - 1, pos, RESULT_FRAME_1);
        }
        this.frame = this.getTestSelectionDownload(this.configuracao.getReceiver(), this.configuracao.getSender(), this.getPacketNumber(), functionCode, tipo_amostra, RESULT_FRAME_1, sampleNumber, diskNumber, positionNumber, idNumber, age, ageUnits, sex, data, hora, CHANNEL_COUNT, tests.toString(), !Funcoes.textoVazio(comment1), !Funcoes.textoVazio(comment2), !Funcoes.textoVazio(comment3), !Funcoes.textoVazio(comment4), !Funcoes.textoVazio(comment5), comment1, comment2, comment3, comment4, comment5);
        this.ultimo_enviado = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames.toString());
        this.ultimo_enviado.setTuboPai(this.rec_tuboPai);
        this.ultimo_enviado.setExamesFilho(StringUtil.implode(this.examesFilho, " "));
        this.ultimo_enviado.setCurva(true);
        this.getPortaCOM().write(this.frame);
    }

    private void enviaRequisicaoSemExame(String functionCode, String sampleNumber, String diskNumber, String positionNumber, String idNumber, String age, String ageUnits, String sex, String data, String hora, StringBuilder tests) throws IOException {
        this.frame = this.getTestSelectionDownload(this.configuracao.getReceiver(), this.configuracao.getSender(), this.getPacketNumber(), functionCode, RESULT_FRAME_1, RESULT_FRAME_1, sampleNumber, diskNumber, positionNumber, idNumber, age, ageUnits, sex, data, hora, CHANNEL_COUNT, tests.toString(), false, false, false, false, false, "", "", "", "", "");
        this.getPortaCOM().write(this.frame);
    }

    private void controlPacket(String controle) throws IOException {
        StringBuilder buf = new StringBuilder(String.valueOf('\u0002'));
        buf.append(this.configuracao.getReceiver());
        buf.append(this.configuracao.getSender());
        buf.append(this.getPacketNumber());
        buf.append(controle);
        String checksum = Checksum.getChecksumMod256(buf.substring(1));
        buf.append('\u0003').append(checksum).append(this.getMsgEnd());
        this.getPortaCOM().write(buf.toString());
    }

    private int getPacketNumber() {
        ++this.packetNumber;
        if (this.packetNumber > 8 || this.packetNumber == 0) {
            this.packetNumber = 1;
        }
        return this.packetNumber;
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\r');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        try {
            String[] msgs;
            for (String msg : msgs = message.split(String.valueOf('\r'))) {
                this.parseResult(msg);
            }
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Erro ao receber resultado do equipamento!");
            e.printStackTrace();
        }
        return null;
    }

    private Map<String, Object> parseMsgResult(String msg) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        ArrayList<Resultado> resultados = new ArrayList<Resultado>();
        int ini = 1;
        int end = 2;
        String receiverID = msg.substring(ini, end);
        String senderID = msg.substring(++ini, ++end);
        String packetNumber = msg.substring(++ini, ++end);
        String frame = msg.substring(++ini, ++end);
        String functionCode = msg.substring(++ini, ++end);
        String sampleClass = msg.substring(++ini, ++end);
        String sampleNumber = msg.substring(++ini, end += 5);
        String diskNumber = msg.substring(ini += 5, end += 5);
        String positionNumber = msg.substring(ini += 5, end += 3);
        String sampleCup = msg.substring(ini += 3, ++end);
        String iDNumber = msg.substring(++ini, end += 13);
        String age = msg.substring(ini += 13, end += 3);
        String ageUnits = msg.substring(ini += 3, ++end);
        String sex = msg.substring(++ini, ++end);
        String collectionDate = msg.substring(++ini, end += 6);
        String collectionTime = msg.substring(ini += 6, end += 4);
        String operatorID = msg.substring(ini += 4, end += 6);
        String resultCount = msg.substring(ini += 6, end += 3);
        ini += 3;
        end += 3;
        if (Funcoes.isNumeric(resultCount)) {
            int numeroDeResultados = Integer.parseInt(resultCount.trim());
            for (int i = 0; i < numeroDeResultados; ++i) {
                Resultado resultado = new Resultado();
                resultado.testNumber = msg.substring(ini, end);
                resultado.result = msg.substring(ini += 3, end += 6);
                ini += 6;
                ++end;
                if (i + 1 < numeroDeResultados) {
                    resultado.alarmCode = msg.substring(ini, end);
                    ++ini;
                    end += 3;
                } else {
                    resultado.alarmCode = msg.substring(ini, end);
                    ++ini;
                    end += 5;
                }
                resultados.add(resultado);
            }
        }
        String commentFlags = "";
        String comment1 = "";
        String comment2 = "";
        String comment3 = "";
        String comment4 = "";
        String comment5 = "";
        if (msg.length() >= end) {
            commentFlags = msg.substring(ini, end);
            comment1 = msg.substring(ini += 5, end += 30);
            comment2 = msg.substring(ini += 30, end += 25);
            comment3 = msg.substring(ini += 25, end += 20);
            comment4 = msg.substring(ini += 20, end += 15);
            comment5 = msg.substring(ini += 15, end += 10);
        }
        request.put(RECEIVER_ID, receiverID);
        request.put(SENDER_ID, senderID);
        request.put(PACKET_NUMBER, packetNumber);
        request.put(FRAME, frame);
        request.put(FUNCTION_CODE, functionCode);
        request.put(SAMPLE_CLASS, sampleClass);
        request.put(SAMPLE_NUMBER, sampleNumber);
        request.put(DISK_NUMBER, diskNumber);
        request.put(POSITION_NUMBER, positionNumber);
        request.put(SAMPLE_CUP, sampleCup);
        request.put(ID_NUMBER, iDNumber);
        request.put(AGE, age);
        request.put(AGE_UNITS, ageUnits);
        request.put(SEX, sex);
        request.put(COLLECTION_DATE, collectionDate);
        request.put(COLLECTION_TIME, collectionTime);
        request.put(OPERATOR_ID, operatorID);
        request.put(RESULT_COUNT, resultCount);
        request.put(COMMENT_FLAGS, commentFlags);
        request.put(COMMENT_1, comment1);
        request.put(COMMENT_2, comment2);
        request.put(COMMENT_3, comment3);
        request.put(COMMENT_4, comment4);
        request.put(COMMENT_5, comment5);
        request.put(RESULTADOS, resultados);
        return request;
    }

    private void parseResult(String msgx) throws Exception {
        Map<String, Object> result = this.parseMsgResult(msgx);
        String functionCode = String.valueOf(result.get(FUNCTION_CODE));
        String idNumber = String.valueOf(result.get(ID_NUMBER));
        idNumber = Funcoes.preencheZero(idNumber.trim(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo());
        String fil_codigo = idNumber.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = idNumber.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = idNumber.substring(ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        if (!(Funcoes.isNumeric(fil_codigo) && Funcoes.isNumeric(req_codigo) && Funcoes.isNumeric(rec_codigo) && Integer.parseInt(fil_codigo) != 0)) {
            this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o com formato fora do padr\u00e3o %s %s %s ", fil_codigo, req_codigo, rec_codigo));
            return;
        }
        Statement st = Conexao.getStatement();
        String resultCount = String.valueOf(result.get(RESULT_COUNT));
        int qtdeResultados = Integer.parseInt(resultCount.trim());
        List resultados = (List)result.get(RESULTADOS);
        for (Resultado r : resultados) {
            String int_codigo;
            String emi_alternativo;
            String alarmCode;
            String resultado;
            block11: {
                resultado = r.result.trim().replaceFirst("\\.", ",");
                alarmCode = r.alarmCode;
                emi_alternativo = r.testNumber.trim();
                int_codigo = "";
                try {
                    int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (int_codigo == null) {
                        this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    }
                    break block11;
                }
                catch (Exception e) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                }
                continue;
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
            String flag = ((Hitachi917s)this.equipamento).getFlag(alarmCode);
            if (exame == null) {
                this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                continue;
            }
            String res = resultado.replaceFirst("\\.", ",");
            HashMap<String, Object> dados = new HashMap<String, Object>();
            int situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo);
            if (situacao <= 2) {
                dados.put("resultado_quantitativo", res);
            } else if (situacao > 2 && this.configuracao.getRepeticaoAutomatica()) {
                dados.put("repeticao_quantitativo", res);
            }
            ArrayList<String> flags = new ArrayList<String>();
            if (!Funcoes.textoVazio(flag)) {
                flags.add(flag);
                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados, flags);
            } else {
                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
            }
            if (!alarmCode.equals("=") || !this.configuracao.getRepeticaoAutomatica() || (situacao = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), rec_codigo)) != 2) continue;
            this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, null, 3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        if (acao.equals(DATA_ACCEEPTED_SUSPEND)) {
            Statement st = Conexao.getStatement();
            try {
                String[] stringArray = exames.split(" ");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String exame;
                    int sitAtual = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame = stringArray[i], mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, sitAtual < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    private String getTestSelectionDownload(String receiverID, String senderID, int packetNumber, String functionCode, String containerType, String standardCup, String sampleNumber, String diskNumber, String positionNumber, String idNumber, String age, String ageUnits, String sex, String data, String hora, String channelCount, String tests, boolean flag1, boolean flag2, boolean flag3, boolean flag4, boolean flag5, String comment1, String comment2, String comment3, String comment4, String comment5) {
        StringBuilder record = new StringBuilder();
        record.append(String.valueOf('\u0002'));
        record.append(receiverID);
        record.append(senderID);
        record.append(packetNumber);
        record.append(";");
        record.append(functionCode);
        record.append(containerType);
        record.append(sampleNumber);
        record.append(diskNumber);
        record.append(positionNumber);
        record.append(standardCup);
        record.append(idNumber);
        record.append(age);
        record.append(ageUnits);
        record.append(sex);
        record.append(data);
        record.append(hora);
        record.append(" ");
        record.append(channelCount);
        record.append(tests);
        record.append(flag1 ? RESULT_FRAME_1 : "0");
        record.append(flag2 ? RESULT_FRAME_1 : "0");
        record.append(flag3 ? RESULT_FRAME_1 : "0");
        record.append(flag4 ? RESULT_FRAME_1 : "0");
        record.append(flag5 ? RESULT_FRAME_1 : "0");
        record.append(flag1 ? comment1 : "");
        record.append(flag2 ? comment2 : "");
        record.append(flag3 ? comment3 : "");
        record.append(flag4 ? comment4 : "");
        record.append(flag5 ? comment5 : "");
        String checksum = Checksum.getChecksumMod256(record.substring(1));
        record.append('\u0003').append(checksum).append(this.getMsgEnd());
        return record.toString();
    }

    private String getFlag(String alarmFlag) {
        return ((Hitachi917s)this.equipamento).getFlag(alarmFlag);
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    @Override
    public void teste() {
        StringBuilder buf = new StringBuilder();
        buf.append("[STX]124;A1[SP][SP][SP]92[SP][SP][SP][SP]5[SP]921[SP]010007491604[SP]41320325191223BMSERV[SP]14[SP][SP]1[SP][SP][SP][SP]70[SP][SP][SP]2[SP][SP][SP]159[SP][SP][SP]3[SP][SP][SP]254[SP][SP][SP]4[SP][SP]32.4[SP][SP][SP]5[SP][SP][SP][SP]24[SP][SP][SP]6[SP][SP]0.81[SP][SP][SP]8[SP][SP]26.5[SP][SP][SP]9[SP][SP]15.7[SP][SP]17[SP][SP][SP][SP]48[SP][SP]24[SP]-0.07$[SP]25[SP][SP]0.07[SP][SP]87[SP][SP][SP]141[SP][SP]88[SP][SP][SP]4.4[SP][SP]89[SP][SP][SP]112[SP][ETX]95[CR]");
        this.parse(TestesInterface.arruma(buf.toString()));
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private class Resultado {
        String testNumber;
        String result;
        String alarmCode;

        private Resultado() {
        }
    }
}

