/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.hitachi911;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.hitachi911.Hitachi911;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.ArraysUtil;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static final int RETRY_COUNT = 3;
    private static final int RETRY_TIME = 5;
    private static final int TIME_OUT = 5000;
    private static final int TEXT_SIZE = 256;
    private static final String RESULT_REQUEST = "<";
    private static final String TEST_SELECT_REQUEST = ";";
    private static final String TEST_SELECT_DOWNLOAD = ";";
    private static final String RESULT_FRAME_1 = "1";
    private static final String RESULT_FRAME_2 = "2";
    private static final String END_RESULT_FRAME = ":";
    private static final String DATA_ACCEEPTED = ">";
    private static final String REPEAT = "?";
    private static final String DATA_BAD = "@";
    private static final String DATA_ACCEEPTED_SUSPEND = "A";
    private static final String CHANNEL_COUNT = "48";
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();
    private static final String MASK_DATA = "MMddyy";
    private String frame;
    private List<String> frameResults = new ArrayList<String>();
    private InfoExameRequisicao ultimo_enviado = new InfoExameRequisicao(null, null, null, null, null, null, null, null, null, null);

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    @Override
    public void dataChanged() {
        try {
            String msg = this.getPortaCOM().getInputString();
            if (msg.length() == 1 && msg.equals(String.valueOf('\u0003'))) {
                this.getPortaCOM().write(String.valueOf('\u0003'));
            } else if (msg.startsWith(String.valueOf(this.getMsgStart())) && msg.endsWith(String.valueOf(this.getMsgEnd()))) {
                this.getPortaCOM().clearInputString();
                int index = msg.indexOf(String.valueOf(this.getMsgStart()));
                String frameType = msg.substring(index + 1, index + 2);
                if (!this.validaCheckSum(msg)) {
                    this.controlPacket(REPEAT);
                    return;
                }
                if (frameType.equals(";")) {
                    this.controlPacket(DATA_ACCEEPTED);
                    if (this.validaCheckSum(msg)) {
                        this.responderRequest(msg);
                    }
                } else if (frameType.equals(RESULT_FRAME_1)) {
                    this.frameResults.add(msg);
                    this.controlPacket(DATA_ACCEEPTED);
                } else if (frameType.equals(RESULT_FRAME_2)) {
                    this.frameResults.add(msg);
                    this.controlPacket(DATA_ACCEEPTED);
                } else if (frameType.equals(END_RESULT_FRAME)) {
                    this.controlPacket(DATA_ACCEEPTED);
                    StringBuilder msgs = new StringBuilder();
                    while (this.frameResults.size() > 0) {
                        msgs.append(this.frameResults.remove(0));
                    }
                    msgs.append(msg);
                    this.addListaRecebimento(msgs.toString());
                } else if (frameType.equals(DATA_ACCEEPTED)) {
                    this.controlPacket(DATA_ACCEEPTED);
                    if (this.frame != null) {
                        this.confirmaTransmissao();
                    }
                } else if (frameType.equals(REPEAT)) {
                    this.retransmitir();
                } else if (frameType.equals(DATA_BAD)) {
                    this.setPausa(5000);
                }
            }
        }
        catch (IOException e) {
            this.fireExcecaoEncontrada(String.format("Erro ao tentar responder solicita\u00e7\u00e3o para o aparelho (%s - %s)", e.getMessage(), e.getLocalizedMessage()));
            e.printStackTrace();
        }
        catch (SQLException e) {
            this.fireExcecaoEncontrada(String.format("Erro de SQL ao responder solicita\u00e7\u00e3o para o aparelho (%s - %s)", e.getMessage(), e.getLocalizedMessage()));
            e.printStackTrace();
        }
    }

    private void retransmitir() {
        try {
            this.getPortaCOM().write(this.frame);
        }
        catch (IOException ex) {
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "InterfaceListener: 128");
        }
    }

    private void confirmaTransmissao() {
        try {
            String[] exames;
            if (this.ultimo_enviado == null || this.ultimo_enviado.getExames() == null) {
                this.equipamento.mensagemEnviada("Erro ao receber resposta do equipamento", 1, 5000);
                return;
            }
            Statement st = Conexao.getStatement();
            for (String exame : exames = this.ultimo_enviado.getExames().split(" ", 0)) {
                String rec_codigo;
                String int_codigo;
                String fil_codigo = this.ultimo_enviado.getFilial();
                String req_codigo = this.ultimo_enviado.getCodigo();
                String mco_codigo = this.ultimo_enviado.getMaterial();
                int situacao = this.getExameSituacao(st, fil_codigo, int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo = this.ultimo_enviado.getRecipiente(), exame, mco_codigo), req_codigo, exame, mco_codigo, rec_codigo);
                this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, situacao < 2 ? 1 : 3);
                if (!req_codigo.equals(this.ultimo_enviado.getCodigo())) continue;
                this.firePacienteEnviado(this.ultimo_enviado.getCodigo(), this.ultimo_enviado.getNome(), this.ultimo_enviado.getSexo(), this.ultimo_enviado.getIdade(), this.ultimo_enviado.getData(), this.ultimo_enviado.getHora(), this.ultimo_enviado.getExames());
            }
            Conexao.arquivaSQL();
            this.fireAtualizarTabela(0);
            this.equipamento.mensagemEnviada("Exame enviado com sucesso para " + this.ultimo_enviado.getNome(), 1, 5000);
        }
        catch (SQLException ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {}
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
        }
    }

    private boolean validaCheckSum(String msg) {
        return true;
    }

    public void responderRequest(String msg) throws IOException, SQLException {
        String comment2;
        List<Object[]> reqs;
        String functionCode = msg.substring(2, 3);
        String sampleNumber = msg.substring(4, 7);
        String diskNumber = msg.substring(7, 8);
        String positionNumber = msg.substring(8, 10);
        String idNumber = msg.substring(10, 23);
        int tam = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        String idAmostra = Funcoes.preencheZero(idNumber.trim(), tam);
        String fil_codigo = idAmostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = idAmostra.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = idAmostra.substring(ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        if (functionCode.equalsIgnoreCase("S") || functionCode.equalsIgnoreCase("T") || functionCode.equalsIgnoreCase("U") || functionCode.equalsIgnoreCase("V") || functionCode.equalsIgnoreCase("W") || functionCode.equalsIgnoreCase("X")) {
            this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o solicitada pelo equipamento com leitor de c\u00f3digo de barras desabilitado");
            return;
        }
        if (!(Funcoes.isNumeric(fil_codigo) && Funcoes.isNumeric(req_codigo) && Funcoes.isNumeric(rec_codigo) && Integer.parseInt(fil_codigo) != 0)) {
            this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o n\u00e3o interfaceada: %s %s %s", fil_codigo, req_codigo, rec_codigo));
            return;
        }
        String pac_nome = null;
        String pac_sexo = null;
        String pac_idade = null;
        String data = null;
        String hora = null;
        String rack = null;
        Object prioridade = null;
        String int_codigo = null;
        String mco_codigo = null;
        StringBuilder pac_exames = new StringBuilder("");
        String acao = DATA_ACCEEPTED_SUSPEND;
        String requisicaoMae = req_codigo;
        if (ParametrosGerais.isAgruparGuiasInterface()) {
            requisicaoMae = Funcoes.preencheZero(BDUtil.getReqMultiGuiaMae(fil_codigo, req_codigo), ParametrosGerais.getDigitosTuboRequisicao());
        }
        Object[] req = this.getRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 0);
        PanelAbaAbstrata aba = this.getAba(0);
        if (req != null) {
            reqs = this.getTodasRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 0);
            for (Object[] r : reqs) {
                pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
            }
        }
        if (req == null) {
            req = this.getRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 1);
            aba = this.equipamento.getTab(1);
            if (req != null) {
                reqs = this.getTodasRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 1);
                for (Object[] r : reqs) {
                    pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                }
            }
        }
        if (req == null && (req = this.getRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 2)) != null) {
            aba = this.equipamento.getTab(2);
            if (req != null) {
                reqs = this.getTodasRequisicaoAba(fil_codigo, requisicaoMae, rec_codigo, 2);
                for (Object[] r : reqs) {
                    if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                    pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                }
            }
        }
        if (req == null) {
            this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o n\u00e3o interfaceada: %s %s %s", fil_codigo, req_codigo, rec_codigo));
            return;
        }
        pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
        pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
        data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
        hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
        rack = aba.getColIndice("Rack") >= 0 ? (String)req[aba.getColIndice("Rack")] : null;
        int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
        mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
        Statement st = Conexao.getStatement();
        ExameMaterial[] exa_lista = ExamesUtil.anexarCodigoMaterial(pac_exames.toString().split(" "), mco_codigo);
        ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
        String comment1 = "";
        if (pac_nome.indexOf(" ") > 0) {
            comment1 = pac_nome.substring(0, pac_nome.indexOf(" "));
        }
        if (comment1.length() > 30) {
            comment1 = comment1.substring(0, 29);
        }
        if ((comment2 = pac_nome.substring(pac_nome.indexOf(" "))).length() > 25) {
            comment2 = comment1.substring(0, 24);
        }
        String comment3 = "";
        String comment4 = "";
        String comment5 = "";
        StringBuilder tests = new StringBuilder(StringUtil.repeteCaractere('0', 48));
        String[] pac_dados = BDUtil.getIdadeNacimentoPaciente(fil_codigo, req_codigo);
        String age = null;
        String ageUnits = null;
        Object dataNasc = null;
        if (pac_dados != null) {
            age = pac_dados[0];
            ageUnits = pac_dados[1].equals(DATA_ACCEEPTED_SUSPEND) ? "3" : ageUnits;
            ageUnits = pac_dados[1].equals("M") ? RESULT_FRAME_2 : ageUnits;
            String string = ageUnits = pac_dados[1].equals("D") ? RESULT_FRAME_1 : ageUnits;
        }
        String sex = pac_sexo.equalsIgnoreCase("M") ? RESULT_FRAME_1 : (pac_sexo.equalsIgnoreCase("F") ? RESULT_FRAME_2 : "0");
        data = Funcoes.formataData(MASK_DATA, data);
        hora = hora.replace(END_RESULT_FRAME, "");
        for (ExameMaterial exameMaterial : alternativos) {
            if (!Funcoes.isNumeric(exameMaterial.getNomeExame())) continue;
            int pos = Integer.parseInt(exameMaterial.getNomeExame());
            tests.replace(pos - 1, pos, RESULT_FRAME_1);
        }
        this.frame = this.getTestSelectionDownload(functionCode, " ", sampleNumber, diskNumber, positionNumber, idNumber, age, ageUnits, sex, data, hora, CHANNEL_COUNT, tests.toString(), comment1, comment2, comment3, comment4, comment5);
        this.ultimo_enviado = new InfoExameRequisicao(fil_codigo, req_codigo, mco_codigo, rec_codigo, pac_nome, pac_idade, pac_sexo, data, hora, pac_exames.toString());
        this.getPortaCOM().write(this.frame);
    }

    private void controlPacket(String controle) throws IOException {
        StringBuilder buf = new StringBuilder(String.valueOf('\u0002'));
        buf.append(controle).append(this.getMsgEnd());
        this.getPortaCOM().write(buf.toString());
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003' + LINE);
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String parse(String message) {
        try {
            String[] msgs;
            String[] functionCode = new String[]{DATA_ACCEEPTED_SUSPEND, "B", "C", "D", "E", "F", "G", "H", "I", "J", "S", "T", "U", "V", "W", "X", "s"};
            for (String msg : msgs = message.split(String.valueOf(LINE))) {
                this.parseResult(msg, functionCode);
            }
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Erro ao receber resultado do equipamento!");
            e.printStackTrace();
        }
        return null;
    }

    private void parseResult(String msg, String[] functionCode) throws Exception {
        String functionCodeRx = msg.substring(2, 3);
        String idNumber = msg.substring(10, 23);
        if (ArraysUtil.indice((Object[])functionCode, functionCodeRx) == -1) {
            return;
        }
        idNumber = Funcoes.preencheZero(idNumber.trim(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo());
        String fil_codigo = idNumber.substring(0, ParametrosGerais.getDigitosTuboFilial());
        String req_codigo = idNumber.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        String rec_codigo = idNumber.substring(ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
        if (!(Funcoes.isNumeric(fil_codigo) && Funcoes.isNumeric(req_codigo) && Funcoes.isNumeric(rec_codigo) && Integer.parseInt(fil_codigo) != 0)) {
            this.fireExcecaoEncontrada(String.format("Requisi\u00e7\u00e3o com formato fora do padr\u00e3o %s %s %s ", fil_codigo, req_codigo, rec_codigo));
            return;
        }
        Statement st = Conexao.getStatement();
        String resultCount = msg.substring(38, 40);
        String results = msg.substring(40, msg.indexOf(String.valueOf('\u0003')));
        int qtdeResultados = Integer.parseInt(resultCount.trim());
        boolean pos = false;
        for (int i = 0; i < qtdeResultados; ++i) {
            String int_codigo;
            String emi_alternativo;
            String alarmCode;
            String resultado;
            block8: {
                String tmp = results.substring(9 * i, 9 * i + 9);
                String channelNumber = tmp.substring(0, 2);
                resultado = tmp.substring(2, 8).trim();
                alarmCode = tmp.substring(8, 9);
                emi_alternativo = channelNumber.trim();
                int_codigo = "";
                try {
                    int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
                    if (int_codigo == null) {
                        this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                    }
                    break block8;
                }
                catch (Exception e) {
                    this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                }
                continue;
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
            String flag = ((Hitachi911)this.equipamento).getFlag(alarmCode);
            if (exame == null) {
                this.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
                continue;
            }
            String res = resultado.replaceFirst("\\.", ",");
            HashMap<String, Object> dados = new HashMap<String, Object>();
            dados.put("resultado_quantitativo", res);
            ArrayList<String> flags = new ArrayList<String>();
            if (!Funcoes.textoVazio(flag)) {
                flags.add(flag);
                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados, flags);
                continue;
            }
            this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, dados);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        if (acao.equals(DATA_ACCEEPTED_SUSPEND)) {
            Statement st = Conexao.getStatement();
            try {
                String[] stringArray = exames.split(" ");
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String exame;
                    int sitAtual = this.getExameSituacao(st, fil_codigo, int_codigo, req_codigo, exame = stringArray[i], mco_codigo, rec_codigo);
                    this.atualizarSituacaoExame(st, fil_codigo, req_codigo, rec_codigo, exame, mco_codigo, int_codigo, null, sitAtual < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (Exception e) {
                try {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    private String getTestSelectionDownload(String functionCode, String containerType, String sampleNumber, String diskNumber, String positionNumber, String idNumber, String age, String ageUnits, String sex, String data, String hora, String channelCount, String tests, boolean flag1, boolean flag2, boolean flag3, boolean flag4, boolean flag5, String comment1, String comment2, String comment3, String comment4, String comment5) {
        StringBuilder record = new StringBuilder();
        record.append(String.valueOf('\u0002'));
        record.append(";");
        record.append(functionCode);
        record.append(containerType);
        record.append(sampleNumber);
        record.append(diskNumber);
        record.append(positionNumber);
        record.append(idNumber);
        record.append(age);
        record.append(ageUnits);
        record.append(sex);
        record.append(data);
        record.append(hora);
        record.append(channelCount);
        record.append(tests);
        record.append(flag1 ? RESULT_FRAME_1 : "0");
        record.append(flag2 ? RESULT_FRAME_1 : "0");
        record.append(flag3 ? RESULT_FRAME_1 : "0");
        record.append(flag4 ? RESULT_FRAME_1 : "0");
        record.append(flag5 ? RESULT_FRAME_1 : "0");
        record.append(flag1 ? comment1 : "");
        record.append(flag2 ? comment2 : "");
        record.append(flag3 ? comment3 : "");
        record.append(flag4 ? comment4 : "");
        record.append(flag5 ? comment5 : "");
        record.append(this.getMsgEnd());
        return record.toString();
    }

    private String getTestSelectionDownload(String functionCode, String containerType, String sampleNumber, String diskNumber, String positionNumber, String idNumber, String age, String ageUnits, String sex, String data, String hora, String channelCount, String tests, String comment1, String comment2, String comment3, String comment4, String comment5) {
        return this.getTestSelectionDownload(functionCode, containerType, sampleNumber, diskNumber, positionNumber, idNumber, age, ageUnits, sex, data, hora, channelCount, tests, !Funcoes.textoVazio(comment1), !Funcoes.textoVazio(comment2), !Funcoes.textoVazio(comment3), !Funcoes.textoVazio(comment4), !Funcoes.textoVazio(comment5), comment1, comment2, comment3, comment4, comment5);
    }

    private String getFlag(String alarmFlag) {
        return ((Hitachi911)this.equipamento).getFlag(alarmFlag);
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

