/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.hemacounter;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaSocketServer;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.interfaces.hemacounter.InterfaceConfiguracao;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Factory;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegment;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegmentParser;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageSegmentType;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.MessageType;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.SegmentFactory;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrmO01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrrO02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsh;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends InterfaceHl7Listener {
    private static final String IMAGE_BMP_BASE64 = "^Image^BMP^Base64^";
    private static final String IMAGE_BINARY_BASE64 = "^Application^Octet-stream^Base64^";
    private HashMap<String, String> parametros = new HashMap();
    private Map<String, String> warning = new HashMap<String, String>();
    private InterfaceConfiguracao configuracao = new InterfaceConfiguracao();

    public InterfaceListener() {
        super("Hemacounter SL");
        this.parametros.put("WBC", "leucocitos");
        this.parametros.put("NEUTP", "neutrofilo_percentual");
        this.parametros.put("LYMP", "linfocitos_tipicos_percentual");
        this.parametros.put("MONOP", "monocitos_percentual");
        this.parametros.put("EOSP", "eosinofilos_percentual");
        this.parametros.put("BASOP", "basofilos_percentual");
        this.parametros.put("NEUTA", "neutrofilo_contagem");
        this.parametros.put("LYMA", "linfocitos_tipicos_contagem");
        this.parametros.put("MONOA", "monocitos_contagem");
        this.parametros.put("EOSA", "eosinofilos_contagem");
        this.parametros.put("BASOA", "basofilos_contagem");
        this.parametros.put("RBC", "hemacias");
        this.parametros.put("HGB", "hgb");
        this.parametros.put("MCHC", "mchc");
        this.parametros.put("MCH", "hcm");
        this.parametros.put("MCV", "vcm");
        this.parametros.put("RDWCV", "rdw_cv");
        this.parametros.put("RDWSD", "rdw_sd");
        this.parametros.put("HCT", "hct");
        this.parametros.put("PLT", "plaquetas");
        this.parametros.put("MPV", "vpm");
        this.parametros.put("PDW", "pdw");
        this.parametros.put("PCT", "pct");
        this.warning.put("WBCFlag", "Lymphocyte is too high");
        this.warning.put("RBCFlag", "Hemoglobin?");
        this.warning.put("PLTFlag", "Big platelet is too low!");
        this.parametros.put("BASA", "basofilos_contagem");
        this.parametros.put("BASP", "basofilos_percentual");
        this.parametros.put("MONP", "monocitos_contagem");
        this.parametros.put("MONA", "monocitos_percentual");
        this.parametros.put("BASP", "bastonados_percentual");
        this.parametros.putAll(this.warning);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        this.configuracao = new InterfaceConfiguracao();
        this.configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
    }

    @Override
    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setSendingApplication("Hemacounter");
            mensagem.getMsh().setSendingFacility(this.modelo);
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.3.1");
            mensagem.getMsh().setCharacterSet("UNICODE");
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            this.getPortaCOM().write(this.messageToText(mensagem, this.fieldSeparator));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    public final void messageToText(Message message, char fieldSeparator, StringBuilder builder) {
        MessageSegmentParser messageSegmentParser = new MessageSegmentParser();
        builder.append('\u000b');
        for (MessageSegment messageSegment : message.getMessageSegments()) {
            messageSegmentParser.messageSegmentToText(messageSegment, fieldSeparator, builder);
            builder.append('\r');
        }
        builder.append('\u001c');
    }

    public final String messageToText(Message message, char fieldSeparator) {
        StringBuilder builder = new StringBuilder();
        this.messageToText(message, fieldSeparator, builder);
        return builder.toString();
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        super.setPortaCOM(portaCOM);
        ((PortaSocketServer)this.getPortaCOM()).setEscreverEmBytes(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String enviarRequisicao(String pacNome, String pacSexo, String pacIdade, String data, String hora, String rackposition, String prioridade, String filCodigo, String intCodigo, String reqCodigo, String mcoCodigo, String recCodigo, String exames, String acao) {
        MessageOrrO02 msgOrrO02 = new MessageOrrO02();
        if (acao.equals("N")) {
            Statement st = Conexao.getStatement();
            try {
                recCodigo = Funcoes.preencheZero(recCodigo, ParametrosGerais.getDigitosTuboTubo());
                Date dtNascimento = BDUtil.getDataNacimentoPaciente(filCodigo, reqCodigo);
                String[] exa = exames.split(" ");
                ExameMaterial[] exameMaterial = new ExameMaterial[]{new ExameMaterial(exa[0], Integer.parseInt(mcoCodigo))};
                exameMaterial = ExamesUtil.getAlternativos(st, filCodigo, intCodigo, exameMaterial);
                msgOrrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                msgOrrO02.getMsa().setMessageControlId(Funcoes.formataData("yyyyMMddHHmmss", new Date()));
                msgOrrO02.getPid().setId(1);
                msgOrrO02.getPid().setPatientID(filCodigo + reqCodigo + recCodigo);
                msgOrrO02.getPid().setPatientIdentifierList("");
                msgOrrO02.getPid().setPatientName(pacNome);
                msgOrrO02.getPid().setDataOfBirth(dtNascimento != null ? Funcoes.formataData("yyyyMMdd", dtNascimento) : "");
                msgOrrO02.getPid().setSex(pacSexo);
                msgOrrO02.getObr().setId(1);
                msgOrrO02.getObr().setPlacerOrderNumber(filCodigo + reqCodigo + recCodigo);
                msgOrrO02.getObr().setObservationDateTime(new Date());
                msgOrrO02.getObr().setChargePractice("O");
                msgOrrO02.getObr().setDiagnosticServSect("CI");
                msgOrrO02.getObr().setResultStatus("O");
                msgOrrO02.getObr().setParentStatus("W");
                msgOrrO02.getObr().setQuantityTiming(exameMaterial[0].getNomeExame());
                msgOrrO02.getObr().setParent("0");
                msgOrrO02.getObr().setTransportationMode("0");
                msgOrrO02.getOrc().setOrderControl("AF");
                msgOrrO02.getOrc().setFilterOrderNumber(filCodigo + reqCodigo + recCodigo);
                msgOrrO02.getOrc().setOrderStatus("IP");
                this.enviaMensagem(Funcoes.formataData("yyyyMMddHHmmss", new Date()), msgOrrO02);
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
            catch (Exception e) {
                try {
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                }
                catch (Throwable throwable) {
                    Conexao.fecharStatement(st);
                    throw throwable;
                }
                Conexao.fecharStatement(st);
            }
            Conexao.fecharStatement(st);
        }
        return null;
    }

    @Override
    protected void messageOrmO01Recebida(MessageOrmO01 ormO01) {
        block16: {
            String messageId = ormO01.getMsh().getMessageControlId();
            MessageOrrO02 orrO02 = new MessageOrrO02();
            try {
                String tuboId = ormO01.getOrc().getFilterOrderNumber();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (tuboId != null && !tuboId.trim().isEmpty() && tuboId != "null" && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                        aba = this.equipamento.getTab(1);
                    }
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                        aba = this.equipamento.getTab(2);
                    }
                    if (req == null) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        return;
                    }
                    String exames = (String)req[aba.getColIndice("Exame")];
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (n == 0 || n == 1) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<String> tests = new HashSet<String>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test == null || test.trim().isEmpty()) continue;
                        tests.add(test);
                    }
                    if (tests.isEmpty()) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(filCodigo).append(reqCodigo).append("^^^^");
                        Date dataHoraRequisicao = new Date();
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        orrO02.getPid().setId(1);
                        orrO02.getPid().setPatientName("^" + pacNome);
                        orrO02.getPid().setSex(pacSexo);
                        orrO02.getPid().setPatientIdentifierList(stringBuilder.toString());
                        orrO02.getPid().setPatientAlias(pacNome);
                        orrO02.getOrc().setOrderControl("AF");
                        orrO02.getOrc().setPlaceOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setPlacerOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setRequestDateTime(dataHoraRequisicao);
                        orrO02.getObr().setCollectorIdentifier("MA");
                        orrO02.getObr().setSpecimenReceiveDateTime(dataHoraRequisicao);
                        orrO02.getObr().setDiagnosticServSect("HM");
                        orrO02.getObr().setQuantityTiming((String)tests.iterator().next());
                        this.enviaMensagem(messageId, orrO02);
                        this.alteraSituacaoParaPendentes((InfoExameRequisicao)this.examesEnviadosPorSid.get(tuboId));
                        this.examesEnviadosPorSid.remove(tuboId);
                    }
                    break block16;
                }
                orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                this.enviaMensagem(messageId, orrO02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = oruR01.getPid().getPatientID();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                String emiAlternativo;
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), recCodigo, emiAlternativo = oruR01.getObr().getQuantityTiming());
                if (Funcoes.textoVazio(intCodigo)) {
                    this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + emiAlternativo);
                    return;
                }
                ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, emiAlternativo);
                if (exame == null) {
                    this.fireExcecaoEncontrada("Nenhum exame foi encontrado para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + emiAlternativo);
                    return;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                ArrayList<String> flags = new ArrayList<String>();
                ArrayList<String> listaWarning = new ArrayList<String>();
                int sit = this.getExameSituacao(st, filCodigo, intCodigo, reqCodigo, exame.getNomeExame(), exame.getCodigoMaterial(), recCodigo);
                for (String p : this.parametros.keySet()) {
                    MessageSegmentObx obx = this.buscaObxPeloObservationID(oruR01.getObxList(), p);
                    if (obx == null) continue;
                    if (obx.getAbnormalFlag() != null && !obx.getAbnormalFlag().equals((Object)MessageSegmentObx.AbnormalFlag.NORMAL)) {
                        flags.add(this.tratarDescricao(p) + " - " + obx.getAbnormalFlag().toString());
                    }
                    String campo = this.parametros.get(p);
                    String resultado = obx.getObservationValue();
                    this.retornaAlerta(campo, resultado, listaWarning);
                    if (resultado.length() > IMAGE_BINARY_BASE64.length() && resultado.substring(0, IMAGE_BINARY_BASE64.length()).equalsIgnoreCase(IMAGE_BINARY_BASE64)) {
                        resultado = resultado.substring(IMAGE_BINARY_BASE64.length());
                        resultado = this.convertImg(reqCodigo, resultado, p);
                    } else if (resultado.length() > IMAGE_BMP_BASE64.length() && resultado.substring(0, IMAGE_BMP_BASE64.length()).equalsIgnoreCase(IMAGE_BMP_BASE64)) {
                        resultado = resultado.substring(IMAGE_BMP_BASE64.length());
                        resultado = this.convertImg(reqCodigo, resultado, p);
                    } else {
                        resultado = resultado.replace('.', ',');
                    }
                    dados.put(campo, resultado);
                }
                flags.addAll(listaWarning);
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                for (BDExame exa : exames) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exa.getExame(), exa.getMaterial(), intCodigo, dados, flags);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
            ackR01.getMsa().setTextMessage("Erro ao receber a mensagem");
            ackR01.getMsa().setErrorCondition(ErrorCondition.APPLICATION_INTERNAL_ERROR);
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
        this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
    }

    private void retornaAlerta(String campo, String resultado, List<String> listaWarning) {
        if (this.warning.containsValue(campo)) {
            listaWarning.add(campo);
        }
    }

    private String tratarDescricao(String p) {
        String[] campo = p.split("\\^");
        return campo != null && campo.length > 1 ? campo[1] : p;
    }

    private String convertImg(String reqCodigo, String resultado, String p) throws IOException {
        Base64 b64 = new Base64();
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(b64.decode(resultado)));
        ImageIO.getCacheDirectory();
        File img = File.createTempFile("bc5380_" + reqCodigo, ".png");
        ImageIO.write((RenderedImage)image, "png", img);
        BufferedImage imgNew = ImageIO.read(img);
        resultado = b64.encodeAsString(ImagemUtils.imageToByte(imgNew));
        img.delete();
        return resultado;
    }

    private MessageSegmentObx buscaObxPeloObservationID(List<MessageSegmentObx> listObx, String observationID) {
        for (MessageSegmentObx obx : listObx) {
            if (!obx.getObservationId().equals(observationID)) continue;
            return obx;
        }
        return null;
    }

    public Message textToMessage(String text) throws ParseException {
        Factory messageFactory = new Factory();
        if (!this.checkMessage(text)) {
            throw new ParseException("Mensagem fora do padr\u00e3o. O texto deve iniciar com <SB> e terminar com <EB><CR>", 0);
        }
        text = text.substring(1, text.length() - 2);
        ArrayList<MessageSegment> segments = new ArrayList<MessageSegment>();
        MessageType messageType = null;
        for (String textSegment : text.split(String.valueOf('\r'))) {
            MessageSegment messageSegment = this.textToMessageSegment(textSegment);
            if (messageSegment == null) continue;
            segments.add(messageSegment);
            if (messageSegment.getType() != MessageSegmentType.MSH) continue;
            messageType = ((MessageSegmentMsh)messageSegment).getMessageType();
        }
        if (messageType != null) {
            Message message = messageFactory.createMessage(messageType);
            message.setMessageSegments(segments);
            return message;
        }
        return null;
    }

    @Override
    public String getMsgEnd() {
        if (this.configuracao.isConsiderarQuebraLinha()) {
            return String.valueOf('\u001c') + String.valueOf('\r');
        }
        return String.valueOf('\u001c');
    }

    @Override
    public synchronized void dataChanged() {
        String message = this.getPortaCOM().removeInputString(this.getMsgEnd());
        if (!Funcoes.textoVazio(message) && this.checkMessage(message)) {
            this.parse(message);
            if (this.getPortaCOM().getInputString().length() > 0) {
                this.dataChanged();
            }
        }
    }

    public final MessageSegment textToMessageSegment(String text) {
        String[] fields;
        MessageSegmentType type;
        SegmentFactory factory = new SegmentFactory();
        if (text == null || text.length() < 3) {
            return null;
        }
        char fieldSeparator = text.charAt(3);
        if (text.contains("MSH")) {
            text = "MSH|" + text.substring(text.indexOf("MSH") + 6, text.length());
        }
        if ((type = MessageSegmentType.valueOf((fields = text.split("\\" + String.valueOf(fieldSeparator), -1))[0])) != null) {
            MessageSegment messageSegment = factory.createMessageSegment(type);
            messageSegment.setFields(fields);
            return messageSegment;
        }
        return null;
    }

    public boolean checkMessage(String text) {
        if (text.charAt(0) == '\u000b') {
            if (this.configuracao.isConsiderarQuebraLinha() && text.charAt(text.length() - 2) == '\u001c') {
                return true;
            }
            if (text.charAt(text.length() - 1) == '\u001c') {
                return true;
            }
        }
        return false;
    }

    @Override
    public String parse(String text) {
        String msg = "";
        try {
            Message message = this.textToMessage(text);
            this.mensagemRecebida(message);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    public void teste() {
        StringBuilder tmp = new StringBuilder();
        String req = "010006042601";
        tmp.append("[SB]MSH|^~\\&|Hemaray86|Rayto|||010000045301||ORM^O01|2013040113|P|2.3.1||||S||UNICODE |||[CR]");
        tmp.append("ORC|RF||010006049701||IP||||||||||||||||[CR]");
        tmp.append("[EB][CR]");
        this.parse(this.equipamento.arruma(tmp.toString()));
        tmp = new StringBuilder();
        tmp.append("[SB]MSH|||^~\\&|Hemaray[SP]86|Rayto|||20180320144349||ORU^R01|2018032010|P|2.3.1||||S||Unicode|||[CR]");
        tmp.append("PID|1|010006049701|||||2018-03-20[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]|O|||||||0Y||||||||||||||||[CR]");
        tmp.append("OBR|1||||||2018-03-20[SP]09:12|||||||2018-03-20[SP]09:12||||||admin|||U|Un|A|W|CBC+DIFF|General|1|1||||||||||||||||||[CR]");
        tmp.append("OBX|1|NM|WBC||8.29|10*3/uL|3.5-9.5|N|||F|||||||[CR]");
        tmp.append("OBX|2|NM|NEUTP||75.8|%|40-75|H|||F|||||||[CR]");
        tmp.append("OBX|3|NM|LYMP||19.9|%|20-50|L|||F|||||||[CR]");
        tmp.append("OBX|4|NM|MONOP||2.2|%|3-10|L|||F|||||||[CR]");
        tmp.append("OBX|5|NM|EOSP||1.7|%|0.4-8|N|||F|||||||[CR]");
        tmp.append("OBX|6|NM|BASOP||0.4|%|0-1|N|||F|||||||[CR]");
        tmp.append("OBX|7|NM|NEUTA||6.29|10*3/uL|1.8-6.3|N|||F|||||||[CR]");
        tmp.append("OBX|8|NM|LYMA||1.65|10*3/uL|1.1-3.2|N|||F|||||||[CR]");
        tmp.append("OBX|9|NM|MONOA||0.18|10*3/uL|0.1-0.6|N|||F|||||||[CR]");
        tmp.append("OBX|10|NM|EOSA||0.14|10*3/uL|0.02-0.52|N|||F|||||||[CR]");
        tmp.append("OBX|11|NM|BASOA||0.03|10*3/uL|0-0.06|N|||F|||||||[CR]");
        tmp.append("OBX|12|NM|RBC||4.68|10*6/uL|3.8-5.8|N|||F|||||||[CR]");
        tmp.append("OBX|13|NM|HGB||14.5|g/dL|11.5-17.5|N|||F|||||||[CR]");
        tmp.append("OBX|14|NM|MCHC||34.9|g/dL|31.6-35.4|N|||F|||||||[CR]");
        tmp.append("OBX|15|NM|MCH||30.9|pg|27-34|N|||F|||||||[CR]");
        tmp.append("OBX|16|NM|MCV||89|fL|82-100|N|||F|||||||[CR]");
        tmp.append("OBX|17|NM|RDWCV||12.8|%|11-16|N|||F|||||||[CR]");
        tmp.append("OBX|18|NM|RDWSD||51.3|fL|35-56|N|||F|||||||[CR]");
        tmp.append("OBX|19|NM|HCT||41.8|%|35-50|N|||F|||||||[CR]");
        tmp.append("OBX|20|NM|PLT||234|10*3/uL|125-350|N|||F|||||||[CR]");
        tmp.append("OBX|21|NM|MPV||9.5|fL|6.5-12|N|||F|||||||[CR]");
        tmp.append("OBX|22|NM|PDW||16.4|fL|10-18|N|||F|||||||[CR]");
        tmp.append("OBX|23|NM|PCT||0.222|%|0.108-0.282|N|||F|||||||[CR]");
        tmp.append("OBX|24|NM|PLCR||21.3|%|11-45|N|||F|||||||[CR]");
        tmp.append("OBX|25|TX|WBCFlag||Left[SP]Shift?[SP]||||||F|||||||[CR]");
        tmp.append("OBX|26|TX|RBCFlag||[SP]||||||F|||||||[CR]");
        tmp.append("OBX|27|TX|PLTFlag||[SP]||||||F|||||||[CR]");
        tmp.append("OBX|28|NM|IGP||0.1|%|||||F|||||||[CR]");
        tmp.append("OBX|29|NM|IGA||0.01|10*9/L|||||F|||||||[CR]");
        tmp.append("OBX|30|NM|ALYP||0.1|%|||||F|||||||[CR]");
        tmp.append("OBX|31|NM|ALYA||0.01|10*9/L|||||F|||||||[CR]");
        tmp.append("[EB]");
        String msg = this.equipamento.arruma(tmp.toString());
        this.getPortaCOM().read(msg, msg.length());
        tmp.delete(0, tmp.length());
        tmp.append("[SB]MSH|||^~\\&|Hemaray[SP]86|Rayto|||20180320144349||ORU^R01|2018032010|P|2.3.1||||S||Unicode|||[CR]");
        tmp.append("PID|1|010006049801|||||2018-03-20[SP][SP][SP][SP][SP][SP][SP][SP][SP][SP]|O|||||||0Y||||||||||||||||[CR]");
        tmp.append("OBR|1||||||2018-03-20[SP]09:12|||||||2018-03-20[SP]09:12||||||admin|||U|Un|A|W|CBC+DIFF|General|1|1||||||||||||||||||[CR]");
        tmp.append("OBX|1|NM|WBC||8.29|10*3/uL|3.5-9.5|N|||F|||||||[CR]");
        tmp.append("OBX|2|NM|NEUTP||75.8|%|40-75|H|||F|||||||[CR]");
        tmp.append("OBX|3|NM|LYMP||19.9|%|20-50|L|||F|||||||[CR]");
        tmp.append("OBX|4|NM|MONOP||2.2|%|3-10|L|||F|||||||[CR]");
        tmp.append("OBX|5|NM|EOSP||1.7|%|0.4-8|N|||F|||||||[CR]");
        tmp.append("OBX|6|NM|BASOP||0.4|%|0-1|N|||F|||||||[CR]");
        tmp.append("OBX|7|NM|NEUTA||6.29|10*3/uL|1.8-6.3|N|||F|||||||[CR]");
        tmp.append("OBX|8|NM|LYMA||1.65|10*3/uL|1.1-3.2|N|||F|||||||[CR]");
        tmp.append("OBX|9|NM|MONOA||0.18|10*3/uL|0.1-0.6|N|||F|||||||[CR]");
        tmp.append("OBX|10|NM|EOSA||0.14|10*3/uL|0.02-0.52|N|||F|||||||[CR]");
        tmp.append("OBX|11|NM|BASOA||0.03|10*3/uL|0-0.06|N|||F|||||||[CR]");
        tmp.append("OBX|12|NM|RBC||4.69|10*6/uL|3.8-5.8|N|||F|||||||[CR]");
        tmp.append("OBX|13|NM|HGB||14.5|g/dL|11.5-17.5|N|||F|||||||[CR]");
        tmp.append("OBX|14|NM|MCHC||34.7|g/dL|31.6-35.4|N|||F|||||||[CR]");
        tmp.append("OBX|15|NM|MCH||30.9|pg|27-34|N|||F|||||||[CR]");
        tmp.append("OBX|16|NM|MCV||89|fL|82-100|N|||F|||||||[CR]");
        tmp.append("OBX|17|NM|RDWCV||12.8|%|11-16|N|||F|||||||[CR]");
        tmp.append("OBX|18|NM|RDWSD||51.3|fL|35-56|N|||F|||||||[CR]");
        tmp.append("OBX|19|NM|HCT||41.8|%|35-50|N|||F|||||||[CR]");
        tmp.append("OBX|20|NM|PLT||234|10*3/uL|125-350|N|||F|||||||[CR]");
        tmp.append("OBX|21|NM|MPV||9.5|fL|6.5-12|N|||F|||||||[CR]");
        tmp.append("OBX|22|NM|PDW||16.4|fL|10-18|N|||F|||||||[CR]");
        tmp.append("OBX|23|NM|PCT||0.222|%|0.108-0.282|N|||F|||||||[CR]");
        tmp.append("OBX|24|NM|PLCR||21.3|%|11-45|N|||F|||||||[CR]");
        tmp.append("OBX|25|TX|WBCFlag||Left[SP]Shift?[SP]||||||F|||||||[CR]");
        tmp.append("OBX|26|TX|RBCFlag||[SP]||||||F|||||||[CR]");
        tmp.append("OBX|27|TX|PLTFlag||[SP]||||||F|||||||[CR]");
        tmp.append("OBX|28|NM|IGP||0.1|%|||||F|||||||[CR]");
        tmp.append("OBX|29|NM|IGA||0.01|10*9/L|||||F|||||||[CR]");
        tmp.append("OBX|30|NM|ALYP||0.1|%|||||F|||||||[CR]");
        tmp.append("OBX|31|NM|ALYA||0.01|10*9/L|||||F|||||||[CR]");
        tmp.append("[EB]");
        msg = this.equipamento.arruma(tmp.toString());
        this.getPortaCOM().read(msg, msg.length());
    }
}

