/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.hemabioiiivet;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.InfoExameRequisicao;
import jalis.laboratorio.interfaceamento.padroes.hl7.InterfaceHl7Listener;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.EncodingCharacters;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.ErrorCondition;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.Message;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageAckR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrmO01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOrrO02;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.messages.MessageOruR01;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentMsa;
import jalis.laboratorio.interfaceamento.padroes.hl7.message.segments.MessageSegmentObx;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.interfaceamento.util.TestesInterface;
import jalis.util.Funcoes;
import jalis.util.ImagemUtils;
import jalis.util.StringUtil;
import jalis.util.TempoUtil;
import jalis.util.logger.ErrorLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.sql.Statement;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import org.apache.commons.codec.binary.Base64;

public class InterfaceListener
extends InterfaceHl7Listener {
    private static final String ALTERNATIVO = "HEMOG";
    private static final String IMAGE_BINARY_BASE64 = "^Application^Octet-stream^Base64^";
    private HashMap<String, String> parametros = new HashMap();
    private Map<String, String> warning = new HashMap<String, String>();

    public InterfaceListener() {
        super("Hemabio III Vet");
        this.parametros.put("WBC", "leucocitos");
        this.parametros.put("Lym%", "linfocitos_tipicos_percentual");
        this.parametros.put("Mid%", "monocitos_percentual");
        this.parametros.put("GR%", "granulocitos_percentual");
        this.parametros.put("Lym#", "linfocitos_tipicos_contagem");
        this.parametros.put("Mid#", "monocitos_contagem");
        this.parametros.put("GR#", "granulocitos_contagem");
        this.parametros.put("RBC", "hemacias");
        this.parametros.put("HGB", "hgb");
        this.parametros.put("HCT", "hct");
        this.parametros.put("MCV", "vcm");
        this.parametros.put("MCH", "hcm");
        this.parametros.put("MCHC", "mchc");
        this.parametros.put("RDW_CV", "rdw_cv");
        this.parametros.put("RDW_SD", "rdw_sd");
        this.parametros.put("PLT", "plaquetas");
        this.parametros.put("MPV", "vpm");
        this.parametros.put("PCT", "pct");
        this.parametros.put("PDW", "pdw");
        this.parametros.put("P_LCC", "plaquetas_lcc");
        this.parametros.put("P_LCR", "plaquetas_lcr");
        this.parametros.put("WBC^PNG^Base64", "histograma_wbc");
        this.parametros.put("RBC^PNG^Base64", "histograma_rbc");
        this.parametros.put("PLT^PNG^Base64", "histograma_plt");
        this.parametros.putAll(this.warning);
    }

    @Override
    protected String getPacienteDataNascimento(String filial, String requisicao) {
        Date nasc = BDUtil.getDataNacimentoPaciente(filial, requisicao);
        if (nasc == null) {
            return "";
        }
        return Funcoes.formataData("yyyyMMdd", nasc) + "000000";
    }

    @Override
    protected void enviaMensagem(String id, Message mensagem) {
        try {
            mensagem.getMsh().setEncodingCharacters(new EncodingCharacters('^', '~', '\\', '&'));
            mensagem.getMsh().setSendingApplication("Mindray");
            mensagem.getMsh().setSendingFacility(this.modelo);
            mensagem.getMsh().setDateTime(new Date());
            mensagem.getMsh().setProcessingId("P");
            mensagem.getMsh().setVersionId("2.3.1");
            mensagem.getMsh().setCharacterSet("UNICODE");
            mensagem.setId(id);
            this.ultimaMensagemEnviada = mensagem;
            ++this.tentativasEnvio;
            this.getPortaCOM().write(this.messageParser.messageToText(mensagem, this.fieldSeparator));
        }
        catch (IOException e) {
            ErrorLogger.mostraMensagem(null, "Falha na comunica\u00e7\u00e3o com o equipamento.", e.getStackTrace());
        }
    }

    @Override
    protected void messageOruR01Recebida(MessageOruR01 oruR01) {
        MessageAckR01 ackR01 = new MessageAckR01();
        ackR01.getMsh().setApplicationAckType(oruR01.getMsh().getApplicationAckType());
        ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
        ackR01.getMsa().setTextMessage("Mensagem aceita");
        ackR01.getMsa().setErrorCondition(ErrorCondition.MESSAGE_ACCEPTED);
        try {
            int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String tuboId = oruR01.getObr().getPlacerOrderNumber();
            if (tuboId != null && tuboId.length() == digitosCodigoTubo && Funcoes.isNumeric(tuboId)) {
                Statement st = Conexao.getStatement();
                String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                String intCodigo = this.getIntCodigo(filCodigo, reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao()), recCodigo, ALTERNATIVO);
                if (Funcoes.textoVazio(intCodigo)) {
                    this.fireExcecaoEncontrada("N\u00e3o foi poss\u00edvel encontrar a interface para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + ALTERNATIVO);
                    return;
                }
                ExameMaterial exame = this.getReqExameLIS(filCodigo, intCodigo, reqCodigo, recCodigo, ALTERNATIVO);
                if (exame == null) {
                    this.fireExcecaoEncontrada("Nenhum exame foi encontrado para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + ALTERNATIVO);
                    return;
                }
                HashMap<String, Object> dados = new HashMap<String, Object>();
                ArrayList<String> flags = new ArrayList<String>();
                ArrayList<String> listaWarning = new ArrayList<String>();
                for (Map.Entry<String, String> p : this.parametros.entrySet()) {
                    String chave = p.getKey();
                    MessageSegmentObx obx = this.buscaObxPeloObservationID(oruR01.getObxList(), chave);
                    if (obx == null) continue;
                    if (obx.getAbnormalFlag() != null && !obx.getAbnormalFlag().equals((Object)MessageSegmentObx.AbnormalFlag.NORMAL)) {
                        flags.add(this.tratarDescricao(chave) + " - " + obx.getAbnormalFlag().toString());
                    }
                    String campo = this.parametros.get(chave);
                    String resultado = obx.getObservationValue();
                    this.retornaAlerta(campo, listaWarning);
                    resultado = resultado.length() > IMAGE_BINARY_BASE64.length() && obx.getValueType().equals((Object)MessageSegmentObx.ValueType.BASE64) ? this.convertImg(reqCodigo, resultado, chave) : resultado.replace('.', ',');
                    dados.put(campo, resultado);
                }
                flags.addAll(listaWarning);
                List<BDExame> exames = BDUtil.getReqExamesMultGuia(filCodigo, intCodigo, reqCodigo, recCodigo);
                if (exames.isEmpty()) {
                    this.fireExcecaoEncontrada("Nenhum exame foi encontrado para a requisi\u00e7\u00e3o: " + filCodigo + " " + reqCodigo + " " + recCodigo + " " + ALTERNATIVO);
                    return;
                }
                for (BDExame exa : exames) {
                    this.atualizarDadosExame(st, filCodigo, reqCodigo, recCodigo, exa.getExame(), exa.getMaterial(), intCodigo, dados, flags);
                }
                Conexao.arquivaSQL();
                this.fireAtualizarTabela();
                this.enviaMensagem(oruR01.getMsh().getMessageControlId(), ackR01);
            } else {
                this.fireExcecaoEncontrada("C\u00f3digo da etiqueta " + tuboId + " n\u00e3o encontrada.");
            }
        }
        catch (Exception e) {
            try {
                Conexao.anulaSQL();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ackR01.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
            ackR01.getMsa().setTextMessage("Erro ao receber a mensagem");
            ackR01.getMsa().setErrorCondition(ErrorCondition.APPLICATION_INTERNAL_ERROR);
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    private void retornaAlerta(String campo, List<String> listaWarning) {
        if (this.warning.containsValue(campo)) {
            listaWarning.add(campo);
        }
    }

    private String tratarDescricao(String p) {
        String[] campo = p.split("\\^");
        return campo != null && campo.length > 1 ? campo[1] : p;
    }

    private String convertImg(String reqCodigo, String resultado, String p) throws IOException {
        Base64 b64 = new Base64();
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(b64.decode(resultado)));
        File img = File.createTempFile("Hemabio III Vet" + reqCodigo, ".png");
        ImageIO.write((RenderedImage)image, "png", img);
        BufferedImage imgNew = ImageIO.read(img);
        resultado = b64.encodeAsString(ImagemUtils.imageToByte(imgNew));
        img.delete();
        return resultado;
    }

    private MessageSegmentObx buscaObxPeloObservationID(List<MessageSegmentObx> listObx, String observationID) {
        for (MessageSegmentObx obx : listObx) {
            if (!obx.getObservationSubId().equals(observationID)) continue;
            return obx;
        }
        return null;
    }

    @Override
    protected void messageOrmO01Recebida(MessageOrmO01 ormO01) {
        block17: {
            String messageId = ormO01.getMsh().getMessageControlId();
            MessageOrrO02 orrO02 = new MessageOrrO02();
            try {
                String tuboId = ormO01.getOrc().getPlaceOrderNumber();
                int digitosCodigoTubo = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
                if (tuboId != null && !tuboId.trim().isEmpty() && tuboId != "null" && Funcoes.isNumeric(tuboId) && tuboId.length() == digitosCodigoTubo) {
                    String filCodigo = tuboId.substring(0, ParametrosGerais.getDigitosTuboFilial());
                    String reqCodigo = tuboId.substring(ParametrosGerais.getDigitosTuboFilial());
                    String recCodigo = reqCodigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
                    reqCodigo = reqCodigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
                    Object[] req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 0);
                    PanelAbaAbstrata aba = this.equipamento.getTab(0);
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 1);
                        aba = this.equipamento.getTab(1);
                    }
                    if (req == null) {
                        req = this.getRequisicaoAba(filCodigo, reqCodigo, recCodigo, 2);
                        aba = this.equipamento.getTab(2);
                    }
                    if (req == null) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        return;
                    }
                    String exames = (String)req[aba.getColIndice("Exame")];
                    String mcoCodigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                    String intCodigo = (String)req[aba.getColIndice("Interface")];
                    String pacNome = (String)req[aba.getColIndice("Paciente")];
                    String pacIdade = (String)req[aba.getColIndice("Ide")];
                    String pacSexo = (String)req[aba.getColIndice("S")];
                    String data = TempoUtil.getCurrentDateBr();
                    String hora = TempoUtil.getCurrentTime();
                    String pacNasc = this.getPacienteDataNascimento(filCodigo, reqCodigo);
                    ArrayList<ExameMaterial> examesDaRequisicao = new ArrayList<ExameMaterial>();
                    for (String string : exames.split(" ", 0)) {
                        examesDaRequisicao.add(new ExameMaterial(string, new Integer(mcoCodigo)));
                    }
                    Date dataColeta = null;
                    ArrayList<ExameMaterial> examesParaEnviar = new ArrayList<ExameMaterial>();
                    for (ExameMaterial exameMaterial : examesDaRequisicao) {
                        if (dataColeta == null) {
                            dataColeta = BDUtil.getExmColeta(filCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial());
                        }
                        int n = this.getExameSituacao(Conexao.getStatement(), filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo);
                        if (BDUtil.isExameDesmembrado(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo)) {
                            List<ExameMaterial> examesFilhos = Arrays.asList(BDUtil.getExamesFilhos(filCodigo, intCodigo, exameMaterial.getString(), mcoCodigo));
                            if (n == 0 || n == 1) {
                                examesParaEnviar.addAll(examesFilhos);
                                continue;
                            }
                            for (ExameMaterial exameFilho : examesFilhos) {
                                int sitFilho = BDUtil.getDesmSituacao(filCodigo, intCodigo, reqCodigo, exameMaterial.getNomeExame(), exameMaterial.getCodigoMaterial(), recCodigo, exameFilho.getNomeExame(), exameFilho.getCodigoMaterial());
                                if (sitFilho != 3) continue;
                                examesParaEnviar.add(exameFilho);
                            }
                            continue;
                        }
                        if (n != 0 && n != 1 && n != 3) continue;
                        examesParaEnviar.add(exameMaterial);
                    }
                    HashSet<String> tests = new HashSet<String>();
                    for (ExameMaterial exameMaterial : examesParaEnviar) {
                        String test = BDUtil.getExmCodigoAlternativo(filCodigo, exameMaterial.getNomeExame(), mcoCodigo, intCodigo);
                        if (test == null || test.trim().isEmpty()) continue;
                        tests.add(test);
                    }
                    if (tests.isEmpty()) {
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                        this.enviaMensagem(messageId, orrO02);
                        this.fireExcecaoEncontrada(tuboId + " - Nenhum exame enviado.");
                    } else {
                        InfoExameRequisicao infoExameRequisicao = new InfoExameRequisicao(filCodigo, reqCodigo, mcoCodigo, recCodigo, pacNome, pacIdade, pacSexo, data, hora, exames);
                        this.examesEnviadosPorSid.put(tuboId, infoExameRequisicao);
                        this.examesEnviadosPorMid.put(messageId, infoExameRequisicao);
                        pacNome = StringUtil.removerAcentos(pacNome);
                        if (!Funcoes.textoVazio(pacNome) && pacNome.length() > 30) {
                            pacNome = pacNome.substring(0, 30);
                        }
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append(filCodigo).append(reqCodigo).append("^^^^");
                        Date dataHoraRequisicao = new Date();
                        orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.ACCEPTED);
                        orrO02.getPid().setId(1);
                        orrO02.getPid().setPatientName("^" + pacNome);
                        orrO02.getPid().setSex(pacSexo);
                        orrO02.getPid().setDataOfBirth(pacNasc);
                        orrO02.getPid().setPatientIdentifierList(stringBuilder.toString());
                        orrO02.getOrc().setOrderControl("AF");
                        orrO02.getOrc().setPlaceOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setPlacerOrderNumber(ormO01.getOrc().getFilterOrderNumber());
                        orrO02.getObr().setRequestDateTime(dataHoraRequisicao);
                        orrO02.getObr().setCollectorIdentifier("MA");
                        orrO02.getObr().setSpecimenReceiveDateTime(dataHoraRequisicao);
                        orrO02.getObr().setDiagnosticServSect("HM");
                        MessageSegmentObx obx = new MessageSegmentObx();
                        obx.setId(1);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("08001^Take Mode^99MRC");
                        obx.setObservationValue("A");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        obx = new MessageSegmentObx();
                        obx.setId(2);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("08002^Blood Mode^99MRC");
                        obx.setObservationValue("W");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        for (String alternativo : tests) {
                            obx = new MessageSegmentObx();
                            obx.setId(3);
                            obx.setValueType(MessageSegmentObx.ValueType.IS);
                            obx.setObservationId("08003^Test Mode^99MRC");
                            obx.setObservationValue(alternativo);
                            obx.setObserveResultStatus("F");
                            orrO02.addObx(obx);
                        }
                        obx = new MessageSegmentObx();
                        obx.setId(4);
                        obx.setValueType(MessageSegmentObx.ValueType.IS);
                        obx.setObservationId("01002^Ref Group^99MRC");
                        obx.setObservationValue("Geral");
                        obx.setObserveResultStatus("F");
                        orrO02.addObx(obx);
                        this.enviaMensagem(messageId, orrO02);
                        this.alteraSituacaoParaPendentes((InfoExameRequisicao)this.examesEnviadosPorSid.get(tuboId));
                        this.examesEnviadosPorSid.remove(tuboId);
                    }
                    break block17;
                }
                orrO02.getMsa().setAckCode(MessageSegmentMsa.AckCode.REJECTED);
                this.enviaMensagem(messageId, orrO02);
            }
            catch (Exception ex) {
                ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
            }
        }
    }

    @Override
    public String parse(String text) {
        try {
            Message message = this.messageParser.textToMessageHemabioIIIVet(text);
            this.mensagemRecebida(message);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "Erro ao efetuar o parse da mensagem";
        }
        return null;
    }

    @Override
    public void teste() {
        String requisicao = JOptionPane.showInputDialog("Informe o tubo: ", (Object)"010051554201");
        StringBuilder bui = new StringBuilder();
        bui.append("[SB]MSH|||^~&|TECOM|TEK5000P|||2024-11-08[SP]02:19:34[SP]08||ORU^R01|2|P|2.3.1||||[NUL]||ASCII|||[CR]");
        bui.append("PID|1||||C\u00c3\u00a3o|||--|Admin||||||||||||||||||||||[CR]");
        bui.append("OBR|1|" + requisicao + "|2|TECOM|N|2024-11-08[SP]02:15:50||||||||||||||||||||||||||||||||||||||||||[CR]");
        bui.append("OBX|1|NM||WBC|8.87|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|2|NM||Lym%|47.2|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|3|NM||Mid%|5.1|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|4|NM||GR%|47.7|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|5|NM||Lym#|4.19|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|6|NM||Mid#|0.45|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|7|NM||GR#|4.23|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|8|NM||RBC|8.22|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|9|NM||HGB|18.0|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|10|NM||HCT|51.7|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|11|NM||MCV|62.8|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|12|NM||MCH|21.9|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|13|NM||MCHC|34.8|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|14|NM||RDW_CV|19.7|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|15|NM||RDW_SD|50.2|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|16|NM||PLT|572|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|17|NM||MPV|11.5|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|18|NM||PCT|0.658|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|19|NM||PDW|15.8|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|20|NM||P_LCR|46.3|||||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|21|NM||P_LCC|265|||A||||||2024-11-08[SP]02:15||||[CR]");
        bui.append("OBX|22|ED||WBC^PNG^Base64|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|||||||||2024-11-08[SP]02:19:32||||[CR]");
        bui.append("OBX|23|ED||RBC^PNG^Base64|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|||||||||2024-11-08[SP]02:19:32||||[CR]");
        bui.append("OBX|24|ED||PLT^PNG^Base64|iVBORw0KGgoAAAANSUhEUgAAASwAAADICAAAAAB3tIOJAAAACXBIWXMAAAsTAAALEwEAmpwYAAAIeElEQVR4nO2deVRUVRzHf8Miy8igrINBMqnhgjtplgikUnb0eDyKlalHTdEUj5nLyUpSK1PyVC5YqR09CuFeqblrasNBXEjcjmgICEpuOIjoyCivP+q4js77vXvvY578Pv/xlu/98Tm/d3lz3wyjk4CQi0tNF6AlSBYCkoWAZCEgWQhIFgKShYBkIXAgK88YEh6/FvKMBwDgDaPRaDQa26lSmDPi9vTdtovfNlyXsPjli1UAMLkMUiwzwVuVwpwRB7IAojr3sXy8GwAAXgNIc+knvCTnRc6c1eryHeF1aAI5srKaOey/2oFDDdklq/ZtUqMSDeBQ1lRDq51xx9UoxflxKGt7ZzXK0AZ0U4pA7tR9DACaBoisRAPYk7VXin1s22gAyHhbdDVOjs7OGvx0aZrqdWgCmrMQkCwEJAsByUJAshCQLAQkCwHJQkCyEJAsBCQLAclCQLIQkCwEJAsByUJAshCQLAQkCwHJQkCyEJAsBCQLAclCQLIQkCwEJAsByUJAshCQLAQkCwHJQkCyEJAsBCQLAclCQLIQkCwEJAsByUJAshCQLAQkCwHJQkCyEJAsBCQLAclCQLIQkCwEJAsByUJAshCQLAQkCwHJQkCyEJAsBCQLAclCQLIQkCwEJAsByUJAshCQLAQkCwHJQkCyEJAsBCQLAclCQLIQkCwEJAsByUJAshCQLAQkCwHJQkCyEJAsBCQLAclCQLIQkCwE6su6ovqI3FD9y/jG54bWKTcWNM95KafF2aAefdQenwVVZd0+Xj22UZd8SZIkSaqWJMnzPa/AC3WXpvqoWYVyVJX125DQlukPbZnSyaNC71pvyhdqlqEYNWW1973y6JffhhTujQEAU2GainUoRqUJvgpghylst50vCo4BACh4xTBgsjqVsKBOZ8262O1QSk7Ekw9IvOkxo17r89HNVClHKap8C12n6sCTXZY5Oqr/EV8PMywdyndsnqhwGe6q0zd704ZlDo9bvfbgcC/3EeFm8SUpRLys3BHmiQCRMo5sBUOKMqyb4mcLr0kh4mX9nNBB/sFB/dwib56NXLBOXD0MCJ/gJ247hj3lx/j9a717iCiGEcGyTvWq2o8/azukxs3dyr8aVsRehrdjtxSFKDnRNycgLAfAyrsgNoTKKukysrHSc9NWd02a/eo3PMthRqSsRQ1Tpis/u9O1kqzuO1vyK4cdgXNW5At32QJ+LQ6DST4p7/MphwNiOqsUYJln7w2sMWEAXxd9MoFHRVwQ0lnjsqML/rrMZ5HKr2xauxwuSewI6KyrDSr6nQ7N57agN7WMYebjCv/OWjE6dTAM8+MX6FqYGJqn55enHO6dVTZ1/WAAjq4AYFGy30yugQrhLmt5z+68IwESb6/rwj8VDW9ZZ+ct4Jz4H4d7efb5U0gyAs6yNkfs4xt4j0kXLo/rJihbLnxlRX9ZHso18AH8zMuNpppdGOQp64/nwjPtPJLgRmTaL91SBOY7hJ+sA2P7blvBLc0+bayFzb9cKXiQJ8NN1v639GVy1o4Zmde0aMjv4oexD7enO4Z9bZiLkUdFdIPNsLMmJntOd/DXmwxXyxX4HBlqDKz0zH7K66m7rkJG5iPL3H15ApcgeSw9kD60OCjpZOTBjkeaFgZfd3erCDr3Ym7U4Vanw67oq6sMOyaNEjEuF1l3YxhXrrB06ABtFmf+/1ace9z/YdCGLVNPm0qCLN53wC398zBOw3KR1X4bjxQkAwc+bW/rYQWmkqBrehu4ezf7fhAA2NyZh+Qhq61HTd9aP06upLv/Q/DEq34WQ/ghADj3PEMouyzJe8BPzCH8ecAVnLDc8r/mPyG2WZHuQqeFyjPZZV2q64yuHiIgAKABpC9YGa3rdbzFV0cjfOMV5bDL6rmFOUIlkka7AMA7c/JbmDPbAgCsGIQLYJYVZ4hijVANFwCADAAojTujq9aBLml7R/T5DGRZdzEm1AQhp+bfslpvWfPG5WNOY+2s+POMATXEaAAAMO4vxJzE1FlVOcEZBpaAmiccczBLZ9n0jcxNGM7XHCyd9eaUU7XKFYus8fVm8KtDEyi/DM0Z/3CsQxMol9XHWd6BoB5KL8PKBr15LXxoB4WyrgWMWsK3EC2gUNaOqGS+dWgChXPWcI3euLOhrLMaL9HIxyn5okRWqiG5P/dCtICCy3DMyhKNvyBUCrqzjvn6Xa2lrrCddXjRxjXKlmSfBVCyLAllgRdEVaIBMJfhvMCQWU748SP1QHRWu/o2cXVoAtmdZfbprsXVdq7I7Kznfc8XBIitRAPIknW7R+yoeuTK7pvZhhbGPrzhh9dNqhTjTMTGPL7NXme1kR4xOBLsKH3Gsfcb2+ssWeyVYmvdQYofWOzZU/sOon9jh4BkIVD8dCdWzmT3jB2keIKvjQi8DEu/A4DCcUl5jDmVPyR+XMol6XrqyIl5MpLWmsLmXLSzXZis6qwPvgOwvabzjatkS8pa3ySzs5VH0o5t7c7E3HSYVD1yYeakYnt7JEFUvtu5oSRt9r8jBWewJVkl6Txk8ki6IUlX4ZDDpGNQUA4H7ewQ1lneaWMAIDfCFSIYn/N7AHjxSdID5OtNDpM+hK7239gv+L8cXa4P4HOJOWa3oe06LkkJ2ev9HNa0yJTraXeH4PusO24AHsxrhlWfjffik/R6VHKV8iTBsvRVALa6rCkfuU7hlDR81dHtypMEywovBigOZwxZk7HRg08SgLv3DeVJgmV1PfV38QnGT/YcSEw3WKw8ktYXwNbyl+Ul3bBYbjy2ke2P8ZMp9/dx8U+WPvXxGcOYNB8AYAKPpLlewZ5zJYdJBVBhAwCIeXSH8Jc7V6qDnCfJVmqsw5BErw0R0BINApKFgGQhIFkISBYCkoWAZCEgWQhIFgKShYBkIfgXhiZEiOJA5XAAAAAASUVORK5CYII=|||||||||2024-11-08[SP]02:19:32||||[CR]");
        bui.append("[EB][CR]");
        this.parse(TestesInterface.arruma(bui.toString()));
    }
}

