/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.h300;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private static Map<String, String> exameCamposByTestId = new HashMap<String, String>();
    private final String CODIGO_ALTERNATIVO = "h300";
    private String int_codigo;
    private String fil_codigo;
    private String req_codigo;
    private String mco_codigo;
    private String rec_codigo;
    private String pac_nome;
    private String pac_exames;
    private String pac_sexo;
    private String req_idade;
    private String req_data;
    private String req_hora;
    private String acao;

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    void limpaDadosRequisicao() {
        this.fil_codigo = null;
        this.req_codigo = null;
        this.mco_codigo = null;
        this.rec_codigo = null;
        this.pac_nome = null;
        this.pac_sexo = null;
        this.req_idade = null;
        this.req_data = null;
        this.req_hora = null;
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        this.fil_codigo = fil_codigo;
        this.int_codigo = int_codigo;
        this.req_codigo = req_codigo;
        this.pac_nome = pac_nome;
        this.pac_sexo = pac_sexo;
        this.req_idade = pac_idade;
        this.req_data = data;
        this.req_hora = hora;
        this.mco_codigo = mco_codigo;
        this.rec_codigo = rec_codigo;
        this.pac_exames = exames;
        this.acao = acao;
        try {
            Statement st = Conexao.getStatement();
            this.atualizarSituacaoTubo(st, fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, acao.equals("N") ? 1 : 3);
            Conexao.arquivaSQL();
            this.fireMensagemEnviada("Pedido(s) enviado(s) com sucesso para " + pac_nome, 0, 10000);
            if (acao.equals("N")) {
                this.firePacienteEnviado(req_codigo, pac_nome, pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
            }
            this.interromperTimer();
            this.limpaDadosRequisicao();
            this.fireAtualizarTabela(0);
            this.setIdle();
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    @Override
    public synchronized String parse(String message) {
        String[] linhas;
        String retorno = null;
        Object checksum = null;
        if (!message.startsWith(this.getMsgStart()) || !message.endsWith(this.getMsgEnd())) {
            return "Erro ao receber o bloco de resultados, caracter inicial ou final n\u00e3o localizado";
        }
        if (message.startsWith(this.getMsgStart())) {
            message = message.replaceFirst(this.getMsgStart(), "");
        }
        if (message.endsWith(this.getMsgEnd())) {
            message = message.replaceFirst(this.getMsgEnd(), "");
        }
        if ((linhas = message.split(LINE)) != null && linhas.length > 0) {
            try {
                retorno = this.parseResults(linhas);
                if (retorno == null) {
                    return "";
                }
                if (retorno.startsWith("Erro")) {
                    return retorno;
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, 2000);
                return retorno;
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage(), ex.getStackTrace());
                try {
                    Conexao.anulaSQL();
                    return "Erro ao inserir resultados recebidos ao banco de dados";
                }
                catch (SQLException e) {
                    ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                    return "Erro ao anular os dados recebidos";
                }
            }
        }
        return "Erro ao realizar parse dos dados recebidos";
    }

    private String parseResults(String[] linhas) throws SQLException {
        try {
            int posFinal = 4 + ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            String requisicao = linhas[3].substring(4, posFinal).trim();
            if (Funcoes.textoVazio(requisicao) || !Funcoes.isNumeric(requisicao)) {
                this.fireExcecaoEncontrada("C\u00f3digo da requisi\u00e7\u00e3o n\u00e3o localizado nos dados recebidos");
                return null;
            }
            Statement st = Conexao.getStatement();
            this.fil_codigo = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
            this.rec_codigo = requisicao.substring(requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.req_codigo = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), requisicao.length() - ParametrosGerais.getDigitosTuboTubo());
            this.int_codigo = this.getIntCodigo(this.fil_codigo, this.req_codigo, this.rec_codigo, "h300");
            if (this.int_codigo == null) {
                this.fireExcecaoEncontrada("Requisi\u00e7\u00e3o n\u00e3o interfaceada: " + this.fil_codigo + this.req_codigo + this.rec_codigo);
                return null;
            }
            HashMap<String, Object> dados = new HashMap<String, Object>();
            for (int i = 4; i < linhas.length; ++i) {
                if (linhas[i].trim().isEmpty() || linhas[i].trim().length() < 6) continue;
                String exameId = linhas[i].substring(1, 5).trim();
                String resultado = linhas[i].substring(5).trim().replace('.', ',');
                if (exameCamposByTestId.get(exameId) == null) continue;
                dados.put(exameCamposByTestId.get(exameId), resultado);
            }
            ExameMaterial exame = this.getReqExameLIS(this.fil_codigo, this.int_codigo, this.req_codigo, this.rec_codigo, "h300");
            this.atualizarDadosExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), this.int_codigo, dados);
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
        return "";
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(5000);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    private void abortarRecepcao() throws Exception {
        this.limpaDadosRequisicao();
        this.setPausa(3000);
    }

    @Override
    public void handShakeCharReceived(char c) {
    }

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String message = InterfaceListener.this.getPortaCOM().removeInputString(InterfaceListener.this.getMsgEnd());
                    if (!message.equals("")) {
                        String resultado = InterfaceListener.this.parse(message);
                        if (resultado != null) {
                            InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                        }
                    } else if (InterfaceListener.this.isRX()) {
                        InterfaceListener.this.aguardarProximoFrame();
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                    try {
                        Conexao.anulaSQL();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
        this.setIdle();
    }

    static {
        exameCamposByTestId.put("UBG", "UBG");
        exameCamposByTestId.put("BIL", "BIL");
        exameCamposByTestId.put("KET", "CET");
        exameCamposByTestId.put("BLD", "SAN");
        exameCamposByTestId.put("PRO", "PRO");
        exameCamposByTestId.put("NIT", "NIT");
        exameCamposByTestId.put("LEU", "LEU");
        exameCamposByTestId.put("GLU", "GLI");
        exameCamposByTestId.put("SG", "DEN");
        exameCamposByTestId.put("pH", "pH");
        exameCamposByTestId.put("VC", "VC");
    }
}

