/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.gens;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.AbstractInterfaceamentoListener;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.util.Funcoes;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;

public class InterfaceListener
extends AbstractInterfaceamentoListener {
    private String PREAMBLE = LINE + LINE + LINE + LINE + LINE + LINE + "--------------" + LINE;
    private String POSTAMBLE = LINE + LINE + "--------------" + LINE;
    private String EXAME_PADRAO = "HEMOG";
    private boolean recebendo = false;
    private boolean enviando = false;
    private boolean enviado = false;
    private String message = new String();
    private String messageRequisicao = "";
    private String fil_codigo;
    private String int_codigo;
    private String req_codigo;
    private String mco_codigo;
    private String rec_codigo;
    private String rackposition;
    private String pac_nome;
    private ThreadRecebimento threadRecebimento = new ThreadRecebimento();

    @Override
    public void dataChanged() {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    String msg = InterfaceListener.this.getPortaCOM().removeInputString(String.valueOf('\u0003'));
                    if (!Funcoes.textoVazio(msg)) {
                        System.out.println("Recebido - ETX");
                        InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0006'));
                        System.out.println("Enviado - ACK");
                        msg = msg.substring(3, msg.length() - 4);
                        InterfaceListener.this.message = InterfaceListener.this.message + msg;
                    } else if (InterfaceListener.this.recebendo) {
                        msg = InterfaceListener.this.getPortaCOM().getInputString();
                        if (!Funcoes.textoVazio(msg) && msg.trim().length() == 2) {
                            System.out.println("Recebido - Block Count");
                            InterfaceListener.this.getPortaCOM().clearInputString();
                            InterfaceListener.this.getPortaCOM().write(String.valueOf('\u0006'));
                        }
                    } else {
                        InterfaceListener.this.aguardarProximoFrame();
                    }
                }
                catch (Exception ex) {
                    ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                    try {
                        InterfaceListener.this.fireMensagemEnviada("Erro ao receber dados do equipamento.", 1, 5000);
                        Conexao.anulaSQL();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        };
        SwingUtilities.invokeLater(run);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void handShakeCharReceived(char c) {
        try {
            switch (c) {
                case '\u0016': {
                    System.out.println("Recebido - SYN");
                    if (this.enviando) {
                        this.enviando = false;
                        break;
                    }
                    if (this.recebendo) {
                        this.getPortaCOM().write(String.valueOf('\u0006'));
                        System.out.println("Enviado - ACK");
                        this.recebendo = false;
                        this.addListaRecebimento(new String(this.message.getBytes()));
                        this.restartThreadRecebimento();
                        this.message = "";
                        break;
                    }
                    this.getPortaCOM().write(String.valueOf('\u0016'));
                    System.out.println("Enviado - SYN");
                    this.recebendo = true;
                    break;
                }
                case '\u0005': {
                    System.out.println("Recebido - ENQ");
                    if (!this.enviando) break;
                    this.getPortaCOM().write("01");
                    System.out.println("Enviado - Block Count");
                    break;
                }
                case '\u0006': {
                    System.out.println("Recebido - ACK");
                    if (!this.enviando || this.enviado) ** GOTO lbl33
                    this.getPortaCOM().write(this.messageRequisicao);
                    System.out.println("Enviado - Bloco Requisi\u00e7\u00e3o");
                    this.enviado = true;
                    ** GOTO lbl41
lbl33:
                    // 1 sources

                    if (this.enviado) {
                        this.enviando = false;
                        this.enviado = false;
                        this.getPortaCOM().write(String.valueOf('\u0005'));
                        System.out.println("Transmiss\u00e3o OK");
                        st = Conexao.getStatement();
                        this.atualizarSituacaoRackTubo(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.mco_codigo, this.int_codigo, 1, this.rackposition);
                        Conexao.arquivaSQL();
                    }
                }
lbl41:
                // 5 sources

                case '\u0015': {
                    System.out.println("Recebido - NAK");
                    if (!this.enviando || !this.enviado) break;
                    this.getPortaCOM().write(this.messageRequisicao);
                    System.out.println("Re-Enviado - Bloco Requisi\u00e7\u00e3o");
                    this.enviado = true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString() + "\n" + ex.getMessage(), ex.getStackTrace());
        }
    }

    @Override
    public String getMsgEnd() {
        return String.valueOf('\u0003');
    }

    @Override
    public String getMsgStart() {
        return String.valueOf('\u0002');
    }

    @Override
    @Deprecated
    public synchronized String parse(String message) {
        block9: {
            System.out.println("-------------------------------------------------");
            System.out.println("Mesagem Recebida:");
            System.out.println(message);
            System.out.println("-------------------------------------------------");
            System.out.println("Mesagem - Postamble - Preamble:");
            message = message.substring(0, message.indexOf(this.POSTAMBLE, this.PREAMBLE.length()));
            System.out.println(message);
            message = message + this.POSTAMBLE;
            System.out.println("-------------------------------------------------");
            try {
                if (message.startsWith(this.PREAMBLE) && message.endsWith(this.POSTAMBLE)) {
                    message = message.substring(this.PREAMBLE.length() + 1);
                    message = message.substring(0, message.length() - this.POSTAMBLE.length());
                    String[] fields = message.split(String.valueOf(LINE));
                    HashMap<String, Object> lines = new HashMap<String, Object>();
                    for (String f : fields) {
                        int indexSP = f.indexOf(String.valueOf(' '));
                        if (indexSP <= 0) continue;
                        String cmd = f.substring(0, indexSP).trim();
                        String value = "";
                        if (f.length() > 0) {
                            value = f.substring(f.indexOf(String.valueOf(' ')), f.length()).trim();
                        }
                        lines.put(cmd, value);
                    }
                    try {
                        this.trataResultado(lines);
                        Conexao.arquivaSQL();
                        this.fireAtualizarTabela();
                        this.setIdle();
                        return "Resultados recebidos com sucesso";
                    }
                    catch (SQLException ex) {
                        ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace());
                        Funcoes.showErro(null, "Erro ao inserir resultados recebidos ao banco de dados.\n" + ex.getMessage() + "\nA opera\u00e7\u00e3o foi desfeita.");
                        try {
                            Conexao.anulaSQL();
                        }
                        catch (SQLException e) {
                            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
                        }
                        break block9;
                    }
                }
                return "Os dados recebidos est\u00e3o imcompletos";
            }
            catch (Exception e) {
                return "Os dados recebidos est\u00e3o conrrompidos";
            }
        }
        this.setIdle();
        return "Erro ao processar resultados";
    }

    public boolean checkCRC(String message, String sCrc) {
        return true;
    }

    @Override
    public void fcTimedOut(EventObject e) throws Exception {
    }

    private void aguardarProximoFrame() throws Exception {
        this.setRX(500);
        this.fireMensagemEnviada("Recebendo dados...", 0, 10000);
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String exames, String acao) {
        try {
            Statement st = Conexao.getStatement();
            this.atualizarSituacaoRackTubo(st, fil_codigo, req_codigo, rec_codigo, mco_codigo, int_codigo, 1, rackposition);
            Conexao.arquivaSQL();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "Requisi\u00e7\u00e3o enviada para " + pac_nome;
    }

    private void trataResultado(HashMap<String, Object> lines) throws Exception {
        String rec_codigo;
        String fil_codigo;
        Statement st = Conexao.getStatement();
        String req_codigo = ((String)lines.get("ID1")).trim();
        if (!Funcoes.textoVazio(req_codigo = req_codigo.replaceAll("-", ""))) {
            if (req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("Resultados recebidos para requisi\u00e7\u00e3o inv\u00e1lida ou n\u00e3o interfaceada: " + req_codigo);
                return;
            }
            fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            req_codigo = req_codigo.substring(0, req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
        } else {
            String ier_rackpos = ((String)lines.get("CASSPOS")).trim();
            if (Funcoes.textoVazio(ier_rackpos)) {
                this.fireExcecaoEncontrada("N\u00e3o foi encontrada a rack :" + ier_rackpos);
                return;
            }
            if (!Funcoes.isNumeric(ier_rackpos.substring(0, 1))) {
                ier_rackpos = ier_rackpos.substring(1);
            }
            req_codigo = this.getRequisicaoRack(ier_rackpos);
            System.out.print("Requisi\u00e7\u00e3o:");
            System.out.print(req_codigo);
            System.out.print(" | Rack:");
            System.out.println(ier_rackpos);
            if (Funcoes.textoVazio(req_codigo) || req_codigo.length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                this.fireExcecaoEncontrada("N\u00e3o foi encontrada a requisi\u00e7\u00e3o para a rack :" + ier_rackpos);
                return;
            }
            fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial());
            rec_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboRequisicao());
            req_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
        }
        String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, this.EXAME_PADRAO);
        if (int_codigo == null) {
            StringBuilder s = new StringBuilder();
            s.append("N\u00e3o foi poss\u00edvel encontrar o exame para a requisicao ");
            s.append(fil_codigo).append(" ").append(req_codigo).append(" ").append(rec_codigo);
            this.fireExcecaoEncontrada(s.toString());
            return;
        }
        HashMap<String, Object> dados = new HashMap<String, Object>();
        dados.put("leucocitos", this.parseValor(lines.get("WBC")));
        dados.put("hemacias", this.parseValor(lines.get("RBC")));
        dados.put("hgb", this.parseValor(lines.get("HGB")));
        dados.put("hct", this.parseValor(lines.get("HCT")));
        dados.put("vcm", this.parseValor(lines.get("MCV")));
        dados.put("hcm", this.parseValor(lines.get("MCH")));
        dados.put("chcm", this.parseValor(lines.get("MCHC")));
        dados.put("rdw", this.parseValor(lines.get("RDW")));
        dados.put("plaquetas", this.parseValor(lines.get("PLT")));
        dados.put("pct", this.parseValor(lines.get("PCT")));
        dados.put("vpm", this.parseValor(lines.get("MPV")));
        dados.put("pdw", this.parseValor(lines.get("PDW")));
        dados.put("linfocitos_tipicos_contagem", this.parseValor(lines.get("LY#")));
        dados.put("monocitos_contagem", this.parseValor(lines.get("MO#")));
        dados.put("segmentados_contagem", this.parseValor(lines.get("NE#")));
        dados.put("eosinofilos_contagem", this.parseValor(lines.get("EO#")));
        dados.put("basofilos_contagem", this.parseValor(lines.get("BA#")));
        dados.put("linfocitos_tipicos_percentual", this.parseValor(lines.get("LY%")));
        dados.put("monocitos_percentual", this.parseValor(lines.get("MO%")));
        dados.put("segmentados_percentual", this.parseValor(lines.get("NE%")));
        dados.put("eosinofilos_percentual", this.parseValor(lines.get("EO%")));
        dados.put("basofilos_percentual", this.parseValor(lines.get("BA%")));
        dados.put("linfocitos_atipicos_percentual", this.parseValor(lines.get("LY%")));
        List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
        if (exames == null || exames.size() == 0) {
            this.fireExcecaoEncontrada(req_codigo + " - " + "N\u00e3o foi encontrada");
        }
        if (exames != null) {
            for (BDExame exame : exames) {
                this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getExame(), exame.getMaterial(), int_codigo, dados);
            }
        }
    }

    private Object parseValor(Object valor) {
        if (valor == null) {
            return new String("");
        }
        String value = valor.toString();
        int idx = value.indexOf(32);
        if (idx > 0) {
            value = value.substring(0, idx);
        }
        if (value.indexOf(".") > 0) {
            value = value.replaceFirst("\\.", ",");
        }
        return value;
    }

    private void addListaRecebimento(String message) {
        this.threadRecebimento.addListaRecebimento(message);
        this.restartThreadRecebimento();
    }

    private void restartThreadRecebimento() {
        if (this.threadRecebimento != null && !this.threadRecebimento.isInterrupted() && this.threadRecebimento.isAlive()) {
            return;
        }
        if (this.threadRecebimento != null && !this.threadRecebimento.isAlive()) {
            ArrayList<String> lista = this.threadRecebimento.getListaRecebimento();
            this.threadRecebimento = new ThreadRecebimento();
            this.threadRecebimento.addListaRecebimentos(lista);
        }
        if (this.threadRecebimento != null) {
            this.threadRecebimento.start();
        }
    }

    class ThreadRecebimento
    extends Thread {
        private ArrayList<String> listaRecebimento = new ArrayList();

        ThreadRecebimento() {
        }

        public ArrayList<String> getListaRecebimento() {
            return this.listaRecebimento;
        }

        public void addListaRecebimento(String message) {
            this.listaRecebimento.add(message);
        }

        public void addListaRecebimentos(ArrayList<String> messages) {
            this.listaRecebimento.addAll(messages);
        }

        @Override
        public void run() {
            try {
                while (this.listaRecebimento.size() > 0) {
                    String message = this.listaRecebimento.remove(0);
                    String resultado = InterfaceListener.this.parse(message);
                    if (resultado != null) {
                        InterfaceListener.this.fireMensagemEnviada(resultado, 0, 10000);
                    }
                    ThreadRecebimento.sleep(450L);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

