/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.genarrayt2;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.genarrayt2.Alimentos;
import jalis.util.Funcoes;
import jalis.util.excel.Excel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import javax.swing.Timer;

public class InterfaceListener
extends jalis.laboratorio.interfaceamento.interfaces.genarrayt.InterfaceListener {
    public static final String ABA_EXCEL_RESULTADO = "Report 1";
    public static final String CEL_CODIGO_REQUISICAO = "E6";
    public static final String CEL_REQUISICAO_VAZIO = "N\u00famero do Paciente:";
    public static final String NOME_EXAME = "IGG";
    ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
    private Timer arquivo = new Timer(30000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            File[] interfaceArquivos = new File(InterfaceListener.this.c.getDiretorioImportacao()).listFiles();
            if (interfaceArquivos != null) {
                for (File arquivo : interfaceArquivos) {
                    String nomeArquivo = arquivo.getName();
                    if (!arquivo.isFile() || !nomeArquivo.substring(nomeArquivo.lastIndexOf(".") + 1).toUpperCase().equals("XLSM")) continue;
                    InterfaceListener.this.parse(arquivo.getAbsolutePath());
                }
            }
        }
    });

    public InterfaceListener() {
        this.arquivo.start();
    }

    @Override
    public String parse(String path) {
        File file = new File(path);
        String arquivo = null;
        try {
            arquivo = (String)Excel.lerCelulaXlsx(file, ABA_EXCEL_RESULTADO, CEL_CODIGO_REQUISICAO);
        }
        catch (IOException e1) {
            this.fireExcecaoEncontrada("Arquivo n\u00e3o cont\u00eam informa\u00e7\u00f5es da requisi\u00e7\u00e3o: " + file.getName());
            File dir = new File(this.c.getDiretorioImportacao() + File.separator + "Rejeitado" + File.separator);
            file.renameTo(new File(dir, file.getName()));
        }
        if (arquivo == null || arquivo.trim().equalsIgnoreCase(CEL_REQUISICAO_VAZIO)) {
            this.fireExcecaoEncontrada("Arquivo n\u00e3o cont\u00eam informa\u00e7\u00f5es da requisi\u00e7\u00e3o: " + file.getName());
            File dir = new File(this.c.getDiretorioImportacao() + File.separator + "Rejeitado" + File.separator);
            file.renameTo(new File(dir, file.getName()));
            return null;
        }
        arquivo = arquivo.replaceAll(CEL_REQUISICAO_VAZIO, "").replaceAll("/", "").trim();
        int totalchar = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
        if (arquivo.length() <= totalchar - 1) {
            arquivo = Funcoes.preencheZero(arquivo, totalchar);
        }
        Statement st = Conexao.getStatement();
        try {
            String fil_codigo = arquivo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = arquivo.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String rec_codigo = arquivo.substring(ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao());
            String int_codigo = this.getIntCodigo(fil_codigo, req_codigo, rec_codigo, NOME_EXAME);
            if (int_codigo == null) {
                this.fireExcecaoEncontrada("Arquivo n\u00e3o cont\u00eam informa\u00e7\u00f5es da requisi\u00e7\u00e3o: " + file.getName());
                File dir = new File(this.c.getDiretorioImportacao() + File.separator + "Rejeitado" + File.separator);
                file.renameTo(new File(dir, file.getName()));
                return null;
            }
            HashMap<String, Object> alimentosMap = new HashMap<String, Object>();
            for (Alimentos alimento : Alimentos.values()) {
                alimentosMap.put(alimento.getNome(), Excel.lerCelulaXlsx(file, ABA_EXCEL_RESULTADO, alimento.getCelula()));
            }
            ExameMaterial exame = this.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, NOME_EXAME);
            this.atualizarDadosExame(st, fil_codigo, req_codigo, rec_codigo, exame.getNomeExame(), exame.getCodigoMaterial(), int_codigo, alimentosMap);
            Conexao.arquivaSQL();
            this.fireAtualizarTabela();
            File dir = new File(this.c.getDiretorioImportacao() + File.separator + "Importado" + File.separator);
            file.renameTo(new File(dir, file.getName()));
            return "Resultados recebidos com sucesso.";
        }
        catch (SQLException e) {
            this.fireExcecaoEncontrada("Arquivo n\u00e3o cont\u00eam informa\u00e7\u00f5es da requisi\u00e7\u00e3o: " + file.getName());
            File dir = new File(this.c.getDiretorioImportacao() + File.separator + "Rejeitado" + File.separator);
            file.renameTo(new File(dir, file.getName()));
        }
        catch (IOException e) {
            this.fireExcecaoEncontrada("Arquivo n\u00e3o cont\u00eam informa\u00e7\u00f5es da requisi\u00e7\u00e3o: " + file.getName());
            File dir = new File(this.c.getDiretorioImportacao() + File.separator + "Rejeitado" + File.separator);
            file.renameTo(new File(dir, file.getName()));
        }
        catch (Exception e) {
            this.fireExcecaoEncontrada("Arquivo n\u00e3o cont\u00eam informa\u00e7\u00f5es da requisi\u00e7\u00e3o: " + file.getName());
            File dir = new File(this.c.getDiretorioImportacao() + File.separator + "Rejeitado" + File.separator);
            file.renameTo(new File(dir, file.getName()));
        }
        return null;
    }
}

