/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.gempremier3500;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.interfaces.gempremier3500.InterfaceListener;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMRecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.StringUtil;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class RecordParser
extends ASTMRecordParser {
    Map<String, String> campos = new HashMap<String, String>();

    @Override
    public void recordFound(String record) throws Exception {
        this.campos.put("pH", "gasometria_ph");
        this.campos.put("pCO2", "gasometria_pco2");
        this.campos.put("pO2", "gasometria_po2");
        this.campos.put("Na+", "gasometria_na");
        this.campos.put("K+", "gasometria_k");
        this.campos.put("Ca++", "gasometria_ca");
        this.campos.put("Hct", "gasometria_hct");
        this.campos.put("Ca++(7.4)", "gasometria_caa");
        this.campos.put("HCO3-", "gasometria_hco3");
        this.campos.put("HCO3std", "gasometria_hco3std");
        this.campos.put("TCO2", "gasometria_tco2");
        this.campos.put("BEecf", "gasometria_brecf");
        this.campos.put("BE(B)", "gasometria_beb");
        this.campos.put("SO2c", "gasometria_so2c");
        this.campos.put("%FiO2", "gasometria_fio2");
        this.campos.put("Lac", "gasometria_lac");
        this.campos.put("Glu", "gasometria_glu");
        this.campos.put("THbc", "gasometria_thb");
        String record_type = ASTMStandard.getRecordTypeIdentifier(record);
        if (record_type != null) {
            if (record_type.equals(ASTMStandard.RECORD_TYPE_HEADER)) {
                this.trataHeaderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_PATIENT)) {
                this.trataPatientRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_ORDER)) {
                this.trataOrderRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_RESULT)) {
                this.trataResultRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_COMMENT)) {
                this.trataCommentRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_REQUEST)) {
                this.trataRequestRecord(record);
                return;
            }
            if (record_type.equals(ASTMStandard.RECORD_TYPE_TERMINATION)) {
                this.trataTerminationRecord();
                return;
            }
        }
    }

    @Override
    protected void trataResultRecord(String record) throws SQLException {
        Hashtable result_fields;
        String dataEquipamento;
        if (this.exame_atual == null) {
            return;
        }
        String action_code = (String)this.exame_atual.get(ACTION_CODE);
        String report_type = (String)this.exame_atual.get(REPORT_TYPE);
        if (action_code != null) {
            this.equip.getClass();
            if (action_code.equals("Q")) {
                this.exame_atual = null;
                return;
            }
        }
        if (report_type != null) {
            this.equip.getClass();
            if (report_type.equals("X")) {
                this.exame_atual = null;
                return;
            }
        }
        if (!Funcoes.textoVazio(dataEquipamento = (String)(result_fields = ASTMStandard.parseDefaultResultRecord(record)).get(ASTMStandard.RESULT_FIELD_DATETIME_ENDED))) {
            Date data = Funcoes.stringToDate("yyyyMMddHHmmss", dataEquipamento);
            this.exame_atual.put("gasometria_datechanged", Funcoes.formataData("dd/MM/yyyy HH:mm:ss", data));
        }
        String fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
        String req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
        String rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        String aux = (String)result_fields.get(3);
        String[] campos = aux.split("\\^", -1);
        String campo = "";
        for (String c : campos) {
            if (Funcoes.textoVazio(c)) continue;
            campo = c;
            break;
        }
        String resultado = (String)result_fields.get(4);
        campo = this.parseCampo(campo);
        String emi_alternativo = ((InterfaceListener)this.equip).NOME_EXAME;
        boolean campoAlternativo = false;
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (Funcoes.textoVazio(int_codigo)) {
            int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, campo);
            campoAlternativo = true;
        }
        if (Funcoes.textoVazio(int_codigo)) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo INT do exame n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
        resultado = resultado.replaceAll("\\.", ",");
        if (resultado.startsWith(",")) {
            resultado = "0" + resultado;
        }
        if (resultado.length() >= 1 && resultado.charAt(resultado.length() - 1) == ',') {
            resultado = resultado + "0";
        }
        Statement st = Conexao.getStatement();
        this.exame_atual.put(campo, resultado);
        String flags = (String)result_fields.get(ASTMStandard.RESULT_FIELD_ABNORMAL_FLAGS);
        if (flags != null && !flags.equals("") && !Funcoes.textoVazio(campo)) {
            this.exame_atual.put("flag_alerta", flags);
        }
    }

    private String parseCampo(String campo) {
        if (this.campos.containsKey(campo)) {
            return this.campos.get(campo);
        }
        return "";
    }

    @Override
    protected void trataOrderRecord(String record) throws Exception {
        if (this.exame_atual == null) {
            return;
        }
        Hashtable<Integer, String> order_fields = ASTMStandard.parseDefaultOrderRecord(record);
        this.exame_atual.put(ACTION_CODE, order_fields.get(ASTMStandard.ORDER_FIELD_ACTION_CODE));
        this.exame_atual.put(REPORT_TYPE, order_fields.get(ASTMStandard.ORDER_FIELD_REPORT_TYPE));
        String instSID = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SYSTEM_SID);
        Map<Integer, String> sys_sample_id = this.equip.parseOrderSystemSID(instSID);
        String emi_alternativo = "GASO";
        String fil_codigo = "";
        String req_codigo = "";
        String rec_codigo = "";
        if (this.exame_atual.containsKey(FIL_CODIGO) && this.exame_atual.containsKey(REQ_CODIGO) && this.exame_atual.containsKey(REC_CODIGO)) {
            fil_codigo = (String)this.exame_atual.get(FIL_CODIGO);
            req_codigo = (String)this.exame_atual.get(REQ_CODIGO);
            rec_codigo = (String)this.exame_atual.get(REC_CODIGO);
        } else {
            req_codigo = (String)order_fields.get(ASTMStandard.ORDER_FIELD_SAMPLE_ID);
            DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(req_codigo);
            if (req_codigo == null || req_codigo.equals("")) {
                req_codigo = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_ID);
            }
            if (!Funcoes.textoVazio(req_codigo) && req_codigo.contains("^")) {
                req_codigo = StringUtil.limpaString(req_codigo, new String[]{"^"});
            }
            try {
                Long.parseLong(req_codigo);
            }
            catch (Exception ex) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(req_codigo);
                this.equip.fireExcecaoEncontrada(msg.toString());
                this.exame_atual = null;
                return;
            }
            int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            req_codigo = Funcoes.preencheZero(req_codigo, qtde);
            String rack_id = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_ID);
            String rack_pos = sys_sample_id.get(this.equip.ORDER_SYS_SAMPLE_RACK_POS);
            this.exame_atual.put("rack_position", rack_id != null ? rack_id + (rack_pos != null ? "-" + rack_pos : "") : rack_pos);
            fil_codigo = req_codigo.substring(0, ParametrosGerais.getDigitosTuboFilial());
            rec_codigo = req_codigo.substring(req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            req_codigo = req_codigo.substring(ParametrosGerais.getDigitosTuboFilial(), req_codigo.length() - ParametrosGerais.getDigitosTuboTubo());
            Map<Integer, String> components = this.equip.parseOrderTestIDField((String)order_fields.get(ASTMStandard.ORDER_FIELD_TEST_ID));
            Statement st = Conexao.getStatement();
            if (etiqueta != null) {
                fil_codigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                req_codigo = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                rec_codigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            }
        }
        String int_codigo = this.equip.getIntCodigo(fil_codigo, req_codigo, rec_codigo, emi_alternativo);
        this.exame_atual.put(INT_CODIGO, int_codigo);
        this.exame_atual.put(FIL_CODIGO, fil_codigo);
        this.exame_atual.put(REC_CODIGO, rec_codigo);
        this.exame_atual.put(REQ_CODIGO, req_codigo);
        if (int_codigo == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado na interface para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            return;
        }
        ExameMaterial exame = this.equip.getReqExameLIS(fil_codigo, int_codigo, req_codigo, rec_codigo, emi_alternativo);
        if (exame == null) {
            this.equip.fireExcecaoEncontrada("C\u00f3digo LIS do exame " + emi_alternativo + " n\u00e3o encontrado para requisi\u00e7\u00e3o " + fil_codigo + " " + req_codigo + " " + rec_codigo);
            this.exame_atual = null;
            return;
        }
        this.exame_atual.put(EXA_CODIGO, exame.getNomeExame());
        this.exame_atual.put(MCO_CODIGO, exame.getCodigoMaterial());
    }

    @Override
    protected void trataPatientRecord(String record) throws Exception {
        super.trataPatientRecord(record);
        this.exame_atual = new HashMap();
        Hashtable paciente = ASTMStandard.parseDefaultPatientRecord(record);
        String idAmostra = (String)paciente.get(ASTMStandard.PATIENT_FIELD_LABORATORY_PID);
        if (!Funcoes.textoVazio(idAmostra)) {
            DescritorCodigoEtiqueta etiqueta = DescritorCodigoEtiqueta.getDescritor(idAmostra);
            try {
                Long.parseLong(idAmostra);
            }
            catch (Exception ex) {
                StringBuilder msg = new StringBuilder();
                msg.append("Resultados recebidos para requisi\u00e7\u00e3o n\u00e3o existente ou n\u00e3o interfaceada: ");
                msg.append(idAmostra);
                this.equip.fireExcecaoEncontrada(msg.toString());
                this.exame_atual = null;
                return;
            }
            int qtde = ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo();
            idAmostra = Funcoes.preencheZero(idAmostra, qtde);
            String fil_codigo = idAmostra.substring(0, ParametrosGerais.getDigitosTuboFilial());
            String rec_codigo = idAmostra.substring(idAmostra.length() - ParametrosGerais.getDigitosTuboTubo());
            idAmostra = idAmostra.substring(ParametrosGerais.getDigitosTuboFilial(), idAmostra.length() - ParametrosGerais.getDigitosTuboTubo());
            String emi_alternativo = "GASO";
            Statement st = Conexao.getStatement();
            if (etiqueta != null) {
                fil_codigo = Funcoes.preencheZero(etiqueta.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                idAmostra = Funcoes.preencheZero(etiqueta.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                rec_codigo = Funcoes.preencheZero(etiqueta.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            }
            String int_codigo = this.equip.getIntCodigo(fil_codigo, idAmostra, rec_codigo, emi_alternativo);
            this.exame_atual.put(INT_CODIGO, int_codigo);
            this.exame_atual.put(FIL_CODIGO, fil_codigo);
            this.exame_atual.put(REC_CODIGO, rec_codigo);
            this.exame_atual.put(REQ_CODIGO, idAmostra);
        }
    }

    @Override
    protected void salvaExame(Map<String, Object> dados) throws Exception {
        String fil_codigo = (String)dados.remove(FIL_CODIGO);
        String int_codigo = (String)dados.remove(INT_CODIGO);
        String req_codigo = (String)dados.remove(REQ_CODIGO);
        String exa_codigo = (String)dados.remove(EXA_CODIGO);
        String mco_codigo = (String)dados.remove(MCO_CODIGO);
        String rec_codigo = (String)dados.remove(REC_CODIGO);
        dados.remove(ACTION_CODE);
        dados.remove(REPORT_TYPE);
        Statement st = Conexao.getStatement();
        List<BDExame> exames = BDUtil.getReqExamesMultGuia(fil_codigo, int_codigo, req_codigo, rec_codigo);
        for (BDExame exame : exames) {
            this.equip.atualizarDadosExame(st, fil_codigo, exame.getRequisicao(), exame.getRecipiente(), exame.getExame(), exame.getMaterial(), int_codigo, dados);
        }
    }
}

