/*
 * Decompiled with CFR 0.152.
 */
package jalis.laboratorio.interfaceamento.interfaces.gempremier3500;

import jalis.comum.Conexao;
import jalis.comum.ParametrosGerais;
import jalis.comum.Variaveis;
import jalis.laboratorio.interfaceamento.InterfaceamentoConfiguracao;
import jalis.laboratorio.interfaceamento.abas.PanelAbaAbstrata;
import jalis.laboratorio.interfaceamento.abas.RefreshTimer;
import jalis.laboratorio.interfaceamento.comunicacao.AbstractPort;
import jalis.laboratorio.interfaceamento.comunicacao.PortaCOM;
import jalis.laboratorio.interfaceamento.configuracao.ConfiguracaoSerial;
import jalis.laboratorio.interfaceamento.exames.BDExame;
import jalis.laboratorio.interfaceamento.exames.ExameMaterial;
import jalis.laboratorio.interfaceamento.exames.ExamesUtil;
import jalis.laboratorio.interfaceamento.interfaces.gempremier3500.RecordParser;
import jalis.laboratorio.interfaceamento.padroes.astm.ASTMStandard;
import jalis.laboratorio.interfaceamento.padroes.astm.InterfaceASTMListener;
import jalis.laboratorio.interfaceamento.util.BDUtil;
import jalis.laboratorio.triagem.apoio.DescritorCodigoEtiqueta;
import jalis.util.Funcoes;
import jalis.util.ListUtil;
import jalis.util.MemoryList;
import jalis.util.StringUtil;
import jalis.util.logger.ErrorLogger;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;

public class InterfaceListener
extends InterfaceASTMListener {
    public String NOME_EXAME = "GASO";
    private List<String> request = new ArrayList<String>();
    private int hostQuery = 0;
    private final int NO_QUERY = 0;
    private final int QUERY_ORDER = 1;
    private final int QUERY_DEMOGRAFICOS = 2;
    private boolean modoHostQuery = false;

    public InterfaceListener() {
        RecordParser record = new RecordParser();
        record.setInterfaceASTMListener(this);
        super.setASTMRecordParser(record);
        ConfiguracaoSerial c = Variaveis.equipamentos.get(0);
        InterfaceamentoConfiguracao configuracao = new InterfaceamentoConfiguracao();
        configuracao.setXmlVariaveis(c.getVariaveisConfiguracao());
        this.modoHostQuery = configuracao.getModoHostQuery();
    }

    @Override
    public String parse(String message) {
        try {
            String checksum = null;
            String termination = null;
            int stx_index = message.indexOf(this.getMsgStart());
            if (stx_index >= 0 && message.length() > 5) {
                if (stx_index > 0) {
                    message = message.substring(stx_index);
                } else if (stx_index < 0) {
                    return "Erro no bloco enviado pelo equipamento";
                }
            } else {
                return "Erro no bloco enviado pelo equipamento";
            }
            message = message.substring(2, message.length() - 2);
            checksum = message.substring(message.length() - 2);
            termination = message.substring(message.length() - 3, message.length() - 2);
            message = message.substring(0, message.length() - 2);
            if (this.checkCRC(message, checksum)) {
                if (this.middleFrame && this.rx_list.getUltimoInserido() <= this.rx_list.size()) {
                    String last = (String)this.rx_list.get(this.rx_list.getUltimoInserido());
                    message = last.substring(0, last.length() - 1) + message;
                    this.rx_list.remove(this.rx_list.getUltimoInserido());
                    this.middleFrame = false;
                }
                if (message.contains(String.valueOf('\r'))) {
                    String[] tmp;
                    for (String s : tmp = message.split(String.format("[%s]", Character.valueOf('\r')))) {
                        if (s.length() <= 1) continue;
                        this.rx_list.add(s);
                    }
                } else {
                    this.rx_list.add(message);
                }
                if (termination.equalsIgnoreCase(this.getMiddleFrameEnd())) {
                    this.middleFrame = true;
                    return "";
                }
                this.rx_list = (MemoryList)ListUtil.removeItemIgual(this.rx_list);
                while (!this.rx_list.isEmpty()) {
                    this.recordParser.recordFound((String)this.rx_list.remove(0));
                }
                Conexao.arquivaSQL();
                RefreshTimer.waitAndRefresh(this, this.TIME_TO_REFRESH);
                return "";
            }
            this.rx_list.clear();
            return "Erro ao receber bloco de dados: CRC incompat\u00edvel!";
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ErrorLogger.mostraMensagem(null, ex.toString(), ex.getStackTrace(), "AbstractASTMInterfaceamento: parse");
            this.rx_list.clear();
            this.interromperTimer();
            this.setIdle();
            try {
                Conexao.anulaSQL();
                return "Erro ao analisar dados recebidos do equipamento.";
            }
            catch (SQLException e) {
                ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o SQL em parse");
                return "Erro ao analisar dados recebidos do equipamento. Podem haver dados inconsistentes no BD.";
            }
        }
    }

    @Override
    public void setPortaCOM(AbstractPort portaCOM) {
        super.setPortaCOM(portaCOM);
        if (portaCOM instanceof PortaCOM) {
            ((PortaCOM)portaCOM).setBuscaHandshakeMensagemInteira(true);
        }
    }

    @Override
    public void dataChanged() {
        try {
            String message = this.getPortaCOM().getInputString();
            if (message.length() == 2 && message.equals(String.valueOf('\u0004') + String.valueOf('\u0005'))) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
            }
            if (!(message = this.getPortaCOM().removeInputString(this.getMsgEnd())).equals("")) {
                this.getPortaCOM().write(String.valueOf('\u0006'));
                String retorno = this.parse(message);
                if (this.isRX()) {
                    this.aguardarProximoFrame();
                }
            } else if (this.isRX()) {
                this.aguardarProximoFrame();
            }
        }
        catch (Exception ex) {
            ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: evento de dados recebidos");
            this.fireMensagemEnviada("Erro ao receber dados do equipamento: " + ex.getMessage(), 1, 5000);
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void encerrarTransmissao() throws Exception {
        if (this.tx_list.getUltimoLido() == this.tx_list.size() - 1) {
            Statement st = Conexao.getStatement();
            if (this.exames != null) {
                for (int i = 0; i < this.exames.length; ++i) {
                    int situacao;
                    if (!Funcoes.textoVazio(this.rec_tuboPai) && this.curva && !this.examesFilho.isEmpty()) {
                        for (String exame : this.examesFilho) {
                            int situacao2 = BDUtil.getDesmSituacao(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai, exame, this.mco_codigo);
                            BDUtil.setExmSituacaoFilho(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, exame, this.mco_codigo, this.rec_tuboPai, situacao2 < 2 ? 1 : 3);
                        }
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        if (!BDUtil.isGrupoInteiroPendente(this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_tuboPai)) continue;
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_tuboPai, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    if (!this.examesFilho.isEmpty()) {
                        situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                        this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                        BDUtil.setExmSituacaoTodosFilhos(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo, situacao < 2 ? 1 : 3);
                        continue;
                    }
                    situacao = this.getExameSituacao(st, this.fil_codigo, this.int_codigo, this.req_codigo, this.exames[i], this.mco_codigo, this.rec_codigo);
                    this.atualizarSituacaoExame(st, this.fil_codigo, this.req_codigo, this.rec_codigo, this.exames[i], this.mco_codigo, this.int_codigo, null, situacao < 2 ? 1 : 3);
                }
                Conexao.arquivaSQL();
                String acao = this.ultima_acao.equals("C") ? "excluido(s)" : "enviado(s)";
                this.fireMensagemEnviada("Exame(s) " + acao + " com sucesso para " + this.pac_nome, 0, 10000);
            } else {
                this.fireMensagemEnviada("Nenhum exame localizado para encerrar para " + this.pac_nome, 0, 10000);
            }
        }
        this.interromperTimer();
        if (this.modoHostQuery) {
            this.getPortaCOM().write(String.valueOf('\u0004'));
            this.getPortaCOM().clearInputString();
        }
        if (this.ultima_acao.equals("N")) {
            this.firePacienteEnviado(this.req_codigo, this.pac_nome, this.pac_sexo, this.req_idade, this.req_data, this.req_hora, this.pac_exames);
        }
        this.limpaDadosRequisicao();
        this.fireAtualizarTabela();
        this.fireAtualizarTabela(0);
        this.setIdle();
    }

    @Override
    public void responderRequest(String starting_range, String ending_range, String statusCode) {
        if (statusCode.equalsIgnoreCase("D")) {
            this.hostQuery = 2;
        } else if (statusCode.equalsIgnoreCase("O")) {
            this.hostQuery = 1;
        }
        try {
            String sampleId;
            int pos = 0;
            if (starting_range.startsWith("^")) {
                pos = 1;
            }
            if (!Funcoes.textoVazio(sampleId = starting_range.substring(pos).trim())) {
                if (Funcoes.textoVazio(sampleId)) {
                    this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                    this.hostQuery = 0;
                    return;
                }
                if (sampleId.trim().length() != ParametrosGerais.getDigitosTuboFilial() + ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboTubo()) {
                    this.fireExcecaoEncontrada(String.format("Amostra com o c\u00f3digo fora do padr\u00e3o %s ", sampleId));
                    this.hostQuery = 0;
                    return;
                }
                if (!this.request.contains(sampleId)) {
                    this.request.add(sampleId);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    protected void tratarEndOfTX() throws Exception {
        super.tratarEndOfTX();
        if (this.hostQuery > 0 && !this.request.isEmpty()) {
            this.responseHostQuery();
        }
    }

    public void responseHostQuery() {
        try {
            String sampleId;
            if (this.request.isEmpty()) {
                return;
            }
            String codigoEtiqueta = sampleId = this.request.remove(0);
            String fil_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboFilial());
            sampleId = sampleId.substring(ParametrosGerais.getDigitosTuboFilial());
            String req_codigo = sampleId.substring(0, ParametrosGerais.getDigitosTuboRequisicao());
            String rec_codigo = sampleId.substring(ParametrosGerais.getDigitosTuboRequisicao());
            String pac_nome = null;
            String pac_sexo = null;
            String pac_idade = null;
            String data = null;
            String hora = null;
            String prioridade = null;
            String int_codigo = null;
            String mco_codigo = null;
            StringBuilder pac_exames = new StringBuilder("");
            String acao = "N";
            DescritorCodigoEtiqueta dce = DescritorCodigoEtiqueta.getDescritor(codigoEtiqueta);
            if (dce != null) {
                fil_codigo = Funcoes.preencheZero(dce.getFilial(), ParametrosGerais.getDigitosTuboFilial());
                req_codigo = Funcoes.preencheZero(dce.getRequisicao(), ParametrosGerais.getDigitosTuboRequisicao());
                rec_codigo = Funcoes.preencheZero(dce.getTubo(), ParametrosGerais.getDigitosTuboTubo());
            }
            Object[] req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 0);
            PanelAbaAbstrata aba = this.equipamento.getTab(0);
            if (req != null) {
                pac_exames.append((String)req[aba.getColIndice("Exame")]);
            }
            if (req == null) {
                req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                aba = this.equipamento.getTab(1);
                if (Funcoes.textoVazio(pac_exames.toString()) && req != null && aba != null) {
                    pac_exames.append((String)req[aba.getColIndice("Exame")]).append(" ");
                }
                if (req != null) {
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 1);
                    for (Object[] r : reqs) {
                        pac_exames.append((String)r[aba.getColIndice("Exame")]).append(" ");
                    }
                }
            }
            String situacao = null;
            if (req == null && (req = this.getRequisicaoAba(fil_codigo, req_codigo, rec_codigo, 2)) != null) {
                aba = this.equipamento.getTab(2);
                if (req != null) {
                    String tuboPai = Funcoes.preencheZero((String)req[aba.getColIndice("Tubo")], ParametrosGerais.getDigitosTuboTubo());
                    List<Object[]> reqs = this.getTodasRequisicaoAba(fil_codigo, req_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai, 2);
                    for (Object[] r : reqs) {
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) <= 2) continue;
                        if (Integer.parseInt((String)r[aba.getColIndice("Sit")]) >= 7) continue;
                        situacao = (String)r[aba.getColIndice("Sit")];
                        String exame = (String)r[aba.getColIndice("Exame")];
                        mco_codigo = (String)req[aba.getColIndice("C\u00f3d. Mat.")];
                        int_codigo = (String)req[aba.getColIndice("Interface")];
                        if (BDUtil.isGrupoInteiroRepetido(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai)) {
                            pac_exames.append(exame).append(" ");
                            acao = "A";
                            continue;
                        }
                        BDExame[] filhos = BDUtil.getDesmExamesFilhos(fil_codigo, int_codigo, req_codigo, exame, mco_codigo, tuboPai.equals(rec_codigo) ? rec_codigo : tuboPai);
                        if (filhos == null) continue;
                        for (BDExame bdExame : filhos) {
                            if (!Funcoes.preencheZero(bdExame.getRecipienteFilho(), ParametrosGerais.getDigitosTuboTubo()).equals(rec_codigo) || bdExame.getSituacao() <= 2 || bdExame.getSituacao() >= 7) continue;
                            pac_exames.append(bdExame.getExame()).append(" ");
                            acao = "A";
                        }
                    }
                }
            }
            if (req != null && !Funcoes.textoVazio(pac_exames.toString())) {
                String req_codigoapoio = null;
                if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                    if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                        String requisicao = (String)req[aba.getColIndice("C\u00f3digo")];
                        if (ParametrosGerais.isAgruparGuiasInterface()) {
                            requisicao = (String)req[aba.getColIndice("Multiguia")];
                        }
                        String filial = requisicao.substring(0, ParametrosGerais.getDigitosTuboFilial());
                        requisicao = requisicao.substring(ParametrosGerais.getDigitosTuboFilial(), ParametrosGerais.getDigitosTuboRequisicao() + ParametrosGerais.getDigitosTuboFilial());
                        String tubo = (String)req[aba.getColIndice("Tubo")];
                        tubo = Funcoes.preencheZero(tubo, ParametrosGerais.getDigitosTuboTubo());
                        if (req[aba.getColIndice("Cod. Apoiado")] != null) {
                            if (!Funcoes.textoVazio((String)req[aba.getColIndice("Cod. Apoiado")])) {
                                req_codigoapoio = (String)req[aba.getColIndice("Cod. Apoiado")];
                            }
                        }
                        fil_codigo = filial;
                        req_codigo = requisicao;
                        rec_codigo = tubo;
                    }
                }
                pac_nome = aba.getColIndice("Paciente") >= 0 ? (String)req[aba.getColIndice("Paciente")] : null;
                pac_sexo = aba.getColIndice("S") >= 0 ? (String)req[aba.getColIndice("S")] : null;
                data = aba.getColIndice("Data") >= 0 ? (String)req[aba.getColIndice("Data")] : null;
                hora = aba.getColIndice("Hora") >= 0 ? (String)req[aba.getColIndice("Hora")] : null;
                int_codigo = aba.getColIndice("Interface") >= 0 ? (String)req[aba.getColIndice("Interface")] : null;
                mco_codigo = aba.getColIndice("C\u00f3d. Mat.") >= 0 ? (String)req[aba.getColIndice("C\u00f3d. Mat.")] : null;
                HashMap<String, String> map = new HashMap<String, String>();
                if (!Funcoes.textoVazio(req_codigoapoio)) {
                    map.put("codigoApoiado", req_codigoapoio);
                    map.put("codigoEtiqueta", codigoEtiqueta);
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao, map);
                } else {
                    map.put("codigoEtiqueta", codigoEtiqueta);
                    this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, "", prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames.toString().trim(), acao, map);
                }
            } else {
                this.fireExcecaoEncontrada(String.format("Nenhuma requisi\u00e7\u00e3o encontrada para a amostra %s %s %s", fil_codigo, req_codigo, rec_codigo));
                if (!this.request.isEmpty()) {
                    this.responseHostQuery();
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace());
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao, HashMap<String, String> mapaParametros) {
        try {
            ExameMaterial[] exa_lista;
            String tipo_amostra;
            if (this.tx_list == null) {
                this.tx_list = new MemoryList();
            }
            if (this.rx_list == null) {
                this.rx_list = new MemoryList();
            }
            this.tx_list.clear();
            this.rx_list.clear();
            this.fil_codigo = fil_codigo;
            this.int_codigo = int_codigo;
            this.req_codigo = req_codigo;
            this.pac_nome = pac_nome;
            this.pac_sexo = pac_sexo;
            this.req_idade = pac_idade;
            this.req_data = data;
            this.req_hora = hora;
            this.mco_codigo = mco_codigo;
            this.rec_codigo = rec_codigo;
            this.pac_exames = pac_exames;
            this.exames = pac_exames.split(" ", 0);
            this.ultima_acao = acao;
            if (!this.modoHostQuery) {
                this.encerrarTransmissao();
                return "";
            }
            Statement st = Conexao.getStatement();
            String short_name = StringUtil.removerAcentos(pac_nome);
            if (short_name.length() > this.MAX_PATIENT_NAME_CHARS) {
                short_name = short_name.substring(0, this.MAX_PATIENT_NAME_CHARS);
            }
            fil_codigo = Funcoes.preencheZero(fil_codigo, ParametrosGerais.getDigitosTuboFilial());
            req_codigo = Funcoes.preencheZero(req_codigo, ParametrosGerais.getDigitosTuboRequisicao());
            StringBuilder codigo = new StringBuilder(fil_codigo).append(req_codigo);
            rec_codigo = Funcoes.preencheZero(rec_codigo, ParametrosGerais.getDigitosTuboTubo());
            codigo.append(rec_codigo);
            if (mapaParametros != null && !Funcoes.textoVazio(mapaParametros.get("codigoApoiado"))) {
                codigo.setLength(0);
                codigo.append(mapaParametros.get("codigoApoiado"));
            }
            if (Funcoes.textoVazio(tipo_amostra = BDUtil.getExmEquipamentoMaterial(fil_codigo, (exa_lista = ExamesUtil.anexarCodigoMaterial(this.exames, mco_codigo))[0].getString(), exa_lista[0].getCodigo().toString(), int_codigo))) {
                tipo_amostra = "A";
            }
            exa_lista = ExamesUtil.desmembrarExames(st, fil_codigo, int_codigo, exa_lista);
            ExameMaterial[] alternativos = ExamesUtil.getAlternativos(st, fil_codigo, int_codigo, exa_lista);
            String nome = short_name;
            String sobrenome = null;
            this.tx_list.add(ASTMStandard.getDefaultHeaderRecord(this.DELIMITERS, this.PASSWORD, this.HOST_NAME, "", null, "", ""));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o cabe\u00e7alho de envio");
            }
            String laboratory_pid = codigo.toString();
            String sexo = "U";
            if (pac_sexo.equalsIgnoreCase("F")) {
                sexo = "F";
            } else if (pac_sexo.equalsIgnoreCase("M")) {
                sexo = "M";
            }
            this.tx_list.add(ASTMStandard.getDefaultPatientRecord(1, "", laboratory_pid, nome, sobrenome, sexo));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel  montar o registro do paciente");
            }
            if (this.hostQuery > 0 && this.hostQuery == 1) {
                this.tx_list.add(ASTMStandard.getDefaultOrderRecord(1, codigo.toString(), null, null, null, null, null, tipo_amostra, null));
                if (this.tx_list.size() < 0) {
                    throw new Exception("N\u00e3o foi poss\u00edvel montar o registro da requisicao");
                }
            }
            this.tx_list.add(ASTMStandard.getDefaultTerminationRecord(""));
            if (this.tx_list.size() < 0) {
                throw new Exception("N\u00e3o foi poss\u00edvel montar o rodap\u00e9 de envio");
            }
            this.tx_list = this.makeFrames(this.tx_list);
            this.tx_list.resetUltimoLido();
            this.setTX(this.TIME_TX);
            this.tx_counter = 0;
            this.getPortaCOM().write(String.valueOf('\u0005'));
            this.hostQuery = 0;
            return "Enviando requisi\u00e7\u00e3o de " + pac_nome;
        }
        catch (Exception e) {
            this.hostQuery = 0;
            ErrorLogger.mostraMensagem(null, e.getMessage(), e.getStackTrace(), "AbstractASTMInterfaceamento: envio de requisi\u00e7\u00e3o");
            try {
                Conexao.anulaSQL();
            }
            catch (SQLException ex) {
                ErrorLogger.mostraMensagem(null, ex.getMessage(), ex.getStackTrace(), "AbstractASTMInterfaceamento: exce\u00e7\u00e3o em envio de requisi\u00e7\u00e3o");
            }
            return "Erro ao enviar exames: " + e.toString();
        }
    }

    @Override
    public String enviarRequisicao(String pac_nome, String pac_sexo, String pac_idade, String data, String hora, String rackposition, String prioridade, String fil_codigo, String int_codigo, String req_codigo, String mco_codigo, String rec_codigo, String pac_exames, String acao) {
        return this.enviarRequisicao(pac_nome, pac_sexo, pac_idade, data, hora, rackposition, prioridade, fil_codigo, int_codigo, req_codigo, mco_codigo, rec_codigo, pac_exames, acao, null);
    }

    @Override
    public String getErroTraduzido(String erro) {
        return null;
    }

    @Override
    public void teste() {
        int op = JOptionPane.showOptionDialog(null, "Op\u00e7\u00e3o", "Tipo teste", 0, 0, null, new String[]{"Query", "ACK", "Resultado", "EOT"}, null);
        if (op == 0) {
            this.query();
        } else if (op == 1) {
            this.confirmacaoACK();
        } else if (op == 2) {
            this.resultado();
        } else if (op == 3) {
            this.finalizaTransmissao();
        }
    }

    protected void finalizaTransmissao() {
        this.handShakeCharReceived('\u0004');
    }

    protected void confirmacaoACK() {
        for (int i = 0; i < 10; ++i) {
            this.handShakeCharReceived('\u0006');
        }
    }

    private void query() {
        String idAmosta = JOptionPane.showInputDialog("Informe o Id da amostra?");
        StringBuffer buf = new StringBuffer();
        buf.append("[STX]1H|\\^&|||GEM[SP]3500^7.2.5[SP][SP][SP][SP][SP]^16086827^^650504^2.4|||||||||20170411153130[CR]");
        buf.append("P|1||" + idAmosta + "[CR]");
        buf.append("O|1||93||||||||||||V");
        buf.append("R|1|^^^BEecf|4.");
        buf.append("2|mmol/L||||||||20170411153129[CR]");
        buf.append("R|2|^^^HCO3-|28.5|mmol/L[CR]");
        buf.append("R|3|^^^SO2c|57|%[CR]");
        buf.append("R|4|^^^TCO2|29.8|mmol/L[CR]");
        buf.append("R|5|^^^THbc||g/dL[ETB]02[LINE]");
        this.parse(this.equipamento.arruma(buf.toString()));
        buf.setLength(0);
        buf.append("[STX]2||C[CR]");
        buf.append("R|6|^^^pCO2|43|mmHg[CR]");
        buf.append("R|7|^^^pH|7.43[CR]");
        buf.append("R|8|^^^pO2|29|mmHg[CR]");
        buf.append("R|9|^^^Temp|37.0|C[CR]");
        buf.append("L|1[CR]");
        buf.append("[ETX]B7[LINE]");
        this.parse(this.equipamento.arruma(buf.toString()));
        this.finalizaTransmissao();
    }

    private void resultado() {
        String idAmostra = JOptionPane.showInputDialog("Informe o Id da amostra?");
        if (Funcoes.textoVazio(idAmostra)) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        buf.append("[STX]1H|\\^&|||GEM[SP]3500^7.2.5[SP][SP][SP][SP][SP]^16086827^^650504^2.4|||||||||20170411173209[CR]");
        buf.append("P|1||" + idAmostra + "[CR]");
        buf.append("O|1||96||||||||||||V[CR]");
        buf.append("R|1|^^^BEecf|2.7|mmol/L||||||||20170411173207[CR]");
        buf.append("R|2|^^^HCO3-|27.3|mmol/L[CR]");
        buf.append("R|3|^^^SO2c|76|%[CR]");
        buf.append("R|4|^^^TCO2|28.6|mmol/L[CR]");
        buf.append("R|5|^^^THbc||g/dL[ETB]0E[LINE]");
        this.parse(this.equipamento.arruma(buf.toString()));
        buf.setLength(0);
        buf.append("[STX]2||C[CR]");
        buf.append("R|6|^^^pCO2|43|mmHg[CR]");
        buf.append("R|7|^^^pH|7.41[CR]");
        buf.append("R|8|^^^pO2|40|mmHg[CR]");
        buf.append("R|9|^^^Temp|37.0|C[CR]");
        buf.append("L|1[CR]");
        buf.append("[ETX]AE[LINE]");
        this.parse(this.equipamento.arruma(buf.toString()));
    }
}

